<?php

/**
 * AJAX handler for Group_User operations
 * fork dlteams
 */

$AJAX_INCLUDE = 1;
include('../../../inc/includes.php');

// Send UTF8 Headers
header("Content-Type: application/json; charset=UTF-8");
Html::header_nocache();

Session::checkLoginUser();

$response = ['success' => false, 'message' => ''];

try {
    if (isset($_POST['delete']) && isset($_POST['linkid'])) {
        $group_user = new Group_User();
        $linkid = (int)$_POST['linkid'];
        
        // Vérifier que l'enregistrement existe
        if (!$group_user->getFromDB($linkid)) {
            $response['message'] = __('Relation introuvable');
            echo json_encode($response);
            exit;
        }
        
        // Vérifier les droits
//        if (!$group_user->canDeleteItem()) {
//            $response['message'] = __('Droits insuffisants');
//            echo json_encode($response);
//            exit;
//        }
        
        // Sauvegarder les informations pour le log
        $users_id = $group_user->fields['users_id'];
        $groups_id = $group_user->fields['groups_id'];
        
        // Supprimer la relation
        if ($group_user->delete(['id' => $linkid])) {
            // Log de l'événement
            \Glpi\Event::log(
                $groups_id,
                "groups",
                4,
                "setup",
                sprintf(__('%s removes a user from a group'), $_SESSION["glpiname"])
            );
            
            $response['success'] = true;
            $response['message'] = __('Utilisateur retiré du groupe avec succès');
        } else {
            $response['message'] = __('Erreur lors de la suppression');
        }
    } else {
        $response['message'] = __('Paramètres manquants');
    }
    
} catch (Exception $e) {
    $response['message'] = __('Erreur système: ') . $e->getMessage();
}


echo json_encode($response); 