<?php
// front/file_actions.php

include('../../../inc/includes.php');
Session::checkLoginUser();

header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'Action non autorisée ou invalide.'];

$action = $_POST['action'] ?? '';
$identifier = $_POST['identifier'] ?? '';
$filename = basename($_POST['old_filename'] ?? $_POST['filename'] ?? '');
$new_filename = basename($_POST['new_filename'] ?? '');

if (!preg_match('/^[a-f0-9]{32}$/i', $identifier) || empty($filename)) {
    $response['message'] = 'Paramètres invalides.';
    echo json_encode($response);
    exit();
}

$dir_path = GLPI_ROOT . '/pub/' . $identifier;
$old_filepath = $dir_path . '/' . $filename;

switch ($action) {
    case 'delete':
        if (file_exists($old_filepath)) {
            if (unlink($old_filepath)) {
                $response = ['success' => true];
            } else {
                $response['message'] = 'Impossible de supprimer le fichier.';
            }
        } else {
            $response['message'] = 'Le fichier n\'existe pas.';
        }
        break;

    case 'rename':
        $new_filepath = $dir_path . '/' . $new_filename;
        if (empty($new_filename)) {
            $response['message'] = 'Le nouveau nom ne peut pas être vide.';
        } else if (!file_exists($old_filepath)) {
            $response['message'] = 'Le fichier original n\'existe pas.';
        } else if (file_exists($new_filepath)) {
            $response['message'] = 'Un fichier avec ce nom existe déjà.';
        } else {
            if (rename($old_filepath, $new_filepath)) {
                $response = ['success' => true];
            } else {
                $response['message'] = 'Impossible de renommer le fichier.';
            }
        }
        break;
}

echo json_encode($response);