﻿<?php
include_once("../../../inc/includes.php");
Session::checkLoginUser();

if (isset($_POST["record_id"]) && isset($_POST["report_type"])) {
    $record_id = (int)$_POST["record_id"];
    $report_type = (int)$_POST["report_type"];
    
    // Récupérer les options d'impression par défaut
    $print_options = PluginDlteamsPublish::getDefaultPrintOptions();
    $print_options['report_type'] = $report_type;
    
    // Générer le PDF directement
    $pdfoutput = new PluginDlteamsPublish();
    $pdfoutput->generateReport([
        'record_id' => $record_id,
        'report_type' => $report_type
    ], $print_options);
    
    // Afficher le PDF avec les paramètres d'impression
    $filename = $pdfoutput->generateFilename([
        'record_id' => $record_id,
        'report_type' => $report_type
    ]) . ".pdf";
    
    $pdfoutput->showPDF([
        'record_id' => $record_id,
        'report_type' => $report_type
    ], $filename);
}
?>
