<?php

/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include("../../../inc/includes.php");

header('Content-Type: application/json; charset=UTF-8');

Session::checkLoginUser();

try {
    // Optionnel : CSRF si tu l’actives sur tes formulaires
    // Session::checkCSRF();

    $itilfollowups_id = (int)($_POST['itilfollowups_id'] ?? 0);
    $emoji_key        = (string)($_POST['emoji_key'] ?? '');

    if ($itilfollowups_id <= 0 || $emoji_key === '') {
        throw new RuntimeException(__('Paramètres invalides'));
    }

    $res = PluginDlteamsITILFollowup_Reaction::toggle($itilfollowups_id, $emoji_key, Session::getLoginUserID());

    echo json_encode([
        'ok'         => true,
        'hasReacted' => $res['hasReacted'],
        'newCount'   => $res['newCount']
    ]);
} catch (Throwable $e) {
    http_response_code(400);
    echo json_encode(['ok'=>false, 'error'=>$e->getMessage()]);
}


/**
 * Transforme un HTML en texte brut propre (sans balises / scripts / styles).
 */
function html_to_text(string $html): string {
    // (1) Option DOM (plus robuste)
    if (class_exists('DOMDocument')) {
        libxml_use_internal_errors(true);
        $dom = new DOMDocument();
        // Forcer l'encodage pour éviter les caractères cassés
        $dom->loadHTML('<?xml encoding="UTF-8">'.$html, LIBXML_HTML_NODEFDTD | LIBXML_HTML_NOIMPLIED);
        $xp = new DOMXPath($dom);
        foreach ($xp->query('//script|//style|//noscript') as $n) {
            $n->parentNode->removeChild($n);
        }
        $text = $dom->textContent ?? '';
        libxml_clear_errors();
    } else {
        // (2) Fallback simple
        $html = preg_replace('#<(script|style|noscript)[^>]*>.*?</\1>#si', ' ', $html);
        $text = strip_tags($html);
    }

    // Normaliser : décoder entités, compacter espaces
    $text = html_entity_decode($text, ENT_QUOTES | ENT_HTML5, 'UTF-8');
    $text = preg_replace('/\s+/u', ' ', $text);
    return trim($text);
}

/**
 * Extrait les N premiers caractères en respectant les mots (optionnel).
 */
function html_excerpt(string $html, int $limit = 180, bool $preserveWords = true, string $ellipsis = '…'): string {
    $text = html_to_text($html);
    if (mb_strlen($text, 'UTF-8') <= $limit) return $text;

    $slice = mb_substr($text, 0, $limit, 'UTF-8');
    if ($preserveWords) {
        $lastSpace = mb_strrpos($slice, ' ', 0, 'UTF-8');
        if ($lastSpace !== false && $lastSpace > (int)($limit * 0.6)) {
            $slice = mb_substr($slice, 0, $lastSpace, 'UTF-8');
        }
    }
    // Nettoyer la fin pour éviter "mot, …"
    $slice = rtrim($slice, " \t\n\r\0\x0B.,;:!?");
    return $slice.$ellipsis;
}
