<?php

/**
 * ---------------------------------------------------------------------
 *
 * DLTeams plugin for GLPI
 *
 * @package   dlteams
 * @author    DLPlace developers
 * @copyright Copyright (c) 2022 DLPlace
 * @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
 * @link      https://github.com/dlplace/dlteams
 * @since     2021
 * ---------------------------------------------------------------------
 */

include("../../../inc/includes.php");
header("Content-Type: text/html; charset=UTF-8");
Html::header_nocache();

switch ($_REQUEST['action']) {
    case "getItemslist":
        $params = [
            'start' => $_REQUEST['start'],
            'is_deleted' => $_REQUEST['is_deleted'],
            'browse' => 1,
            'as_map' => 0,
            'showmassiveactions' => true,
            'criteria' => $_REQUEST['criteria'],
            'sort' => $_REQUEST['sort'] ?? [],
            'order' => $_REQUEST['order'] ?? [],
        ];

        $itemtype = $_REQUEST['itemtype'];

        if ($itemtype !== 'PluginDlteamsMessage') {
            http_response_code(400);
            return;
        }

        $cat_id = $_REQUEST['cat_id'] ?? '';

        $cat_id = preg_replace('/_1$/', '-1', $cat_id);

        if ($cat_id !== '' && $cat_id !== '-1') {
            $params['criteria'][] = [
                'link' => "AND",
                'field' => '10',
                'searchtype' => "equals",
                'value' => $cat_id
            ];

            Search::showList(PluginDlteamsMessage::class, $params);
            return;
        } elseif ($cat_id === '-1') {
            // Messages sans conversation
//            $params['criteria'][] = [
//                'link' => "AND",
//                'field' => '10',
//                'searchtype' => "equals",
//                'value' => '0'
//            ];
            $params = [];

            Search::show(PluginDlteamsMessage::class);
            return;
        }
}
http_response_code(400);
return;