<?php
/**
 * Fichier de diagnostic pour les widgets centraux dlteams
 */

include('../../inc/includes.php');

echo "<h2>Diagnostic des widgets centraux DLTeams</h2>";

// Vérifier les classes dlteams
$dlteams_classes = [
    'PluginDlteamsRecord' => 'plugin_dlteams_record',
    'PluginDlteamsConcernedPerson' => 'plugin_dlteams_concernedperson',
    'PluginDlteamsProcessedData' => 'plugin_dlteams_processeddata',
    'PluginDlteamsLegalbasi' => 'plugin_dlteams_legalbasi',
    'PluginDlteamsStoragePeriod' => 'plugin_dlteams_storageperiod',
    'PluginDlteamsPolicieForm' => 'plugin_dlteams_policieform',
    'PluginDlteamsDataCatalog' => 'plugin_dlteams_datacatalog'
];

echo "<h3>1. Vérification des classes et droits</h3>";
echo "<table border='1' style='border-collapse: collapse;'>";
echo "<tr><th>Classe</th><th>Existe</th><th>Droit</th><th>showCentralList</th><th>getTable</th></tr>";

foreach ($dlteams_classes as $class => $right) {
    echo "<tr>";
    echo "<td>$class</td>";
    echo "<td>" . (class_exists($class) ? '✅' : '❌') . "</td>";
    echo "<td>" . (Session::haveRight($right, READ) ? '✅' : '❌') . "</td>";
    echo "<td>" . (method_exists($class, 'showCentralList') ? '✅' : '❌') . "</td>";
    if (class_exists($class)) {
        echo "<td>" . (method_exists($class, 'getTable') ? $class::getTable() : 'N/A') . "</td>";
    } else {
        echo "<td>N/A</td>";
    }
    echo "</tr>";
}
echo "</table>";

echo "<h3>2. Test des tokens IDOR</h3>";
foreach ($dlteams_classes as $class => $right) {
    if (class_exists($class) && Session::haveRight($right, READ)) {
        $card_params = ['start' => 0, 'status' => 'process', 'showgrouptickets' => 'false'];
        $idor = Session::getNewIDORToken($class, $card_params);
        echo "<p><strong>$class:</strong> " . ($idor ? '✅ Token généré' : '❌ Erreur token') . "</p>";
    }
}

echo "<h3>3. Test de la fonction showCentral</h3>";
if (class_exists('PluginDlteamsCentral')) {
    echo "<p>Classe PluginDlteamsCentral : ✅</p>";
    if (method_exists('PluginDlteamsCentral', 'showCentral')) {
        echo "<p>Méthode showCentral : ✅</p>";
    } else {
        echo "<p>Méthode showCentral : ❌</p>";
    }
} else {
    echo "<p>Classe PluginDlteamsCentral : ❌</p>";
}

echo "<h3>4. Vérification de l'ajax</h3>";
$ajax_file = __DIR__ . '/ajax/central.php';
if (file_exists($ajax_file)) {
    echo "<p>Fichier ajax/central.php : ✅</p>";
    echo "<p>Taille : " . filesize($ajax_file) . " bytes</p>";
} else {
    echo "<p>Fichier ajax/central.php : ❌</p>";
}

echo "<h3>5. Test d'une requête directe</h3>";
if (class_exists('PluginDlteamsRecord')) {
    global $DB;
    try {
        $result = $DB->request([
            'FROM' => 'glpi_plugin_dlteams_records',
            'WHERE' => [
                'entities_id' => Session::getActiveEntity()
            ],
            'LIMIT' => 5
        ]);
        echo "<p>Requête PluginDlteamsRecord : ✅ (" . count($result) . " résultats)</p>";
    } catch (Exception $e) {
        echo "<p>Requête PluginDlteamsRecord : ❌ " . $e->getMessage() . "</p>";
    }
}

echo "<h3>6. Session et entité</h3>";
echo "<p>Utilisateur connecté : " . Session::getLoginUserID() . "</p>";
echo "<p>Entité active : " . Session::getActiveEntity() . "</p>";
echo "<p>Profil actuel : " . $_SESSION['glpiactiveprofile']['name'] ?? 'N/A' . "</p>"; 