<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include("../../../inc/includes.php");

Session::checkLoginUser();
/*highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//die();

if (isset($_POST['consent_type']) && $_POST['consent_type'] && $_POST['appliances_id'] && $_POST['add1']) {
    $appliance_item = new PluginDlteamsAppliance_Item();

    $appliance = new Appliance();
    $appliance->getFromDB($_POST['appliances_id']);

    switch ($_POST["consent_type"]) {
        case 1:
            if ($_POST['groups_id']) {

                $r_id = $appliance_item->add([
                    'appliances_id' => $_POST['appliances_id'],
                    'itemtype' => 'Group',
                    'items_id' => $_POST['groups_id'],
                    'comment' => addslashes($_POST['comment']),
                    'name' => addslashes($appliance->fields['name']),
                    'groups_id' => $_POST['groups_id'],
                ]);

                $group_item = new PluginDlteamsGroup_Item();

//                $group = new Group();
//                $group->getFromDB($_POST['groups_id']);

                $group_item->add([
                    'groups_id' => $_POST['groups_id'],
                    'itemtype' => 'PluginDlteamsAppliance',
                    'items_id' => $_POST['appliances_id'],
                    'comment' => addslashes($_POST['comment']),
//                    'name' => $group->fields['name']
                ]);

                Session::addMessageAfterRedirect("Groupe responsable ajouté avec succès");
            }
            break;
        case 2:
            if ($_POST['users_id']) {
                $r_id = $appliance_item->add([
                    'appliances_id' => $_POST['appliances_id'],
                    'itemtype' => 'User',
                    'items_id' => $_POST['users_id'],
                    'comment' => addslashes($_POST['comment']),
                    'name' => addslashes($appliance->fields['name']),
                    'users_id' => $_POST['users_id'],
                ]);


                $user = new User();
                $user->getFromDB($_POST['users_id']);
                $group_item = new PluginDlteamsUser_Item();
                $u = $group_item->add([
                    'users_id' => $_POST['users_id'],
                    'itemtype' => 'PluginDlteamsAppliance',
                    'items_id' => $_POST['appliances_id'],
                    'comment' => addslashes($_POST['comment']),
//                    'name' => $user->fields["name"]
                ]);

                Session::addMessageAfterRedirect("Utilisateur responsable ajouté avec succès");
            }
            break;
        case 3:
            if ($_POST['plugin_dlteams_thirdpartycategories_id1']) {
                $thpc_item = new PluginDlteamsThirdPartyCategory_Item();
                if($r_id = $appliance_item->add([
                        'appliances_id' => $_POST['appliances_id'],
                        'itemtype' => 'PluginDlteamsThirdPartyCategory',
                        'items_id' => $_POST['plugin_dlteams_thirdpartycategories_id1'],
                        'comment' => addslashes($_POST['comment']),
                        'name' => addslashes($appliance->fields['name'])
                    ])
                    &&
                    $g_id = $thpc_item->add([
                            'thirdpartycategories_id' => $_POST['plugin_dlteams_thirdpartycategories_id1'],
                            'itemtype' => 'PluginDlteamsAppliance',
                            'items_id' => $_POST['appliances_id'],
                            'comment' => addslashes($_POST['comment']),
                        ])
                )
                    Session::addMessageAfterRedirect("Tier catégorie responsable ajouté avec succès");
                else{
                    global $DB;
                    Session::addMessageAfterRedirect("Une erreur s'est produite", 0, ERROR);
                }
            }
            break;
        case 4:
            if ($_POST['suppliers_id1']) {
                $r_id = $appliance_item->add([
                    'appliances_id' => $_POST['appliances_id'],
                    'itemtype' => 'Supplier',
                    'items_id' => $_POST['suppliers_id1'],
                    'comment' => addslashes($_POST['comment']),
                    'name' => addslashes($appliance->fields['name'])
                ]);

                $group_item = new PluginDlteamsSupplier_Item();
                $group_item->add([
                    'suppliers_id' => $_POST['suppliers_id1'],
                    'itemtype' => 'PluginDlteamsAppliance',
                    'items_id' => $_POST['appliances_id'],
                    'comment' => addslashes($_POST['comment']),
//                    'foreign_id' => $r_id
                ]);

                Session::addMessageAfterRedirect("Fournisseur responsable ajouté avec succès");
            }
            break;
    }

}
elseif (isset($_POST["update_edit_appliance_acteur"])){
//    if(!$_POST["items_id1"]){
//        Session::addMessageAfterRedirect("Veuillez sélectionner un motif", 0, ERROR);
//        Html::back();
//    }

    $appliance_item = new PluginDlteamsAppliance_Item();
    if($appliance_item->getFromDB($_POST["linkid"])){

        $appliance_item_oldfields = $appliance_item->fields;

        $appliance_item->update([
            "comment" => $_POST["comment"],
            "id" => $_POST["linkid"]
        ]);

        if($appliance_item_oldfields["itemtype"] == User::class)
            $itemtype_item_str = PluginDlteamsUser_Item::class;
        else
            $itemtype_item_str = $appliance_item_oldfields["itemtype"]."_Item";
        $itemtype_item = new $itemtype_item_str();

        if($appliance_item_oldfields["itemtype"] == PluginDlteamsThirdPartyCategory::class)
            $relation_column_id = "thirdpartycategories_id";
        else
            $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $appliance_item_oldfields["itemtype"]))) . "s_id";
        $criteria = [
            "itemtype" => "PluginDlteamsAppliance",
            "items_id" => $appliance_item_oldfields["appliances_id"],
            $relation_column_id => $appliance_item_oldfields["items_id"],
            "comment" => $appliance_item_oldfields["comment"]
        ];
        $itemtype_item->deleteByCriteria($criteria);
        $itemtype_item->add([
            ...$criteria,
            "comment" => $_POST["comment"]
        ]);


        Session::addMessageAfterRedirect("Opération éffectuée avec succès");
        Html::back();
    }

}


Html::back();
