<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software. 
 It disallow others people than DLPlace developers to distribute, sell, 
 or add additional requirements to this software. 
 Though, a limited set of safe added requirements can be allowed, but 
 for private or internal usage only ;  without even the implied warranty 
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include("../../../inc/includes.php");

if (!isset($_GET['id'])) {
    $_GET['id'] = "";
}

$policieform = new PluginDlteamsPolicieForm();

if (isset($_POST['add'])) {

    $policieform->check(-1, CREATE, $_POST);
    $id = $policieform->add($_POST);
    Html::redirect($policieform->getFormURLWithID($id));

}
else if (isset($_POST['update'])) {

    if (isset($_POST["update_document_modele"])) {
        $document = new Document();
        $document->getFromDB($_POST["documents_id"]);
        $document->update([
            "id" => $_POST["documents_id"],
            "deliverables_id" => $_POST["deliverables_id"],
            "policieforms_id" => $_POST["policieforms_id"],
        ]);
    } else {
        $policieform->check($_POST['id'], UPDATE);
        $data = $_POST;
        $data["setofdocuments"] = (int)$data["setofdocuments"];
        $resp = $policieform->update($data);


//        var_dump($resp);
/*        highlight_string("<?php\n\$data =\n" . var_export($data, true) . ";\n?>");*/
//        die();
    }
    Html::back();

}
else if (isset($_POST['delete'])) {

    $policieform->check($_POST['id'], DELETE);
    $policieform->delete($_POST);
    $policieform->redirectToList();

}
else if (isset($_POST['purge'])) {

    $policieform->check($_POST['id'], PURGE);
    $policieform->delete($_POST, true);
    $policieform->redirectToList();

} else if (isset($_POST["update_policieforms_item"])) {

    if (!$_POST["items_id"]) {
        Session::addMessageAfterRedirect(sprintf("Mandatory fields are not filled. Please correct: %s", PluginDlteamsDataCarrierType::getTypeName()), 0, ERROR);
        Html::back();
    }
    $policieform_item = new PluginDlteamsPolicieForm_Item();

    global $DB;

    $policieform_item->getFromDB($_POST["linkid"]);
    $data = $policieform_item->fields;
//    $policieform_item->update([
//        "id" => $_POST["linkid"],
//        "items_id" => $_POST["items_id"],
//        "comment" => $_POST["comment"],
//    ]);
    $DB->update($policieform_item->getTable(),
        [
            "items_id" => $_POST["items_id"],
            "comment" => $_POST["comment"],
        ],
        [
            "id" => $_POST["linkid"],
        ]
    );

    $datacarriertype_item = new PluginDlteamsDataCarrierType_Item();
    if ($datacarriertype_item->deleteByCriteria([
        "itemtype" => PluginDlteamsPolicieForm::class,
        "items_id" => $data["policieforms_id"],
        "datacarriertypes_id" => $data["items_id"],
//        "comment" => $data["comment"]
    ])) {
        $datacarriertype_item->add([
            "itemtype" => PluginDlteamsPolicieForm::class,
            "items_id" => $data["policieforms_id"],
            "datacarriertypes_id" => $_POST["items_id"],
            "comment" => $_POST["comment"],
        ]);
    }
    Session::addMessageAfterRedirect("Opération éffectuée avec succès");
    Html::back();
}
else if (isset($_POST["update_policieforms_item_personal_and_datacategory"])) {

/*    highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//    die();
    if (!$_POST["items_id"] && !$_POST["!items_id"]) {
        $msg = PluginDlteamsConcernedPerson::getTypeName()." et ".PluginDlteamsProcessedData::getTypeName()." ne peuvent etre vide";
        Session::addMessageAfterRedirect(sprintf("Mandatory fields are not filled. Please correct: %s", $msg), 0, ERROR);
        Html::back();
    }
    $policieform_item = new PluginDlteamsPolicieForm_Item();

    global $DB;

    $policieform_item->getFromDB($_POST["linkid"]);
    $data = $policieform_item->fields;
//    $policieform_item->update([
//        "id" => $_POST["linkid"],
//        "items_id" => $_POST["items_id"],
//        "comment" => $_POST["comment"],
//    ]);
    $DB->update($policieform_item->getTable(),
        [
            "items_id" => $_POST["items_id"],
            "items_id1" => $_POST["items_id1"],
            "mandatory" => $_POST["mandatory"],
            "comment" => $_POST["comment"],
        ],
        [
            "id" => $_POST["linkid"],
        ]
    );

//    mettre a jour concernedperson_item
    $concernedperson_item = new PluginDlteamsConcernedPerson_Item();
    $cp_array = [
        "concernedpersons_id" => $policieform_item->fields["items_id"],
        "itemtype" => PluginDlteamsPolicieForm::class,
        "items_id" => $policieform_item->fields["policieforms_id"],
        "itemtype1" => PluginDlteamsProcessedData::class,
        "items_id1" => $policieform_item->fields["items_id1"]
    ];

    if($concernedperson_item->getFromDBByCrit($cp_array))
        $concernedperson_item->deleteByCriteria($cp_array);

    $concernedperson_item->add([
        ...$cp_array,
        "comment" => $_POST["comment"]
    ]);


    //    mettre a jour processeddata_item
    $processeddata_item = new PluginDlteamsProcessedData_Item();
    $pd_array = [
        "processeddatas_id" => $policieform_item->fields["items_id1"],
        "itemtype" => PluginDlteamsPolicieForm::class,
        "items_id" => $policieform_item->fields["policieforms_id"],
        "itemtype1" => PluginDlteamsConcernedPerson::class,
        "items_id1" => $policieform_item->fields["items_id"]
    ];

    if($processeddata_item->getFromDBByCrit($cp_array))
        $processeddata_item->deleteByCriteria($cp_array);

    $processeddata_item->add([
        ...$pd_array,
        "comment" => $_POST["comment"]
    ]);
    Session::addMessageAfterRedirect("Opération éffectuée avec succès");
    Html::back();
}
else if (isset($_POST["delete_policieforms_item_personal_and_datacategory"])) {

/*    highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//    die();
//    if (!$_POST["items_id"]) {
//        Session::addMessageAfterRedirect(sprintf("Mandatory fields are not filled. Please correct: %s", PluginDlteamsDataCarrierType::getTypeName()), 0, ERROR);
//        Html::back();
//    }
    $policieform_item = new PluginDlteamsPolicieForm_Item();

    global $DB;

    $policieform_item->getFromDB($_POST["linkid"]);
    $policieform_item->delete(["id" => $_POST["linkid"]]);

//    mettre a jour concernedperson_item
    $concernedperson_item = new PluginDlteamsConcernedPerson_Item();
    $cp_array = [
        "concernedpersons_id" => $policieform_item->fields["items_id"],
        "itemtype" => PluginDlteamsPolicieForm::class,
        "items_id" => $policieform_item->fields["policieforms_id"],
        "itemtype1" => PluginDlteamsProcessedData::class,
        "items_id1" => $policieform_item->fields["items_id1"]
    ];

    if($concernedperson_item->getFromDBByCrit($cp_array))
        $concernedperson_item->deleteByCriteria($cp_array);


    $processeddata_item = new PluginDlteamsProcessedData_Item();
    $pd_array = [
        "processeddatas_id" => $policieform_item->fields["items_id1"],
        "itemtype" => PluginDlteamsPolicieForm::class,
        "items_id" => $policieform_item->fields["policieforms_id"],
        "itemtype1" => PluginDlteamsConcernedPerson::class,
        "items_id1" => $policieform_item->fields["items_id"]
    ];

    if($processeddata_item->getFromDBByCrit($cp_array))
        $processeddata_item->deleteByCriteria($cp_array);

    Session::addMessageAfterRedirect("Opération éffectuée avec succès");
    Html::back();
}
else {
    $policieform->checkGlobal(READ);

    if (Session::getCurrentInterface() == 'central') {
//        Html::header(PluginDlteamsPolicieForm::getTypeName(2), '', 'dlteams', 'plugindlteamsmenu', 'policieform');

        $menus = ["dataaccess", "datagovernancepolicieform", "policieform"];
        Html::requireJs('sortable');
        PluginDlteamsPolicieForm::displayFullPageForItem($_GET['id'], $menus, [
            'formoptions'  => "data-track-changes=true",
        ]);

//        Html::header(PluginDlteamsPolicieForm::getTypeName(2), '', "dataaccess", "datagovernancepolicieform", "policieform");
    } else {
        Html::helpHeader(PluginDlteamsPolicieForm::getTypeName(0));
    }

//    $policieform->display(['id' => $_GET['id']]);

    if (Session::getCurrentInterface() == 'central') {
        Html::requireJs('sortable');
        Html::footer();
    } else {
        Html::helpFooter();
    }

}