<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include("../../../inc/includes.php");

Session::checkLoginUser();

if(isset($_POST['update'])){

    $pi = new PluginDlteamsPolicieForm_Item();
    /*    highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//    die();
    $pi->getFromDB($_POST["linkid"]);

    global $DB;

    $DB->update($pi->getTable(), [
        "mandatory" => $_POST["mandatory"],
        "comment" => $_POST["comment"],
    ],
        ["id" => $_POST["linkid"]]);




    $relation_item_str = $pi->fields["itemtype"] . "_Item";
    if(!class_exists($relation_item_str))
        $relation_item_str = "PluginDlteams".$relation_item_str;
    $relation_item = new $relation_item_str();
    $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $pi->fields["itemtype"]))) . "s_id";

    $criteria = [
        "itemtype" => PluginDlteamsPolicieForm::class,
        "items_id" => $pi->fields["policieforms_id"],
        $relation_column_id => $pi->fields["items_id"],
        "comment" => $pi->fields["comment"]
    ];

    global $DB;
    $DB->delete(
        $relation_item->getTable(),
        $criteria
    );
//        $relation_item->deleteByCriteria($criteria);

//        $criteria["plugin_dlteams_storageendactions_id"] = $this->fields["plugin_dlteams_storageendactions_id"];
//        $criteria["plugin_dlteams_storagetypes_id"] = $this->fields["plugin_dlteams_storagetypes_id"];
    $criteria["comment"] = $_POST["comment"];
    $criteria["mandatory"] = $_POST["mandatory"];

    $DB->insert($relation_item->getTable(), $criteria);
//        $relation_item->add([
//            ...$criteria,
//        ]);

    Session::addMessageAfterRedirect("Opération éffectuée");
    Session::addMessageAfterRedirect("Relation mis a jour avec succès");

//    post_updateItem will update the item

    Html::back();

}

Html::back();
