<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include("../../../inc/includes.php");

Session::checkLoginUser();


if (isset($_POST['add']) && (isset($_POST['plugin_dlteams_records_id']))) {

    $record_item = new PluginDlteamsRecord_Item();
    switch ($_POST["consent_type"]) {
        case 1:
            $r_id = $record_item->add([
                'records_id' => $_POST['plugin_dlteams_records_id'],
                'itemtype' => 'PluginDlteamsConcernedPerson',
                'items_id' => $_POST['plugin_dlteams_concernedpersons_id'],
                'itemtype1' => 'PluginDlteamsSendingReason',
                'items_id1' => $_POST['plugin_dlteams_sendingreasons_id'],
                'comment' => $_POST['recipient_comment']
            ]);

            $cp_i = new PluginDlteamsConcernedPerson_Item();
            $cp_i->add([
                'concernedpersons_id' => $_POST['plugin_dlteams_concernedpersons_id'],
                'itemtype' => 'PluginDlteamsRecord',
                'items_id' => $_POST['plugin_dlteams_records_id'],
                'itemtype1' => 'PluginDlteamsSendingReason',
                'items_id1' => $_POST['plugin_dlteams_sendingreasons_id'],
                'comment' => $_POST['recipient_comment'],
                'foreign_id' => $r_id
            ]);

            $sr_i = new PluginDlteamsSendingReason_Item();
            $sr_i->add([
                'sendingreasons_id' => $_POST['plugin_dlteams_sendingreasons_id'],
                'itemtype' => 'PluginDlteamsRecord',
                'items_id' => $_POST['plugin_dlteams_records_id'],
                'itemtype1' => 'PluginDlteamsConcernedPerson',
                'items_id1' => $_POST['plugin_dlteams_concernedpersons_id'],
                'comment' => $_POST['recipient_comment'],
                'foreign_id' => $r_id
            ]);

            Session::addMessageAfterRedirect("Destinataire ajouté avec succès");
            break;
        case 2:
            $r_id = $record_item->add([
                'records_id' => $_POST['plugin_dlteams_records_id'],
                'itemtype' => 'PluginDlteamsThirdPartyCategory',
                'items_id' => $_POST['plugin_dlteams_thirdpartycategories_id'],
                'itemtype1' => 'PluginDlteamsSendingReason',
                'items_id1' => $_POST['plugin_dlteams_sendingreasons_id'],
                'comment' => $_POST['recipient_comment']
            ]);

            $cp_i = new PluginDlteamsThirdPartyCategory_Item();
            $cp_i->add([
                'thirdpartycategories_id' => $_POST['plugin_dlteams_thirdpartycategories_id'],
                'itemtype' => 'PluginDlteamsRecord',
                'items_id' => $_POST['plugin_dlteams_records_id'],
                'itemtype1' => 'PluginDlteamsSendingReason',
                'items_id1' => $_POST['plugin_dlteams_sendingreasons_id'],
                'comment' => $_POST['recipient_comment'],
                'foreign_id' => $r_id
            ]);

            $sr_i = new PluginDlteamsSendingReason_Item();
            $sr_i->add([
                'sendingreasons_id' => $_POST['plugin_dlteams_sendingreasons_id'],
                'itemtype' => 'PluginDlteamsRecord',
                'items_id' => $_POST['plugin_dlteams_records_id'],
                'itemtype1' => 'PluginDlteamsThirdPartyCategory',
                'items_id1' => $_POST['plugin_dlteams_thirdpartycategories_id'],
                'comment' => $_POST['recipient_comment'],
                'foreign_id' => $r_id
            ]);

            Session::addMessageAfterRedirect("Destinataire ajouté avec succès");
            break;
        case 3:
            $r_id = $record_item->add([
                'records_id' => $_POST['plugin_dlteams_records_id'],
                'itemtype' => 'Supplier',
                'items_id' => $_POST['suppliers_id'],
                'itemtype1' => 'PluginDlteamsSendingReason',
                'items_id1' => $_POST['plugin_dlteams_sendingreasons_id'],
                'comment' => $_POST['recipient_comment']
            ]);

            $cp_i = new PluginDlteamsSupplier_Item();
            $cp_i->add([
                'suppliers_id' => $_POST['suppliers_id'],
                'itemtype' => 'PluginDlteamsRecord',
                'items_id' => $_POST['plugin_dlteams_records_id'],
                'itemtype1' => 'PluginDlteamsSendingReason',
                'items_id1' => $_POST['plugin_dlteams_sendingreasons_id'],
                'comment' => $_POST['recipient_comment'],
                'foreign_id' => $r_id
            ]);

            $sr_i = new PluginDlteamsSendingReason_Item();
            $sr_i->add([
                'sendingreasons_id' => $_POST['plugin_dlteams_sendingreasons_id'],
                'itemtype' => 'PluginDlteamsRecord',
                'items_id' => $_POST['plugin_dlteams_records_id'],
                'itemtype1' => 'Supplier',
                'items_id1' => $_POST['suppliers_id'],
                'comment' => $_POST['recipient_comment'],
                'foreign_id' => $r_id
            ]);

            Session::addMessageAfterRedirect("Destinataire ajouté avec succès");
            break;

        default:
           break;
    }
}
elseif (isset($_POST['add2']) && (isset($_POST['plugin_dlteams_records_id']))) {
    global $DB;
    $record = new PluginDlteamsRecord();
    $record->canEdit($_POST['plugin_dlteams_records_id']);

    // Add/update process
    foreach ($_POST as $key => $value) {
        if (preg_match('/process_.*/',$key)) {
            $process_array [preg_replace('/process_/', '',$key)] = $value;
        }
    }

    if (array_key_exists(2, $process_array) && $process_array[2] === 'on') {
        $DB->updateOrDie(
            'glpi_plugin_dlteams_records',
            [
                'external_process' => "yes",
            ],
            ['id' => $_POST['plugin_dlteams_records_id']]
        );
    }
    else{
        $DB->updateOrDie(
            'glpi_plugin_dlteams_records',
            [
                'external_process' => "no",
            ],
            ['id' => $_POST['plugin_dlteams_records_id']]
        );
    }
    $process_json = json_encode($process_array, JSON_UNESCAPED_UNICODE);


    $DB->updateOrDie(
        'glpi_plugin_dlteams_records',
        [
            'external_group' => json_encode($_POST['external_group']),
            'external_supplier' => json_encode($_POST['external_supplier']),
            'external_process' => $process_json,
        ],
        ['id' => $_POST['plugin_dlteams_records_id']]
    );

}
elseif (isset($_POST["update_edit_record_acteur_externe"])){
/*    highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//    die();
    if(!$_POST["items_id1"]){
        Session::addMessageAfterRedirect("Veuillez sélectionner un motif", 0, ERROR);
        Html::back();
    }
    $record_item = new PluginDlteamsRecord_Item();
    if($record_item->getFromDB($_POST["linkid"])){
        $record_item_oldfields = $record_item->fields;

        global $DB;
        $DB->update(
            $record_item->getTable(),
            [
                "itemtype" => $_POST["itemtype"],
                "items_id" => $_POST["items_id"],
                "items_id1" => $_POST["items_id1"],
                "comment" => $_POST["comment"],
            ],
            [
                "id" => $_POST["linkid"]
            ]
        );

        $criteria_sr = [
            "sendingreasons_id" => $record_item_oldfields["items_id1"],
            "itemtype" => PluginDlteamsRecord::class,
            "items_id" => $record_item_oldfields["records_id"],
            "itemtype1" => $record_item_oldfields["itemtype"],
            "items_id1" => $record_item_oldfields["items_id"],
            "comment" => $record_item_oldfields["comment"]
        ];

        $sendingreasn_item = new PluginDlteamsSendingReason_Item();
        if($sendingreasn_item->deleteByCriteria($criteria_sr)){
            $sendingreasn_item->add([
                ...$criteria_sr,
                "sendingreasons_id" => $_POST["items_id1"],
                "comment" => $_POST["comment"]
            ]);
        }


//        itemtype
        $tempitemtype = $record_item_oldfields["itemtype"];
        if($tempitemtype == PluginDlteamsThirdPartyCategory::class)
            $relation_column_id = "thirdpartycategories_id";
        else
            $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $tempitemtype))) . "s_id";

        $criteria_sr = [
            "$relation_column_id" => $record_item_oldfields["items_id"],
            "itemtype" => PluginDlteamsRecord::class,
            "items_id" => $record_item_oldfields["records_id"],
            "itemtype1" => $record_item_oldfields["itemtype1"],
            "items_id1" => $record_item_oldfields["items_id1"],
            "comment" => $record_item_oldfields["comment"]
        ];

        $tempitemtype_item_str = $tempitemtype."_Item"; // ex: ThirdPartyCategory_Item
        $tempitemtype_item = new $tempitemtype_item_str();
        if($tempitemtype_item->deleteByCriteria($criteria_sr)){
            $tempitemtype_item->add([
                ...$criteria_sr,
                "$relation_column_id" => $_POST["items_id"],
                "itemtype" => PluginDlteamsRecord::class,
                "items_id" => $record_item_oldfields["records_id"],
                "itemtype1" => PluginDlteamsSendingReason::class,
                "items_id1" => $_POST["items_id1"],
                "comment" => $_POST["comment"]
            ]);
        }


//        $itemtype_item_str = $record_item_oldfields["itemtype"]."_Item"; // ConcernedPerson, ThirdPartyCategory, Supplier
//        $itemtype_item = new $itemtype_item_str();
//        $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $record_item_oldfields["itemtype"]))) . "s_id";
//
//        $criteria_itemtype = [
//            $relation_column_id => $record_item_oldfields["records_id"],
//            "itemtype" => PluginDlteamsRecord::class,
//            "items_id" => $record_item_oldfields["records_id"],
//            "itemtype1" => $record_item_oldfields["itemtype1"],
//            "items_id1" => $record_item_oldfields["items_id1"],
//            "comment" => $record_item_oldfields["comment"]
//        ];
//        if($itemtype_item->getFromDBByCrit($criteria_itemtype)){
//            $itemtype_item->update([
//                ...$criteria_itemtype,
//                "items_id1" => $_POST["items_id1"],
//                "comment" => $_POST["comment"]
//            ]);
//        }

        Session::addMessageAfterRedirect("Opération éffectuée avec succès");
        Html::back();
    }

}

if($_POST["plugin_dlteams_records_id"]){

    $r = new PluginDlteamsRecord();
    $r->getFromDB($_POST["plugin_dlteams_records_id"]);
    $nb = count(PluginDlteamsRecord_External::getListForItem($r));
//    $max_vuln = count();

    $DB->update(PluginDlteamsRecord::getTable(),[
        "r_actors" => $nb,
//        "r_max_vuln" => ""
    ],
        ["id" => $_POST["plugin_dlteams_records_id"]]);




    $iterator = PluginDlteamsRecord_External::getListForItem($r);
    $number = count($iterator);

    $DB->update(PluginDlteamsRecord::getTable(),[
        "r_recipients" => $number,
    ],
        ["id" => $_POST["plugin_dlteams_records_id"]]);
}


Html::back();
