<?php

/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2023 Teclib' and contributors.
 * @copyright 2003-2014 by the INDEPNET Development Team.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */

class PluginDlteamsAppliance_Actor extends CommonDBTM
{
    use Glpi\Features\Clonable;

//    public static $itemtype_1 = 'PluginDlteamsDataCatalog';
//    public static $items_id_1 = 'datacatalogs_id';
//    public static $take_entity_1 = false;
//
//    public static $itemtype_2 = 'itemtype';
//    public static $items_id_2 = 'items_id';
//    public static $take_entity_2 = true;

//    public function getCloneRelations(): array
//    {
//        return [
//            Appliance_Item_Relation::class
//        ];
//    }

    static function canCreate() {return true;}
    static function canView() {return true;}
    static function canUpdate() {return true;}
    static function canDelete() {return true;}
    static function canPurge() {return true;}

    public static function showManualLinkSupport(CommonGLPI $item)
    {

        global $DB;
        $iterator = $DB->request([
            'FROM'         => 'glpi_manuallinks',
            'WHERE'        => [
                'itemtype'  => $item->getType(),
                'items_id'  => $item->fields[$item->getIndexName()],
                'comment'   => ["help&support", "help&#38;support"]
            ],
            'ORDERBY'      => 'name'
        ]);
//        var_dump($iterator->getSql());
//        die();

        echo '<div class="spaced">';
        echo '<table class="tab_cadrehov" style="with: 100%">';
        echo '<tr>';
        echo '<th colspan="2">';
        echo self::getTypeName(Session::getPluralNumber());
        echo '</th>';
        echo '<th class="right">';
        echo '</th>';
        echo '</tr>';
        if (count($iterator)) {
            foreach ($iterator as $row) {
//                $link->getFromResultSet($row);

                echo '<tr class="tab_bg_2">';
                echo '<td>';
                echo self::getLinkHtml($row);
                echo '</td>';
                echo '<td>';
                echo $row['comment'];
                echo '</td>';
                echo '<td class="right">';
                echo '</td>';
                echo '</tr>';
            }
        } else {
            echo '<tr class="tab_bg_2">';
            echo '<td colspan="3">';
            echo __('No link defined');
            echo '</td>';
            echo '</tr>';
        }

        echo '</table>';
        echo '</div>';
    }

    private static function getLinkHtml(array $fields): string
    {

        if (empty($fields['url'])) {
            return '';
        }

        $html = '';

        // decode `&` to prevent doube encoding when value will be printed using `htmlspecialchars()`
        $raw_url = \Glpi\Toolbox\Sanitizer::decodeHtmlSpecialChars($fields['url']);

        $target = $fields['open_window'] == 1 ? '_blank' : '_self';
        $html .= '<a href="' . htmlspecialchars($raw_url) . '" target="' . $target . '">';
        if (!empty($fields['icon'])) {
            // Forces font family values to fallback on ".fab" family font if char is not available in ".fas" family.
            $html .= '<i class="fa-lg fa-fw fa ' . htmlspecialchars($fields['icon']) . '"'
                . ' style="font-family:\'Font Awesome 6 Free\', \'Font Awesome 6 Brands\';"></i>&nbsp;';
        }
        $html .= !empty($fields['name']) ? $fields['name'] : $fields['url'];
        $html .= '</a>';

        return $html;
    }

    function canCreateItem() {return true;}
    function canViewItem() {return true;}
    function canUpdateItem() {return true;}
    function canDeleteItem() {return true;}
    function canPurgeItem() {return true;}

    public static function getTypeName($nb = 0)
    {
        return _n('Help & support', 'Help & support', $nb);
    }

//    static public $itemtype_2 = 'PluginDlteamsDataCatalog';
    static public $itemtype_1;
    public static $items_id_1;
    public static $title;
    public static $sub_title;
    public static $table_match_str = [];

    public function __construct()
    {
        static::$itemtype_1 = str_replace("_Item", "", __CLASS__); // $itemtype_1 ---> PluginDlteamsDataCatalog
        static::$items_id_1 = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", __CLASS__))) . "s_id";
        parent::__construct();
        self::forceTable(Appliance_Item::getTable());
    }


    public function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {


        $nb = 0;

            if ($_SESSION['glpishow_count_on_tabs']) {
                global $DB;
                $iterator=$DB->request(self::getRequest($item));
                $nb = count($iterator);
            return self::createTabEntry(self::getTypeName(Session::getPluralNumber()), $nb);
        }

        return '';
    }

    public static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {

        switch ($item->getType()) {
            case Appliance::class:
                self::showItemsForItemType($item);


                self::showManualLinkSupport($item);
                break;
        }
        return true;
    }


    static function showItemsForItemType(CommonDBTM $object_item, $withtemplate = 0) {
        global $DB;
        $id = $object_item->fields['id'];
        if (!$object_item->can($id, READ)) {
            return false;
        }

        $canedit = $object_item->can($id, UPDATE);
        $rand = mt_rand(1, mt_getrandmax());

        $iterator=$DB->request(self::getRequest($object_item));
        /*        highlight_string("<?php\n\$data =\n" . var_export($iterator->getSql(), true) . ";\n?>");*/
//        die();


//        $iterator=$DB->request([]);
        $number = count($iterator);


        $items_list = [];
        $used = [];
        foreach ($iterator as $id => $data){
            // while ($data = $iterator->next()) {
            $items_list[$data['linkid']] = $data;

            $used[$data['linkid']] = $data['linkid'];

        }
        //print_r($items_list);die;
        if ($canedit) {
            echo "<div class='firstbloc'>";
            echo "<form name='ticketitem_form$rand' id='ticketitem_form$rand' method='post'
            action='" . Toolbox::getItemTypeFormURL(__class__) . "'>";
            $iden = $object_item->fields['id'];
            echo "<input type='hidden' name='appliances_id' value='$iden' />";

            echo "<table class='tab_cadre_fixe'>";
            echo "<tr class='tab_bg_2'><th colspan='3'>" . __("Intervenants techniques pour l'installation et la configuration", 'dlteams');
            Html::showToolTip(__("Intervenants techniques pour l'installation et la configuration)"));
            echo "</th></tr>";

            echo "<tr class='tab_bg_1'>";
            //echo __("Group");
            echo "<td width='' class='left'>";
//            echo "<p style='font-size:13px'><i></i></p>";
            /* Test Field */
            global $CFG_GLPI;

            $id = $object_item->fields['id'];
            if (!$object_item->can($id, READ)) {
                return false;
            }

            $canedit = PluginDlteamsRecord::canUpdate();
            $rand = mt_rand(1, mt_getrandmax());

            $options['canedit'] = $canedit;
            $options['formtitle'] = __("Right exercice", 'dlteams');

            $rand = Dropdown::showFromArray("consent_type", [
                __("------", 'dlteams'),
                __("Groupe", 'dlteams'),
                __("Utilisateur", 'dlteams'),
                __("Tiers Categories", 'dlteams'),
                __("Tiers", 'dlteams'),
            ], [
                'value' => $item->fields['consent_type1'] ?? 0,
                'width' => '130px'
            ]);
            $params = [
                'consent_type1' => '__VALUE__',
                'appliances_id' => $id
            ];
            Ajax::updateItemOnSelectEvent(
                "dropdown_consent_type$rand",
                'consent_row2',
                $CFG_GLPI['root_doc'] . '/marketplace/dlteams/ajax/appliance_external_dropdown.php',
                $params
            );
            echo "<span id='consent_row2' style='margin-left:40px!important'>";
//            static::showConsent1($object_item, $object_item->fields);

            echo "</span>";
            echo "</td></tr>";

            echo "</table>";
            Html::closeForm();
            echo "</div>";

        }

        // Display recipients
        echo "<div class='spaced'>";
        if ($canedit && $number) {
            Html::openMassiveActionsForm('mass' . __CLASS__ . $rand);
            $massive_action_params = ['container' => 'mass' .__CLASS__ . $rand,
                'num_displayed' => min($_SESSION['glpilist_limit'], $number)];
            Html::showMassiveActions($massive_action_params);
        }
        echo "<table class='tab_cadre_fixehov'>";

        $header_begin = "<tr>";
        $header_top = '';
        $header_bottom = '';
        $header_end = '';

        if ($canedit && $number) {

            $header_begin   .= "<th width='10'>";
            $header_top     .= Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand);
            $header_bottom  .= Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand);
            $header_end     .= "</th>";

            $header_end .= "<th></th>";
        }


        $header_end .= "<th>" . __("Acteur") . "</th>";
        $header_end .= "<th>" . __("Type", 'dlteams') . "</th>";
        $header_end .= "<th>" . __("Rôles") . "</th>";
        $header_end .= "</tr>";


        echo $header_begin . $header_top . $header_end;
        //var_dump($items_list);

        foreach ($items_list as $data) {
            echo "<tr class='tab_bg_1'>";

            if ($canedit && $number) {
                echo "<td width='10'>";
                Html::showMassiveActionCheckBox(__CLASS__, $data['linkid']);
                echo "</td>";

                echo "<td width='15' >";
                $linkid = $data['linkid'];
//                TODO: edit
                echo "<i class='fa fa-edit editma$rand' style='cursor:pointer;' data-id='$linkid'></i>";
                echo "</td>";
            }

            $itemtype_str = $data['itemtype'];
            $itemtype_object = new $itemtype_str();
            $itemtype_object->getFromDB($data['items_id']);

            $nametodisplay = isset($itemtype_object->fields['name'])?$itemtype_object->fields['name']:"";

            if($itemtype_str == User::class){
//                $email = UserEmail::getDefaultForUser($data['items_id']);
                $user_fields = $itemtype_object->fields;
                $fields = [
//                    $user_fields["name"] ?? '',
                    $user_fields["firstname"] ?? '',
                    $user_fields["realname"] ?? '',
//                    $email ?? ''
                ];
                /*                highlight_string("<?php\n\$data =\n" . var_export($fields, true) . ";\n?>");*/

//              Filtrer les champs vides
                $fields = array_filter($fields, fn($value) => !empty($value));

//              Joindre les champs avec ' | '
                $nametodisplay = implode(' ', $fields);
            }
            $name = "<a target='_blank' href=\"" . $data['itemtype']::getFormURLWithID($data['items_id']) . "\">" . $nametodisplay . "</a>";

            echo "<td width='40%' class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
            echo ">" . $name . "</td>";

            echo "<td class='left' width='30%'>" . $data['itemtype']::getTypeName() . "</td>";
            echo "<td class='left' width='40%'>" . (stripslashes($data['comment'])?? "") . "</td>";
            echo "</tr>";
        }

        if ($iterator->count() > 10) {
            echo $header_begin . $header_bottom . $header_end;
        }
        echo "</table>";

        if ($canedit && $number > 10) {
            $massive_action_params['ontop'] = false;
            Html::showMassiveActions($massive_action_params);
        }
        Html::closeForm();


        echo "<script>
            $('.editma$rand').off('click').click(function(e) {
                
               glpi_ajax_dialog({
                dialogclass: 'modal-xs',
                bs_focus: false,
                url: '/marketplace/dlteams/ajax/edit_items.php',
                params: {
                    action: 'edit_appliance_acteurs',
                    linkid: $(this).data('id')
                },
                title: i18n.textdomain('dlteams').__('Action', 'dlteams'),
                close: function () {

                },
                fail: function () {
                    displayAjaxMessageAfterRedirect();
                }
            });
            });
            
            </script>";


        echo "</div>";
    }

    static function showConsent1(Appliance $record, $data = []) {
        if ($data['consent_type1'] == 0) {
        }else if ($data['consent_type1'] == 1) {
            //echo __("Groupe <i class='fas fa-dolly'></i>&nbsp;", 'dlteams');
            Group::dropdown([
                'addicon'  => Group::canCreate(),
                'name' => "groups_id",
                'display_emptychoice' => false,
                'width' => "200px"
            ]);
            echo "<textarea type='text' rows='1' name='comment' placeholder='Commentaire'  style='margin-bottom:-15px;margin-left:90px;width:45%'></textarea>";
            echo "<input type='submit' name='add1' value=\"" . _sx('button', 'Add') . "\" class='submit' style='float:right;margin-right:7.5%'>";

        } else if ($data['consent_type1'] == 2) {

            //echo __("Utilisateur <i class='fas fa-dolly'></i>&nbsp;", 'dlteams');

            /*User::dropdown([
            'addicon'  => User::canCreate(),
            'name' => "users_id",
            'display_emptychoice' => false,
            'width' => "200px"

         ]); */
            $randDropdown = mt_rand();
            User::dropdown(['value'  => $record->fields["users_id"],
                'entity' => $record->fields["entities_id"],
                'right'  => 'all',
                'width' => '200px',
                'rand'   => $randDropdown]);
            echo "<textarea type='text' maxlength=600 rows='1' name='comment' placeholder='Commentaire' style='margin-bottom:-15px;margin-left:40px;width:45%'></textarea>";
            echo "<input type='submit' name='add1' value=\"" . _sx('button', 'Add') . "\" class='submit' style='float:right;margin-right:7.5%'>";


        }
        else if ($data['consent_type1'] == 3) {
            // Display explicit consentecho "<td><br>" . "</td><td>";

            //echo __("Tiers Categories <i class='fas fa-dolly'></i>&nbsp;", 'dlteams');

            PluginDlteamsThirdPartyCategory::dropdown([
                'addicon'  => PluginDlteamsThirdPartyCategory::canCreate(),
                'name' => "plugin_dlteams_thirdpartycategories_id1",
                'width' => "200px"
            ]);
            echo "<textarea type='text' maxlength=600 rows='1' name='comment' placeholder='Commentaire' style='margin-bottom:-15px;margin-left:90px;width:45%'></textarea>";
            echo "<input type='submit' name='add1' value=\"" . _sx('button', 'Add') . "\" class='submit' style='float:right;margin-right:7.5%'>";

        }

        else if ($data['consent_type1'] == 4) {
            // Display explicit consentecho "<td><br>" . "</td><td>";

            //echo __("Tiers <i class='fas fa-dolly'></i>&nbsp;", 'dlteams');

            Supplier::dropdown([
                'addicon'  => Supplier::canCreate(),
                'name' => "suppliers_id1",
                'display_emptychoice' => false,
                'width' => "200px"
            ]);
            echo "<textarea type='text' maxlength=600 rows='1' name='comment' placeholder='Commentaire' style='margin-bottom:-15px;margin-left:90px;width:45%'></textarea>";

            echo "<input type='submit' name='add1' value=\"" . _sx('button', 'Add') . "\" class='submit' style='float:right;margin-right:7.5%'>";
        }

    }

    /**
     * Print enclosure items
     *
     * @param Appliance $appliance  Appliance object wanted
     *
     * @return void|boolean (display) Returns false if there is a rights error.
     **/
    public static function showItems(Appliance $appliance)
    {
        global $DB;

        $ID = $appliance->fields['id'];
        $rand = mt_rand();

        if (
            !$appliance->getFromDB($ID)
            || !$appliance->can($ID, READ)
        ) {
            return false;
        }
        $canedit = $appliance->canEdit($ID);

        $items = $DB->request([
            'FROM'   => self::getTable(),
            'WHERE'  => [
                self::$items_id_1 => $ID
            ]
        ]);

        Session::initNavigateListItems(
            self::getType(),
            //TRANS : %1$s is the itemtype name,
            //        %2$s is the name of the item (used for headings of a list)
            sprintf(
                __('%1$s = %2$s'),
                $appliance->getTypeName(1),
                $appliance->getName()
            )
        );

        if ($appliance->canAddItem('itemtype')) {
            echo "<div class='firstbloc'>";
            echo "<form method='post' name='appliances_form$rand'
                     id='appliances_form$rand'
                     action='" . Toolbox::getItemTypeFormURL(__CLASS__) . "'>";

            echo "<table class='tab_cadre_fixe'>";

            switch ($item::getType()){
                case PluginDlteamsDataCatalog::class:
                    static::$title = "Applications permettant l'accès à ce catalogue";
                    break;
                //case Document::class:
                //    static::$title = "Jeux de données contenus dans ce document";
                //    break;
            }

            echo "<tr class='tab_bg_2'><th colspan='3'>" . static::$title .
                "</th>";
            echo "</tr>";

            echo "<tr class='tab_bg_2'>";
            echo "<th colspan='2'>" .
                __('Add an item', 'dlteams') . "</th></tr>";

            echo "<tr class='tab_bg_1'><td class='center'>";
//            Dropdown::showSelectItemFromItemtypes(
//                ['items_id_name'   => 'items_id',
//                    'itemtypes'       => Appliance::getTypes(true),
//                    'entity_restrict' => ($appliance->fields['is_recursive']
//                                      ? getSonsOf(
//                                          'glpi_entities',
//                                          $appliance->fields['entities_id']
//                                      )
//                                       : $appliance->fields['entities_id']),
//                    'checkright'      => true,
//                ]
//            );

            Appliance::dropdown([
                'addicon' => PluginDlteamsSendingReason::canCreate(),
                'name' => 'items_id',
                'entity_restrict' => ($appliance->fields['is_recursive']
                    ? getSonsOf(
                        'glpi_entities',
                        $appliance->fields['entities_id']
                    )
                    : $appliance->fields['entities_id']),
                'width' => "250px",
                'checkright'      => true,
            ]);
            echo "</td><td class='center' class='tab_bg_1'>";
            echo Html::hidden('appliances_id', ['value' => $ID]);
            echo Html::submit(_x('button', 'Add'), ['name' => 'add']);
            echo "</td></tr>";
            echo "</table>";
            Html::closeForm();
            echo "</div>";
        }

        $items = iterator_to_array($items);

        if (!count($items)) {
            echo "<table class='tab_cadre_fixe'><tr><th>" . __('No item found') . "</th></tr>";
            echo "</table>";
        } else {
            if ($canedit) {
                Html::openMassiveActionsForm('mass' . __CLASS__ . $rand);
                $massiveactionparams = [
                    'num_displayed'   => min($_SESSION['glpilist_limit'], count($items)),
                    'container'       => 'mass' . __CLASS__ . $rand
                ];
                Html::showMassiveActions($massiveactionparams);
            }

            echo "<table class='tab_cadre_fixehov'>";
            $header = "<tr>";
            if ($canedit) {
                $header .= "<th width='10'>";
                $header .= Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand);
                $header .= "</th>";
            }
            $header .= "<th>" . __('Itemtype') . "</th>";
            $header .= "<th>" . _n('Item', 'Items', 1) . "</th>";
            $header .= "<th>" . __("Serial") . "</th>";
            $header .= "<th>" . __("Inventory number") . "</th>";
            $header .= "<th>" . Appliance_Item_Relation::getTypeName(Session::getPluralNumber()) . "</th>";
            $header .= "</tr>";
            echo $header;

            foreach ($items as $row) {
                $item = new $row['itemtype']();
                $item->getFromDB($row['items_id']);
                echo "<tr lass='tab_bg_1'>";
                if ($canedit) {
                    echo "<td>";
                    Html::showMassiveActionCheckBox(__CLASS__, $row["id"]);
                    echo "</td>";
                }
                echo "<td>" . $item->getTypeName(1) . "</td>";
                echo "<td>" . $item->getLink() . "</td>";
                echo "<td>" . ($item->fields['serial'] ?? "") . "</td>";
                echo "<td>" . ($item->fields['otherserial'] ?? "") . "</td>";
                echo "<td class='relations_list'>";
                echo Appliance_Item_Relation::showListForApplianceItem($row["id"], $canedit);
                echo "</td>";
                echo "</tr>";
            }
            echo $header;
            echo "</table>";

            if ($canedit && count($items)) {
                $massiveactionparams['ontop'] = false;
                Html::showMassiveActions($massiveactionparams);
            }
            if ($canedit) {
                Html::closeForm();
            }

            echo Appliance_Item_Relation::getListJSForApplianceItem($appliance, $canedit);
        }
    }


    public function post_purgeItem()
    {
//        purge relations
        $relation_item_str = $this->fields["itemtype"] . "_Item";
        if(!class_exists($relation_item_str))
            $relation_item_str = "PluginDlteams".$relation_item_str;
        $relation_item = new $relation_item_str();

        if($this->fields["itemtype"] == PluginDlteamsThirdPartyCategory::class)
            $relation_column_id = "thirdpartycategories_id";
        else
            $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype"]))) . "s_id";

        /*        highlight_string("<?php\n\$data =\n" . var_export($this->fields, true) . ";\n?>");*/
//        highlight_string("<?php\n\$data =\n" . var_export([
//                "itemtype" => PluginDlteamsDataCatalog::class,
//                "items_id" => $this->fields["appliances_id"],
//                $relation_column_id => $this->fields["items_id"],
//                "comment" => $this->fields["comment"]
        /*            ], true) . ";\n?>");*/
//        die();
        $criteria = [
            "itemtype" => "PluginDlteamsAppliance",
            "items_id" => $this->fields["appliances_id"],
            $relation_column_id => $this->fields["items_id"],
            "comment" => $this->fields["comment"]
        ];

        $relation_item->deleteByCriteria($criteria);
    }

    public function post_updateItem($history = 1)
    {
        $relation_item_str = $this->fields["itemtype"] . "_Item";
        if(!class_exists($relation_item_str))
            $relation_item_str = "PluginDlteams".$relation_item_str;
        $relation_item = new $relation_item_str();
        $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype"]))) . "s_id";

        $criteria = [
            "itemtype" => PluginDlteamsAppliance::class,
            "items_id" => $this->fields["appliances_id"],
            $relation_column_id => $this->fields["items_id"],
            "comment" => $this->oldvalues["comment"]
        ];

        $relation_item->deleteByCriteria($criteria);
        $relation_item->add([
            ...$criteria,
            "comment" => $this->fields["comment"]
        ]);
    }

    public static function getRequest(CommonDBTM $object_item){
        $tablename = Appliance_Item::getTable();
        $request = [
            'SELECT' => [
                $tablename.'.id AS linkid',
                $tablename.'.itemtype AS itemtype',
                $tablename.'.items_id AS items_id',
                $tablename.'.comment AS comment',
            ],
            'FROM' => $tablename,
            'ORDER' => [$tablename.'.id ASC'],
            'OR' => [
                [
                    $tablename.'.appliances_id' => $object_item->fields['id'],
                    $tablename.'.itemtype' => 'Group',
                ],
                [
                    $tablename.'.appliances_id' => $object_item->fields['id'],
                    $tablename.'.itemtype' => 'User',
                ],
                [
                    $tablename.'.appliances_id' => $object_item->fields['id'],
                    $tablename.'.itemtype' => 'PluginDlteamsThirdPartyCategory',
                ],
//                [
//                    $tablename.'.records_id' => $object_item->fields['id'],
//                    $tablename.'.itemtype' => 'PluginDlteamsThirdPartyCategory',
//                    $tablename.'.itemtype1' => 'PluginDlteamsRgpdAdequacy',
//                ],
                [
                    $tablename.'.appliances_id' => $object_item->fields['id'],
                    $tablename.'.itemtype' => 'Supplier',
                ],
            ]
        ];

        return $request;
    }

    function rawSearchOptions()
    {
        $tab[] = [
            'id' => '44',
            'table' => static::getTable(),
            'field' => 'comment',
            'datatype' => 'text',
            'name' => __("Commentaire"),
            'forcegroupby' => true,
            'massiveaction' => true,
        ];

        return $tab;
    }

    public function prepareInputForAdd($input)
    {
        return $this->prepareInput($input);
    }

    public function prepareInputForUpdate($input)
    {
        return $this->prepareInput($input);
    }

    /**
     * Prepares input (for update and add)
     *
     * @param array $input Input data
     *
     * @return array
     */
    private function prepareInput($input)
    {
        $error_detected = [];

        //check for requirements
        if (
            ($this->isNewItem() && (!isset($input['itemtype']) || empty($input['itemtype'])))
            || (isset($input['itemtype']) && empty($input['itemtype']))
        ) {
            $error_detected[] = __('An item type is required');
        }
        if (
            ($this->isNewItem() && (!isset($input['items_id']) || empty($input['items_id'])))
            || (isset($input['items_id']) && empty($input['items_id']))
        ) {
            $error_detected[] = __('An item is required');
        }
        if (
            ($this->isNewItem() && (!isset($input[self::$items_id_1]) || empty($input[self::$items_id_1])))
            || (isset($input[self::$items_id_1]) && empty($input[self::$items_id_1]))
        ) {
            $error_detected[] = __('An appliance is required');
        }

        if (count($error_detected)) {
            foreach ($error_detected as $error) {
                Session::addMessageAfterRedirect(
                    $error,
                    true,
                    ERROR
                );
            }
            return false;
        }

        return $input;
    }

    public static function countForMainItem(CommonDBTM $item, $extra_types_where = [])
    {
        $types = Appliance::getTypes();
        $clause = [];
        if (count($types)) {
            $clause = ['itemtype' => $types];
        } else {
            $clause = [new \QueryExpression('true = false')];
        }
        $extra_types_where = array_merge(
            $extra_types_where,
            $clause
        );
        return parent::countForMainItem($item, $extra_types_where);
    }

    public function getForbiddenStandardMassiveAction()
    {
        $forbidden = parent::getForbiddenStandardMassiveAction();
        $forbidden[] = 'clone';
        $forbidden[] = 'MassiveAction:add_transfer_list';
        $forbidden[] = 'MassiveAction:amend_comment';
        $forbidden[] = 'MassiveAction:update';
        return $forbidden;
    }

    public static function getRelationMassiveActionsSpecificities()
    {
        global $CFG_GLPI;

        $specificities              = parent::getRelationMassiveActionsSpecificities();
        $specificities['itemtypes'] = Appliance::getTypes();

        return $specificities;
    }

    public function cleanDBonPurge()
    {
        $this->deleteChildrenAndRelationsFromDb(
            [
                Appliance_Item_Relation::class,
            ]
        );
    }

    public function getCloneRelations(): array
    {
        // TODO: Implement getCloneRelations() method.
    }
}

