<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

use GlpiPlugin\dlteams\Exception\ImportFailureException;


define('age_digital_maturity', [
//    null,
    1 => __("Low", 'dlteams'),
    2 => __("Medium", 'dlteams'),
    3 => __("High", 'dlteams')
]);

define('dependancy_status', [
//    null,
    1 => __("Low", 'dlteams'),
    2 => __("Medium", 'dlteams'),
    3 => __("High", 'dlteams')
]);

define('ability_understant_record', [
//    null,
    1 => __("Low", 'dlteams'),
    2 => __("Medium", 'dlteams'),
    3 => __("High", 'dlteams')
]);

define('socio_economic_or_legal_situation', [
//    null,
    1 => __("Low", 'dlteams'),
    2 => __("Medium", 'dlteams'),
    3 => __("High", 'dlteams')
]);



//class PluginDlteamsConcernedPerson extends CommonDBTM implements
class PluginDlteamsConcernedPerson extends CommonDropdown implements
    PluginDlteamsExportableInterface
{

    use PluginDlteamsExportable;

    static $rightname = 'plugin_dlteams_concernedperson';
    public static $menukey = "datagovernanceconcernedperson";
    public $dohistory = true;
    protected $usenotepad = true;

    public const LOW    = 1;
    public const MEDIUM = 2;
    public const HIGH   = 3;

    // Libellés associés
    private const LABELS = [
        self::LOW    => 'Risque faible',
        self::MEDIUM => 'Moyen',
        self::HIGH   => 'Vulnérable',
    ];

    static function getTypeName($nb = 0)
    {
        return _n("Concerned person", "Concerned persons", $nb, 'dlteams');
    }

    function showForm($id, $options = [])
    {
        global $CFG_GLPI;

        $this->initForm($id, $options);
        $this->showFormHeader($options);

        echo "<style>";
        echo "
            .form-table-text {
                text-align: right;
                width: 25%;
            }
            
            
            @media (max-width: 800px) {
                .form-table-text {
                    text-align: left;
                    width: 100%;
                }
            }
        ";

        echo "</style>";
        echo "<table, th, td width='100%'>";

        echo "<tr>";
////		echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td class='form-table-text'>" . __("Order", 'dlteams') . "</td>";
        echo "<td colspan='1'>";
        $number = Html::cleanInputText($this->fields['ranking']);
        echo "<input type='number' min='1' max='999' name='ranking' size='8' value='" . $number . "'>";
        echo "</td>";
        echo "<td width='30%' style='text-align:right'>" . " " . "</td>";
        echo "</tr>";

        echo "<tr>";
//		echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td class='form-table-text'>" . __("Name", 'dlteams') . "</td>";
        echo "<td>";
        $name = Html::cleanInputText($this->fields['name']);
        echo "<input type='text' style='width:98%' name='name' required value='" . $name . "'>" . "</td>";
        echo "<td width='30%' style='text-align:right'>" . " " . "</td>";
        echo "</tr>";

        // Ajout des boutons radio pour la catégorie de personne
        echo "<tr>";
        echo "<td class='form-table-text'>" . __("Individus ou organismes ?", 'dlteams') . "</td>";
        echo "<td>";
        $category = isset($this->fields['category']) ? $this->fields['category'] : 'physique';
        echo "<div style='display: flex; gap: 20px; align-items: center;'>";
        echo "<label style='display: flex; align-items: center; gap: 5px;'>";
        echo "<input type='radio' name='category' value='physique' " . ($category == 'physique' ? 'checked' : '') . ">";
        echo "<span>" . __("Personnes physiques", 'dlteams') . "</span>";
        echo "</label>";
        echo "<label style='display: flex; align-items: center; gap: 5px;'>";
        echo "<input type='radio' name='category' value='morale' " . ($category == 'morale' ? 'checked' : '') . ">";
        echo "<span>" . __("Personnes morales", 'dlteams') . "</span>";
        echo "</label>";
        echo "</div>";
        echo "</td>";
        echo "<td width='30%' style='text-align:right'>" . " " . "</td>";
        echo "</tr>";


        echo "<tr class='tab_bg_1'>";
        echo "<td class='form-table-text'>" . PluginDlteamsConcernedPersonCategory::getTypeName(Session::getPluralNumber()) . "</td>";
        echo "<td>";
        echo Html::input("__categories_defined", ["type" => "hidden", "value" => 1]);
        $rand = mt_rand();
        echo "<div style='display: flex; flex-direction: row; gap: 0px'>";
        PluginDlteamsConcernedPersonCategory::dropdown([
            'name' => "_categories[]",
            'value' => $this->fields['_categories'] ?? [],
            'multiple' => true,
            'width' => "100%",
        ]);
        $comment_icon = "";
        $comment_id = Html::cleanId("comment_" . "_categories[]" . $rand);
        $link_id = Html::cleanId("comment_link_" . "_categories[]" . $rand);

        $comment_icon .= Html::showToolTip("Montrer " . PluginDlteamsConcernedPersonCategory::getTypeName(), [
            "link_class" => 'btn btn-outline-secondary',
            'contentid' => $comment_id,
            'linkid' => $link_id,
            'addicon' => false,
            'display' => false,
            'link' => PluginDlteamsConcernedPersonCategory::getSearchURL()
        ]);

        echo $comment_icon;
        echo "</div>";

        echo "</td>";
        echo "</tr>\n";

        echo "<tr>";
//      echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td class='form-table-text'>" . __("Description", 'dlteams') . "</td>";
        echo "<td>";
        $content = Html::cleanInputText($this->fields['content']);
        echo "<textarea style='width: 98%;' name='content' rows='2'>" . $content . "</textarea>";
        echo "</td>";
        echo "<td width='30%' style='text-align:right'>" . " " . "</td>";
        echo "</tr>";

        echo "<tr>";
//      echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td class='form-table-text'>" . __("Comment", 'dlteams') . "</td>";
        echo "<td>";
        $comment = Html::cleanInputText($this->fields['comment']);
        echo "<textarea style='width: 98%;' name='comment' rows='2'>" . $comment . "</textarea>";
        echo "</td>";
        echo "<td width='30%' style='text-align:right'>" . " " . "</td>";
        echo "</tr>";
        echo "</table>";

        $this->showFormButtons($options);




        if(!$this->isNewItem()){
            $this->initForm($id, $options);
            $this->showFormHeader($options);
            echo "<table class='tab_cadre_fixe' style='width:100%;margin-bottom:16px;'>";
            echo "<colgroup>
                <col style='width:50%'>
                <col style='width:50%'>
              </colgroup>";
            echo "<tr class='tab_bg_1'><th colspan='2'>" . __('Critère de risque 1 : nombre de personnes concernées par cette catégorie') . "</th></tr>";

            echo "<tr>";
            echo "<td class='form-table-text'>" . __("Nombre de personnes de cette catégorie dont les données sont actuellement stockées", 'dlteams') . "</td>";
            $number = Html::cleanInputText($this->fields['number']);
            echo "<td><input type='number' min='0' name='number' size='8' value='" . $number . "'>";
            echo "<input type='hidden' name='id' size='8' value='" . $id . "'></td>";
            echo "</tr>";

            echo "<tr>";
            echo "<td class='form-table-text'>" . __("Nombre d’entrants, par an", 'dlteams') . "</td>";
            $newperyear = Html::cleanInputText($this->fields['newperyear']);
            echo "<td><input type='number' min='0' name='newperyear' size='8' value='" . $newperyear . "'></td>";
            echo "</tr>";

            echo "<tr>";
            echo "<td class='form-table-text'>" . __("Nombre de sortants, par an (suite aux suppressions et anonymisations en fin de traitement)", 'dlteams') . "</td>";
            $deletedperyear = Html::cleanInputText($this->fields['deletedperyear']);
            echo "<td><input type='number' min='0' name='deletedperyear' size='8' value='" . $deletedperyear . "'></td>";
            echo "</tr>";

            echo "<tr>";
            echo "<td class='form-table-text'>" . __("Cette comptabilisation est-elle déjà effectuée dans une autre catégorie", 'dlteams') . "</td>";
            echo "<td>";
            Dropdown::showYesNo('accounted', $this->fields['accounted']);
            echo "</td>";
            echo "</tr>";

            if ($this->fields['accounted']) {
                echo "<tr>";
                echo "<td class='form-table-text'>" . PluginDlteamsConcernedPerson::getTypeName() . "</td>";
                echo "<td>";
                PluginDlteamsConcernedPerson::dropdown([
                    'addicon' => PluginDlteamsConcernedPerson::canCreate(),
                    'name' => 'evenaccounted_id',
                    'used' => [$id],
                    'value' => $this->fields["evenaccounted_id"],
                    'width' => '200px'
                ]);
                echo "</td>";
                echo "</tr>";
            }

            echo "<tr class='tab_bg_2'><td colspan='2' class='center'>";
            echo "<input type='submit' name='update' value=\"" . __s('Save') . "\" class='btn btn-primary'></td></tr>";
            echo "</table>";
            Html::closeForm();

            $this->initForm($id, $options);
            $this->showFormHeader($options);

            echo "<div id='vulnerability-section'>";
            echo "<table class='tab_cadre_fixe' style='width:100%;margin-bottom:16px;'>";
            echo "<colgroup>
        <col style='width:50%'>
        <col style='width:50%'>
            </colgroup>";


            echo "<tr class='tab_bg_1'><th colspan='2'>" . __('Critère de risque 2 : niveau de vulnérabilité potentielle des personnes concernées', 'dlteams') . "</th></tr>";

            echo "<input type='hidden' name='id' size='8' value='" . $id . "'></td>";
            // 1. Âge et maturité numérique
            echo "<tr>";
            echo "<td class='form-table-text'>";
            echo __("Âge et maturité numérique", "dlteams") . " ";
            Html::showToolTip(__("Personnes mineures, âgées ou peu à l'aise avec le numérique", "dlteams"));
            echo "</td>";
            echo "<td>";
            Dropdown::showFromArray(
                'age_and_digital_maturity',
                [
                    '' => __('Non définie', 'dlteams'),
                    1 => __('Peu vulnérable', 'dlteams'),
                    2 => __('Moyen', 'dlteams'),
                    3 => __('Vulnérable', 'dlteams')
                ],
                ['value' => $this->fields['age_and_digital_maturity'], 'width' => '150px']
            );
            echo "</td>";
            echo "</tr>";

// 2. Situation de dépendance
            echo "<tr>";
            echo "<td class='form-table-text'>";
            echo __("Situation de dépendance", "dlteams") . " ";
            Html::showToolTip(__("Employés, patients, étudiants, clients captifs", "dlteams"));
            echo "</td>";
            echo "<td>";
            Dropdown::showFromArray(
                'dependency_situation',
                [
                    '' => __('Non définie', 'dlteams'),
                    1 => __('Peu vulnérable', 'dlteams'),
                    2 => __('Moyen', 'dlteams'),
                    3 => __('Vulnérable', 'dlteams')
                ],
                ['value' => $this->fields['dependency_situation'], 'width' => '150px']
            );
            echo "</td>";
            echo "</tr>";

// 3. Capacité à comprendre un traitement
            echo "<tr>";
            echo "<td class='form-table-text'>";
            echo __("Capacité à comprendre un traitement", "dlteams") . " ";
            Html::showToolTip(__("Complexité de l'information, transparence, compréhension limitée", "dlteams"));
            echo "</td>";
            echo "<td>";
            Dropdown::showFromArray(
                'record_understanding_ability',
                [
                    '' => __('Non définie', 'dlteams'),
                    1 => __('Peu vulnérable', 'dlteams'),
                    2 => __('Moyen', 'dlteams'),
                    3 => __('Vulnérable', 'dlteams')
                ],
                ['value' => $this->fields['record_understanding_ability'], 'width' => '150px']
            );
            echo "</td>";
            echo "</tr>";

// 4. Situation socio-économique ou juridique
            echo "<tr>";
            echo "<td class='form-table-text'>";
            echo __("Situation socio-économique ou juridique", "dlteams") . " ";
            Html::showToolTip(__("Personnes précaires, réfugiés, endettées", "dlteams"));
            echo "</td>";
            echo "<td>";
            Dropdown::showFromArray(
                'socioeconomic_or_legal_situation',
                [
                    null => __('Non définie', 'dlteams'),
                    1 => __('Peu vulnérable', 'dlteams'),
                    2 => __('Moyen', 'dlteams'),
                    3 => __('Vulnérable', 'dlteams')
                ],
                ['value' => $this->fields['socioeconomic_or_legal_situation'], 'width' => '150px']
            );
            echo "</td>";
            echo "</tr>";

            // Aperçu du résultat
//        $c1 = (int) $this->fields['age_and_digital_maturity'];
//        $c2 = (int) $this->fields['dependency_situation'];
//        $c3 = (int) $this->fields['record_understanding_ability'];
//        $c4 = (int) $this->fields['socioeconomic_or_legal_situation'];
//        $filled = 0;
//        foreach ([$c1, $c2, $c3, $c4] as $v) { if ($v > 0) $filled++; }
//        $moyenne = $filled ? ($c1 + $c2 + $c3 + $c4) / $filled : 0;
//        if ($moyenne < 1.5) { $apercu = __('Risque faible', 'dlteams'); }
//        elseif ($moyenne < 2.5) { $apercu = __('Moyen', 'dlteams'); }
//        else { $apercu = __('Vulnérable', 'dlteams'); }

            $result = static::computeVulnerability($this);
            echo "<tr>";
            echo "<td class='form-table-text'>" . __("Aperçu du résultat", 'dlteams') . "</td>";
            echo "<td>";
            if ($result['level'] == __('Non définie', 'dlteams')) {
                echo "<span style='padding: 4px 8px; border-radius: 4px; font-weight: bold; background-color: #e2e3e5; color: #6c757d;'>";
                echo $result['level'];
                echo "</span>";
            } else {
                echo "<span style='padding: 4px 8px; border-radius: 4px; font-weight: bold; background-color: " .
                    ($result['level'] == 'Vulnérable' ? '#f8d7da' :
                        ($result['level'] == 'Moyen' ? '#fff3cd' : '#d4edda')) .
                    "; color: " .
                    ($result['level'] == 'Vulnérable' ? '#721c24' :
                        ($result['level'] == 'Moyen' ? '#856404' : '#155724')) . ";'>";
                echo $result['level'];
                echo "</span>";
            }
            echo "</td>";
            echo "</tr>";

            // Bouton enregistrer
            echo "<tr class='tab_bg_2'><td colspan='2' class='center'>";
            echo "<input type='submit' name='update' value=\"" . __s('Save') . "\" class='btn btn-primary'>";
            echo "</td></tr>";

            echo "</table>";
            echo "</div>";

            Html::closeForm();

            // Ajoutez ceci après la section des boutons radio (ligne ~150)

            echo "<script>
$(document).ready(function() {
    function toggleVulnerabilitySection() {
        var category = $('input[name=\"category\"]:checked').val();
        var vulnerabilitySection = $('#vulnerability-section');
        
        if (category === 'morale') {
            vulnerabilitySection.hide();
        } else {
            vulnerabilitySection.show();
        }
    }
    
    // Au chargement
    toggleVulnerabilitySection();
    
    // Au changement de sélection
    $('input[name=\"category\"]').change(function() {
        toggleVulnerabilitySection();
    });
});
</script>";

//        responsive
            echo "<style>
            .glpi-responsive-table {
                  width: 100%;
                  overflow-x: auto;
                }
                
                .glpi-responsive-table table {
                  width: 100%;
                  border-collapse: collapse;
                  min-width: 600px; /* empêche la casse sur les petits écrans */
                }
                
                @media screen and (max-width: 768px) {
                  .tab_cadre_fixe th,
                  .tab_cadre_fixe td,
                  .tab_cadre_fixehov th,
                  .tab_cadre_fixehov td {
                    font-size: 14px;
                    padding: 8px;
                  }
                
                  .btn,
                  input[type='submit'] {
                    width: 100%;
                    margin-top: 8px;
                  }
                }
                
                .td-fixed-small {
                  width: 2%;
                }
                
                @media screen and (max-width: 768px) {
                  .td-fixed-small {
                    width: fit-content !important;
                    white-space: nowrap;
                  }
                }
        </style>";
        }



    }



    /**
     * Sauvegarde les catégories dans les tables _Item
     */
    public function saveCategoriesToItemTables($categories = [])
    {
        global $DB;

        if (empty($categories)) {
            $categories = $_POST['_categories'] ?? [];
        }

        // 1. Supprimer les anciennes relations
        $this->deleteCategoriesFromItemTables();

        if (empty($categories)) {
            return;
        }

        foreach ($categories as $category_id) {

            $concernedperson_item = new PluginDlteamsConcernedPerson_Item();
            $res = $concernedperson_item->add([
                'concernedpersons_id' => $this->getID(),
                'itemtype' => PluginDlteamsConcernedPersonCategory::class,
                'items_id' => $category_id,
            ]);


            $category_item = new PluginDlteamsConcernedPersonCategory_Item();
            $res2 = $category_item->add([
                'concernedpersoncategories_id' => $category_id,
                'itemtype' => PluginDlteamsConcernedPerson::class,
                'items_id' => $this->getID()
            ]);

        }
    }

    /**
     * Supprime les catégories des tables _Item
     */
    public function deleteCategoriesFromItemTables()
    {
        global $DB;

        $DB->delete(PluginDlteamsConcernedPersonCategory_Item::getTable(), [
            'itemtype' => PluginDlteamsConcernedPerson::class,
            'items_id' => $this->getID()
        ]);

        $DB->delete(PluginDlteamsConcernedPerson_Item::getTable(), [
            'concernedpersons_id' => $this->getID(),
            'itemtype' => PluginDlteamsConcernedPersonCategory::class
        ]);
    }

    /**
     * Charge les catégories depuis les tables _Item
     */
    public function loadCategoriesFromItemTables()
    {
        global $DB;

        // 1. Récupérer les ProcessedData_Item liés
        $concernedperson_items = $DB->request([
            'SELECT' => ['items_id'],
            'FROM' => PluginDlteamsConcernedPerson_Item::getTable(),
            'WHERE' => [
                'concernedpersons_id' => $this->getID(),
                'itemtype' => PluginDlteamsConcernedPersonCategory::class
            ]
        ]);

        $concernedperson_categories_ids = [];
        foreach ($concernedperson_items as $item) {
            $concernedperson_categories_ids[] = $item['items_id'];
        }

        if (empty($concernedperson_categories_ids)) {
            $this->fields['_categories'] = [];
            return;
        }

        $category_ids = [];
        foreach ($concernedperson_categories_ids as $category_id) {
            $category_ids[] = $category_id;
        }

        $this->fields['_categories'] = $category_ids;
    }

    /**
     * Remplace post_addItem()
     */
    public function post_addItem()
    {
        $this->saveCategoriesToItemTables();
        parent::post_addItem();
    }

    /**
     * Remplace post_updateItem()
     */
    public function post_updateItem($history = true)
    {
        $this->saveCategoriesToItemTables();
        parent::post_updateItem($history);
    }

    /**
     * Remplace post_getFromDB()
     */
    public function post_getFromDB()
    {
        $this->loadCategoriesFromItemTables();
        parent::post_getFromDB();
    }

    static function getSpecificValueToDisplay($field, $values, array $options = [])
    {
        if (!is_array($values)) {
            $values = [$field => $values];
        }
        switch ($field) {
            case 'category':
                if ($values[$field] == 'physique') {
                    return __("Personnes physiques", 'dlteams');
                } elseif ($values[$field] == 'morale') {
                    return __("Personnes morales", 'dlteams');
                }
                return $values[$field];

            case '_virtual_vulnerability_level':
                $temp_concerned_person = new self();
                $temp_concerned_person->fields = $values;

                $result = static::computeVulnerability($temp_concerned_person);

                // Retourner le niveau avec un style coloré
                if ($result['level'] == __('Non définie', 'dlteams')) {
                    return "<span style='padding: 2px 6px; border-radius: 3px; font-weight: bold; background-color: #e2e3e5; color: #6c757d;'>" .
                        $result['level'] . "</span>";
                } else {
                    $bg_color = ($result['level'] == 'Vulnérable' ? '#f8d7da' :
                        ($result['level'] == 'Moyen' ? '#fff3cd' : '#d4edda'));
                    $text_color = ($result['level'] == 'Vulnérable' ? '#721c24' :
                        ($result['level'] == 'Moyen' ? '#856404' : '#155724'));

                    return "<span style='padding: 2px 6px; border-radius: 3px; font-weight: bold; background-color: " .
                        $bg_color . "; color: " . $text_color . ";'>" .
                        $result['level'] . "</span>";
                }
        }
        return parent::getSpecificValueToDisplay($field, $values, $options);
    }

    public static function computeVulnerability(PluginDlteamsConcernedPerson $concernedPerson){
        $c1 = (int) $concernedPerson->fields['age_and_digital_maturity'];
        $c2 = (int) $concernedPerson->fields['dependency_situation'];
        $c3 = (int) $concernedPerson->fields['record_understanding_ability'];
        $c4 = (int) $concernedPerson->fields['socioeconomic_or_legal_situation'];

        // Vérifier si au moins un critère est NULL/vide
        $has_null = empty($concernedPerson->fields['age_and_digital_maturity']) ||
            empty($concernedPerson->fields['dependency_situation']) ||
            empty($concernedPerson->fields['record_understanding_ability']) ||
            empty($concernedPerson->fields['socioeconomic_or_legal_situation']);

        if ($has_null) {
            return [
                'level' => __('Non définie', 'dlteams'),
                'average' => 0,
                'filled' => 0
            ];
        }

        $vals = array_filter([$c1, $c2, $c3, $c4], fn($v) => $v > 0);
        $filled = count($vals);

        $cat = function (float $s): string {
            if ($s < 1.5)       return __('Peu vulnérable', 'dlteams');
            elseif ($s < 2.5)   return __('Moyen', 'dlteams');
            else                return __('Vulnérable', 'dlteams');
        };

        $moyenne = $filled ? array_sum($vals) / $filled : 0;
        $apercu  = $cat($moyenne);

        // Garder les mêmes noms de clés que l'original
        return [
            'level' => $apercu,
            'average' => $moyenne,
            'filled' => $filled
        ];
    }

    public static function getMenuContent()
    {

        $menu = [];
        $menu['title'] = static::getTypeName(Session::getPluralNumber());
        $menu['shortcut'] = 'n';
        $menu['page'] = static::getSearchURL();
        $menu['icon'] = self::getIcon();
        $menu['config']['default'] = '/front/dropdown.php';


        $menu['options'] = [];
//        Bouton add
        if (static::canCreate()) {
            $menu['options']["concernedperson"]['links']['add'] = static::getFormURL(false);
        }

//        bouton rechercher
        $menu['options']["concernedperson"]['links']['search'] = static::getSearchURL(false);


//        bouton help
        $image = "<i class='fas fa-question' title='" . 'Aide' . "'></i>";
        $menu['options']["concernedperson"]['links'][$image] = KnowbaseItem::getSearchURL(false) . '?contains="personne concernée"';

        echo "<script>
                        \$(document).ready(function () {
                            // Attendre que la page soit complètement chargée
                            \$('a[href^=\"/front/knowbaseitem.php?contains=\"]').attr('target', '_blank');
                           
                        });
                    </script>";


        if (count($_SESSION['glpiprofiles']) > 1) {
            $profile = new Profile();
            $name = 'Vue-Modele';
            $options = [
                'SELECT' => [
                    'id'
                ],
                'WHERE' => [
                    'name' => $name,
                ]
            ];

            global $DB;
            $req = $DB->request($profile->getTable(), $options);
            foreach ($req as $id => $row) {
                //if ($row = $req->next()) {
                $profile->getFromDB($row['id']);
                if (array_key_exists($profile->getID(), $_SESSION['glpiprofiles'])) {
                    $swap = $_SESSION['glpiactiveprofile']['id'] == $profile->getID();
                    $text = '<i class="fa fa-layer-group pointer" style="margin-right: 0.4em;"></i>' . __("Swap to model view", "dlteams");
                    $returnKey = array_key_first($_SESSION['glpiprofiles']) == $profile->getID() ? array_keys($_SESSION['glpiprofiles'])[1] : array_key_first($_SESSION['glpiprofiles']);
                    $prodif = $profile->getID();
                    $server_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
                    empty($swap) ? $text = "vue modèle" : $text = "vue modèle";
                    empty($swap) ? $val = $prodif : $val = $returnKey;
                    empty($swap) ? $checked = '' : $checked = 'checked';


                    $text_temp = "<div id='switchmodelcontainer' style='width:100%; display: flex;justify-content: center; margin-bottom: 1px; margin-right: 25px;'>
                                        <label class='form-check form-switch btn-xs  me-0 me-sm-1 px-1 py-1 mb-0 flex-column-reverse flex-sm-row'
                                            title='$text'>
                                         <input type='checkbox' class='form-check-input ms-0 me-1 mt-0' role='button'
                                                autocomplete='off'
                                                $checked
                                                onclick='window.location.href=`$server_url/front/central.php?newprofile=$val`'
                                                />
                                         <span class='form-check-label mb-1 mb-sm-0'>
                                            $text
                                         </span>
                                      </label></div>
                                      
                                      <script>
                                            var child = document.getElementById('switchmodelcontainer');
                                            var parent = child.parentNode;
                                            parent.style.border = 'none';
                                            parent.classList.remove('btn-outline-secondary');
                                        </script>
                            ";


                    $menu['options']["concernedperson"]['links'][$text_temp] = "/front/central.php?newprofile=$val";
                    break;


                }
            }

        }

        return $menu;
    }

    public static function getCurrentId()
    {
        // Get the current URL
        $currentURL = $_SERVER['REQUEST_URI'];

        // Get the query string from the URL
        $queryString = parse_url($currentURL, PHP_URL_QUERY);

        // Initialize an empty array for query parameters
        $queryParams = [];

        // Parse the query string into an array of parameters if it exists
        if ($queryString) {
            parse_str($queryString, $queryParams);
        }

        // Get the value of the "id" parameter
        $id = isset($queryParams['id']) ? $queryParams['id'] : null;

        return $id;
    }

    function prepareInputForAdd($input)
    {
        $input['users_id_creator'] = Session::getLoginUserID();
        
        // S'assurer que category a une valeur par défaut
        if (!isset($input['category']) || empty($input['category'])) {
            $input['category'] = 'physique';
        }

        $vulnerability_fields = [
            'age_and_digital_maturity',
            'dependency_situation',
            'record_understanding_ability',
            'socioeconomic_or_legal_situation'
        ];

        foreach ($vulnerability_fields as $field) {
            if (isset($input[$field]) && $input[$field] === '') {
                $input[$field] = null; // Convertir chaîne vide en NULL
            }
        }
        
        return parent::prepareInputForAdd($input);
    }

    function prepareInputForUpdate($input)
    {
        $input['users_id_lastupdater'] = Session::getLoginUserID();

        $vulnerability_fields = [
            'age_and_digital_maturity',
            'dependency_situation',
            'record_understanding_ability',
            'socioeconomic_or_legal_situation'
        ];

        foreach ($vulnerability_fields as $field) {
            if (isset($input[$field]) && $input[$field] === '') {
                $input[$field] = null; // Convertir chaîne vide en NULL
            }
        }

        return parent::prepareInputForUpdate($input);
    }


    public function getSpecificMassiveActions($checkitem = null)
    {
        global $DB;

        $actions = parent::getSpecificMassiveActions($checkitem);
        $actions['Appliance' . MassiveAction::CLASS_ACTION_SEPARATOR . 'add_item'] =
            "<i class='fa-fw " . Appliance::getIcon() . "'></i>" . _x('button', 'Associate to an appliance');

        return $actions;
    }


    function cleanDBonPurge()
    {
        /*$rel = new PluginDlteamsRecord_MotifEnvoi();
        $rel->deleteByCriteria(['plugin_dlteams_concernedpersons_id' => $this->fields['id']]);*/
    }

    function rawSearchOptions()
    {

        $tab = [];

        $tab[] = [
            'id' => 'common',
            'name' => __("Characteristics")
        ];

        $tab[] = [
            'id' => '1',
            'table' => $this->getTable(),
            'field' => 'ranking',
            'name' => __("Classement"),
            'datatype' => 'number',
            'min' => 1,
            'max' => 10000,
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '2',
            'table' => $this->getTable(),
            'field' => 'name',
            'name' => __("Name"),
            'datatype' => 'itemlink',
            'massiveaction' => false,
            'autocomplete' => true,
        ];

        $tab[] = [
            'id' => '3',
            'table' => $this->getTable(),
            'field' => 'id',
            'name' => __("ID"),
            'massiveaction' => false,
            'datatype' => 'number',
        ];

        $tab[] = [
            'id' => '4',
            'table' => $this->getTable(),
            'field' => 'comment',
            'name' => __("Comments"),
            'datatype' => 'text',
            'toview' => true,
            'massiveaction' => true,
        ];

        if ($this->isEntityAssign()) {
            $tab[] = [
                'id' => '5',
                'table' => 'glpi_entities',
                'field' => 'completename',
                'name' => __("Entity"),
                'datatype' => 'dropdown',
                'massiveaction' => true,
            ];
        }

        $tab[] = [
            'id' => '6',
            'table' => $this->getTable(),
            'field' => 'is_recursive',
            'name' => __("Child entities"),
            'datatype' => 'bool',
            'massiveaction' => false,
        ];

        $tab[] = [
            'id' => '7',
            'table' => $this->getTable(),
            'field' => 'content',
            'name' => __("Content"),
            'datatype' => 'text',
            'toview' => true,
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '8',
            'table' => $this->getTable(),
            'field' => 'date_creation',
            'name' => __("Creation date"),
            'massiveaction' => false,
            'datatype' => 'text',
        ];

        $tab[] = [
            'id' => '9',
            'table' => $this->getTable(),
            'field' => 'date_mod',
            'name' => __("Last update"),
            'massiveaction' => false,
            'datatype' => 'text',
        ];

        $tab[] = [
            'id' => '10',
            'table' => $this->getTable(),
            'field' => 'number',
            'name' => __("Nombre"),
            'massiveaction' => false,
            'datatype' => 'number',
        ];

        $tab[] = [
            'id' => '11',
            'table' => $this->getTable(),
            'field' => 'newperyear',
            'name' => __("Entrants"),
            'massiveaction' => false,
            'datatype' => 'number',
        ];

        $tab[] = [
            'id' => '12',
            'table' => $this->getTable(),
            'field' => 'deletedperyear',
            'name' => __("Sortants"),
            'massiveaction' => false,
            'datatype' => 'number',
        ];

        $tab[] = [
            'id' => '101',
            'table' => 'glpi_plugin_dlteams_records_items',
            'field' => 'items_id1',
            'name' => _x('quantity', 'Données'),
            'forcegroupby' => true,
            'usehaving' => true,
            'datatype' => 'count',
            'massiveaction' => false,
            'joinparams' => [
                'jointype' => 'itemtype_item'
            ]
        ];

        $tab[] = [
            'id' => '108',
            'table' => 'glpi_plugin_dlteams_records_items',
            'field' => 'records_id',
            'name' => _x('quantity', 'Traitements'),
            'forcegroupby' => true,
            'usehaving' => true,
            'datatype' => 'count',
            'massiveaction' => false,
            'joinparams' => [
                'jointype' => 'itemtype_item'
            ]
        ];

        $tab[] = [
            'id' => '111',
            'table' => PluginDlteamsPolicieForm_Item::getTable(),
            'field' => 'items_id',
            'name' => _x('quantity', 'Jeux de données'),
            'forcegroupby' => true,
            'usehaving' => true,
            'datatype' => 'count',
            'massiveaction' => false,
            'joinparams' => [
                'jointype' => 'itemtype_item'
            ]
        ];


        $tab[] = [
            'id' => '112',
            'table' => $this->getTable(),
            'field' => '_virtual_vulnerability_level', // Utiliser le préfixe _virtual_
            'name' => __("Vulnérabilité", 'dlteams'),
            'datatype' => 'specific',
            'massiveaction' => false,
            'nosort' => false,
            'nosearch' => true,
            'additionalfields' => [
                'age_and_digital_maturity',
                'dependency_situation',
                'record_understanding_ability',
                'socioeconomic_or_legal_situation'
            ]
        ];

//        $tab[] = [
//            'id'                 => '111',
//            'table'              => PluginDlteamsConcernedPerson_Item::getTable(),
//            'field'              => 'items_id',
//            'name'               => _x('quantity','Jeux données'),
//            'datatype'           => 'specific', //'itemlink',
//            'comments'           => true,
//            'nosort'             => false,
//            'additionalfields'   => ['itemtype'],
//            'joinparams'         => [
//                'linkfield' => 'concernedpersons_id',
//                'jointype'           => 'child',
//                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsPolicieForm::class."'",
//            ],
//            'forcegroupby'       => true,
//            'massiveaction'      => false,
//            'htmltext'           => true,
//            'showpolicies' => true
//            //'dlteams_activityname' => true,
//        ];
//
        return $tab;
    }

    public function defineTabs($options = [])
    {
        $ong = [];
        $ong = array();
        //add main tab for current object
        $this->addDefaultFormTab($ong)
            ->addImpactTab($ong, $options)
            ->addStandardTab(PluginDlteamsPolicieForm_Item::class, $ong, $options)
            ->addStandardTab('PluginDlteamsRecord_Item', $ong, $options)
            ->addStandardTab('PluginDlteamsObject_document', $ong, $options)
            ->addStandardTab('Notepad', $ong, $options)
//            ->addStandardTab('ManualLink', $ong, $options)
//            ->addStandardTab(PluginDlteamsProcessedData_Item::class, $ong, $options)
            ->addStandardTab(PluginDlteamsMessage::class, $ong, $options)
            ->addStandardTab(PluginDlteamsTicket_Item::class, $ong, $options)
            ->addStandardTab('KnowbaseItem_Item', $ong, $options)
            ->addStandardTab('PluginDlteamsConcernedPerson_Item', $ong, $options)
            ->addStandardTab('Log', $ong, $options);
        return $ong;
    }

    function exportToDB($subItems = [])
    {
        if ($this->isNewItem()) {
            return false;
        }

        $export = $this->fields;
        return $export;
    }

    public static function importToDB(PluginDlteamsLinker $linker, $input = [], $containerId = 0, $subItems = [])
    {
        $item = new self();
        $originalId = $input['id'];
        unset($input['id']);
        $input['entities_id'] = $_POST['entities_id'];;
        $input['comment'] = str_replace(['\'', '"'], "", $input['comment']);
        $input['name'] = str_replace(['\'', '"'], "", $input['name']);
        $input['content'] = str_replace(['\'', '"'], "", $input['content']);
        
        // S'assurer que category a une valeur par défaut lors de l'import
        if (!isset($input['category']) || empty($input['category'])) {
            $input['category'] = 'physique';
        }
        $itemId = $item->add($input);
        if ($itemId === false) {
            $typeName = strtolower(self::getTypeName());
            throw new ImportFailureException(sprintf(__('failed to copy the %1$s record', 'dlteams'), $input['name']));
        }
        return $itemId;
    }

    public function deleteObsoleteItems(CommonDBTM $container, array $exclude)
    {
    }

    public static function showMassiveActionsSubForm(MassiveAction $ma)
    {
        switch ($ma->getAction()) {
            case 'copyTo':
                //                $values = [];
//                foreach ($_SESSION["glpiactiveentities"] ?? [] as $key => $entities_id) {
//                    $entity = new Entity();
//                    $entity->getFromDB($entities_id);
//                    $values[$key] = $entity->fields["completename"];
//                }
                Entity::dropdown(['name' => 'entities_id']);
                echo '<br /><br />' . Html::submit(_x('button', 'Post'), ['name' => 'massiveaction']);
                return true;
        }
        return parent::showMassiveActionsSubForm($ma);
    }



    public function post_purgeItem()
    {


        $concernedpersons_item = new PluginDlteamsConcernedPerson_Item();
        $concernedpersons_item->deleteByCriteria([
            "concernedpersons_id" => $this->fields["id"],
            "itemtype" => "PluginDlteamsRecord",
            "itemtype1" => "PluginDlteamsProcessedData"
        ]);

        $record_item = new PluginDlteamsRecord_Item();
        $record_item->deleteByCriteria([
            "itemtype" => "PluginDlteamsConcernedPerson",
            "items_id" => $this->fields["id"],
//           "itemtype1" peut etre null
        ]);

        $processeddata_items = new PluginDlteamsProcessedData_Item();
        $processeddata_items->deleteByCriteria([
            "itemtype" => "PluginDlteamsRecord",
            "itemtype1" => "PluginDlteamsConcernedPerson",
            "items_id1" => $this->fields["id"],
        ]);
        parent::post_purgeItem(); // TODO: Change the autogenerated stub
    }

    static function processMassiveActionsForOneItemtype(MassiveAction $ma, CommonDBTM $item, array $ids)
    {
        switch ($ma->getAction()) {
            case 'copyTo':
                if ($item->getType() == 'PluginDlteamsConcernedPerson') {
                    /** @var PluginDlteamsConcernedPerson $item */
                    foreach ($ids as $id) {
                        if ($item->getFromDB($id)) {
                            if ($item->copy1($ma->POST['entities_id'], $id, $item)) {

                                Session::addMessageAfterRedirect(sprintf(__('Record copied: %s', 'dlteams'), $item->getName()));
                                $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);
                            }
                        } else {
                            // Example of ko count
                            $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_KO);
                        }
                    }
                }
                return;
        }
        parent::processMassiveActionsForOneItemtype($ma, $item, $ids);
    }

    public function copy1($entity, $id, $item)
    {
        global $DB;
        $dbu = new DbUtils();
        $name = str_replace('"', '', addslashes($item->fields['name']));
        $entities_ori = $item->fields['entities_id'];
        $id_ori = $item->fields['id'];

        //var_dump($name);
        //var_dump($entities_ori);
        //var_dump($id_ori);

        $nb = $dbu->countElementsInTable(static::getTable(), ['name' => addslashes($name), 'entities_id' => $entity]);
        //var_dump($nb);

        $cp = new PluginDlteamsConcernedPerson();
        $cp->getFromDB($id);

        if ($nb <= 0) {
//            $DB->request("INSERT INTO " . static::getTable() . " (entities_id, is_recursive, date_mod, date_creation, name, content, comment, plugin_dlteams_rightmeasurecategories_id) SELECT '$entity', is_recursive, date_mod, date_creation, name, content, comment, 0 FROM " . static::getTable() . " WHERE id='$id'");
            $concernedperson = new PluginDlteamsConcernedPerson();
            $concernedperson->add([
                "name" => addslashes($cp->fields["name"] ?? ""),
                "content" => addslashes($cp->fields["content"] ?? ""),
                "comment" => addslashes($cp->fields["comment"] ?? ""),
                "is_recursive" => $cp->fields["is_recursive"],
                "ranking" => $cp->fields["ranking"],
                "category" => $cp->fields["category"] ?? "physique",
                "entities_id" => $entity,
            ]);
            $newid = $concernedperson->fields["id"];

//           $DB->request("INSERT INTO " . PluginDlteamsRecord_Item::getTable() . " (records_id, items_id, itemtype, itemtype1, items_id1, comment) SELECT 'records_id', $newid, itemtype, itemtype1, items_id1, comment FROM " . PluginDlteamsRecord_Item::getTable() . " WHERE items_id='$id' AND itemtype='PluginDlteamsConcernedPerson'");
//           $DB->request("INSERT INTO " . PluginDlteamsConcernedPerson_Item::getTable() . " (concernedpersons_id, items_id, itemtype, items_id1, itemtype1, comment) SELECT $newid, items_id, itemtype, items_id1, itemtype1, comment FROM " . PluginDlteamsConcernedPerson_Item::getTable() . " WHERE itemtype='PluginDlteamsRecord' AND concernedpersons_id='$id'");
//           $DB->request("INSERT INTO " . PluginDlteamsProcessedData_Item::getTable() . " (processeddatas_id, items_id, itemtype, items_id1, itemtype1, comment) SELECT processeddatas_id, items_id, itemtype, items_id1, itemtype1, comment FROM " . PluginDlteamsProcessedData_Item::getTable() . " WHERE itemtype='PluginDlteamsRecord' AND itemtype1='PluginDlteamsConcernedPerson' AND items_id1='$id'");

            return true;
        } else {
            return false;
        }
    }

    /**
     * Display concerned persons in central view
     *
     * @param integer $start
     * @param string  $status
     * @param boolean $showgrouptickets
     *
     * @return void
     */
    public static function showCentralList($start = 0, $status = 'process', $showgrouptickets = true)
    {
        global $DB;

        if (!Session::haveRight('plugin_dlteams_concernedperson', READ)) {
            return false;
        }

        $iterator = $DB->request([
            'FROM' => self::getTable(),
            'WHERE' => [
                'entities_id' => Session::getActiveEntity()
            ],
            'ORDER' => ['date_mod DESC'],
            'LIMIT' => $_SESSION['glpidisplay_count_on_home'] ?? 10
        ]);

        $total_row_count = count($iterator);
        $displayed_row_count = min((int)$_SESSION['glpidisplay_count_on_home'], $total_row_count);

        if ($total_row_count > 0) {
            // Titre principal avec lien
            $main_header = "<a href=\"" . self::getSearchURL() . "\">" .
                Html::makeTitle(__('Recent Concerned Persons', 'dlteams'), $displayed_row_count, $total_row_count) . "</a>";
            
            echo "<div class='table-responsive'>";
            echo "<table class='table table-borderless table-striped table-hover card-table'>";
            echo "<thead>";
            echo "<tr>";
            echo "<th colspan='3'>" . $main_header . "</th>";
            echo "</tr>";
            echo "<tr>";
            echo "<th>" . __('ID') . "</th>";
            echo "<th>" . __('Name') . "</th>";
            echo "<th>" . __('Date modification') . "</th>";
            echo "</tr>";
            echo "</thead>";
            echo "<tbody>";

            foreach ($iterator as $data) {
                $url = self::getFormURLWithID($data['id']);
                echo "<tr>";
                echo "<td><a href='" . $url . "' class='btn btn-sm btn-outline-primary'>" . $data['id'] . "</a></td>";
                echo "<td>" . htmlspecialchars($data['name']) . "</td>";
                echo "<td class='text-muted'>" . Html::convDateTime($data['date_mod']) . "</td>";
                echo "</tr>";
            }

            echo "</tbody>";
            echo "</table>";
            echo "</div>";

            if ($total_row_count > $displayed_row_count) {
                echo "<div class='text-center mt-2'>";
                echo "<a href='" . self::getSearchURL() . "' class='btn btn-sm btn-outline-secondary'>";
                echo sprintf(__('Show all %d items'), $total_row_count);
                echo "</a>";
                echo "</div>";
            }
        } else {
            echo "<div class='text-center text-muted p-4'>";
            echo "<i class='fas fa-inbox fa-2x mb-2'></i><br>";
            echo __('No item found');
            echo "</div>";
        }
    }

}
