<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

class PluginDlteamsConcernedPerson_Item extends CommonDBTM
{

    public static $itemtype_1 = "PluginDlteamsConcernedPerson";
    public static $items_id_1 = 'concernedpersons_id';
    public static $take_entity_1 = false;

    public static $itemtype_2 = 'itemtype';
    public static $items_id_2 = 'items_id';
    public static $take_entity_2 = true;

    public static $column2_id = "34";

    static function canCreate()
    {
        return true;
    }

    static function canView()
    {
        return true;
    }

    static function canUpdate()
    {
        return true;
    }

    static function canDelete()
    {
        return true;
    }

    static function canPurge()
    {
        return true;
    }

    function canCreateItem()
    {
        return true;
    }

    function canViewItem()
    {
        return true;
    }

    function canUpdateItem()
    {
        return true;
    }

    function canDeleteItem()
    {
        return true;
    }

    function canPurgeItem()
    {
        return true;
    }

    static function getTypeNameForClass($nb = 0)
    {
        return __("Associated items", 'dlteams');
    }

    static function getTypeNameForRecordsRelies($nb = 0)
    {
        return __("Traitements rattachés", 'dlteams');
    }

    static function getTypeName($nb = 0)
    {
        return __("Personnes concernées", 'dlteams');
    }

    // affichage de l'onglet et de son nom
    public function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {
        global $DB;

        switch ($item->getType()) {
            case 'PluginDlteamsConcernedPerson':
                // Récupération des éléments et suppression des doublons
                $rawItems   = $DB->request(static::getRequest($item->fields['id']));
                $uniqueItems = [];
                foreach ($rawItems as $itemData) {
                    $key = $itemData['items_id'] . '_' . $itemData['itemtype'];
                    if (!isset($uniqueItems[$key])) {
                        $uniqueItems[$key] = $itemData;
                    }
                }
                $nbUniqueItems = count($uniqueItems);

                // Création de l'onglet
                $tabs = [];
                $tabs[1] = static::createTabEntry(static::getTypeNameForClass(Session::getPluralNumber()), 0);
                return $tabs;

            case PluginDlteamsProcessedData::class:
                $nbItem = 0;
                if ($_SESSION['glpishow_count_on_tabs']) {
                    // Comptage sur le premier ensemble de résultats
                    $iterator1 = static::getProcesseddataRecordRequest($item);
                    $previousRecordId = null;
                    foreach ($iterator1 as $data) {
                        if ($previousRecordId !== $data["items_id"]) {
                            $nbItem++;
                            $previousRecordId = $data["items_id"];
                        }
                    }
                    // Comptage sur le second ensemble de résultats
                    $iterator2 = static::getProcesseddataPolicieformRequest($item);
                    $previousRecordId = null;
                    foreach ($iterator2 as $data) {
                        if ($previousRecordId !== $data["items_id"]) {
                            $nbItem++;
                            $previousRecordId = $data["items_id"];
                        }
                    }
                }
                return static::createTabEntry(static::getTypeName(Session::getPluralNumber()), $nbItem);

            default:
                $nbItem = count(self::getForItemRequest($item));
                // Optionnel : compter via self::countForItem($item) si besoin
                return static::createTabEntry(static::getTypeName(Session::getPluralNumber()), $nbItem);
        }
    }

    public static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {
        switch ($item->getType()) {
            case 'PluginDlteamsConcernedPerson':
                if ($tabnum == 1) {
                    self::showForConcernedPersons($item);
                }
                break;

            case PluginDlteamsProcessedData::class:
                self::showRecordForProcessedData($item);
                self::showPolicieFormForProcessedData($item);
                break;

            default:
                 self::showForItem($item, $withtemplate);
                break;
        }
        return true;
    }

    static function showForItem(CommonDBTM $item, $withtemplate = 0)
    {
        $id = $item->fields['id'];
        $canedit = $item->can($id, UPDATE); // canedit booleen = true
        $rand = mt_rand(1, mt_getrandmax());
        global $DB;

        $iterator = self::getForItemRequest($item);


        $number = count($iterator); // $number est le nombre de ligne à afficher (=nombre de documents reliés)
        $items_list = [];
        $used = [];

        foreach ($iterator as $data) {
            $items_list[$data['linkid']] = $data;
            $used[$data['id']] = $data['id'];
        }

        if ($canedit && $item->getType() != PluginDlteamsConcernedPerson::class) {
            echo "<form name='legalbasi_item_form$rand' id='legalbasi_item_form$rand' method='post'
            action='" . Toolbox::getItemTypeFormURL(__CLASS__) . "'>";
            echo "<input type='hidden' name='itemtype1' value='" . $item->getType() . "' />";
            echo "<input type='hidden' name='items_id1' value='" . $item->getID() . "' />";
//            echo "<input type='hidden' name='records_id' value='" . $item->getID() . "' />";
            echo "<input type='hidden' name='itemtype' value='" . PluginDlteamsConcernedPerson::getType() . "' />";
            echo "<input type='hidden' name='entities_id' value='" . $item->fields['entities_id'] . "' />";

            $title = __("Catégories de données", 'dlteams');
            $entitled = "Ajouter des personnes concernées";
            echo "<table class='tab_cadre_fixe'>";
            echo "<tr class='tab_bg_2'><th colspan='3'>" . $title . "<br><i style='font-weight: normal'>" . "</i></th>";
            echo "<th colspan='1'></th></tr>";
            echo "<th colspan='2'></th></tr>";
            echo "<tr class='tab_bg_1'><td class='left' width='30%'>" . __($entitled, 'dlteams');
            echo "</td><td width='20%' class='left'>";
            Dropdown::show(static::$itemtype_1, [
                'addicon' => static::$itemtype_1::canCreate(),
                'name' => 'items_id',
                'used' => $used
            ]);
            echo "</td>";
            echo "<td width='' colspan='1'>";
            echo "<span style='display:none' id='td1'>";

            echo "<br/><br/>";
            echo "<textarea type='text' style='width:100%;float:right;margin-right:5%' maxlength=1000 rows='3' id='update_comment_textarea' name='comment' class='storage_comment1' placeholder='commentaire'></textarea>";
            echo "</span>";
            echo "</td>";

            echo "<td width='20%' class='left'><input for='legalbasi_item_form$rand' type='submit' name='add' value=\"" . _sx('button', 'Add') . "\" class='submit'>";
            echo "</td></tr>";
            echo "</table>";

            Html::closeForm();
        }




//        $iterator = self::getRequest($item);
        if ($iterator) {

            echo "<div class='spaced'>";
            if ($canedit && $number && $item->getType() != PluginDlteamsConcernedPerson::class) {
                Html::openMassiveActionsForm('mass' . __class__ . $rand);
                $massive_action_params = [
                    'container' => 'mass' . __class__ . $rand,
                    'num_displayed' => min($_SESSION['glpilist_limit'], $number)];
                Html::showMassiveActions($massive_action_params);
            }
            echo "<br/>";

            echo "<table class='tab_cadre_fixehov'>";

            $header_begin = "<tr>";
            $header_top = '';
            $header_bottom = '';
            $header_end = '';

            if ($canedit && $number && $item->getType() != PluginDlteamsConcernedPerson::class) {
                $header_begin .= "<th width='10'>";
                $header_top .= Html::getCheckAllAsCheckbox('mass' . __class__ . $rand);
                $header_bottom .= Html::getCheckAllAsCheckbox('mass' . __class__ . $rand);
                $header_end .= "</th>";
            }

            $header_end .= "<th>" . __("Name") . "</th>";
//            $header_end .= "<th width='20%'>" . __("Type", 'dlteams') . "</th>";
//            $header_end .= "<th width='20%'>" . __("Category", 'dlteams') . "</th>";
            if($item->getType() != PluginDlteamsProcessedDataCategory::class)
            $header_end .= "<th width='40%'>" . __("Comment") . "</th>";
            $header_end .= "</tr>";


            echo $header_begin . $header_top . $header_end;
            foreach ($iterator as $data) {

                if ($data['name']) {
                    echo "<tr class='tab_bg_1'>";

                    if ($canedit && $number  && $item->getType() != PluginDlteamsConcernedPerson::class) {
                        echo "<td width='10'>";
                        Html::showMassiveActionCheckBox(PluginDlteamsProcessedData_Item::class, $data['linkid']);
                        echo "</td>";
                    }

                    $link = $data['name'];
                    if ($_SESSION['glpiis_ids_visible'] || empty($data['name'])) {
                        $link = sprintf(__("%1\$s (%2\$s)"), $link, $data['id']);
                    }
                    $name = "<a target='_blank' href=\"" . static::$itemtype_1::getFormURLWithID($data['id']) . "\">" . $link . "</a>";

                    echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                    echo ">" . $name . "</td>";

                    /*                    highlight_string("<?php\n\$data =\n" . var_export($data, true) . ";\n?>");*/
//                    die();

//                    if($item->getType() != PluginDlteamsProcessedDataCategory::class) {
//                        $itemtype1 = "--";
//                        if ($data["itemtype1"]) {
//                            $itemtype1str = $data["itemtype1"];
//                            $itemtype1 = new $itemtype1str();
//                            $itemtype1->getFromDB($data["items_id1"]);
//                            $url = $itemtype1::getFormURLWithID($data["items_id1"]);
//                            $name = $itemtype1->fields["name"];
//                            $itemtype1 = "<a href='$url' target='_blank'>$name</a>";
//                        }
//                        echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
//                        echo ">" . $itemtype1 . "</td>";
//                    }


//                    echo "<td class='left'>" . $data['typename'] . " </td>";
//                    echo "<td class='left'>" . $data['nameCat'] . " </td>";

                    echo "<td class='left'>" . $data['comment'] . "</td>";
                    echo "</tr>";
                }
            }

            if ($iterator->count() > 10) {
                //echo $header_begin . $header_bottom . $header_end;
            }
            echo "</table>";

            if ($canedit && $number > 10) {
                $massive_action_params['ontop'] = false;
                Html::showMassiveActions($massive_action_params);
                Html::closeForm();
            }

            echo "</div>";
        }
    }

    public static function getSpecificValueToDisplay($field, $values, array $options = [])
    {
        if (!is_array($values)) {
            $values = [$field => $values];
        }

        if(isset($options["searchopt"]["showpolicies"])){
            $record = new PluginDlteamsPolicieForm();
            if($record->getFromDB($values["items_id"])){
                $url = PluginDlteamsPolicieForm::getFormURLWithID($values["items_id"]);
                return "<a href='$url' target='_blank'>". $record->fields["name"].";</a>";
            }
            return;
        }


        return parent::getSpecificValueToDisplay($field, $values, $options);
    }

    /**
     * Affiche un tableau avec un en-tête et une liste d'éléments.
     *
     * @param string   $headerTitle Titre de l'en-tête du tableau.
     * @param string   $colTitle    Titre de la deuxième colonne.
     * @param callable $linkCallback Fonction de rappel permettant de générer le lien dans la deuxième colonne.
     * @param iterable $iterator    Jeu d'enregistrements à afficher.
     */
    private static function renderProcessedDataTable(string $headerTitle, string $colTitle, callable $linkCallback, iterable $iterator)
    {
        $rand = mt_rand(1, mt_getrandmax());
        $itemsList = [];
        foreach ($iterator as $data) {
            $itemsList[$data['linkid']] = $data;
        }
        $canEdit = false; // La modification est désactivée

        echo "<table class='tab_cadre_fixe'>
            <tbody>
                <tr class='headerRow'>
                    <th colspan='3'>{$headerTitle}</th>
                </tr>
            </tbody>
          </table>";

        echo "<table class='tab_cadre_fixehov'>
            <tr>"
            . ($canEdit ? "<th width='10'>" . Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand) . "</th>" : "")
            . "<th>" . _n("Personne concernée", "Personnes concernées", 0, 'dlteams') . "</th>"
            . "<th>" . $colTitle . "</th>"
            . "</tr>";

        $previousRecordId = null;
        foreach ($itemsList as $data) {
            $recordText = ($previousRecordId === $data["items_id"])
                ? "----"
                : PluginDlteamsRecord_PersonalAndDataCategory::getItemLinkWithNumber($data, 'itemtype', 'items_id', "");
            echo "<tr>"
                . ($canEdit ? "<td>" . Html::getMassiveActionCheckBox(__CLASS__, $data['linkid']) . "</td>" : "")
                . "<td>{$recordText}</td>"
                . "<td>" . $linkCallback($data) . "</td>"
                . "</tr>";
            $previousRecordId = $data["items_id"];
        }
        echo "</table>";
    }
    

    public static function showRecordForProcessedData(PluginDlteamsProcessedData $processedData)
    {
        $iterator = static::getProcesseddataRecordRequest($processedData);
        self::renderProcessedDataTable(
            __("Traitements", 'dlteams'),
            _n("Traitement", "Traitements", 0, 'dlteams'),
            function ($data) {
                return PluginDlteamsRecord_PersonalAndDataCategory::getItemLinkWithNumber($data, PluginDlteamsRecord::class, 'records_id', "", true);
            },
            $iterator
        );
    }

    public static function showPolicieFormForProcessedData(PluginDlteamsProcessedData $processedData)
    {
        $iterator = static::getProcesseddataPolicieformRequest($processedData);
        self::renderProcessedDataTable(
            PluginDlteamsPolicieForm::getTypeName(),
            _n("Jeux de données", "Jeux de données", 0, 'dlteams'),
            function ($data) {
                return PluginDlteamsRecord_PersonalAndDataCategory::getItemLinkWithNumber($data, PluginDlteamsPolicieForm::class, 'policieforms_id', "", true);
            },
            $iterator
        );
    }

    public static function getProcesseddataRecordRequest(PluginDlteamsProcessedData $processedData)
    {
        $query = [
            'SELECT'   => [
                PluginDlteamsRecord_Item::getTable() . '.id AS linkid',
                PluginDlteamsRecord_Item::getTable() . '.itemtype AS itemtype',
                PluginDlteamsRecord_Item::getTable() . '.items_id AS items_id',
                PluginDlteamsRecord_Item::getTable() . '.*',
                PluginDlteamsRecord::getTable() . '.id AS id',
                PluginDlteamsRecord::getTable() . '.name AS name',
                PluginDlteamsRecord::getTable() . '.content AS content',
            ],
            'FROM'     => PluginDlteamsRecord_Item::getTable(),
            'LEFT JOIN'=> [
                PluginDlteamsRecord::getTable() => [
                    'ON' => [
                        PluginDlteamsRecord_Item::getTable() => "records_id",
                        PluginDlteamsRecord::getTable()       => 'id'
                    ]
                ]
            ],
            'WHERE'    => [
                "itemtype1" => PluginDlteamsProcessedData::class,
                "items_id1" => $processedData->fields["id"],
                "itemtype"  => PluginDlteamsConcernedPerson::class,
                "records_id" => ["<>", 0],
            ],
            "ORDERBY"  => ['items_id']
        ];

        global $DB;
        return $DB->request($query);
    }

    public static function getProcesseddataPolicieformRequest(PluginDlteamsProcessedData $processedData)
    {
        $query = [
            'SELECT'   => [
                PluginDlteamsPolicieForm_Item::getTable() . '.id AS linkid',
                PluginDlteamsPolicieForm_Item::getTable() . '.itemtype AS itemtype',
                PluginDlteamsPolicieForm_Item::getTable() . '.items_id AS items_id',
                PluginDlteamsPolicieForm_Item::getTable() . '.*',
                PluginDlteamsPolicieForm::getTable() . '.id AS id',
                PluginDlteamsPolicieForm::getTable() . '.name AS name',
                PluginDlteamsPolicieForm::getTable() . '.content AS content',
            ],
            'FROM'     => PluginDlteamsPolicieForm_Item::getTable(),
            'LEFT JOIN'=> [
                PluginDlteamsPolicieForm::getTable() => [
                    'ON' => [
                        PluginDlteamsPolicieForm_Item::getTable() => "policieforms_id",
                        PluginDlteamsPolicieForm::getTable()       => 'id'
                    ]
                ]
            ],
            'WHERE'    => [
                "itemtype1" => PluginDlteamsProcessedData::class,
                "items_id1" => $processedData->fields["id"],
                "itemtype"  => PluginDlteamsConcernedPerson::class,
                "policieforms_id" => ["<>", 0],
                PluginDlteamsPolicieForm::getTable() . ".id" => ["<>", "0"],
                PluginDlteamsPolicieForm::getTable() . ".id is not null"
            ],
            "ORDERBY"  => ['items_id']
        ];

        global $DB;
        return $DB->request($query);
    }


    public static function showForConcernedPersons(PluginDlteamsConcernedPerson $item)
    {
        global $DB;
        $instID = $item->fields['id'];
        if (!$item->can($instID, READ)) {
            return false;
        }
        $canedit = $item->can($instID, UPDATE);
        // for a measure,
        // don't show here others protective measures associated to this one,
        // it's done for both directions in self::showAssociated
        $types_iterator = [];
        $number = count($types_iterator);

        $used = [];
        $types = PluginDlteamsItemType::getTypes();
        $key = array_search(get_class($item), $types);
        unset($types[$key]);
        $rand = mt_rand();

        if ($canedit) {
            echo "<form name='ticketitem_form$rand' id='ticketitem_form$rand' method='post'
            action='" . Toolbox::getItemTypeFormURL(__CLASS__) . "'>";
            echo "<input type='hidden' name='" . static::$items_id_1 . "' value='$instID'>";
            echo "<input type='hidden' name='itemtype1' value='" . str_replace("_Item", "", __CLASS__) . "'>";
            echo "<input type='hidden' name='items_id1' value='" . $instID . "'>";

            echo "<table class='tab_cadre_fixe'>";
            $title = "Related objects";
            $entitled = "Indicate the objects related to this element";
            echo "<tr class='tab_bg_2'><th>" . __($title, 'dlteams') .
                "<br><i style='font-weight: normal'>" .
                "</i></th>";
            echo "<th colspan='2'></th></tr>";

            echo "<tr class='tab_bg_1'><td class='left' width='40%'>" . __($entitled, 'dlteams');
            echo "</td><td width='40%' class='left'>";
            $types = PluginDlteamsItemType::getTypes();
            $key = array_search("PluginDlteamsConcernedPerson", $types);
            unset($types[$key]);
            Dropdown::showSelectItemFromItemtypes(['itemtypes' => $types,
                'entity_restrict' => ($item->fields['is_recursive'] ? getSonsOf('glpi_entities', $item->fields['entities_id'])
                    : $item->fields['entities_id']),
                'checkright' => true,
                'used' => $used
            ]);
            unset($types);
            echo "</td><td width='20%' class='left'><input for='ticketitem_form$rand' type='submit' name='add' value=\"" . _sx('button', 'Add') . "\" class='submit'>";
            echo "</td></tr>";

            echo "<tr class='tab_bg_1'>";
            echo "<td style='text-align:left'>" . __("Domaine d'activité", 'dlteams') . "</td>";
            //$randDropdown = mt_rand();
            echo "<td colspan='2'>";
            PluginDlteamsConcernedPerson::dropdown([
                'addicon' => PluginDlteamsConcernedPerson::canCreate(),
                'name' => 'plugin_dlteams_recordcategories_id',
                'value' => "", //$responsible,
                // 'entity' => $this->fields["entities_id"],
                'right' => 'all',
                'width' => "250px",
                // 'rand'   => $randDropdown
            ]);
            echo "</td></tr>";
            echo "<tr class='tab_bg_1'><td width='35%' class=''>";
            echo __("Comment");
            echo "<br/><br/>";
            echo "<textarea type='text' style='width:100%' maxlength=1000 rows='3' name='comment' class='comment_legalbasi_item'></textarea>";
            echo "</td>";
            echo "</table>";
            Html::closeForm();
        }
        $items = $DB->request(static::getRequest($instID));
        $items = iterator_to_array($items);
        $items_to_list = [];
        foreach ($items as $itemdata) {
            $temp = array_filter($items_to_list, function ($k) use ($itemdata) {
                return $k['items_id'] === $itemdata['items_id'] && $k['itemtype'] === $itemdata['itemtype'];
            });

//          Decommenter si on doit afficher les redondance
            if (count($temp) === 0) {
                array_push($items_to_list, $itemdata);
            }
        }


        if (!count($items_to_list)) {
            echo "<table class='tab_cadre_fixe'><tr><th>" . __('No item found') . "</th></tr>";
            echo "</table>";
        } else {
            if ($canedit) {
                Html::openMassiveActionsForm('mass' . __CLASS__ . $rand);
                $massiveactionparams = [
                    'num_displayed' => min($_SESSION['glpilist_limit'], count($items)),
                    'container' => 'mass' . __CLASS__ . $rand,
                    'confirm' => true
                ];
                Html::showMassiveActions($massiveactionparams);
            }
            echo "<table class='tab_cadre_fixehov'>";
            $header = "<tr>";
            if ($canedit) {
                $header .= "<th width='10'>";
                $header .= Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand);
                $header .= "</th>";
            }
            $header .= "<th>" . __("Object") . "</th>";
            $header .= "<th>" . __("Type") . "</th>";
            $header .= "<th>" . __("Comment") . "</th>";
            $header .= "</tr>";
            echo $header;

            foreach ($items_to_list as $row) {
                $item = new $row['itemtype']();
                $item->getFromDB($row['items_id']);
                $name = "<a target='_blank' href=\"" . $item::getFormURLWithID($item->getField('id')) . "\">" . $item->getField('name') . "</a>";
                echo "<tr lass='tab_bg_1'>";
                if ($canedit) {
                    echo "<td>";
                    Html::showMassiveActionCheckBox(__CLASS__, $row["id"]);
                    echo "</td>";
                }
                echo "<td>" . $name . "</td>";
                echo "<td>" . $row["itemtype"]::getTypeName() . "</td>";
                echo "<td>" . $row['comment'] . "</td>";
                echo "</tr>";
            }
            echo $header;
            echo "</table>";

            if ($canedit && count($items)) {
                $massiveactionparams['ontop'] = false;
                Html::showMassiveActions($massiveactionparams);
            }
            if ($canedit) {
                Html::closeForm();
            }

        }
    }


    public static function showRecordsRelies(PluginDlteamsConcernedPerson $item)
    {
        global $DB;
        $instID = $item->fields['id'];
        if (!$item->can($instID, READ)) {
            return false;
        }
        $canedit = $item->can($instID, UPDATE);
        // for a measure,
        // don't show here others protective measures associated to this one,
        // it's done for both directions in self::showAssociated
        $types_iterator = [];
        $number = count($types_iterator);

        $used = [];
        $types = PluginDlteamsItemType::getTypes();
        $key = array_search(get_class($item), $types);
        unset($types[$key]);
        $rand = mt_rand();
        if ($canedit) {
            echo "<div class='firstbloc'>";
            echo "<form name='concernedpersonsitem_form$rand' id='concernedpersonsitem_form$rand' method='post'
               action='" . Toolbox::getItemTypeFormURL(__CLASS__) . "'>";

            echo "<table class='tab_cadre_fixe'>";
            echo "<tr class='tab_bg_2'><th colspan='2'>" . _n("Personal Data Category", "Personal Data Categories", 0, 'dlteams') . "</th></tr>";

            echo "<tr class='tab_bg_1'><td class='right'>";
//            Dropdown::showSelectItemFromItemtypes(['itemtypes' => $types,
//                'entity_restrict' => ($item->fields['is_recursive'] ? getSonsOf('glpi_entities', $item->fields['entities_id'])
//                    : $item->fields['entities_id']),
//                'checkright' => true,
//                'used' => $used
//            ]);
            PluginDlteamsProcessedData::dropdown([
                'addicon' => PluginDlteamsProcessedData::canCreate(),
                'name' => 'items_id1',
                'width' => '300px'
            ]);
            echo "</td><td class='center'>";
            echo "<input type='submit' name='add' value=\"" . _sx('button', 'Add') . "\" class='btn btn-primary'>";
            echo "<input type='hidden' name='concernedpersons_id' value='$instID'>";
            echo "<input type='hidden' name='itemtype1' value='" . str_replace("_Item", "", __CLASS__) . "'>";
            echo "<input type='hidden' name='recordsrelies' value='" . true . "'>";

            echo "</td></tr>";
            echo "</table>";
            echo "<textarea type='text' style='width:40%;margin-right:5%; display:none;margin-bottom: 10px;' maxlength=1000 rows='3' id='update_comment_textarea' name='comment' class='storage_comment1' placeholder='commentaire'></textarea>";
            Html::closeForm();
            echo "</div>";
        }

        $items = $DB->request(static::getRecordsReliesRequest($instID));
        $items = iterator_to_array($items);
        $items_to_list = [];
        foreach ($items as $itemdata) {
            $temp = array_filter($items_to_list, function ($k) use ($itemdata) {
                return $k['items_id'] === $itemdata['items_id'] && $k['itemtype'] === $itemdata['itemtype'];
            });
// Decommenter si on doit afficher les redondance
//            if (count($temp) === 0) {
            array_push($items_to_list, $itemdata);
//            }
        }


        if (!count($items_to_list)) {
            echo "<table class='tab_cadre_fixe'><tr><th>" . __('No item found') . "</th></tr>";
            echo "</table>";
        } else {
            if ($canedit) {
                Html::openMassiveActionsForm('mass' . __CLASS__ . $rand);
                $massiveactionparams = [
                    'num_displayed' => min($_SESSION['glpilist_limit'], count($items)),
                    'container' => 'mass' . __CLASS__ . $rand,
                    'confirm' => true
                ];
                Html::showMassiveActions($massiveactionparams);
            }
            echo "<table class='tab_cadre_fixehov'>";
            $header = "<tr>";
            if ($canedit) {
                $header .= "<th width='10'>";
                $header .= Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand);
                $header .= "</th>";
            }
            $header .= "<th>" . __("Type") . "</th>";
            $header .= "<th>" . __("Nom") . "</th>";
            $header .= "<th>" . __("Comment") . "</th>";
            $header .= "</tr>";
            echo $header;

            foreach ($items_to_list as $row) {
                $tempitem = new $row['itemtype1']();
                $tempitem->getFromDB($row['items_id1']);

                $name = "<a target='_blank' href=\"" . $tempitem::getFormURLWithID($tempitem->getField('id')) . "\">" . $tempitem->getField('name') . "</a>";
                echo "<tr lass='tab_bg_1'>";
                if ($canedit) {
                    echo "<td>";
                    Html::showMassiveActionCheckBox(__CLASS__, $row["id"]);
                    echo "</td>";
                }
                echo "<td>" . $row["itemtype1"]::getTypeName() . "</td>";
                echo "<td>" . $name . "</td>";
                echo "<td>" . $row['comment'] . "</td>";
                echo "</tr>";
            }
            echo $header;

            echo "</table>";

            if ($canedit && count($items)) {
                $massiveactionparams['ontop'] = false;
                Html::showMassiveActions($massiveactionparams);
            }
            if ($canedit) {
                Html::closeForm();
            }

        }
    }

    function rawSearchOptions()
    {

        $tab = [];


        $tab[] = [
            'id' => static::$column2_id,
            'table' => PluginDlteamsConcernedPerson_Item::getTable(),
            'field' => 'comment',
            'name' => __("Commentaire"),
            'massiveaction' => true,
            'datatype' => 'text',
        ];

        return $tab;
    }


    public  static function getForItemRequest(CommonDBTM $item){
        $params = [
            'SELECT' => [
                'glpi_plugin_dlteams_concernedpersons_items.id AS linkid',
                'glpi_plugin_dlteams_concernedpersons_items.comment AS comment',
                'glpi_plugin_dlteams_concernedpersons_items.itemtype1 AS itemtype1',
                'glpi_plugin_dlteams_concernedpersons_items.items_id1 AS items_id1',
                'glpi_plugin_dlteams_concernedpersons_items.itemtype AS itemtype',
                'glpi_plugin_dlteams_concernedpersons_items.items_id AS items_id',
                'glpi_plugin_dlteams_concernedpersons.' . 'name as name',
                'glpi_plugin_dlteams_concernedpersons.' . 'id as id',
                'glpi_plugin_dlteams_concernedpersons.content',
//                'glpi_plugin_dlteams_processeddatas.plugin_dlteams_processeddatastypes_id as processeddatastypes_id',
            ],
            'FROM' => 'glpi_plugin_dlteams_concernedpersons_items',
            'JOIN' => [
                'glpi_plugin_dlteams_concernedpersons' => [
                    'FKEY' => [
                        'glpi_plugin_dlteams_concernedpersons_items' => 'concernedpersons_id',
                        'glpi_plugin_dlteams_concernedpersons' => "id",
                    ]
                ],
            ],
            'WHERE' => [
                'glpi_plugin_dlteams_concernedpersons_items.items_id' => $item->fields['id'],
                'glpi_plugin_dlteams_concernedpersons_items.itemtype' => $item->getType(),
                'glpi_plugin_dlteams_concernedpersons.is_deleted' => 0
            ],
            //'ORDER' => 'glpi_plugin_dlteams_records_items.id',
//			  'ORDER' => 'glpi_plugin_dlteams_processeddatas.plugin_dlteams_processeddatastypes_id',
        ];


        global $DB;
        return $DB->request($params);
    }

    static function getRequest($instID)
    {
        $link_table = str_replace("_Item", "", __CLASS__);
        $temp = new $link_table();
        return [
            'FROM' => self::getTable(),
            'SELECT' => [
                self::getTable() . '.id',
                self::getTable() . '.id as linkid',
                self::getTable() . '.comment',
                self::getTable() . '.itemtype as itemtype',
                self::getTable() . '.items_id as items_id',
            ],
            'WHERE' => [
                static::getTable() . '.concernedpersons_id' => $instID
            ],

            'LEFT JOIN' => [
                $temp->getTable() => [
                    'FKEY' => [
                        static::getTable() => 'concernedpersons_id',
                        $temp->getTable() => 'id'
                    ]
                ]
            ],
            'ORDER' => self::getTable() . '.id DESC'
        ];
    }

    static function getRecordsReliesRequest($instID)
    {
        $link_table = str_replace("_Item", "", __CLASS__);
        $temp = new $link_table();
        return [
            'FROM' => self::getTable(),
            'SELECT' => [
                self::getTable() . '.id',
                self::getTable() . '.id as linkid',
                self::getTable() . '.comment',
                self::getTable() . '.itemtype as itemtype',
                self::getTable() . '.itemtype1 as itemtype1',
                self::getTable() . '.items_id as items_id',
                self::getTable() . '.items_id1 as items_id1',
            ],
            'WHERE' => [
                static::getTable() . '.concernedpersons_id' => $instID,
                static::getTable() . '.itemtype1' => 'PluginDlteamsProcessedData',
            ],

            'LEFT JOIN' => [
                $temp->getTable() => [
                    'FKEY' => [
                        static::getTable() => 'concernedpersons_id',
                        $temp->getTable() => 'id'
                    ]
                ]
            ],
            'ORDER' => self::getTable() . '.id DESC'
        ];
    }

    public function getForbiddenStandardMassiveAction()
    {
        $forbidden = parent::getForbiddenStandardMassiveAction();
        $forbidden[] = 'clone';
        $forbidden[] = 'MassiveAction:add_transfer_list';
        $forbidden[] = 'MassiveAction:amend_comment';
        return $forbidden;
    }

    public function post_purgeItem()
    {
        global $DB;
//        purge relations
        if ($this->fields["itemtype"] && $this->fields["items_id"]) {

            $relation_item_str = $this->fields["itemtype"] . "_Item";
            if (!class_exists($relation_item_str))
                $relation_item_str = "PluginDlteams" . $relation_item_str;
            $relation_item = new $relation_item_str();

            $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype"]))) . "s_id";

            $criteria = [
                "itemtype" => PluginDlteamsConcernedPerson::class,
                "items_id" => $this->fields["concernedpersons_id"],
                $relation_column_id => $this->fields["items_id"],
                "comment" => $this->fields["comment"]
            ];

            $result = $relation_item->getFromDBByCrit($criteria);
            if ($result) {
                if ($result && $relation_item->fields["itemtype1"] && $relation_item->fields["items_id1"]) {
                    $DB->update(
                        $relation_item->getTable(),
                        [
                            "itemtype" => null,
                            "items_id" => 0,
                        ],
                        [
                            'id' => $relation_item->fields["id"]
                        ]
                    );

                    Session::addMessageAfterRedirect("Relation " . $relation_item::getTypeName() . " mis à jour avec succès");
                } else {
                    $relation_item->deleteByCriteria($criteria);
                    Session::addMessageAfterRedirect("Relation " . $relation_item::getTypeName() . " supprimé avec succès");
                }
            }
        }


//        traitement de la seconde relation
        if ($this->fields["itemtype1"] && $this->fields["items_id1"]) {
            $relation_item_str = $this->fields["itemtype1"] . "_Item";
            if (!class_exists($relation_item_str))
                $relation_item_str = "PluginDlteams" . $relation_item_str;
            $relation_item = new $relation_item_str();


            $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype"]))) . "s_id";

            $criteria = [
                "itemtype1" => PluginDlteamsConcernedPerson::class,
                "items_id1" => $this->fields["concernedpersons_id"],
                "items_id" => $this->fields["items_id1"],
                "comment" => $this->fields["comment"]
            ];

            $result = $relation_item->getFromDBByCrit($criteria);

            if ($result) {
                if ($result && $relation_item->fields["itemtype"] && $relation_item->fields["items_id"]) {
                    $DB->update(
                        $relation_item->getTable(),
                        [
                            "itemtype1" => null,
                            "items_id1" => 0,
                        ],
                        [
                            'id' => $relation_item->fields["id"]
                        ]
                    );
                    Session::addMessageAfterRedirect("Relation " . $relation_item::getTypeName() . " mis à jour avec succès");
                } else {
                    $relation_item->deleteByCriteria($criteria);
                    Session::addMessageAfterRedirect("Relation " . $relation_item::getTypeName() . " supprimé avec succès");
                }
            }
        }
    }

    public function post_updateItem($history = 1)
    {
        global $DB;
        if ($this->fields["itemtype"] && $this->fields["items_id"]) {
            $relation_item_str = $this->fields["itemtype"] . "_Item";
            if (!class_exists($relation_item_str))
                $relation_item_str = "PluginDlteams" . $relation_item_str;
            $relation_item = new $relation_item_str();
            $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype"]))) . "s_id";

            $criteria = [
                "itemtype" => PluginDlteamsConcernedPerson::class,
                "items_id" => $this->fields["concernedpersons_id"],
                $relation_column_id => $this->fields["items_id"],
                "itemtype1" => $this->fields["itemtype1"],
                "items_id1" => $this->fields["items_id1"],
                "comment" => $this->oldvalues["comment"]
            ];

            $relation_item->getFromDBByCrit($criteria);

            $DB->delete(
                $relation_item->getTable(),
                $criteria,
            );
            $relation_item->add([
                ...$criteria,
                "comment" => $this->fields["comment"]
            ]);
        }


        if ($this->fields["itemtype1"] && $this->fields["items_id1"]) {
            $relation_item_str = $this->fields["itemtype1"] . "_Item";
            if (!class_exists($relation_item_str))
                $relation_item_str = "PluginDlteams" . $relation_item_str;
            $relation_item = new $relation_item_str();
            $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype1"]))) . "s_id";

            $criteria = [
                "itemtype" => $this->fields["itemtype"],
                "items_id" => $this->fields["items_id"],
                $relation_column_id => $this->fields["items_id1"],
                "itemtype1" => PluginDlteamsConcernedPerson::class,
                "items_id1" => $this->fields["concernedpersons_id"],
                "comment" => $this->oldvalues["comment"]
            ];

            $relation_item->getFromDBByCrit($criteria);

            $DB->delete(
                $relation_item->getTable(),
                $criteria
            );
            $relation_item->add([
                ...$criteria,
                "comment" => $this->fields["comment"]
            ]);
        }
    }
}

//?>

<!--<script>-->
<!--    $(document).ready(function () {-->
<!---->
<!--        var form = document.querySelector('[id^="massaction_"][id$="' + dynamicID + '"]');-->
<!---->
<!--        form.addEventListener('submit', function (event) {-->
<!--            console.log(event);-->
<!--            if (!confirm('Voulez-vous vraiment soumettre ce formulaire ?')) {-->
<!--                event.preventDefault();-->
<!--            }-->
<!--        });-->
<!---->
<!--        $('select[name=items_id]').on('change', function () {-->
<!--            // alert($(this).val());-->
<!--            if ($(this).val() != '0') {-->
<!--                document.getElementById('update_comment_textarea').style.display = 'block';-->
<!---->
<!--            } else {-->
<!--                document.getElementById('update_comment_textarea').style.display = 'none';-->
<!--            }-->
<!--            //-->
<!--        });-->
<!---->
<!---->
<!--        $('select[name=itemtype]').on('change', function () {-->
<!--            if ($(this).val() != '0') {-->
<!--                document.getElementById('update_comment_textarea').style.display = 'block';-->
<!--            } else {-->
<!--                document.getElementById('update_comment_textarea').style.display = 'none';-->
<!--            }-->
<!--            //-->
<!--        });-->
<!---->
<!--    });-->
<!---->
<!---->
<!--</script>-->
