<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

class PluginDlteamsForm_Item extends CommonDBTM
{

//    public static $itemtype_1 = "PluginDlteamsDeliverable";
//    public static $items_id_1 = 'deliverables_id ';
//    public static $take_entity_1 = false;
//
//    public static $itemtype_2 = 'itemtype';
//    public static $items_id_2 = 'items_id';
//    public static $take_entity_2 = true;


    static public $itemtype_2 = 'PluginFormcreatorForm';
    static public $itemtype_1;
    public static $items_id_1;
    public static $title;
    public static $sub_title;
    public static $table_match_str = [];

    public function __construct()
    {
        static::$itemtype_1 = str_replace("_Item", "", __CLASS__); // $itemtype_1 ---> PluginDlteamsPolicieForm
        static::$items_id_1 = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", __CLASS__))) . "s_id";
        static::$title = __("Fichiers HTML en ", 'dlteams');
        static::$sub_title = __("Ajouter des fichiers HTML", 'dlteams');
        static::$table_match_str = [
            [
                'head_text' => __("Name"),
                'column_name' => 'name',
                'show_as_link' => true
            ],
            [
                'head_text' => __("Content"),
                'column_name' => 'content',
            ],
            [
                'head_text' => __("Comment"),
                'column_name' => 'comment',
            ]
        ];
        parent::__construct();
    }

    static function canCreate()
    {
        return true;
    }

    static function canView()
    {
        return true;
    }

    static function canUpdate()
    {
        return true;
    }

    static function canDelete()
    {
        return true;
    }

    static function canPurge()
    {
        return true;
    }

    function canCreateItem()
    {
        return true;
    }

    function canViewItem()
    {
        return true;
    }

    function canUpdateItem()
    {
        return true;
    }

    function canDeleteItem()
    {
        return true;
    }

    function canPurgeItem()
    {
        return true;
    }

    static function deleteItemAfterLinkDeletion(CommonDBTM $item)
    {
        $deliverable_item = new PluginDlteamsDeliverable_Item();
        $result = $deliverable_item->deleteByCriteria([
            "items_id" => $item->fields["id"],
            "itemtype" => Link::getType(),
        ]);
        if ($result)
            Session::addMessageAfterRedirect("Dossier de publication supprimé avec succès");
    }


    static function showForItem(CommonDBTM $item, $withtemplate = 0, $showitemtype1 = false)
    {
        $id = $item->fields['id'];
        $canedit = $item->can($id, UPDATE); // canedit booleen = true
        $rand = mt_rand(1, mt_getrandmax());
        global $DB;

        $iterator = static::getRequest($item, $showitemtype1);
        $number = count($iterator);
        $items_list = [];
        $used = [];

        //while ($data = $iterator->next()) {
        foreach ($iterator as $id => $data) {
            $items_list[$data['linkid']] = $data;
            $used[$data['id']] = $data['id'];
        }

        if ($canedit && $item::getType() != PluginDlteamsProcessedData::class) {
            echo "<form name='audititem_form$rand' id='audititem_form$rand' method='post'
             action='" . Toolbox::getItemTypeFormURL(PluginDlteamsElementsRGPD::class) . "'>";
            echo "<input type='hidden' name='itemtype1' value='" . $item->getType() . "' />";
            echo "<input type='hidden' name='itemtype' value='" . static::$itemtype_2 . "' />";
            echo "<input type='hidden' name='items_id1' value='" . $item->getID() . "' />";
            echo "<input type='hidden' name='entities_id' value='" . $item->fields['entities_id'] . "' />";
            echo "<input type='hidden' name='processitemtype1' value='" . $showitemtype1 . "' />";
//
            echo "<table class='tab_cadre_fixe'>";

            switch ($item::getType()) {
                case PluginDlteamsDataCatalog::class:
                    static::$title = "Ce jeu de données se trouve classé dans les catalogues suivants";
                    break;
                case Document::class:
                    static::$title = "Fichiers HTML en relation avec cet élément";
                    break;
            }
            echo "<tr class='tab_bg_2'><th colspan='3'>" . static::$title .
                "</th>";
            echo "</tr>";

            echo "<tr class='tab_bg_1'>";
            echo "<td class='right' style='text-wrap: nowrap;' width='20%'>";
            echo static::$sub_title;
            echo "</td>";

            echo "<td style='display: flex;' class='left'>";


            $rand = mt_rand();

            static::$itemtype_2::dropdown([
                'addicon' => true,
                'name' => 'items_id',
                'value' => "", //$responsible,
                // 'entity' => $this->fields["entities_id"],
                'right' => 'all',
                'rand' => $rand,
                'width' => "250px",
                'used' => $used
            ]);
//            $field_id = Html::cleanId("dropdown_" . 'items_' . mt_rand());
//            $item_link = getItemForItemtype(static::$itemtype_2);
//
//            echo '<div class="btn btn-outline-secondary"
//                           title="' . __s('Add') . '" data-bs-toggle="modal" data-bs-target="#add_' . $field_id . '">'
//                .Ajax::createIframeModalWindow('add_' . $field_id, $item_link->getFormURL(), ['display' => false])
//                ."<span data-bs-toggle='tooltip'>
//              <i class='fa-fw ti ti-plus'></i>
//              <span class='sr-only'>" . __s('Add') . "</span>
//                </span>"
//                .'</div>';


            echo "</td>";
            echo "<td class='left'>";
            echo "</td>";
            echo "</tr>";


//
//
            echo "<tr class='tab_bg_1' style='display: none;' id='field-deliverableitem-createlink'>";
            echo "<td class='right' width='20%'>";
            echo __("Comment");
            echo "</td>";
            echo "<td style='display: flex;' class='left'>";
            echo "<textarea type='text' style='width:100%;' maxlength=1000 rows='2' name='comment' id='deliverableitem-comment' class='comment'></textarea>";
            echo "</td>";
            echo "<td class='left'>";
            echo "</td>";
            echo "</tr>";

            echo "<tr>";
            echo "<td>";
            echo "</td>";
            echo "<td colspan='2' class='left'>";
            echo "<button name='link_element' style='display: none;' id='btn-deliverableitem-createlink' class='btn btn-primary'>Relier cet élément</button>";
            echo "</td>";
            echo "</tr>";


            echo "</table>";
            Html::closeForm();
        }

        echo "<script>
                $(document).ready(function(e){

                $('select[id=dropdown_items_id" . $rand . "]').on('change', function () {
                    if($(this).val() != '0'){
                        document.getElementById('btn-deliverableitem-createlink').style.display = 'block';
                        document.getElementById('field-deliverableitem-createlink').style.display = 'table-row';
                        
                        $.ajax({
                                url: '/marketplace/dlteams/ajax/get_object_specific_field.php',
                                type: 'POST',
                                data: {
                                    id: $(this).val(),
                                    object: '" . static::$itemtype_2 . "',
                                    field: 'content'
                                },
                                success: function (data) {
                                    // Handle the returned data here
                                    let comm_field = $('textarea[id=deliverableitem-comment]');
                                    comm_field.val(data);
                                    comm_field.val(comm_field.val().replace(/^\s+/, ''));
                                }
                            });                      
                        
                        
                    }
                    else{
                        document.getElementById('btn-deliverableitem-createlink').style.display = 'none';
                        document.getElementById('field-deliverableitem-createlink').style.display = 'none';
                    }
                       
                    });
                });
        </script>";


        if ($iterator) {

            echo "<div class='spaced'>";
            if ($canedit && $number && $item::getType() != PluginDlteamsProcessedData::class) {
                Html::openMassiveActionsForm('mass' . __CLASS__ . $rand);
                $massive_action_params = [
                    'container' => 'mass' . __CLASS__ . $rand,
                    'num_displayed' => min($_SESSION['glpilist_limit'], $number)
                ];
                Html::showMassiveActions($massive_action_params);
            }
            echo "<table class='tab_cadre_fixehov'>";

            $header_begin = "<tr>";
            $header_top = '';
            $header_bottom = '';
            $header_end = '';


            if ($canedit && $number && $item::getType() != PluginDlteamsProcessedData::class) {

                $header_begin .= "<th width='10'>";
                $header_top .= Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand);
//                $header_bottom .= Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand);
                $header_end .= "</th>";
            }


//            foreach (static::$table_match_str as $column) {
            $header_end .= "<th>" . "Nom" . "</th>";
//            if($item::getType() == PluginDlteamsProcessedData::class)
//                $header_end .= "<th>" . "Personnes concernées" . "</th>";
//            else
            $header_end .= "<th>" . "Contenu" . "</th>";
            $header_end .= "<th>" . "Commentaire" . "</th>";
//            }

//            $header_end.="<th>"."Traitements"."</th>";
            $header_end .= "</tr>";

            echo $header_begin . $header_top . $header_end;
            //var_dump($items_list);
            foreach ($items_list as $data) {
                echo "<tr class='tab_bg_1'>";

                if ($canedit && $number && $item::getType() != PluginDlteamsProcessedData::class) {
                    echo "<td width='10'>";

                    $item_str = $item::class . "_Item";
//                        Computer_Item::class;
                    Html::showMassiveActionCheckBox(__CLASS__, $data['linkid']);
                    echo "</td>";

                    $id = $data['linkid'];
                }


//                foreach (static::$table_match_str as $key => $column) {

                $name = $data["name"];
                $name = "<a target='_blank' href=\"" . static::$itemtype_2::getFormURLWithID($data["deliverables_id"]) . "\">" . $name . "</a>";
                echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                echo ">" . $name . "</td>";

                echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                echo ">" . $data["content"] . "</td>";


                if ($item::getType() == PluginDlteamsProcessedData::class) {
                    $concernedperson_id = $data["items_id"];
                    $cp = new PluginDlteamsConcernedPerson();
                    $cp->getFromDB($concernedperson_id);
                    echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                    echo ">" . $cp->fields["name"] . "</td>";
                } else {
                    echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                    echo ">" . $data["comment"] . "</td>";
                }

//                    if (isset($data[$column["column_name"]]))
//                        $name = $data[$column["column_name"]];
//                    if (!isset($data[$column["column_name"]]))
//                        $name = "--";
//
//                    if ($key === 0)
//                        $name = "<a target='_blank' href=\"" . static::$itemtype_2::getFormURLWithID($data[static::$items_id_1]) . "\">" . $name . "</a>";
//
//                    echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
//                    echo ">" . $name . "</td>";
//                }

//                echo "<td class='left relations_list" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
//                echo ">";

//                $policieform_id = $data["deliverables_id"];
//                $policieform = new PluginDlteamsPolicieForm();
//                $policieform->getFromDB($policieform_id);


//                $users_data = PluginDlteamsRecord_Item::getRequest($policieform);
                /*                highlight_string("<?php\n\$data =\n" . var_export($users_data, true) . ";\n?>");*/
//                die();
//                echo "<ul>";
//                foreach ($users_data as $li_row) {
//                    echo "<li>";
//                    $linkid = $li_row["linkid"];
//                    echo $li_row["name"] . "&nbsp; <i class='fa fa-close delete-record-pf' data-linkid='$linkid' style='color: red; cursor: pointer'></i>";
//                    echo "</li>";
//                }
//                echo "</ul>";

//                echo "<span class='pointer add_record' data-policieform-id='$policieform_id' data-datacatalog-id='$id'>
//                    <i class='fa fa-plus' title='" . __('Attribuer un traitement') . "'></i>
//                    <span class='sr-only'>" . __('Attribuer un traitement à ce jeu de données') . "</span>
//                 </span>";
//                echo "</td>";

                echo "</tr>";
            }

            echo "</table>";

//            echo "
//            <script>
//                $('.add_record').click(function () {
//             glpi_ajax_dialog({
//                dialogclass: 'modal-md',
//                bs_focus: false,
//                params: {
//                  policieforms_id: $(this).attr('data-policieform-id'),
//                  datacatalogs_id: $(this).attr('data-datacatalog-id')
//                },
//                url: '/marketplace/dlteams/ajax/policiform_record.php',
//                title: i18n.textdomain('dlteams').__('Action', 'dlteams'),
//                close: function () {
//
//                },
//                fail: function () {
//                    displayAjaxMessageAfterRedirect();
//                }
//
//             });
//        });
//
//
//
//                 $('.delete-record-pf').click(function(e) {
//          e.preventDefault();
//           $.ajax({
//                        url: '/marketplace/dlteams/ajax/policiform_record.php',
//                        type: 'POST',
//                        data: {
//                            delete: true,
//                            linkid: $(this).attr('data-linkid'),
//                        },
//                        success: function (data) {
//                            location.reload();
//                        },
//
//            });
//        });
//                </script>
//            ";

            Html::closeForm();

            echo "
                <script>
                    $(document).ready(function(e) {
                        var window.eventBinded = false;
                
                        $(document).on('change', 'select[name=id_field]', function () {
                            console.log('shhhh');
                            
                            if (!alertShown) {
                                $.ajax({
                                        url: '/marketplace/dlteams/ajax/get_object_specific_field.php',
                                        type: 'POST',
                                        data: {
                                            id: " . $id . ",
                                            object: '" . static::$itemtype_2 . "_Item" . "',
                                            field: 'comment'
                                        },
                                        success: function (data) {
                                            // Handle the returned data here
                                            console.log(data);
                                            $('textarea[name=comment]').val(data);
                                        }
                            });
                                eventBinded = true;
                            }
                        });
                    });
                </script>
                ";
            echo "</div>";
        }

    }


    public static function getRequest(CommonDBTM $item, $showitemtype1 = false)
    {
        $table_name = static::$itemtype_2::getTable(); // si $item = DataCatalog, $table_name contiendra data_carriers
        $columnid_name = strtolower(str_replace("PluginDlteams", "", static::$itemtype_2::getType())) . "s_id"; // $columnid_name contiendra users_id si $item = User
        global $DB;        //var_dump ($table_name, $columnid_name);
        $table_item_name = getTableForItemType(static::$itemtype_2 . "_Item");

        $firstitemtype_str = $showitemtype1 ? "itemtype1" : "itemtype";
        $firstitems_id = $showitemtype1 ? "items_id1" : "items_id";
        $query = [
            'SELECT' => [
                $table_item_name . '.id AS linkid',
                $table_item_name . '.' . $firstitemtype_str . ' AS itemtype',
                $table_item_name . '.' . $firstitems_id . ' AS items_id',
                $table_item_name . '.*',
                $table_name . '.id AS id',
                $table_name . '.name AS name',
                $table_name . '.content AS content',
            ],
            'FROM' => $table_item_name,
            'JOIN' => [
                $table_name => [
                    'ON' => [
                        $table_item_name => $columnid_name,
                        $table_name => 'id'
                    ]
                ]
            ],
            'WHERE' => [
                $table_item_name . '.' . $firstitemtype_str => ['LIKE', $item::getType()],
                $table_item_name . '.' . $firstitems_id => $item->fields['id'],
            ],
            'ORDERBY' => ['name ASC']
        ];


        /*        highlight_string("<?php\n\$data =\n" . var_export($query, true) . ";\n?>");*/
//        die();
        if ($DB->fieldExists($table_item_name, 'comment')) {
            $query['SELECT'][] = $table_item_name . '.comment AS comment';
        }

        if ($DB->fieldExists($table_name, 'content')) {
            $query['SELECT'][] = $table_name . '.content AS content';
        }


        $iterator = $DB->request($query);

        $temp = [];

        foreach ($iterator as $id => $data) {
            if ($data[$firstitemtype_str] && $data["id"]) {
                $item_object = null;
                $item_str = $data[$firstitemtype_str];
                $item_object = new $item_str();
                $item_object->getFromDB($data[$firstitems_id]);


                if (isset($item_object->fields["entities_id"])) {
                    array_push($temp, $data);
                }

            }

        }
        return $temp;
    }

    public function post_purgeItem()
    {
//        purge relations
        $relation_item_str = $this->fields["itemtype"] . "_Item";
        if (!class_exists($relation_item_str))
            $relation_item_str = "PluginDlteams" . $relation_item_str;
        $relation_item = new $relation_item_str();

        $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype"]))) . "s_id";

        $criteria = [
            "itemtype" => static::$itemtype_2,
            "items_id" => $this->fields[static::$items_id_1],
            $relation_column_id => $this->fields["items_id"],
            "comment" => $this->fields["comment"]
        ];

        $relation_item->deleteByCriteria($criteria);
    }


    public function post_updateItem($history = 1)
    {
        $relation_item_str = $this->fields["itemtype"] . "_Item";
        if (!class_exists($relation_item_str))
            $relation_item_str = "PluginDlteams" . $relation_item_str;
        $relation_item = new $relation_item_str();
        $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype"]))) . "s_id";

        $criteria = [
                "itemtype" => static::$itemtype_2,
                "items_id" => $this->fields[static::$items_id_1],
                $relation_column_id => $this->fields["items_id"],
            ] + ($this->oldvalues["comment"] ? ["comment" => $this->oldvalues["comment"]] : []);


        if ($this->fields["itemtype"] != Document::class) {
            $relation_item->deleteByCriteria($criteria);
            $relation_item->add([
                ...$criteria,
                "comment" => $this->fields["comment"]
            ]);
        }
    }

    public function getForbiddenStandardMassiveAction()
    {
        $forbidden = parent::getForbiddenStandardMassiveAction();
        $forbidden[] = 'clone';
        $forbidden[] = 'MassiveAction:add_transfer_list';
        $forbidden[] = 'MassiveAction:amend_comment';
        $forbidden[] = 'MassiveAction:purge_but_item_linked';
        $forbidden[] = 'MassiveAction:add_note';
        return $forbidden;
    }


    function rawSearchOptions()
    {
//        $tab[] = [
//            'id' => '43',
//            'table' => static::getTable(),
//            'field' => 'mandatory',
//            'datatype' => 'bool',
//            'name' => __("Obligatoire"),
//            'forcegroupby' => true,
//            'massiveaction' => true,
//        ];

        $tab[] = [
            'id' => '44',
            'table' => static::getTable(),
            'field' => 'comment',
            'datatype' => 'text',
            'name' => __("Commentaire"),
            'forcegroupby' => true,
            'massiveaction' => true,
        ];

        return $tab;
    }

}
