<?php

/**
 * Class for managing massive actions on KnowbaseItemCategory
 */
class PluginDlteamsKnowbaseItemCategory_Actions extends CommonDBTM
{
    public function __construct()
    {
        self::forceTable(KnowbaseItemCategory::getTable());
    }

    static function canCreate() { return true; }
    static function canView() { return true; }
    static function canUpdate() { return true; }
    static function canDelete() { return true; }
    static function canPurge() { return true; }
    function canCreateItem() { return true; }
    function canViewItem() { return true; }
    function canUpdateItem() { return true; }
    function canDeleteItem() { return true; }
    function canPurgeItem() { return true; }

    public function getForbiddenStandardMassiveAction()
    {
        $forbidden = parent::getForbiddenStandardMassiveAction();
        $forbidden[] = 'clone';
        $forbidden[] = 'MassiveAction:add_transfer_list';
        $forbidden[] = 'MassiveAction:amend_comment';
        return $forbidden;
    }

    public static function showMassiveActionsSubForm(MassiveAction $ma)
    {
        switch ($ma->getAction()) {
            case 'update_comment':
                Html::textarea([
                    'name' => 'comment',
                    'value' => "",
                    'cols' => 125,
                    'rows' => 3,
                    'enable_richtext' => true
                ]);
                break;
        }
        return parent::showMassiveActionsSubForm($ma);
    }

    public function getSpecificMassiveActions($checkitem = NULL)
    {
        $actions = parent::getSpecificMassiveActions($checkitem);

        // Ajouter des actions massives spécifiques
        $class = __CLASS__;
        $action_key = "update_comment";
        $action_label = __("Update comment");
        $actions[$class . MassiveAction::CLASS_ACTION_SEPARATOR . $action_key] = $action_label;

        return $actions;
    }

    public static function processMassiveActionsForOneItemtype(MassiveAction $ma, CommonDBTM $item, array $ids)
    {
        switch ($ma->getAction()) {
            case 'update_comment':
                foreach ($ids as $key) {
                    if ($item->can($key, UPDATE)) {
                        if ($item->update([
                            "comment" => $ma->POST['comment'],
                            "id" => $key
                        ])) {
                            $ma->itemDone($item->getType(), $key, MassiveAction::ACTION_OK);
                        } else {
                            $ma->itemDone($item->getType(), $key, MassiveAction::ACTION_KO);
                        }
                    } else {
                        $ma->itemDone($item->getType(), $key, MassiveAction::ACTION_NORIGHT);
                    }
                }
                break;
        }
        return true;
    }
}