<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

class PluginDlteamsRightMeasure extends CommonDropdown
{
    static $rightname = 'plugin_dlteams_rightmeasure';
    public static $menukey = "datagovernancerightmeasure";
    public $dohistory = true;
    protected $usenotepad = true;

    static function getTypeName($nb = 0)
    {
        return _n("Rights measure", "Rights measures", $nb, 'dlteams');
    }


    public static function getMenuContent()
    {

        $menu = [];
        $menu['title'] = static::getTypeName(Session::getPluralNumber());
        $menu['shortcut'] = 'n';
        $menu['page'] = static::getSearchURL();
        $menu['icon'] = self::getIcon();
        $menu['config']['default'] = '/front/dropdown.php';


        $menu['options'] = [];
//        Bouton add
        if (static::canCreate()) {
            $menu['options']["rightmeasure"]['links']['add'] = static::getFormURL(false);
        }

//        bouton rechercher
        $menu['options']["rightmeasure"]['links']['search'] = static::getSearchURL(false);

//        bouton help
        $image = "<i class='fas fa-question' title='" . 'Aide' . "'></i>";
        // $menu['options']["rightmeasure"]['links'][$image] = KnowbaseItem::getSearchURL(false) . '?contains="%2Bmesure %2Bdroit"';
		$menu['options']["rightmeasure"]['links'][$image] = 'https://help.dlteams.app/front/helpdesk.faq.php?id=6';

        echo "<script>
                        \$(document).ready(function () {
                            // Attendre que la page soit complètement chargée
                            \$('a[href^=\"/front/knowbaseitem.php?contains=\"]').attr('target', '_blank');
                           
                        });
                    </script>";


        if (count($_SESSION['glpiprofiles']) > 1) {
            $profile = new Profile();
            $name = 'Vue-Modele';
            $options = [
                'SELECT' => [
                    'id'
                ],
                'WHERE' => [
                    'name' => $name,
                ]
            ];

            global $DB;
            $req = $DB->request($profile->getTable(), $options);
            foreach ($req as $id => $row) {
                //if ($row = $req->next()) {
                $profile->getFromDB($row['id']);
                if (array_key_exists($profile->getID(), $_SESSION['glpiprofiles'])) {
                    $swap = $_SESSION['glpiactiveprofile']['id'] == $profile->getID();
                    $text = '<i class="fa fa-layer-group pointer" style="margin-right: 0.4em;"></i>' . __("Swap to model view", "dlteams");
                    $returnKey = array_key_first($_SESSION['glpiprofiles']) == $profile->getID() ? array_keys($_SESSION['glpiprofiles'])[1] : array_key_first($_SESSION['glpiprofiles']);
                    $prodif = $profile->getID();
                    $server_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
                    empty($swap) ? $text = "vue modèle" : $text = "vue modèle";
                    empty($swap) ? $val = $prodif : $val = $returnKey;
                    empty($swap) ? $checked = '' : $checked = 'checked';


                    $text_temp = "<div id='switchmodelcontainer' style='width:100%; display: flex;justify-content: center; margin-bottom: 1px; margin-right: 25px;'>
                                        <label class='form-check form-switch btn-xs  me-0 me-sm-1 px-1 py-1 mb-0 flex-column-reverse flex-sm-row'
                                            title='$text'>
                                         <input type='checkbox' class='form-check-input ms-0 me-1 mt-0' role='button'
                                                autocomplete='off'
                                                $checked
                                                onclick='window.location.href=`$server_url/front/central.php?newprofile=$val`'
                                                />
                                         <span class='form-check-label mb-1 mb-sm-0'>
                                            $text
                                         </span>
                                      </label></div>
                                      
                                      <script>
                                            var child = document.getElementById('switchmodelcontainer');
                                            var parent = child.parentNode;
                                            parent.style.border = 'none';
                                            parent.classList.remove('btn-outline-secondary');
                                        </script>
                            ";


                    $menu['options']["rightmeasure"]['links'][$text_temp] = "/front/central.php?newprofile=$val";
                    break;


                }
            }

        }

        return $menu;
    }

    public static function getCurrentId()
    {
        // Get the current URL
        $currentURL = $_SERVER['REQUEST_URI'];

        // Get the query string from the URL
        $queryString = parse_url($currentURL, PHP_URL_QUERY);

        // Initialize an empty array for query parameters
        $queryParams = [];

        // Parse the query string into an array of parameters if it exists
        if ($queryString) {
            parse_str($queryString, $queryParams);
        }

        // Get the value of the "id" parameter
        $id = isset($queryParams['id']) ? $queryParams['id'] : null;

        return $id;
    }

    public static function getIcon()
    {
        return "ti ti-edit";
    }


    function showForm($id, $options = [])
    {
        global $CFG_GLPI;
        $this->initForm($id, $options);
        $this->showFormHeader($options);

        echo "<style>";
        echo "
            .form-table-text {
                text-align: right;
                width: 25%;
            }
            
            @media (max-width: 800px) {
                .form-table-text {
                    text-align: left;
                    width: 100%;
                }
            }
        ";
        echo "</style>";

        echo "<table, th, td width='100%'>";
        echo "<tr>";
//		echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td class='form-table-text' >" . __("Name", 'dlteams');
		Html::showtooltip ('Document, formulaire, mention légale<br>Procédure d\'information, de recueil du consentement, d\'exercice et de traitement des droits, de notification des violations, ...');
		echo "</td><td>";
        $name = Html::cleanInputText($this->fields['name']);
        echo "<input type='text' style='width:100%' name='name' required value='" . $name . "'>" . "</td>";
        echo "<td width='15%' style='text-align:right'>" . " " . "</td>";
        echo "</tr>";

        echo "<tr>";
//      echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td class='form-table-text''>" . __("Content", 'dlteams') . "</td>";
        echo "<td>";
        $content = Html::cleanInputText($this->fields['content']);
//      echo "<textarea style='width: 98%;' name='content' rows='3'>" . $content . "</textarea>";
        Html::textarea(['name' => 'content',
            'value' => $content,
            'enable_fileupload' => false,
            'enable_richtext' => true,
            'enable_images' => false,
            'cols' => 12,
            'rows' => 80
        ]);
        echo "</td></tr>";

//	  echo "<tr>";
//	  echo "<td class='form-table-text'>". __("Catégorie de mesure", 'dlteams') . "</td>";
//	  echo "<td>";
//		PluginDlteamsRightMeasureCategory::dropdown([
//         'addicon'  => PluginDlteamsRightMeasureCategory::canCreate(),
//         'name' => 'rightmeasurecategories[]',
//         'value'  => json_decode($this->fields['rightmeasurecategories']??"[]"), //$responsible,
//         'right'  => 'all',
//         'width'  => "300px",
//         'multiple' => true
//        // 'rand'   => $randDropdown
//       ]);
//	  echo "</td></tr>" ;

        echo "<tr>";
//      echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td class='form-table-text'>" . __("Comment", 'dlteams') . "</td>";
        echo "<td>";
        $comment = Html::cleanInputText($this->fields['comment']);
        echo "<textarea style='width: 100%;' name='comment' rows='3'>" . $comment . "</textarea>";
        echo "</td></tr>";
        echo "</table>";

        $this->showFormButtons($options);


        PluginDlteamsRightMeasureCategory_Item::showForItem($this);
        return true;
    }

    public static function getDefaultSearchRequest()
    {
        $search = [
            'criteria' => [
                0 => [
                    'field' => 0,
                    'searchtype' => 'contains',
                    'value' => ''
                ],
            ],
            'sort' => 101,
            'order' => 'DESC'
        ];

        if (Session::haveRight(self::$rightname, Ticket::READALL)) {
            $search['criteria'][0]['value'] = 'notold';
        }
        return $search;
    }

    function rawSearchOptions()
    {

        $tab = [];

        $tab[] = [
            'id' => 'common',
            'name' => __("Characteristics")
        ];

        $tab[] = [
            'id' => '1',
            'table' => $this->getTable(),
            'field' => 'name',
            'name' => __("Name"),
            'datatype' => 'itemlink',
            'massiveaction' => false,
            'autocomplete' => true,
        ];

        $tab[] = [
            'id' => '2',
            'table' => $this->getTable(),
            'field' => 'id',
            'name' => __("ID"),
            'massiveaction' => false,
            'datatype' => 'number',
        ];

//      $tab[] = [
//         'id'                 => '3',
//         'table'              => 'glpi_plugin_dlteams_rightmeasurecategories',
//         'field'              => 'name',
//         'name'               => __("Type", 'dlteams'),
//         'searchtype'         => 'equals',
//         'massiveaction'      => true,
//         'datatype'           => 'specific'
//      ];

        $tab[] = [
            'id' => '4',
            'table' => $this->getTable(),
            'field' => 'content',
            'name' => __("Content"),
            'datatype' => 'text',
            'htmltext' => true,
            'toview' => true,
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '5',
            'table' => $this->getTable(),
            'field' => 'comment',
            'name' => __("Comments"),
            'datatype' => 'text',
            'toview' => true,
            'massiveaction' => true,
        ];

        $tab[] = [
            'id' => '100',
            'table' => $this->getTable(),
            'field' => 'date_creation',
            'name' => __("Date de creation"),
            'massiveaction' => false,
            'datatype' => 'date',
        ];

        $tab[] = [
            'id' => '101',
            'table' => $this->getTable(),
            'field' => 'date_mod',
            'name' => __("Last update"),
            'massiveaction' => false,
            'datatype' => 'date',
        ];

        $tab[] = [
            'id' => '6',
            'table' => 'glpi_entities',
            'field' => 'completename',
            'name' => __("Entity"),
            'massiveaction' => true,
            'datatype' => 'dropdown',
        ];

        $tab[] = [
            'id' => '7',
            'table' => $this->getTable(),
            'field' => 'is_recursive',
            'name' => __("Child entities"),
            'massiveaction' => false,
            'datatype' => 'bool',
        ];

        $tab[] = [
            'id' => '10',
            'table' => PluginDlteamsRightMeasure_Item::getTable(),
//            'table' => 'glpi_plugin_dlteams_rightmeasures_items',
            'field' => 'id',
            'name' => __("Catégorie"),
            'massiveaction' => false,
            'datatype' => 'dropdown',
            'joinparams' => [
                'jointype' => 'itemtype_item'
            ]
        ];


//        $tab[] = [
//            'id'                 => '10',
//            'table'              => PluginDlteamsRightMeasure_Item::getTable(),
//            'field'              => 'items_id',
//            'name'               => _x('quantity', 'Catégorie'),
//            'datatype'           => 'specific', //'itemlink',
//            'comments'           => true,
//            'nosort'             => false,
//            'additionalfields'   => ['itemtype'],
//            'joinparams'         => [
//                'linkfield' => 'rightmeasures_id',
//                'jointype'           => 'child',
//                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsDataCategory::class."'",
//            ],
//            'forcegroupby'       => true,
//            'massiveaction'      => false,
//            'htmltext'           => true,
//            'showcategories' => true
//            //'dlteams_activityname' => true,
//        ];

        $tab[] = [
            'id' => '11',
            'table' => PluginDlteamsRightMeasure_Item::getTable(),
            'field' => 'items_id',
            'name' => _x('quantity', 'Jeux données'),
            'datatype' => 'specific', //'itemlink',
            'comments' => true,
            'nosort' => false,
            'additionalfields' => ['itemtype'],
            'joinparams' => [
                'linkfield' => 'rightmeasures_id',
                'jointype' => 'child',
                'condition' => "AND NEWTABLE.`itemtype` = '" . PluginDlteamsPolicieForm::class . "'",
            ],
            'forcegroupby' => true,
            'massiveaction' => false,
            'htmltext' => true,
            'showpolicies' => true
            //'dlteams_activityname' => true,
        ];

//        $tab[] = [
//            'id' => '11',
//            'table' => 'glpi_plugin_dlteams_policieforms_items',
//            'field' => 'id',
//            'name' => _x('quantity', 'Jeux données'),
//            'forcegroupby' => true,
//            'usehaving' => true,
//            'datatype' => 'count',
//            'massiveaction' => false,
//            'joinparams' => [
//                'jointype' => 'itemtype_item'
//            ]
//        ];

//        $tab[] = [
//            'id' => '12',
//            'table' => PluginDlteamsRecord_Item::getTable(),
//            'field' => 'id',
//            'name' => PluginDlteamsRecord::getTypeName(2),
//            'forcegroupby' => true,
//            'usehaving' => true,
//            'datatype' => 'count',
//            'massiveaction' => false,
//            'joinparams' => [
//                'jointype' => 'itemtype_item'
//            ]
//        ];

        $tab[] = [
            'id' => '12',
            'table' => PluginDlteamsRightMeasure_Item::getTable(),
            'field' => 'items_id',
            'name' => PluginDlteamsRecord::getTypeName(2),
            'datatype' => 'specific', //'itemlink',
            'comments' => true,
            'nosort' => false,
            'additionalfields' => ['itemtype'],
            'joinparams' => [
                'linkfield' => 'rightmeasures_id',
                'jointype' => 'child',
                'condition' => "AND NEWTABLE.`itemtype` = '" . PluginDlteamsRecord::class . "'",
            ],
            'forcegroupby' => true,
            'massiveaction' => false,
            'htmltext' => true,
            'showrecords' => true
            //'dlteams_activityname' => true,
        ];

        $tab[] = [
            'id' => '13',
            'table' => PluginDlteamsRightMeasureCategory_Item::getTable(),
            'field' => 'id',
            'name' => PluginDlteamsRightMeasureCategory::getTypeName(),
            'forcegroupby' => true,
            'usehaving' => true,
            'datatype' => 'count',
            'massiveaction' => false,
            'joinparams' => [
                'jointype' => 'itemtype_item'
            ]
        ];

        return $tab;
    }

    public function defineTabs($options = [])
    {
        $ong = [];
        $ong = array();
        $this->addDefaultFormTab($ong)
            ->addStandardTab(PluginDlteamsPolicieForm_Item::class, $ong, $options)
//      ->addStandardTab(PluginDlteamsRightMeasureCategory_Item::class, $ong, $options)
            ->addStandardTab('PluginDlteamsObject_document', $ong, $options)
            ->addStandardTab(PluginDlteamsFormcreatorForm_Item::class, $ong, $options)
            ->addStandardTab('PluginDlteamsRecord_Item', $ong, $options)
            ->addStandardTab(PluginDlteamsTicket_Item::class, $ong, $options)
            ->addStandardTab('KnowbaseItem_Item', $ong, $options)
            ->addImpactTab($ong, $options)
            ->addStandardTab('Notepad', $ong, $options)
            ->addStandardTab('PluginDlteamsRightMeasure_Item', $ong, $options)
            ->addStandardTab('Log', $ong, $options);
        return $ong;
    }

    public static function showMassiveActionsSubForm(MassiveAction $ma)
    {
        switch ($ma->getAction()) {
            case 'copyTo':
                //                $values = [];
//                foreach ($_SESSION["glpiactiveentities"] ?? [] as $key => $entities_id) {
//                    $entity = new Entity();
//                    $entity->getFromDB($entities_id);
//                    $values[$key] = $entity->fields["completename"];
//                }
                Entity::dropdown(['name' => 'entities_id']);
                echo '<br /><br />' . Html::submit(_x('button', 'Post'), ['name' => 'massiveaction']);
                return true;
        }
        return parent::showMassiveActionsSubForm($ma);
    }

    static function processMassiveActionsForOneItemtype(MassiveAction $ma, CommonDBTM $item, array $ids)
    {
        switch ($ma->getAction()) {
            case 'copyTo':
                if ($item->getType() == PluginDlteamsRightMeasure::getType()) {
                    foreach ($ids as $id) {
                        if ($item->getFromDB($id)) {
                            if ($item->copy1($ma->POST['entities_id'], $id, $item)) {

                                Session::addMessageAfterRedirect(sprintf(__('%s copied: %s', 'dlteams'), $item->getTypeName(), $item->getName()));
                                $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);
                            }
                        } else {
                            // Example of ko count
                            $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_KO);
                        }
                    }
                }
                return;
        }
        parent::processMassiveActionsForOneItemtype($ma, $item, $ids);
    }

    public function copy1($entity, $id, $item)
    {
        global $DB;
        $dbu = new DbUtils();
        $name = $item->fields['name'];

        $nb = $dbu->countElementsInTable(static::getTable(), ['name' => addslashes($name), 'entities_id' => $entity]);

        if ($nb <= 0) {
            $DB->request("INSERT INTO " . static::getTable() . " (entities_id, is_recursive, date_mod, date_creation, name, content, comment) SELECT '$entity', is_recursive, date_mod, date_creation, name, content, comment FROM " . static::getTable() . " WHERE id='$id'");
            return true;
        } else {
            return false;
        }
    }
}
