<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software. 
 It disallow others people than DLPlace developers to distribute, sell, 
 or add additional requirements to this software. 
 Though, a limited set of safe added requirements can be allowed, but 
 for private or internal usage only ;  without even the implied warranty 
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

class PluginDlteamsStep extends CommonTreeDropdown
{
    static $rightname = 'plugin_dlteams_step';
    public $dohistory = true;
    protected $usenotepad = true;

    static function getTypeName($nb = 0)
    {
        return _n("Project task", "Project tasks", $nb, 'dlteams');
    }

    public function getName($options = [])
    {
        return sprintf("%s | %s", $this->fields["projects_id"], $this->fields["completename"]);
    }

    public static function getTable($classname = null)
    {
        return ProjectTask::getTable(); // TODO: Change the autogenerated stub
    }

//    public static function getDefaultSearchRequest()
//    {
//        $projects_id = isset($_GET['projects_id']) ? $_GET['projects_id']:null;
//        if(!$projects_id){
//            $project = new Project();
//            $project->getFromDBByCrit([
//                "name" => "Conformité RGPD",
//                "entities_id" => Session::getActiveEntity(),
//                "is_deleted" => 0
//            ]);
//            $projects_id = $project->fields["id"];
//        }
//
//
//
//        $search = [];
//        if ($projects_id)
//            $search = [
//                'criteria' => [
//                    0 => [
//                        'field' => 2,
//                        'searchtype' => 'equals',
//                        'value' => $projects_id,
//                    ],
//                ],
//                'sort' => 20,
//                'order' => 'ASC'
//            ];
//
////        if (Session::haveRight(self::$rightname, Ticket::READALL)) {
////            $search['criteria'][0]['value'] = 'notold';
////        }
//        return $search;
//    }

    /*
    public function showForm($ID, array $options = [])
    {
        if ($ID > 0) {
            $this->check($ID, READ);
            $duration        = ProjectTask_Ticket::getTicketsTotalActionTime($this->getID());
            $projects_id     = $this->fields['projects_id'];
            $projecttasks_id = $this->fields['projecttasks_id'];
            $recursive       = null; // Wont be used in the case, value is irrelevant
        } else {
            $this->check(-1, CREATE, $options);
            $duration        = null;
            $projects_id     = $options['projects_id'];
            $projecttasks_id = $options['projecttasks_id'];
            $recursive       = $this->fields['is_recursive'];
        }

        $duration_dropdown_to_add = [];
        for ($i = 9; $i <= 100; $i++) {
            $duration_dropdown_to_add[] = $i * HOUR_TIMESTAMP;
        }

        $this->initForm($ID, $options);
        \Glpi\Application\View\TemplateRenderer::getInstance()->display('pages/tools/project_task.html.twig', [
            'id'                       => $ID,
            'item'                     => $this,
            'params'                   => $options,
            'parent'                   => Project::getById($projects_id),
            'projects_id'              => $projects_id,
            'projecttasks_id'          => $projecttasks_id,
            'recursive'                => $recursive,
            'duration_dropdown_to_add' => $duration_dropdown_to_add,
            'duration'                 => $duration,
            'rand'                     => mt_rand(),
        ]);
        return true;
    }
    */

    /**
     * function showForm($id, $options = []) {
     * global $CFG_GLPI;
     * $this->initForm($id, $options);
     * $this->showFormHeader($options);
     *
     * echo "<tr class='tab_bg_1'>";
     * echo "<td width='50%'>". __("Name", 'dlteams') . "</i></td>";
     * echo "<td colspan='2'>";
     * $name = Html::cleanInputText($this->fields['name']);
     * echo "<input type='text' style='width:71%' maxlength=250 name='name' required value='" . $name . "'>";
     * echo "</td></tr>";
     *
     * echo "<tr class='tab_bg_1'>";
     * echo "<td>" . __("Comment", 'dlteams') . "</td>";
     * echo "<td colspan='2'>";
     * $comment = Html::cleanInputText($this->fields['comment']);
     * echo "<textarea style='width: 70%;' name='comment' maxlength='1000' rows='3'>" . $comment . "</textarea>";
     * echo "</td></tr>";
     *
     * $this->showFormButtons($options);
     * return true;
     * }
     **/

    public static function getFormURLWithID($id = 0, $full = true)
    {
        $itemtype = PluginDlteamsAccountKey::class;
        $itemtype_item = new PluginDlteamsAccountKey_Item();
        $itemtype_item->getFromDB($id);
        $link = $itemtype::getFormURL($full);
        $link .= (strpos($link, '?') ? '&' : '?') . 'id=' . $itemtype_item->fields["accountkeys_id"];
        return $link;
    }


    function prepareInputForAdd($input)
    {
        $input['users_id_creator'] = Session::getLoginUserID();
        return parent::prepareInputForAdd($input);
    }

    function prepareInputForUpdate($input)
    {
        $input['users_id_lastupdater'] = Session::getLoginUserID();
        return parent::prepareInputForUpdate($input);
    }

    function cleanDBonPurge()
    {
        //$rel = new PluginDlteamsRecord_MotifEnvoi();
        //$rel->deleteByCriteria(['plugin_dlteams_concernedpersons_id' => $this->fields['id']]);

        $this->showFormButtons($options);
        return true;
    }

    public static function addSelect($itemtype, $ID, $meta = 0, $meta_type = 0)
    {
        var_dump("in add select");
        die();
    }


    function rawSearchOptions()
    {


//        $caller = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 2)[1];
//        echo "Appelé par {$caller['function']} dans {$caller['file']} à la ligne {$caller['line']}";
        $tab = [];

        $tab[] = [
            'id' => 'common',
            'name' => __('Characteristics')
        ];

        $tab[] = [
            'id' => '1',
            'table' => $this->getTable(),
            'field' => 'completename',
            'name' => __('Complete name'),
            'datatype' => 'itemlink',
            'massiveaction' => false,
        ];

        $tab[] = [
            'id' => '2',
            'table' => 'glpi_projects',
            'field' => 'name',
            'name' => Project::getTypeName(1),
            'massiveaction' => false,
            'datatype' => 'dropdown'
        ];
        // il faudrait ajouter un bouton sur la ligne "filtrer ce projet"

        $tab[] = [
            'id' => '13',
            'table' => $this->getTable(),
            'field' => 'name',
            'name' => __('Father'),
            'datatype' => 'dropdown',
            'massiveaction' => false,
            // Add virtual condition to relink table
            'joinparams' => [
                'condition' => 'AND 1=1'
            ]
        ];

        $tab[] = [
            'id' => '21',
            'table' => $this->getTable(),
            'field' => 'content',
            'name' => __('Description'),
            'massiveaction' => false,
            'datatype' => 'text',
            'htmltext' => true,
        ];

        $tab[] = [
            'id' => '12',
            'table' => 'glpi_projectstates',
            'field' => 'name',
            'name' => _x('item', 'State'),
            'datatype' => 'dropdown'
        ];

        $tab[] = [
            'id' => '14',
            'table' => 'glpi_projecttasktypes',
            'field' => 'name',
            'name' => _n('Type', 'Types', 1),
            'datatype' => 'dropdown'
        ];

        $tab[] = [
            'id' => '121',
            'table' => $this->getTable(),
            'field' => 'date_creation',
            'name' => __('Creation date'),
            'datatype' => 'datetime',
            'massiveaction' => false
        ];

        $tab[] = [
            'id' => '19',
            'table' => $this->getTable(),
            'field' => 'date_mod',
            'name' => __('Last update'),
            'datatype' => 'datetime',
            'massiveaction' => false
        ];

        $tab[] = [
            'id' => '5',
            'table' => $this->getTable(),
            'field' => 'percent_done',
            'name' => __('Percent done'),
            'datatype' => 'number',
            'unit' => '%',
            'min' => 0,
            'max' => 100,
            'step' => 5
        ];

        $tab[] = [
            'id' => '24',
            'table' => 'glpi_users',
            'field' => 'name',
            'linkfield' => 'users_id',
            'name' => __('Creator'),
            'datatype' => 'dropdown'
        ];

        $tab[] = [
            'id' => '7',
            'table' => $this->getTable(),
            'field' => 'plan_start_date',
            'name' => __('Planned start date'),
            'datatype' => 'datetime'
        ];

        $tab[] = [
            'id' => '8',
            'table' => $this->getTable(),
            'field' => 'plan_end_date',
            'name' => __('Planned end date'),
            'datatype' => 'datetime'
        ];

        $tab[] = [
            'id' => '9',
            'table' => $this->getTable(),
            'field' => 'real_start_date',
            'name' => __('Real start date'),
            'datatype' => 'datetime'
        ];

        $tab[] = [
            'id' => '10',
            'table' => $this->getTable(),
            'field' => 'real_end_date',
            'name' => __('Real end date'),
            'datatype' => 'datetime'
        ];

        $tab[] = [
            'id' => '11',
            'table' => $this->getTable(),
            'field' => 'planned_duration',
            'name' => __('Planned duration'),
            'datatype' => 'timestamp',
            'min' => 0,
            'max' => 100 * HOUR_TIMESTAMP,
            'step' => HOUR_TIMESTAMP,
            'addfirstminutes' => true,
            'inhours' => true
        ];

        $tab[] = [
            'id' => '17',
            'table' => $this->getTable(),
            'field' => 'effective_duration',
            'name' => __('Effective duration'),
            'datatype' => 'timestamp',
            'min' => 0,
            'max' => 100 * HOUR_TIMESTAMP,
            'step' => HOUR_TIMESTAMP,
            'addfirstminutes' => true,
            'inhours' => true
        ];

        $tab[] = [
            'id' => '16',
            'table' => $this->getTable(),
            'field' => 'comment',
            'name' => __('Comments'),
            'datatype' => 'text'
        ];

        $tab[] = [
            'id' => '18',
            'table' => $this->getTable(),
            'field' => 'is_milestone',
            'name' => __('Milestone'),
            'datatype' => 'bool'
        ];

        $tab[] = [
            'id' => '50',
            'table' => $this->getTable(),
            'field' => 'template_name',
            'name' => __('Template name'),
            'datatype' => 'text',
            'massiveaction' => false,
            'nosearch' => true,
            'nodisplay' => true,
        ];

        if ($this->isEntityAssign()) {
            $tab[] = [
                'id' => '4',
                'table' => 'glpi_entities',
                'field' => 'completename',
                'name' => Entity::getTypeName(1),
                'datatype' => 'dropdown',
                'massiveaction' => false,
                'nosearch' => true,
                'nodisplay' => true,
            ];
        }

        $tab[] = [
            'id' => '86',
            'table' => $this->getTable(),
            'field' => 'is_recursive',
            'name' => __('Child entities'),
            'datatype' => 'bool'
        ];
//        $caller = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 2)[1];
//        echo "Appelé par {$caller['function']} dans {$caller['file']} à la ligne {$caller['line']}";

		// afficher les tickets liés à chaque sous-projet
		// $tab = array_merge($tab, Ticket::rawSearchOptions());

        $tab[] = [
            'id'                 => '26',
            'table'              => ProjectTask_Ticket::getTable(),
            'field'              => 'tickets_id',
            'name'               => __('Tickets'),
            'datatype'           => 'specific',
            'forcegroupby'       => true,
            'splititems'         => true,
            'massiveaction'      => false,
            'htmltext'           => true,
            'joinparams'         => [
                'jointype'           => 'child',
            ]
        ];


//
//        $tab[] = [
//            'id'                 => '27',
//            'table'              => TicketTask::getTable(),
//            'field'              => 'id',
//            'name'               => __('Tâches'),
//            'datatype'           => 'specific',
//            'forcegroupby'       => true,
//            'splititems'         => true,
//            'massiveaction'      => false,
//            'htmltext'           => true,
//            'joinparams'         => [
//                'linkfield'          => 'tickets_id',
//                'jointype'           => 'child',
//                'table'         => Ticket::getTable()
//            ]
//        ];
//
        $tab = array_merge($tab, Notepad::rawSearchOptionsToAdd());

        return $tab;
    }



    /**
     * @since 0.85
     **/
    public static function rawSearchOptionsToAdd($itemtype = null)
    {

//        $caller = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 2)[1];
//        echo "Appelé par {$caller['function']} dans {$caller['file']} à la ligne {$caller['line']}";
        $task = new static();
        $tab = [];
        $name = _n('Task', 'Tasks', Session::getPluralNumber());

        $task_condition = '';
        if ($task->maybePrivate() && !Session::haveRight("task", CommonITILTask::SEEPRIVATE)) {
            $task_condition = [
                'OR' => [
                    'NEWTABLE.is_private'   => 0,
                    'NEWTABLE.users_id'     => Session::getLoginUserID()
                ]
            ];
        }


        $tab[] = [
            'id'                 => 'task',
            'name'               => $name
        ];

        $tab[] = [
            'id'                 => '26',
            'table'              => static::getTable(),
            'field'              => 'content',
            'name'               => __('Description'),
            'datatype'           => 'text',
            'forcegroupby'       => true,
            'splititems'         => true,
            'massiveaction'      => false,
            'htmltext'           => true,
            'joinparams'         => [
                'jointype'           => 'child',
                'condition'          => $task_condition,
            ]
        ];

        $tab[] = [
            'id'                 => '28',
            'table'              => static::getTable(),
            'field'              => 'id',
            'name'               => _x('quantity', 'Number of tasks'),
            'forcegroupby'       => true,
            'usehaving'          => true,
            'datatype'           => 'count',
            'massiveaction'      => false,
            'joinparams'         => [
                'jointype'           => 'child',
                'condition'          => $task_condition,
            ]
        ];

        $tab[] = [
            'id'                 => '20',
            'table'              => 'glpi_taskcategories',
            'field'              => 'name',
            'datatype'           => 'dropdown',
            'name'               => _n('Category', 'Categories', 1),
            'forcegroupby'       => true,
            'splititems'         => true,
            'massiveaction'      => false,
            'joinparams'         => [
                'beforejoin'         => [
                    'table'              => static::getTable(),
                    'joinparams'         => [
                        'jointype'           => 'child',
                        'condition'          => $task_condition,
                    ]
                ]
            ]
        ];

        if ($task->maybePrivate()) {
            $tab[] = [
                'id'                 => '92',
                'table'              => static::getTable(),
                'field'              => 'is_private',
                'name'               => __('Private task'),
                'datatype'           => 'bool',
                'forcegroupby'       => true,
                'splititems'         => true,
                'massiveaction'      => false,
                'joinparams'         => [
                    'jointype'           => 'child',
                    'condition'          => $task_condition,
                ]
            ];
        }

        $tab[] = [
            'id'                 => '94',
            'table'              => 'glpi_users',
            'field'              => 'name',
            'name'               => __('Writer'),
            'datatype'           => 'itemlink',
            'right'              => 'all',
            'forcegroupby'       => true,
            'massiveaction'      => false,
            'joinparams'         => [
                'beforejoin'         => [
                    'table'              => static::getTable(),
                    'joinparams'         => [
                        'jointype'           => 'child',
                        'condition'          => $task_condition,
                    ]
                ]
            ]
        ];

        $tab[] = [
            'id'                 => '95',
            'table'              => 'glpi_users',
            'field'              => 'name',
            'linkfield'          => 'users_id_tech',
            'name'               => __('Technician in charge'),
            'datatype'           => 'itemlink',
            'right'              => 'own_ticket',
            'forcegroupby'       => true,
            'massiveaction'      => false,
            'joinparams'         => [
                'beforejoin'         => [
                    'table'              => static::getTable(),
                    'joinparams'         => [
                        'jointype'           => 'child',
                        'condition'          => $task_condition,
                    ]
                ]
            ]
        ];

        $tab[] = [
            'id'                 => '112',
            'table'              => 'glpi_groups',
            'field'              => 'completename',
            'linkfield'          => 'groups_id_tech',
            'name'               => __('Group in charge'),
            'datatype'           => 'itemlink',
            'condition'          => ['is_task' => 1],
            'forcegroupby'       => true,
            'massiveaction'      => false,
            'joinparams'         => [
                'beforejoin'         => [
                    'table'              => static::getTable(),
                    'joinparams'         => [
                        'jointype'           => 'child',
                        'condition'          => $task_condition,
                    ]
                ]
            ]
        ];

        $tab[] = [
            'id'                 => '96',
            'table'              => static::getTable(),
            'field'              => 'actiontime',
            'name'               => __('Duration'),
            'datatype'           => 'timestamp',
            'massiveaction'      => false,
            'forcegroupby'       => true,
            'joinparams'         => [
                'jointype'           => 'child',
                'condition'          => $task_condition,
            ]
        ];

        $tab[] = [
            'id'                 => '97',
            'table'              => static::getTable(),
            'field'              => 'date',
            'name'               => _n('Date', 'Dates', 1),
            'datatype'           => 'datetime',
            'massiveaction'      => false,
            'forcegroupby'       => true,
            'joinparams'         => [
                'jointype'           => 'child',
                'condition'          => $task_condition,
            ]
        ];

        $tab[] = [
            'id'                 => '33',
            'table'              => static::getTable(),
            'field'              => 'state',
            'name'               => __('Status'),
            'datatype'           => 'specific',
            'searchtype'         => 'equals',
            'searchequalsonfield' => true,
            'massiveaction'      => false,
            'forcegroupby'       => true,
            'joinparams'         => [
                'jointype'           => 'child',
                'condition'          => $task_condition,
            ]
        ];

        $tab[] = [
            'id'                 => '173',
            'table'              => static::getTable(),
            'field'              => 'begin',
            'name'               => __('Begin date'),
            'datatype'           => 'datetime',
            'maybefuture'        => true,
            'massiveaction'      => false,
            'forcegroupby'       => true,
            'joinparams'         => [
                'jointype'           => 'child',
                'condition'          => $task_condition,
            ]
        ];

        $tab[] = [
            'id'                 => '174',
            'table'              => static::getTable(),
            'field'              => 'end',
            'name'               => __('End date'),
            'datatype'           => 'datetime',
            'maybefuture'        => true,
            'massiveaction'      => false,
            'forcegroupby'       => true,
            'joinparams'         => [
                'jointype'           => 'child',
                'condition'          => $task_condition,
            ]
        ];

        $tab[] = [
            'id'                 => '175',
            'table'              => TaskTemplate::getTable(),
            'field'              => 'name',
            'linkfield'          => 'tasktemplates_id',
            'name'               => TaskTemplate::getTypeName(1),
            'datatype'           => 'dropdown',
            'massiveaction'      => false,
            'joinparams'         => [
                'beforejoin'         => [
                    'table'              => static::getTable(),
                    'joinparams'         => [
                        'jointype'           => 'child',
                        'condition'          => $task_condition,
                    ]
                ]
            ]
        ];

        return $tab;
    }

    public function defineTabs($options = [])
    {
        $ong = [];
        $ong = array();
        //add main tab for current object
        $this->addDefaultFormTab($ong)
            ->addStandardTab('ManualLink', $ong, $options)
            ->addStandardTab(PluginDlteamsTicket_Item::class, $ong, $options)
            ->addStandardTab('KnowbaseItem_Item', $ong, $options)
            ->addImpactTab($ong, $options)
            ->addStandardTab('Notepad', $ong, $options)
            ->addStandardTab('Log', $ong, $options);
        return $ong;
    }
    /*
       function exportToDB($subItems = [])
       {
          if ($this->isNewItem()) {
             return false;
          }

          $export = $this->fields;
          return $export;
       }

        public static function importToDB(PluginDlteamsLinker $linker, $input = [], $containerId = 0, $subItems = [])
       {
          $item = new self();
          $originalId = $input['id'];
          unset($input['id']);
          $input['entities_id']= $_POST['entities_id'];;
          $input['comment']=str_replace(['\'', '"'], "", $input['comment']);
          $input['name']=str_replace(['\'', '"'], "", $input['name']);
          $input['content']=str_replace(['\'', '"'], "", $input['content']);
          $itemId = $item->add($input);
          if ($itemId === false) {
             $typeName = strtolower(self::getTypeName());
             throw new ImportFailureException(sprintf(__('failed to copy the %1$s record', 'dlteams'), $input['name']));
          }
          return $itemId;
       }

        public function deleteObsoleteItems(CommonDBTM $container, array $exclude)
       {
       }
    */

}
