<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */


use GlpiPlugin\dlteams\Exception\ImportFailureException;

class PluginDlteamsTicketTask_Planning extends CommonDBTM
{
    static public $itemtype_2 = PluginDlteamsTicketTask::class;

    public function __construct()
    {
        parent::__construct();
        self::forceTable(TicketTask::getTable());
    }

    static function canCreate()
    {
        return true;
    }

    static function canView()
    {
        return true;
    }

    static function canUpdate()
    {
        return true;
    }

    static function canDelete()
    {
        return true;
    }

    static function canPurge()
    {
        return true;
    }

    function canCreateItem()
    {
        return true;
    }

    function canViewItem()
    {
        return true;
    }

    function canUpdateItem()
    {
        return true;
    }

    function canDeleteItem()
    {
        return true;
    }

    function canPurgeItem()
    {
        return true;
    }


    static function getTypeName($nb = 0)
    {
        return __("Planifications", 'dlteams');
    }

    // affichage de l'onglet et de son nom
    public function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {
        switch ($item->getType()) {
            case static::$itemtype_2:
                // var_dump(Session::haveRight($item::$rightname, READ));
                // if (Session::haveRight($item::$rightname, READ)) {
                $nb = 0;
//                if ($item->fields["begin"]) $nb++;
                if ($_SESSION['glpishow_count_on_tabs']) {
                    $items = self::getItemsRequest($item);
                    $items_todo = count(self::getItemsRequest($item)) - count(self::getItemsRequest($item, true));

//                    if ($item->fields["state"] == Planning::TODO)
//                        $items_todo++;

                    $nb = $nb + count($items);

                    return static::createTabEntry(static::getTypeName(), "$items_todo / $nb");
                }
                return static::getTypeName();
                // }
                break;
        }

        return '';
    }

    // comptage du nombre de liaison entre les 2 objets dans la table de l'objet courant
    static function countForItem(CommonDBTM $item)
    {
        $dbu = new DbUtils();
        return $dbu->countElementsInTable(static::getTable(), ['tickettasks_id' => $item->getID()]);
    }

    public static function getItemsRequest(CommonDBTM $object_item, $todo = false)
    {
        global $DB;
        $link_table = str_replace("_Item", "", __CLASS__);
        $temp = new $link_table();

        $items = $DB->request([
            'FROM' => self::getTable(),
            'SELECT' => [
                TicketTask::getTable() . '.id',
                TicketTask::getTable() . '.*',
                TicketTask::getTable() . '.id as linkid',
            ],
            'OR' => [
                [
                    TicketTask::getTable() . '.tickettasks_id' => $object_item->fields['id']
                ] + ($todo ? [TicketTask::getTable() . '.state' => Planning::TODO] : []),
                [
                    TicketTask::getTable() . '.id' => $object_item->fields['id']
                ] + ($todo ? [TicketTask::getTable() . '.state' => Planning::TODO] : []),

            ],
            'ORDER' => TicketTask::getTable() . '.begin DESC'
        ]);

        return iterator_to_array($items);
    }

    public function update(array $input, $history = 1, $options = [])
    {
        if (isset($input["plugin_dlteams_protectivemeasures_id"]))
            $input["protectivemeasures_id"] = $input["plugin_dlteams_protectivemeasures_id"];

        /*        highlight_string("<?php\n\$data =\n" . var_export($input, true) . ";\n?>");*/
        //        die();
        parent::update($input, $history, $options);
        return true;
    }

    public function defineTabs($options = [])
    {
        $ong = [];
        $this->addDefaultFormTab($ong);
        $this->addImpactTab($ong, $options);
        return $ong;
    }

    public static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {
        switch ($item->getType()) {
            case static::$itemtype_2:
                self::showItems($item);
                break;
        }
    }

    /**
     * Show items links to a document
     *
     * @param $doc Document object
     *
     * @return void
     **@since 0.84
     *
     */
    public static function showItems(PluginDlteamsTicketTask $object_item)
    {

        if (!$object_item->fields["tickettasks_id"]) {
            echo "<button name='add_tickettask_plannification' id='add_tickettask_plannification' style='width: fit-content;' class='btn btn-primary add_tickettask_plannification'>" .
                _x('button', 'Ajouter planification') . "</button>";
            // echo "</div>";


            echo "<script>";
            $queryString = http_build_query([
                "itemtype" => TicketTask::class,
                "items_id" => $object_item->fields["id"],
                "action" => "add"
            ]);

            echo "
        const observer = new MutationObserver((mutations) => {
        
        
        $('.add_tickettask_plannification').off('click').click(function(e){
                        e.preventDefault();
                        
                        var modalId = glpi_ajax_dialog({
                            dialogclass: 'modal-lg',
                            bs_focus: false,
                            url: '/marketplace/dlteams/ajax/tickettask_plannif.php?" . $queryString . "',
                            title: i18n.textdomain('dlteams').__('Ajouter une planification', 'dlteams'),
                            close: function () {
            
                            },
                            fail: function () {
                                // displayAjaxMessageAfterRedirect();
                            }
                        });
                    });
                    
                    
                    
             $('#subtaskplanplanif').off('click').click(function(e){
                       e.preventDefault();
                                              
                                    $('#subtaskviewplanPlanif').load('/ajax/planning.php', {
                                        action: 'add_event_classic_form',
                                        form: 'followups',
                                        entity: " . Session::getActiveEntity() . ",
                                        itemtype: '" . TicketTask::class . "',
                                        items_id: '" . $object_item->fields["id"] . "'
                                    });
                                    $(this).hide();
                   });
                   
                   
               
                   
        });
        
        // Configuration de l'observateur : surveiller l'ajout et la suppression d'éléments, ainsi que les changements d'attribut
        const config = {
            childList: true,
            attributes: true,
            subtree: true // Observer les mutations sur des descendants également
        };
        
        // Commencer l'observation sur l'élément body pour couvrir tout le DOM
        observer.observe(document.body, config);
        ";
            echo "</script>";
        }

        $items = self::getItemsRequest($object_item);
        if (!count($items) && !$object_item->fields["begin"]) {
            echo "<table class='tab_cadre_fixe'><tr><th>" . __('No item found') . "</th></tr>";
            echo "</table>";
        } else {
            echo "<table class='tab_cadre_fixehov'>";
            echo static::generateTableHeader();

            // Première planification
//            echo static::generateTableRow([...$object_item->fields, "linkid" => $object_item->fields["id"]]);

// Boucle sur les éléments
            foreach ($items as $row) {
                echo static::generateTableRow($row);
            }

            echo "</table>";

// Script pour les actions
            echo "
            <script>
                $('.editma').off('click').click(function(e) {
                    glpi_ajax_dialog({
                        dialogclass: 'modal-lg',
                        bs_focus: false,
                        url: '/marketplace/dlteams/ajax/tickettask_plannif.php',
                        params: {
                            action: 'edit_tickettask_planif',
                            linkid: $(this).data('id'),
                            action: 'update',
                        },
                        title: i18n.textdomain('dlteams').__('Modifier une planification', 'dlteams'),
                        close: function () {},
                        fail: function () {
                            displayAjaxMessageAfterRedirect();
                        }
                    });
                });
            </script>";
        }
    }


    public static function generateTableHeader($showTicket = false)
    {
        $columns = [
            "",
            __("Id"),
            __("Statut"),
            __("Planifié le"),
            __("Durée planif"),
            __("Acteur"),
            __("Groupe"),
            __("Echéance"),
            __("Durée prévue"),
        ];

        if ($showTicket) {
            // à l’index 2, ne rien supprimer (0) et y insérer __("Ticket")
            array_splice($columns, 2, 0, __("Ticket"));
        }

        $header = "<tr>";
        foreach ($columns as $column) {
            $header .= "<th>" . $column . "</th>";
        }
        $header .= "</tr>";

        return $header;
    }

// Fonction pour générer une cellule d'utilisateur ou de groupe
    static function generateLinkedCell($type, $id, $fallback = "--")
    {
        $object = $type === "user" ? new User() : new Group();
        $object->getFromDB($id);
        $nameField = $type === "user" ? $object->getName() : ($object->fields["name"] ?? $fallback);
        $url = $type === "user" ? User::getFormURLWithID($id) : Group::getFormURLWithID($id);

        return isset($nameField) ? "<a target='_blank' href=\"$url\">$nameField</a>" : $fallback;
    }

// Fonction pour générer une ligne du tableau
    public static function generateTableRow($row, $showTicket = false)
    {
        $linkid = $row["linkid"] ?? $row["linkid"];
        $id = "<a target='_blank' href='".PluginDlteamsTicketTask::getFormURLWithID($row["id"])."'>" . $row["id"] ?? $row->getID() . "</a>";

        // Préparer les données nécessaires
        $userLink = static::generateLinkedCell("user", $row["users_id_tech"] ?? $row->fields["users_id_tech"]);
        $groupLink = static::generateLinkedCell("group", $row["groups_id_tech"] ?? $row->fields["groups_id_tech"]);
        $statusIcon = Planning::getStatusIcon($row["state"] ?? $row->fields["state"]);

        // Formatter la date
        $formatter = new IntlDateFormatter('fr_FR', IntlDateFormatter::FULL, IntlDateFormatter::NONE);
        $formatter->setPattern('EEE dd-MM-yyyy HH:mm');

        $date = $formatter->format(new DateTime($row["date"] ?? $row->fields["date"] ?? ""));
        $begin = $formatter->format(new DateTime($row["begin"] ?? $row->fields["begin"] ?? ""));

        $estimatedTime = PluginDlteamsToolbox::timestampToString($row["estimate_duration"] ?? $row->fields["estimate_duration"], false, false);
        $actionTime = PluginDlteamsToolbox::timestampToString($row["actiontime"] ?? $row->fields["actiontime"], false, false);

        $tickets_id = $row["tickets_id"];

        // Générer la ligne
        $row  = "<tr class='tab_bg_1'>";
        $row .= "    <td width='15'><i class='fa fa-edit editma' style='cursor:pointer;' data-id='{$linkid}'></i></td>";
        $row .= "    <td>{$id}</td>";

//  ⇨ Si on affiche le ticket, on l’ajoute à cet endroit
        if ($showTicket) {
            $row .= "    <td>{$tickets_id}</td>";
        }

        $row .= "    <td>{$statusIcon}</td>";
        $row .= "    <td>{$begin}</td>";
        $row .= "    <td>{$actionTime}</td>";
        $row .= "    <td>{$userLink}</td>";
        $row .= "    <td>{$groupLink}</td>";
        $row .= "    <td>{$date}</td>";
        $row .= "    <td>{$estimatedTime}</td>";
        $row .= "</tr>";

        return $row;
    }

    public static function convertirTemps($tempsEnSecondes)
    {
        if ($tempsEnSecondes && is_integer($tempsEnSecondes)) {
            $heures = floor($tempsEnSecondes / 3600);
            $minutes = floor(($tempsEnSecondes % 3600) / 60);
            $secondes = $tempsEnSecondes % 60;

            return sprintf("%02d:%02d:%02d", $heures, $minutes, $secondes);
        }
        return "";
    }


    public function getForbiddenStandardMassiveAction()
    {
        $forbidden = parent::getForbiddenStandardMassiveAction();
        $forbidden[] = 'clone';
//        $forbidden[] = 'MassiveAction:update';
        $forbidden[] = 'MassiveAction:add_transfer_list';
        $forbidden[] = 'MassiveAction:amend_comment';
        return $forbidden;
    }

}
