<?php

/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2025 Teclib' and contributors.
 * @copyright 2003-2014 by the INDEPNET Development Team.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */

/**
 * @since 0.84
 */

use Glpi\Event;

include('../inc/includes.php');

Session::checkCentralAccess();

$group_user = new Group_User();



if (isset($_POST["add"])) {
    $group_user->check(-1, CREATE, $_POST);
    if ($group_user->add($_POST)) {
        Event::log(
            $_POST["groups_id"],
            "groups",
            4,
            "setup",
            //TRANS: %s is the user login
            sprintf(__('%s adds a user to a group'), $_SESSION["glpiname"])
        );
    }
    Html::back();
}

//fork dlteams
elseif (isset($_POST["add_group_user"])) {
//    $group_user->check(-1, CREATE, $_POST);

    // Vérifier que les champs obligatoires sont présents
    if (!isset($_POST['users_id']) || !isset($_POST['groups_id'])) {
        Session::addMessageAfterRedirect(__('Données manquantes pour l\'attribution du groupe'), false, ERROR);
        Html::back();
    }

    // Vérifier si l'utilisateur n'est pas déjà dans ce groupe
    $existing = $group_user->find([
        'users_id' => $_POST['users_id'],
        'groups_id' => $_POST['groups_id']
    ]);

    if (!empty($existing)) {
        Session::addMessageAfterRedirect(__('L\'utilisateur appartient déjà à ce groupe'), false, WARNING);
        Html::back();
    }

    // Préparer les données avec les valeurs par défaut
    $input = $_POST;
    $input['is_dynamic'] = isset($_POST['is_dynamic']) ? $_POST['is_dynamic'] : 0;
    $input['is_manager'] = isset($_POST['is_manager']) ? $_POST['is_manager'] : 0;
    $input['is_userdelegate'] = isset($_POST['is_userdelegate']) ? $_POST['is_userdelegate'] : 0;

    if ($group_user->add($input)) {
        // Récupérer les noms pour le log
        $user = new User();
        $group = new Group();
        $user->getFromDB($_POST['users_id']);
        $group->getFromDB($_POST['groups_id']);

        Event::log(
            $_POST["groups_id"],
            "groups",
            4,
            "setup",
            //TRANS: %1$s is the user login, %2$s is the user name, %3$s is the group name
            sprintf(__('%1$s adds user %2$s to group %3$s'),
                $_SESSION["glpiname"],
                $user->getName(),
                $group->getName()
            )
        );

        Session::addMessageAfterRedirect(__('Utilisateur ajouté au groupe avec succès'), false, INFO);
    } else {
        Session::addMessageAfterRedirect(__('Erreur lors de l\'ajout de l\'utilisateur au groupe'), false, ERROR);
    }

    Html::back();
}

// Traitement pour la suppression (si nécessaire)
if (isset($_POST["delete"]) || isset($_POST["purge"])) {
    $group_user->check($_POST['id'], DELETE);

    if ($group_user->delete($_POST)) {
        Event::log(
            $_POST["groups_id"] ?? 0,
            "groups",
            4,
            "setup",
            sprintf(__('%s removes a user from a group'), $_SESSION["glpiname"])
        );
        Session::addMessageAfterRedirect(__('Utilisateur retiré du groupe avec succès'), false, INFO);
    } else {
        Session::addMessageAfterRedirect(__('Erreur lors de la suppression'), false, ERROR);
    }

    Html::back();
}

Html::displayErrorAndDie("lost");
