<?php
/**
-------------------------------------------------------------------------
LICENSE

This file is part of Reports plugin for GLPI.

Reports is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Reports is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with Reports. If not, see <http://www.gnu.org/licenses/>.

@package   reports
@authors   Nelly Mahu-Lasson, Remi Collet
@copyright Copyright (c) 2009-2022 Reports plugin team
@license   AGPL License 3.0 or (at your option) any later version
http://www.gnu.org/licenses/agpl-3.0-standalone.html
@link      https://forge.glpi-project.org/projects/reports
@link      http://www.glpi-project.org/
@since     2009
--------------------------------------------------------------------------
 */

$USEDBREPLICATE        = 1;
$DBCONNECTION_REQUIRED = 0; // not really a big SQL request

include ("../../../../inc/includes.php");

$dbu = new DbUtils();

// TRANS: The name of the report = Location tree
$report = new PluginReportsAutoReport(__('Liste des catalogues (racine)', 'dlteams'));

// Display criterias form if needed
$report->displayCriteriasForm();

$colonnes = [
    new PluginReportsColumn('completename', __('Nom complet'), ['sorton' => 'completename']),
    new PluginReportsColumn('manage_accountkey', __('Est Annuaire'), ['sorton' => 'manage_accountkey']),
    new PluginReportsColumn('datatype', __('Type de données'), ['sorton' => 'catalogclassifications']),
    new PluginReportsColumn('catalogclassifications', __('Information classification'), ['sorton' => 'catalogclassifications']),
    // Vérifiez si cette colonne dupliquée est souhaitée
    new PluginReportsColumn('catalogclassifications', __('Information classification'), ['sorton' => 'catalogclassifications']),
    new PluginReportsColumn('content', __('Contenu'), ['sorton' => 'content']),
];

$report->setColumns($colonnes);

// Construction de la requête SQL
$query = "SELECT t1.`name` AS name,
                 t1.`content` AS content,
                 t1.`completename` AS completename,
                 `glpi_plugin_dlteams_datacarriercategories`.`name` AS datatype,
                 `glpi_plugin_dlteams_catalogclassifications`.`name` AS catalogclassifications,
                 CASE 
                    WHEN t1.`manage_accountkey` = 1 THEN 'Oui'
                    ELSE 'non'
                 END AS manage_accountkey
          FROM `glpi_plugin_dlteams_datacatalogs` AS t1
          LEFT JOIN `glpi_plugin_dlteams_datacarriercategories` ON (t1.`plugin_dlteams_datacarriercategories_id` = `glpi_plugin_dlteams_datacarriercategories`.`id`)
          LEFT JOIN `glpi_plugin_dlteams_catalogclassifications` ON (t1.`plugin_dlteams_catalogclassifications_id` = `glpi_plugin_dlteams_catalogclassifications`.`id`)
          " .
    $dbu->getEntitiesRestrictRequest(" WHERE ", "t1") .
    " AND t1.`is_deleted` = 0 " .

$report->getOrderBy('completename');

$report->setGroupBy('completename');
$report->setSqlRequest($query);
$report->execute();
