<?php
/**
-------------------------------------------------------------------------
LICENSE

This file is part of Reports plugin for GLPI.

Reports is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Reports is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with Reports. If not, see <http://www.gnu.org/licenses/>.

@package   reports
@authors    Nelly Mahu-Lasson, Remi Collet
@copyright Copyright (c) 2009-2022 Reports plugin team
@license   AGPL License 3.0 or (at your option) any later version
http://www.gnu.org/licenses/agpl-3.0-standalone.html
@link      https://forge.glpi-project.org/projects/reports
@link      http://www.glpi-project.org/
@since     2009
--------------------------------------------------------------------------
 */

$USEDBREPLICATE        = 1;
$DBCONNECTION_REQUIRED = 0; // not really a big SQL request

include ("../../../../inc/includes.php");

$dbu = new DbUtils();


//if(isset($_POST["publish_dlteams"])){
//
//}
/*highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//die();
//TRANS: The name of the report = Location tree
$report = new PluginReportsAutoReport(__('Acteurs des traitements', 'dlteams'));

//Display criterias form is needed
$report->displayCriteriasForm();


$report->setColumns([
    new PluginReportsColumn('group_name', __('Acteurs interne'), ['sorton' => 'group_name']),
    new PluginReportsColumn('completenumber', __('Num'), ['sorton' => 'completenumber']),
    new PluginReportsColumn('record_name', __('Traitement'), ['sorton' => 'record_name']),
//    new PluginReportsColumn('entity', __('Entité'), ['sorton' => 'entity']),
]);


// SQL statement
$query = "SELECT `glpi_plugin_dlteams_records_items`.`id` AS `linkid`, 
`glpi_plugin_dlteams_records_items`.`itemtype` AS `itemtype`, 
`glpi_plugin_dlteams_records_items`.`items_id` AS `items_id`, 
`glpi_plugin_dlteams_records`.`name` AS `record_name`,
`glpi_plugin_dlteams_records`.`completenumber` AS `completenumber`,
`glpi_groups`.`name` AS `group_name`

FROM `glpi_plugin_dlteams_records_items` 
LEFT JOIN `glpi_plugin_dlteams_records` ON (`glpi_plugin_dlteams_records_items`.`records_id` = `glpi_plugin_dlteams_records`.`id`)
LEFT JOIN `glpi_groups` ON (`glpi_plugin_dlteams_records_items`.`records_id` = `glpi_groups`.`id`)
LEFT JOIN `glpi_entities` ON (`glpi_plugin_dlteams_records`.`entities_id` = `glpi_entities`.`id`)
WHERE (
    (`glpi_plugin_dlteams_records_items`.`itemtype` = 'Group' AND `glpi_plugin_dlteams_records_items`.`itemtype1` IS NULL) 
  )
AND glpi_plugin_dlteams_records.`is_deleted` = 0 " .
    $dbu->getEntitiesRestrictRequest(" AND ", "glpi_plugin_dlteams_records") .
    $report->getOrderBy('completenumber');

$report->setGroupBy(['completenumber']);
//$report->setGroupBy('registration_number');
//$report->setGroupBy('completenumber')s;
$report->setSqlRequest($query);
//var_dump("zzzsss");
//die();
error_reporting(0);
ini_set('display_errors', 0);
$report->execute();