<?php
/**
 * Script utilitaire pour ajouter les méthodes showCentralList aux classes dlteams
 */

$classes_to_update = [
    'PluginDlteamsSupplierCategory' => 'suppliercategory',
    'PluginDlteamsAppliance' => 'appliance', 
    'PluginDlteamsAccountKey' => 'accountkey',
    'PluginDlteamsPhysicalAccess' => 'physicalaccess',
    'PluginDlteamsProtectiveMeasure' => 'protectivemeasure',
    'PluginDlteamsRiskAssessment' => 'riskassessment'
];

function generateShowCentralListMethod($className, $rightName) {
    return '
    /**
     * Display ' . strtolower(str_replace('PluginDlteams', '', $className)) . ' in central view
     *
     * @param integer $start
     * @param string  $status
     * @param boolean $showgrouptickets
     *
     * @return void
     */
    public static function showCentralList($start = 0, $status = \'process\', $showgrouptickets = true)
    {
        global $DB;

        if (!Session::haveRight(\'plugin_dlteams_' . $rightName . '\', READ)) {
            return false;
        }

        $iterator = $DB->request([
            \'FROM\' => self::getTable(),
            \'WHERE\' => [
                \'entities_id\' => Session::getActiveEntity()
            ],
            \'ORDER\' => [\'date_mod DESC\'],
            \'LIMIT\' => $_SESSION[\'glpidisplay_count_on_home\'] ?? 10
        ]);

        $total_row_count = count($iterator);
        $displayed_row_count = min((int)$_SESSION[\'glpidisplay_count_on_home\'], $total_row_count);

        if ($total_row_count > 0) {
            echo "<div class=\'table-responsive\'>";
            echo "<table class=\'table table-hover card-table\'>";
            echo "<thead>";
            echo "<tr>";
            echo "<th>" . __("ID") . "</th>";
            echo "<th>" . __("Name") . "</th>";
            echo "<th>" . __("Date modification") . "</th>";
            echo "</tr>";
            echo "</thead>";
            echo "<tbody>";

            foreach ($iterator as $data) {
                $url = self::getFormURLWithID($data[\'id\']);
                echo "<tr>";
                echo "<td><a href=\'" . $url . "\' class=\'btn btn-sm btn-outline-primary\'>" . $data[\'id\'] . "</a></td>";
                echo "<td>" . htmlspecialchars($data[\'name\']) . "</td>";
                echo "<td class=\'text-muted\'>" . Html::convDateTime($data[\'date_mod\']) . "</td>";
                echo "</tr>";
            }

            echo "</tbody>";
            echo "</table>";
            echo "</div>";

            if ($total_row_count > $displayed_row_count) {
                echo "<div class=\'text-center mt-2\'>";
                echo "<a href=\'" . self::getSearchURL() . "\' class=\'btn btn-sm btn-outline-secondary\'>";
                echo sprintf(__("Show all %d items"), $total_row_count);
                echo "</a>";
                echo "</div>";
            }
        } else {
            echo "<div class=\'text-center text-muted p-4\'>";
            echo "<i class=\'fas fa-inbox fa-2x mb-2\'></i><br>";
            echo __("No item found");
            echo "</div>";
        }
    }
';
}

echo "Méthodes showCentralList générées :\n\n";

foreach ($classes_to_update as $className => $rightName) {
    echo "=== $className ===\n";
    echo generateShowCentralListMethod($className, $rightName);
    echo "\n\n";
} 