<?php

include_once('../../../inc/includes.php');
$cols = 100;
$rows = 60;

$dc = new PluginDlteamsDeliverable_Content();
$contentid = $_POST["content_id"];
$dc->getFromDB($contentid);
$rand = mt_rand();

// Obtenir la liste des contenus et réindexer les clés
$contents = PluginDlteamsDeliverable_Section::getDeliverableContents($dc->fields['deliverable_sections_id']);
$contentArray = array_values(iterator_to_array($contents)); // Réindexation des clés

// Obtenez l'index actuel dans la liste réindexée
$currentIndexParagraph = null;
foreach ($contentArray as $index => $content) {
    if ($content['id'] == $_POST['content_id']) {
        $currentIndexParagraph = $index;
        break;
    }
}

// Déterminer s'il y a un paragraphe suivant ou précédent
$hasPreviousParagraph = $currentIndexParagraph > 0;
$hasNextParagraph = $currentIndexParagraph < count($contentArray) - 1;


$currentsection = new PluginDlteamsDeliverable_Section();
$currentsection->getFromDB($dc->fields['deliverable_sections_id']);
global $DB;
$sections = $DB->request(PluginDlteamsDeliverable_Section::getTable(), ['ORDER' => ['timeline_position ASC'], 'deliverables_id' => $currentsection->fields["deliverables_id"]]);
$sectionsArray = array_values(iterator_to_array($sections)); // Réindexation des clés

$currentIndexSection = null;
$currentsectionPosition = 0;
foreach ($sectionsArray as $indexSection => $section) {
    if ($section['id'] == $currentsection->fields["id"]) {
        $currentIndexSection = $indexSection;
        break;
    } else
        $currentsectionPosition++;
}


// Déterminer s'il y a une section suivante ou précédente
$hasPreviousSection = $currentIndexSection > 0;
$hasNextSection = $currentIndexSection < count($sectionsArray) - 1;
$previousSection = null;
$nextSection = null;
$nextSectionFirstParagraph = null;
$previousSectionLastParagraph = null;

if (!$hasPreviousParagraph && $hasPreviousSection)
    $previousSection = $sectionsArray[$currentIndexSection - 1];
if (!$hasNextParagraph && $hasNextSection)
    $nextSection = $sectionsArray[$currentIndexSection + 1];

if ($nextSection) {
    $nextSection_allparagraph = iterator_to_array(PluginDlteamsDeliverable_Section::getDeliverableContents($nextSection['id']), false);
    if (count($nextSection_allparagraph) > 0)
        $nextSectionFirstParagraph = $nextSection_allparagraph[0];
}

if ($previousSection) {
    $previousSection_allparagraph = iterator_to_array(PluginDlteamsDeliverable_Section::getDeliverableContents($previousSection['id']), false);
    if (count($previousSection_allparagraph) > 0)
        $previousSectionLastParagraph = $previousSection_allparagraph[count($previousSection_allparagraph) - 1];
}

echo "<form name='deliverable_form$rand' id='update_deliverablecontent_form$rand' method='post'>";
echo "<div class='row flex-column'>";

echo "<div id='error-message' style='display: none; color: red; font-weight: bold; margin-top: 10px;'></div>";

echo "<input type='hidden' name='id_field' value='" . $dc->fields['id'] . "'>
      <div class='form-field col-12  mb-2'>
         <label class='col-form-label ' for=''>Titre</label>
         <div class='field-container'>
             <input type='text' class='form-control' required name='name' value='" . htmlspecialchars($dc->fields['name']) . "' maxlength='255'>
         </div>
     </div>

     <div class='form-field col-12 col-12 itil-textarea-content mb-2'>
         <label class='col-form-label'>Commentaire</label>
         <div class='field-container'>
             <textarea class='form-control' name='comment' rows='3' style='width: 100%;' aria-hidden='true'>" . $dc->fields['comment'] . "</textarea>
         </div>
     </div>

     <div class='form-field col-12 col-12 itil-textarea-content mb-2'>
         <label class='col-form-label'>Contenu</label>
         <div class='field-container'>";
$cols = 100;
$rows = 60;
Html::textarea(['name' => 'content',
    'value' => $dc->fields['content'],
    'enable_fileupload' => false,
    'enable_richtext' => true,
    'cols' => $cols,
    'rows' => $rows
]);
echo "</div>" .
    "</div>" .
    "</div>";

// Affichage des boutons "Précédent" et "Suivant" si nécessaire
echo "<div style='display: flex; justify-content: space-between; align-items: center; padding: 20px; background-color: white; box-shadow: #0a0a0a;'>";
echo "<div style='display: flex; gap: 10px; align-items: center;'>";
if ($hasPreviousParagraph) {
    echo "<button class='btn-navigation' type='button' onclick='navigateToParagraph(" . $contentArray[$currentIndexParagraph - 1]['id'] . ")'>← Précédent</button>";
}
if ($hasNextParagraph) {
    echo "<button class='btn-navigation' type='button' onclick='navigateToParagraph(" . $contentArray[$currentIndexParagraph + 1]['id'] . ")'>Suivant →</button>";
}

if (!$hasNextParagraph && $hasNextSection && $nextSectionFirstParagraph)
    echo "<button class='btn-navigation' type='button' onclick='navigateToParagraph(" . $nextSectionFirstParagraph["id"] . ")'>Chapitre Suivant >></button>";

if (!$hasPreviousParagraph && $hasPreviousSection && $previousSectionLastParagraph)
    echo "<button class='btn-navigation' type='button' onclick='navigateToParagraph(" . $previousSectionLastParagraph["id"] . ")'><< Chapitre Pécédent</button>";


echo "<button data-bs-toggle='tooltip' data-bs-placement='top' title='Enrégistrer' class='btn-enregistrer' type='button' onclick='saveForm(true, false, this)'>
        <i class='fa fa-save'></i>
     </button>";
// Conteneur pour le statut
echo "Dernière mise à jour: <span id='save-status' style='margin-left: 10px; font-size: 14px; color: #666;'>" . Html::timestampToRelativeStr($dc->fields["date_mod"]) . "</span>";
echo "</div>";
echo "<button data-bs-toggle='tooltip' data-bs-placement='top' title='Enrégistrer et fermer' class='btn-enregistrer' type='button' onclick='saveForm(true, true, this)'>Fermer</button>";
echo "</div>";

Html::closeForm();

echo "<style>
        .btn-navigation {
            border: 2px solid #ffcc00;
            background-color: transparent;
            padding: 5px 10px;
            color: black;
            font-weight: bold;
        }
        .btn-enregistrer {
            background-color: #ffcc00;
            padding: 5px 10px;
            font-weight: bold;
            border: none;
            color: black;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .btn-enregistrer i {
            margin-right: 5px;
        }
      </style>";

echo "<script>

console.log('$rand');
        window.statusIntervalId = [];
        window.autoSaveIntervalId = [];
        window.statusIntervalId[$rand] = null;
        window.autoSaveIntervalId[$rand] = null;

        function saveForm(isManual = false, closeModal = true, button = null) {
            // Si c'est une sauvegarde manuelle, afficher le spinner
            let originalIconClass = null;

            if (isManual && button) {
                const icon = $(button).find('i'); // Déclaration explicite
                originalIconClass = icon.attr('class');
                icon.removeClass().addClass('fa fa-spinner fa-spin'); // Icône de chargement
            }
            
            // Sauvegarde du contenu TinyMCE
            tinyMCE.triggerSave();
            console.log('#update_deliverablecontent_form$rand');
            console.log($('#update_deliverablecontent_form$rand').serializeArray());
            
            // Envoi de la requête AJAX
            $.ajax({
                url: '/marketplace/dlteams/ajax/update_deliverable_paragraph.php',
                type: 'POST',
                data: $('#update_deliverablecontent_form$rand').serializeArray(),
                success: function (response) {
                    $('#error-message').hide();
            
                    if (isManual && button) {
                        const icon = $(button).find('i'); // Re-déclarer `icon` dans ce scope
                        setTimeout(() => {
                            icon.removeClass().addClass('fa fa-check'); // Icône de succès
                            setTimeout(() => {
                                icon.removeClass().addClass(originalIconClass); // Rétablir l'icône originale
                            }, 1500);
                        }, 500);
                    }  
                    if (closeModal) {
                        $('#update_deliverablecontent_form$rand').closest('div.modal').modal('hide');
                    }
            
                    $('#document_bloc').html(response);
                    //$('html, body').animate({ scrollTop: $(document).height() }, 1000);
                },
                
                
                error: function () {
                    if (isManual && button) {
                        const icon = $(button).find('i'); // Re-déclarer `icon` dans ce scope
                        icon.removeClass().addClass(originalIconClass); // Rétablir l'icône originale en cas d'erreur
                    }
                    $('#error-message').text(`Erreur de connexion : la perte de connexion Internet ou un délai d'inactivité prolongé a interrompu votre session.
                        Sauvegarde automatique activée : seules les dernières secondes de saisie peuvent ne pas avoir été enregistrées.
                        Veuillez vérifier votre connexion et actualiser la page.`).show();

                }
            });
        }

        function navigateToParagraph(contentId) {
            stopAutoSave();
            glpi_close_all_dialogs();

            glpi_ajax_dialog({
                dialogclass: 'modal-xl',
                bs_focus: false,
                url: '/marketplace/dlteams/ajax/get_deliverable_paragraph_content.php',
                params: { content_id: contentId },
                title: i18n.textdomain('dlteams').__('Edit paragraph', 'dlteams'),
                close: function () {},
                fail: function () {
                    displayAjaxMessageAfterRedirect();
                }
            });
        }
        
        function updateSaveStatus() {
            const saveStatus = $('#save-status');
            $.ajax({
                url: '/marketplace/dlteams/ajax/deliverable_paragraph_infos.php',
                type: 'POST',
                data: {id: $contentid},
                success: function (html) {
                    const maxLength = 5000;
                    const textContent = html;  

                    if (textContent.length > maxLength) {
                      saveStatus.text('Session expiré, veuillez réactualiser la page');
                    } else {
                      saveStatus.text(html);
                    }
                },
                error: function () {
                    saveStatus.html('<i style=\"color: red;\">Problème de connexion</i>');
                }
            });
        }

        function startAutoSave() {
            if (!window.autoSaveIntervalId[$rand]) {
                window.autoSaveIntervalId[$rand] = setInterval(function () {
                    saveForm(false, false);
                }, 20000);
            }
            if (!window.statusIntervalId[$rand]) {
                window.statusIntervalId[$rand] = setInterval(updateSaveStatus, 5000);
            }
        }

        function stopAutoSave() {
            if (window.autoSaveIntervalId[$rand]) {
                clearInterval(window.autoSaveIntervalId[$rand]);
                window.autoSaveIntervalId[$rand] = null;
            }
            if (window.statusIntervalId[$rand]) {
                clearInterval(window.statusIntervalId[$rand]);
                window.statusIntervalId[$rand] = null;
            }
        }

        startAutoSave();
        $('#update_deliverablecontent_form$rand').closest('div.modal').on('hidden.bs.modal', function () {
            stopAutoSave();
        });
    </script>";
?>
