<?php

include_once('../../../inc/includes.php');
global $DB;



$direction = $_POST["direction"];


if($direction == "to_chapter"){
    $rand = mt_rand();

    $deliverable_content = new PluginDlteamsDeliverable_Content();
    $condition = [];
    if($deliverable_content->update([
        "id" => $_POST["paragraphId"],
    ])){
        $deliverable_section = new PluginDlteamsDeliverable_Section();
        $deliverable_section->getFromDB($deliverable_content->fields["deliverable_sections_id"]);
    }

    echo "<form name='timeline_move_tickettask_form$rand' id='update_timeline_move_tickettask_form$rand' action='/marketplace/dlteams/front/deliverable_section.form.php' method='post'>";
    echo "<input type='hidden' name='deliverable_contents_id' value='".$_POST["paragraphId"]."'>";
    global $CFG_GLPI;
    PluginDlteamsDeliverable_Section::dropdown([
        'addicon' => false,
        'name' => 'deliverables_sections_id',
        'width' => '300px',
        'value' => "",
        'condition' => [
            "deliverables_id" => $deliverable_section->fields["deliverables_id"]
        ],
        'url' => $CFG_GLPI['root_doc'] . "/marketplace/dlteams/ajax/getDropdownValue.php"
    ]);
    echo '<br /><br />' . Html::submit(_x('button', 'Post'), ['name' => 'move_to_chapter']);

    Html::closeForm();


    return;
}
else{

// Validation des entrées
    if (!isset($_POST["idx"], $_POST["tomove_id"], $_POST["direction"])) {
        http_response_code(400);
        die("Invalid request");
    }

    $idx = array_map('intval', $_POST["idx"]); // Sécuriser les ID comme entiers
    $tomove_id = intval($_POST["tomove_id"]);


// Vérifications des limites
    if (($tomove_id == $idx[0] && $direction == "up") || ($tomove_id == $idx[count($idx) - 1] && $direction == "down")) {
        http_response_code(200); // Retour OK mais rien à déplacer
        die("No movement required");
    }



// Charger les données de l'élément à déplacer
    $content_data = new PluginDlteamsDeliverable_Content();
    if (!$content_data->getFromDB($tomove_id)) {
        http_response_code(404);
        die("Item to move not found");
    }

// Charger toutes les positions
    $section_id = intval($content_data->fields["deliverable_sections_id"]);
    $query = "SELECT id, timeline_position FROM glpi_plugin_dlteams_deliverables_contents 
          WHERE deliverable_sections_id = $section_id 
          ORDER BY timeline_position ASC";

    $positions = [];
    $duplicate_detected = false;
    $position_check = [];

// Débogage : Compter le nombre de lignes retournées
    $result = $DB->query($query);
    $num_rows = $DB->numrows($result); // Compte les lignes
    error_log("Nombre de lignes retournées : $num_rows");

// Examiner les données retournées
    while ($row = $result->fetch_assoc()) {
        error_log("Ligne retournée : " . json_encode($row)); // Affiche chaque ligne dans les logs
        if (in_array($row['timeline_position'], $position_check)) {
            $duplicate_detected = true;
        }
        $position_check[] = $row['timeline_position'];
        $positions[] = $row;
    }

// Débogage : Vérifier les duplications détectées
    if ($duplicate_detected) {
        error_log("Duplications détectées dans les positions.");
    } else {
        error_log("Aucune duplication détectée.");
    }

// Normaliser si des duplications sont détectées
    if ($duplicate_detected) {
        $normalized_position = 1;
        foreach ($positions as $row) {
            $DB->update('glpi_plugin_dlteams_deliverables_contents', [
                'timeline_position' => $normalized_position++
            ], [
                'id' => $row['id']
            ]);
            error_log("Normalisation : ID " . $row['id'] . " mis à jour avec position " . ($normalized_position - 1));
        }
        // Recharger les positions après normalisation
        $positions = [];
        $result = $DB->query($query);
        while ($row = $result->fetch_assoc()) {
            $positions[] = $row;
        }
        error_log("Positions rechargées après normalisation.");
    }

// Trouver l'élément à échanger selon la direction
    $target_key = array_search($tomove_id, array_column($positions, 'id'));
    if ($direction === "up" && $target_key > 0) {
        $swap_id = $positions[$target_key - 1]['id']; // Échange avec l'élément précédent
    } elseif ($direction === "down" && $target_key < count($positions) - 1) {
        $swap_id = $positions[$target_key + 1]['id']; // Échange avec l'élément suivant
    } else {
        http_response_code(400);
        die("Invalid move direction");
    }

// Charger l'élément avec lequel échanger
    $swap_content = new PluginDlteamsDeliverable_Content();
    if (!$swap_content->getFromDB($swap_id)) {
        http_response_code(404);
        die("Target item not found");
    }

// Échanger les positions
    $current_position = intval($content_data->fields["timeline_position"]);
    $swap_position = intval($swap_content->fields["timeline_position"]);

    $content_data->update([
        "timeline_position" => $swap_position,
        "id" => $tomove_id,
    ]);

    $swap_content->update([
        "timeline_position" => $current_position,
        "id" => $swap_id,
    ]);

// Réafficher la section mise à jour
    PluginDlteamsDeliverable_Section::showAllDeliverableParagraph($section_id);
}
?>