<?php

$AJAX_INCLUDE = 1;
include_once('../../../inc/includes.php');

Session::checkLoginUser();

echo "
    <style>
        .form-container {
            padding: 20px;
            max-width: 100%;
            margin: 0 auto;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
        }
        .form-group input[type='time'],
        .form-group input[type='date'],
        .form-group select {
            width: 100%;
            padding: 8px;
            box-sizing: border-box;
        }
        .form-group input[type='checkbox'] {
            margin-right: 5px;
        }
        .form-group .inline {
            display: inline-block;
            margin-right: 10px;
        }
        .form-group .block {
            display: block;
        }
        .hidden {
            display: none;
        }
       
    </style>
";
$rand = mt_rand();
echo "
  <div class='form-container'>";
$tickettasks_id = $_POST["tickettasks_id"];
$tickettask = new TicketTask();
$tickettask->getFromDB($tickettasks_id);
echo "<form name='attribution_form$rand' id='attribution_form$rand' class='needs-validation' novalidate method='post'
            action='" . Toolbox::getItemTypeFormURL(PluginDlteamsTicketTask::class) . "'>";
echo "<input type='hidden' name='tickettasks_id' value='$tickettasks_id'>";
echo "<div id='error-messages'></div>";


echo "        <table class='tab_cadre_fixe' style='width: 100%'>";
echo "            <tr class='tab_bg_1'>";
echo "                <td width=''>";
echo "                    <label>Durée prévisionnelle</label>";
echo "                </td>";
echo "                <td width=''>";

Dropdown::showTimeStamp('estimate_duration', [
    'icon_label' => true,
    'rand' => $rand,
    'min' => 0,
    'max' => 8 * constant('HOUR_TIMESTAMP'),
    'addfirstminutes' => true,
    'inhours' => true,
    'value' => $tickettask->fields["estimate_duration"],
    'toadd' => array_map(function ($i) {
        return $i * HOUR_TIMESTAMP;
    }, range(9, 100)),
]);

echo "                </td>";
echo "            </tr>";

echo "            <tr class='tab_bg_1'>";
echo "                <td width=''>";
echo "                    <label>Utilisateur</label>";
echo "                </td>";
echo "                <td width=''>";
User::dropdown([
    'addicon' => true,
    'name' => 'users_id_tech',
    'value' => $tickettask->fields["users_id_tech"],
    'entity' => Session::getActiveEntity(),
    'right' => 'all',
    'width' => '250px',
]);
echo "                </td>";
echo "            </tr>";


echo "            <tr class='tab_bg_1'>";
echo "                <td width=''>";
echo "                    <label>Groupe</label>";
echo "                </td>";
echo "                <td width=''>";
Group::dropdown([
    'name' => 'groups_id_tech',
    'value' => $tickettask->fields["groups_id_tech"],
    'entity' => Session::getActiveEntity(),
    'right' => 'all',
    'width' => '250px',
]);
echo "                </td>";
echo "            </tr>";


echo "</table>";


echo "<div class='form-group'>";
echo "<label>Périodicité :</label>";
echo "<div class='block'>";
echo "    <label class='inline'><input type='radio' name='periodicity' value='daily'> Quotidienne</label>";
echo "    <label class='inline'><input type='radio' name='periodicity' value='weekly' checked> Hebdomadaire</label>";
echo "    <label class='inline'><input type='radio' name='periodicity' value='monthly'> Mensuelle</label>";
//echo "    <label class='inline'><input type='radio' name='periodicity' value='annually'> Annuelle</label>";
echo "</div>";
echo "</div>";

echo "<div class='form-group hidden' id='weekday-group'>";
echo "    <label>Jours de la semaine :</label>";
echo "    <div class='block'>";
echo "        <label class='inline'><input type='checkbox' name='weekday[]' value='monday' checked> lundi</label>";
echo "        <label class='inline'><input type='checkbox' name='weekday[]' value='tuesday'> mardi</label>";
echo "        <label class='inline'><input type='checkbox' name='weekday[]' value='wednesday'> mercredi</label>";
echo "        <label class='inline'><input type='checkbox' name='weekday[]' value='thursday'> jeudi</label>";
echo "        <label class='inline'><input type='checkbox' name='weekday[]' value='friday'> vendredi</label>";
echo "        <label class='inline'><input type='checkbox' name='weekday[]' value='saturday'> samedi</label>";
echo "        <label class='inline'><input type='checkbox' name='weekday[]' value='sunday'> dimanche</label>";
echo "    </div>";
echo "</div>";

echo "<div class='form-group hidden' id='month-day-group'>";
echo "    <label>Jour du mois :</label>";
echo "    <input type='number' name='month_day' min='1' max='31'>";
echo "</div>";

echo "<div class='form-group hidden' id='year-month-group'>";
echo "    <label>Mois de l'année :</label>";
echo "    <div class='block'>";
echo "        <label class='inline'><input type='checkbox' name='year-month[]' value='january'> Janvier</label>";
echo "        <label class='inline'><input type='checkbox' name='year-month[]' value='february'> Février</label>";
echo "        <label class='inline'><input type='checkbox' name='year-month[]' value='march'> Mars</label>";
echo "        <label class='inline'><input type='checkbox' name='year-month[]' value='april'> Avril</label>";
echo "        <label class='inline'><input type='checkbox' name='year-month[]' value='may'> Mai</label>";
echo "        <label class='inline'><input type='checkbox' name='year-month[]' value='jule'> Juin</label>";
echo "        <label class='inline'><input type='checkbox' name='year-month[]' value='july'> Juillet</label>";
echo "        <label class='inline'><input type='checkbox' name='year-month[]' value='august'> Août</label>";
echo "        <label class='inline'><input type='checkbox' name='year-month[]' value='september'> Septembre</label>";
echo "        <label class='inline'><input type='checkbox' name='year-month[]' value='october'> Octobre</label>";
echo "        <label class='inline'><input type='checkbox' name='year-month[]' value='november'> Novembre</label>";
echo "        <label class='inline'><input type='checkbox' name='year-month[]' value='december'> Décembre</label>";
echo "    </div>";
echo "</div>";

echo "<div style='width: 100%' class='form-group'>";
echo "    <label>Plage de périodicité :</label>";
echo "    <div style='display: flex; justify-content: start'>";
echo "        <table class='tab_cadre_fixe' style='width: 100%'>";
echo "            <tr class='tab_bg_1'>";
echo "                <td width=''>";
echo "                    <input type='radio' id='periodicity_range_begin' name='periodicity_range_begin' value='begin_on_date'>";
echo "                    <label for='periodicity_range_begin' class='inline'>Début</label>";
echo "                </td>";
echo "                <td width=''>";
//echo "                    <input type='date' id='start-date' name='start-date' value='2024-08-05'>";
Html::showDateTimeField('begin_date', [
    'timestep'   => -1,
    'maybeempty' => false,
    'canedit'    => true,
    'mindate'    => '',
    'maxdate'    => '',
]);
echo "                </td>";
echo "            </tr>";

echo "            <tr class='tab_bg_1'>";
echo "                <td width=''>";
echo "                    <input type='radio' id='periodicity_range_end_on_date' name='periodicity_range_end' value='end_on_date'>";
echo "                    <label for='periodicity_range_end_on_date' class='inline'>Fin le </label>";
echo "                </td>";
echo "                <td width=''>";
//echo "                    <input type='date' id='end-date'  name='end-date' value='2025-01-20'>";
Html::showDateField('end_date', [
    'timestep'   => -1,
    'maybeempty' => false,
    'canedit'    => true,
    'mindate'    => '',
    'maxdate'    => '',
]);
echo "                </td>";
echo "            </tr>";

echo "            <tr class='tab_bg_1'>";
echo "                <td width=''>";
echo "                    <div style='display: flex; align-items: center; gap: 0.2rem'>";
echo "                        <input type='radio' id='periodicity_range_end_after_date' name='periodicity_range_end' value='end_after_date'>";
echo "                        <label for='periodicity_range_end_after_date'>Fin après</label>";
echo "                    </div>";
echo "                </td>";
echo "                <td width=''>";
echo "                    <div style='display: flex; align-items: center; gap: 1rem'>";
echo "                        <input type='number' id='occurrences' name='occurrences' value='25' min='1'>";
echo "                        <label>occurrences</label>";
echo "                    </div>";
echo "                </td>";
echo "            </tr>";

//echo "            <tr class='tab_bg_1'>";
//echo "                <td colspan='2'>";
//echo "                    <label for='end_after_date_no_end' class='inline'><input type='radio' id='end_after_date_no_end' name='periodicity_range_end' value='no_end'>Pas de date de fin</label>";
//echo "                </td>";
//echo "            </tr>";
echo "        </table>";
echo "    </div>";
echo "</div>";

echo "<div class='form-group'>";
echo "    <div class='form-actions '>";
echo "        <button class='btn btn-secondary block' name='add_periodic_tasks' type='submit'>OK</button>";
echo "    </div>";
echo "</div>";

Html::closeForm();
echo "</div>";

echo "<script>
    $(document).ready(function() {
        // Gestion de la visibilité et de l'état des champs en fonction de la périodicité
        function handlePeriodicityChange() {
            var periodicity = $('input[name=\"periodicity\"]:checked').val();

            // Réinitialiser tous les champs avant d'appliquer la logique spécifique
            $('#weekday-group').addClass('hidden');
            $('#month-day-group').addClass('hidden');
            $('#year-month-group').addClass('hidden');
            $('input[name=\"weekday[]\"]').prop('checked', false).prop('disabled', true);
            $('input[name=\"month_day\"]').val('').prop('disabled', true);
            $('input[name=\"year-month[]\"]').prop('checked', false).prop('disabled', true);

            // Appliquer les actions spécifiques selon la périodicité choisie
            switch(periodicity) {
                case 'daily':
                    // Aucune action supplémentaire à faire pour 'daily', tout reste caché
                    break;
                case 'weekly':
                    $('#weekday-group').removeClass('hidden');
                    $('input[name=\"weekday[]\"]').prop('disabled', false); // Activer les jours de la semaine
                    break;
                case 'monthly':
                    $('#month-day-group').removeClass('hidden');
                    $('input[name=\"month_day\"]').prop('disabled', false); // Activer le jour du mois
                    break;
                case 'annually':
                    $('#year-month-group').removeClass('hidden');
                    $('input[name=\"year-month[]\"]').prop('disabled', false); // Activer les mois
                    break;
            }
        }

        // Déclencher automatiquement le changement lors du chargement de la page
        handlePeriodicityChange();

        // Appliquer les changements lors du changement de périodicité
        $('input[name=\"periodicity\"]').change(function() {
            handlePeriodicityChange();
        });

        // Cocher automatiquement la radio de début si la date de début est renseignée
        $('input[name=\"begin_date\"]').on('change', function() {
            $('#periodicity_range_begin').prop('checked', true);
        });

        // Cocher automatiquement la radio de fin si la date de fin est renseignée
        $('input[name=\"end_date\"]').on('change', function() {
            $('#periodicity_range_end_on_date').prop('checked', true);
            $('#occurrences').val(''); // Effacer les occurrences si une date de fin est choisie
        });

        // Si l'utilisateur commence à modifier le champ occurrences
        $('#occurrences').on('input', function() {
            $('#periodicity_range_end_on_date').prop('checked', false);
            $('#end_date').val('');
            $('#periodicity_range_end_after_date').prop('checked', true);
        });

        // Si l'utilisateur choisit 'Pas de fin', réinitialiser les autres choix de fin
        $('#end_after_date_no_end').on('change', function() {
            $('#end_date').val('');
            $('#occurrences').val('');
            $('#periodicity_range_end_on_date').prop('checked', false);
            $('#periodicity_range_end_after_date').prop('checked', false);
        });

        // Filtrer les champs avant l'envoi du formulaire pour ne pas soumettre les champs désactivés
        $('#attribution_form$rand').on('submit', function() {
            var periodicity = $('input[name=\"periodicity\"]:checked').val();

            if (periodicity === 'daily') {
                $('input[name=\"weekday[]\"]').prop('disabled', true);
                $('input[name=\"month_day\"]').prop('disabled', true);
                $('input[name=\"year-month[]\"]').prop('disabled', true);
            } else if (periodicity === 'weekly') {
                $('input[name=\"month_day\"]').prop('disabled', true);
                $('input[name=\"year-month[]\"]').prop('disabled', true);
            } else if (periodicity === 'monthly') {
                $('input[name=\"weekday[]\"]').prop('disabled', true);
                $('input[name=\"year-month[]\"]').prop('disabled', true);
            } else if (periodicity === 'annually') {
                $('input[name=\"weekday[]\"]').prop('disabled', true);
                $('input[name=\"month_day\"]').prop('disabled', true);
            }
        });
    });
</script>";



