<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include("../../../inc/includes.php");

Session::checkLoginUser();

if (isset($_POST['add'])) {
    $itemtype = $_POST['itemtype']; // ex: PluginDlteamsProtectiveMeasure
    $itemtype1 = $_POST['itemtype1']; // ex: PluginDlteamsRecord
    $itemtype_item = $itemtype . '_Item'; // ex: PluginDlteamsProtectiveMeasure_Item
    $itemtype1_item = $itemtype1 . '_Item'; // ex: PluginDlteamsRecord_Item
    $baseItem = new $itemtype();
//    $baseItem->check($_POST[$itemtype::getForeignKeyField()], UPDATE);

    global $DB;

    if (isset($_POST['items_id'])) {
        //add baseItem side
        $baseItem_items = new $itemtype_item();

        $i1_itemsid_column = strtolower(str_replace("PluginDlteams", "",$itemtype))."s_id";
        $i1 = [
            $i1_itemsid_column => $_POST["items_id"],
            "items_id" => $_POST["items_id1"],
            "itemtype" => $_POST["itemtype1"],
            "comment" => $_POST["comment"],
        ];
        $test = $baseItem_items->add($i1);

        $i2_itemsid_column = strtolower(str_replace("PluginDlteams", "",$itemtype1))."s_id";
        $i2 = [
            $i2_itemsid_column => $_POST["items_id1"],
            "items_id" => $_POST["items_id"],
            "itemtype" => $_POST["itemtype"],
            "comment" => $_POST["comment"],
        ];
        $second_items = new $itemtype1_item();
        $test1 = $second_items->add($i2);


        Session::addMessageAfterRedirect("Ajouté avec succès");


    }
}

elseif(isset($_POST['update'])){

    $legalbasi_item = new PluginDlteamsLegalBasi_Item();
/*    highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//    die();
    $legalbasi_item->getFromDB($_POST["linkid"]);

    if(!$_POST["legalbasis_id"]){
        Session::addMessageAfterRedirect("Veuillez choisir une base légale", 0, ERROR);
        Html::back();
    }

    global $DB;

    $DB->update($legalbasi_item->getTable(), [
        "legalbasis_id" => $_POST["legalbasis_id"],
        "itemtype" => $_POST["itemtype"],
        "items_id" => $_POST["items_id"],
        "comment" => $_POST["comment"],
    ],
    ["id" => $_POST["linkid"]]);




    $relation_item_str = $legalbasi_item->fields["itemtype"] . "_Item";
    if(!class_exists($relation_item_str))
        $relation_item_str = "PluginDlteams".$relation_item_str;
    $relation_item = new $relation_item_str();
    $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $legalbasi_item->fields["itemtype"]))) . "s_id";

    $criteria = [
        "itemtype" => PluginDlteamsLegalbasi::class,
        "items_id" => $legalbasi_item->fields[PluginDlteamsLegalBasi_Item::$items_id_1],
        $relation_column_id => $legalbasi_item->fields["items_id"],
        "comment" => $legalbasi_item->fields["comment"]
    ];

    global $DB;
    $DB->delete(
        $relation_item->getTable(),
        $criteria
    );
//        $relation_item->deleteByCriteria($criteria);

//        $criteria["plugin_dlteams_storageendactions_id"] = $this->fields["plugin_dlteams_storageendactions_id"];
//        $criteria["plugin_dlteams_storagetypes_id"] = $this->fields["plugin_dlteams_storagetypes_id"];
    $criteria["comment"] = $_POST["comment"];
    $criteria["items_id"] = $_POST["items_id"];

    $DB->insert($relation_item->getTable(), $criteria);
//        $relation_item->add([
//            ...$criteria,
//        ]);

    Session::addMessageAfterRedirect("Opération éffectuée");
    Session::addMessageAfterRedirect("Relation mis a jour avec succès");

//    post_updateItem will update the item

    Html::back();

}

//        A chaque ajoute de legalbasi pour un record, on mets a jour les stats dans record
if($_POST["itemtype1"] == PluginDlteamsRecord::class
    && $_POST["items_id1"]
){
    $r = new PluginDlteamsRecord();
    $r->getFromDB($_POST["items_id1"]);
    $nb = PluginDlteamsLegalBasi_Item::countElements($r);
    $DB->update(PluginDlteamsRecord::getTable(),[
        "r_legalbasis" => $nb
    ],
        ["id" => $_POST["items_id1"]]);
}
Html::back();
