<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired  DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include("../../../inc/includes.php");

Session::checkLoginUser();

/**
 * Lier un document à un élément (item), avec transaction pour chaque
 * insertion dans Document_Item et dans la table spécifique à l’item.
 *
 * @param int $documents_id ID du document à lier
 * @param string $item1_str Nom de la classe de l’item (ex : "PluginDlteamsRecord")
 * @param int $items_id1 ID de l’élément à lier au document
 */
function linkDocumentToItem(int $documents_id, string $item1_str, int $items_id1): void
{
    global $DB;
    if($item1_str == DocumentCategory::class){
        $document = new Document();
        $document->update([
            "id" => $documents_id,
            "documentcategories_id" => $items_id1
        ]);

        Session::addMessageAfterRedirect("Opération effectuée avec succès");
        Html::back();
    }


    // Détermination dynamique de la classe et du nom de colonne cible
    switch ($item1_str) {
        case Ticket::class:
            $item1_item_str = PluginDlteamsTicket_Item::class;
            break;
        default:
            $item1_item_str = $item1_str . "_Item";
            break;
    }
    $item1_item = new $item1_item_str();
    $i1_itemsid_column = strtolower(str_replace("PluginDlteams", "", $item1_str)) . "s_id";

    // Démarrage de la transaction
    $DB->beginTransaction();

    // 1) Insertion dans Document_Item
    $DB->insert(
        Document_Item::getTable(),
        [
            "itemtype" => $item1_str,
            "items_id" => $items_id1,
            "documents_id" => $documents_id
        ]
    );
    if ($DB->error()) {
        $DB->rollback();
        Session::addMessageAfterRedirect("Erreur lors de la liaison Document_Item.", 0, ERROR);
        Html::back();
        return;
    }

    // 2) Insertion dans la table spécifique à l’item (ex : plugin_dlteams_records_items)
    $DB->insert(
        $item1_item::getTable(),
        [
            "itemtype" => Document::class,
            "items_id" => $documents_id,
            $i1_itemsid_column => $items_id1
        ]
    );
    if ($DB->error()) {
        $DB->rollback();
        Session::addMessageAfterRedirect("Erreur lors de la liaison dans {$item1_item_str}.", 0, ERROR);
        Html::back();
        return;
    }

    // Si tout est OK, on commit
    $DB->commit();
    Session::addMessageAfterRedirect("Opération effectuée avec succès");
    Html::back();
}

// ------------------------------------------------------------
// 1) Gestion du paramètre "switchfoldermanagement"
// ------------------------------------------------------------
if (isset($_GET["action"]) && $_GET["action"] === "switchfoldermanagement") {
    $foldermanagement_state = Config::getConfigurationValues('dlteams', ['document_manage_folders']);
    if (empty($foldermanagement_state)) {
        Config::setConfigurationValues("dlteams", ['document_manage_folders' => 1]);
    } else {
        Config::setConfigurationValues("dlteams", [
            'document_manage_folders' => !Config::getConfigurationValue("dlteams", "document_manage_folders")
        ]);
    }
    Html::back();
}

// ------------------------------------------------------------
// 2) Liaison "record – document" + autres liaisons basées sur $_POST
// ------------------------------------------------------------
if (isset($_POST['add']) && isset($_POST['plugin_dlteams_records_id'])) {
    $record = new PluginDlteamsRecord();
    $record->check($_POST[PluginDlteamsRecord::getForeignKeyField()], UPDATE);

    global $DB;

    // a) Si on lie un document existant au record
    if (!empty($_POST['documents_id']) && $_POST['documents_id'] != 0) {
        // On crée d’abord l’objet PluginDlteamsObject_document (API GLPI)
        $item = new PluginDlteamsObject_document();
        $_POST['items_id'] = $_POST['documents_id'];
        $_POST['itemtype'] = 'Document';
        $item->add($_POST);

        // Puis on gère la transaction pour l’insertion dans glpi_documents_items
        $DB->beginTransaction();
        $DB->insert(
            'glpi_documents_items',
            [
                'documents_id' => $_POST['documents_id'],
                'items_id' => $_POST['plugin_dlteams_records_id'],
                'itemtype' => 'PluginDlteamsRecord'
            ]
        );
        if ($DB->error()) {
            $DB->rollback();
            Session::addMessageAfterRedirect("Erreur lors de la liaison record–document.", 0, ERROR);
            Html::back();
        } else {
            $DB->commit();
        }
    }

    // b) Si on lie une base de données au record
    if (!empty($_POST['plugin_databases_databases_id']) && $_POST['plugin_databases_databases_id'] != 0) {
        $DB->beginTransaction();
        $DB->insert(
            'glpi_plugin_dlteams_records_databases',
            [
                'plugin_dlteams_records_id' => $_POST['plugin_dlteams_records_id'],
                'plugin_databases_databases_id' => $_POST['plugin_databases_databases_id']
            ]
        );
        if ($DB->error()) {
            $DB->rollback();
            Session::addMessageAfterRedirect("Erreur lors de la liaison record–database.", 0, ERROR);
            Html::back();
        } else {
            $DB->commit();
        }
    }

    // c) Si on lie un accountkey au record
    if (!empty($_POST['plugin_dlteams_accountkey_id']) && $_POST['plugin_dlteams_accountkey_id'] != 0) {
        $DB->beginTransaction();
        $DB->insert(
            'glpi_plugin_dlteams_accountkeys_items',
            [
                'accountkeys_id' => $_POST['items_id1'],
                'items_id' => $_POST['items_id'],
                'itemtype' => $_POST['document'],
                'entities_id' => $_POST['entities_id']
            ]
        );
        if ($DB->error()) {
            $DB->rollback();
            Session::addMessageAfterRedirect("Erreur lors de la liaison record–accountkey.", 0, ERROR);
            Html::back();
        } else {
            $DB->commit();
        }
    }
}

// ------------------------------------------------------------
// 3) Liaison "Document – item" existant
// ------------------------------------------------------------
if (isset($_POST["add"])) {
    $base_items_id = (int)$_POST["items_id"];
    $item1_str = $_POST["itemtype1"];
    $items_id1 = (int)$_POST["items_id1"];
    linkDocumentToItem($base_items_id, $item1_str, $items_id1);
}

// ------------------------------------------------------------
// 4) Création ou upload d’un document puis liaison à un item
// ------------------------------------------------------------
if (isset($_POST["add_doc"])) {
    $doc = new Document();
    $doc->check(-1, CREATE, $_POST);

    // a) Cas d’upload multiple (tableaux)
    if (isset($_POST['_filename']) && is_array($_POST['_filename'])) {
        $fic = $_POST['_filename'];
        $tag = $_POST['_tag_filename'];
        $prefix = $_POST['_prefix_filename'];
        $lastID = null;

        foreach (array_keys($fic) as $key) {
            $_POST['_filename'] = [$fic[$key]];
            $_POST['_tag_filename'] = [$tag[$key]];
            $_POST['_prefix_filename'] = [$prefix[$key]];

            if ($addedID = $doc->add(array_merge($_POST, ["entities_id" => Session::getActiveEntity()]))) {
                \Glpi\Event::log(
                    $addedID,
                    "documents",
                    4,
                    "login",
                    sprintf(__('%1$s adds the item %2$s'), $_SESSION["glpiname"], $doc->fields["name"])
                );
                $lastID = $addedID;
            }
        }

        if ($lastID !== null) {
            $item1_str = $_POST["itemtype1"];
            $items_id1 = (int)$_POST["items_id1"];
            linkDocumentToItem($lastID, $item1_str, $items_id1);
        }
    } // b) Cas d’un seul fichier (scalar)
    else if ($newID = $doc->add(array_merge($_POST, ["entities_id" => Session::getActiveEntity()]))) {
        \Glpi\Event::log(
            $newID,
            "documents",
            4,
            "login",
            sprintf(__('%1$s adds the item %2$s'), $_SESSION["glpiname"], $doc->fields["name"])
        );

        $item1_str = $_POST["itemtype1"];
        $items_id1 = (int)$_POST["items_id1"];
        linkDocumentToItem($newID, $item1_str, $items_id1);
    }

    Html::back();
}

// ------------------------------------------------------------
// 5) Ajout d’un fichier HTML (création Document + Deliverable + liaison)
// ------------------------------------------------------------
if (isset($_POST["add_html_file"])) {
    if (empty($_POST["htmlfile_name"])) {
        Session::addMessageAfterRedirect("Veuillez saisir le nom du fichier HTML", 0, ERROR);
        Html::back();
    }

    $document = new Document();
    $docid = $document->add([
        "name" => $_POST["htmlfile_name"],
        "entities_id" => Session::getActiveEntity()
    ]);

    if ($docid) {
        $deliverable = new PluginDlteamsDeliverable();
        $deliverables_id = $deliverable->add([
            "name" => $_POST["htmlfile_name"],
            "entities_id" => Session::getActiveEntity(),
            "documents_id" => $docid
        ]);

        if ($deliverables_id) {
            $document->update([
                "id" => $docid,
                "deliverables_id" => $deliverables_id
            ]);
        }

        $item1_str = $_POST["itemtype1"];
        $items_id1 = (int)$_POST["items_id1"];
        linkDocumentToItem($docid, $item1_str, $items_id1);
    } else {
        Session::addMessageAfterRedirect("Une erreur s'est produite", 0, ERROR);
        Html::back();
    }
}

// ------------------------------------------------------------
// 6) Ajout d’un lien (Document de type "lien" + liaison)
// ------------------------------------------------------------
if (isset($_POST["add_link"])) {
    if (empty($_POST["url_link"])) {
        Session::addMessageAfterRedirect("Veuillez saisir l'url'", 0, ERROR);
        Html::back();
    }

    $document = new Document();
    $docid = $document->add([
        "link" => $_POST["url_link"],
        "entities_id" => Session::getActiveEntity()
    ]);

    if ($docid) {
        $item1_str = $_POST["itemtype1"];
        $items_id1 = (int)$_POST["items_id1"];
        linkDocumentToItem($docid, $item1_str, $items_id1);
    } else {
        Session::addMessageAfterRedirect("Une erreur s'est produite", 0, ERROR);
        Html::back();
    }
}

// ------------------------------------------------------------
// Si on n’est arrivé nulle part, on retourne simplement en arrière
// ------------------------------------------------------------
Html::back();
