<?php
$USEDBREPLICATE        = 1;
$DBCONNECTION_REQUIRED = 0; // not really a big SQL request

include ("../../../../inc/includes.php");

// Extend TCPDF to create custom Header and Footer
class MYPDF extends TCPDF {
    // Custom Header
    public function Header() {
        // Get current date
        $date = date('d/m/Y');
        // Set font for header
        $this->SetFont('helvetica', 'B', 12);
        // Title and Date, leaving some space at the top
        $this->Cell(0, 15, 'Rapport des traitements et leurs finalités - ' . $date, 0, false, 'C', 0, '', 0, false, 'M', 'M');
        // Add some space after header
        $this->Ln(10); // Adjust to add space after header
    }

    // Custom Footer
    public function Footer() {
        // Set font for footer
        $this->SetFont('helvetica', 'I', 8);
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Copyright text
        $this->Cell(0, 10, '© 2024 Dlteams. Tous droits réservés.', 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

// Create new PDF document
$pdf = new MYPDF('L', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$record_query = [
    "FROM" => PluginDlteamsRecord::getTable(),
    "WHERE" => [
        "entities_id" => Session::getActiveEntity()
    ],
    "ORDER" => ["completenumber"]
];
global $DB;
$iterator = $DB->request($record_query);

// Set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Dlteams');
$pdf->SetTitle('Rapport des traitements et leurs finalités');

// Set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// Set margins - Adjust top margin to give more space for the header
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP + 10, PDF_MARGIN_RIGHT);

// Set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// Set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// Add a page
$pdf->AddPage();

// Set content for the PDF with colored header
$htmlContent = '
    <h1>Rapport des traitements et leurs finalités</h1>
    <table border="1" cellpadding="5" cellspacing="0">
        <thead>
            <tr style="background-color: #f2f2f2; color: #000;">
                <th><strong>Num</strong></th>
                <th><strong>Traitement</strong></th>
                <th><strong>Finalités</strong></th>
            </tr>
        </thead>
        <tbody>';

// Build table rows from database
foreach ($iterator as $row) {
    $htmlContent .= '<tr>
        <td>' . $row["completenumber"] . '</td>
        <td>' . $row["name"] . '</td>
        <td>' . htmlspecialchars_decode($row["content"]) . '</td>
    </tr>';
}

$htmlContent .= '</tbody></table>';

// Output the HTML content as a PDF and prevent page breaks inside table rows
$pdf->writeHTMLCell(0, 0, '', '', $htmlContent, 0, 1, 0, true, 'L', true);

// Close and output the PDF document (send to browser)
$pdf->Output('traitement_finalites.pdf', 'I'); // 'I' to display in browser, 'D' to download directly
