<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired   DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include("../../../inc/includes.php");

if (!Session::haveRight("user", UPDATE)) {
    Session::addMessageAfterRedirect("Vous n'avez pas les droits suffisants pour effectuer cette action", false, ERROR);
    Html::back();
}
global $DB;

// Récupérer l'annuaire sélectionné depuis le formulaire
$annuaire = isset($_POST['annuaire']) ? trim($_POST['annuaire']) : null;
if (!$annuaire) {
    Session::addMessageAfterRedirect("Aucun annuaire sélectionné", false, ERROR);
    Html::back();
}

// Définir les en-têtes attendus en fonction de l'annuaire
// Les clés correspondent aux colonnes de la table glpi_users à approvisionner.
$expected = array();
if ($annuaire === 'm365') {
    $expected = array(
        'realname' => 'Nom',                         // Surname
        'firstname' => 'Prénom',                      // GivenName
        'email' => "Nom d’utilisateur principal", // Email à traiter séparément
        'name' => "Nom d’utilisateur principal", // Autre champ à approvisionner
        'mobile' => "Téléphone mobile",
        'phone' => "Numéro de téléphone",
        'microsoft_guid' => "ID de l’objet"
    );
} elseif ($annuaire === 'google') {
    $expected = array(
        'realname' => 'Last Name [Required]',
        'firstname' => 'First Name [Required]',
        'email' => 'Email Address [Required]',
        'name' => 'Email Address [Required]',
        'google_guid' => 'Email Address [Required]',
    );
} else {
    $expected = array(
        'realname' => 'Last Name [Required]',
        'firstname' => 'First Name [Required]',
        'email' => 'Email Address [Required]',
        'google_guid' => 'Mobile Phone',
    );
}

// Vérification et ouverture du fichier CSV
if (isset($_FILES['csvFile']) && $_FILES['csvFile']['error'] === UPLOAD_ERR_OK) {
    $fileTmpPath = $_FILES['csvFile']['tmp_name'];
    if (($handle = fopen($fileTmpPath, "r")) !== false) {

        // Lecture de la première ligne pour récupérer les entêtes du CSV
        $header = fgetcsv($handle, 1000, ",");
        if (!$header) {
            Session::addMessageAfterRedirect("Le fichier CSV est vide ou invalide.", false, ERROR);
            fclose($handle);
            Html::back();
            exit;
        }

        // Construire un mapping associant chaque clé attendue à l'index correspondant dans le CSV.
        // On initialise avec toutes les clés de $expected et on ajoute "fullname" pour reconstitution éventuelle.
        $mapping = array();
        foreach (array_keys($expected) as $field) {
            $mapping[$field] = null;
        }
        $mapping['fullname'] = null; // pour reconstituer realname/firstname si nécessaire

        foreach ($header as $index => $colName) {
            $colNameTrim = trim($colName);
            foreach ($expected as $field => $expectedName) {
                if (strcasecmp($colNameTrim, $expectedName) === 0) {
                    $mapping[$field] = $index;
                }
            }
            // Détecter une colonne pour le nom complet
            if ($mapping['fullname'] === null && (strcasecmp($colNameTrim, 'DisplayName') === 0 || strcasecmp($colNameTrim, 'Nom complet') === 0)) {
                $mapping['fullname'] = $index;
            }

//            if ($mapping['fullname'] === null && (strcasecmp($colNameTrim, 'DisplayName') === 0 || strcasecmp($colNameTrim, 'Nom complet') === 0)) {
//                $mapping['fullname'] = $index;
//            }
        }

        // Vérifier que la colonne email est présente
        if ($mapping['email'] === null) {
            Session::addMessageAfterRedirect("Le fichier CSV ne contient pas la colonne email attendue.", false, ERROR);
            fclose($handle);
            Html::back();
            exit;
        }

        // Initialisation des compteurs
        $countUpdate = 0;
        $countAdd = 0;
        $countSkipped = 0;
        $dataUpdate = [];
        $dataAdd = [];

        $profile = new Profile();
        if (!$profile->getFromDBByCrit([
            "interface" => "central",
            "name" => "Invité",
            "entities_id" => Session::getActiveEntity()
        ])) {
            Session::addMessageAfterRedirect("Les utilisateurs importés ne pourront pas se connecter, le profil 'Invité' n'a pas été trouvé", 0, WARNING);
        } else {
            $dataUpdate["profiles_id"] = $profile->fields["id"];
            $dataAdd["profiles_id"] = $profile->fields["id"];
        }
        global $DB;

        // Parcours de chaque ligne du CSV
        while (($data = fgetcsv($handle, 1000, ",")) !== false) {

            // Construction d'un tableau de données pour glpi_users à partir des champs attendus
            $fields = array();
            foreach ($expected as $field => $expectedName) {
                // On ne traite pas "email" ici (il sera géré dans glpi_useremails)
                if ($field == 'email') {
                    continue;
                }
                if (isset($mapping[$field]) && $mapping[$field] !== null) {
                    $fields[$field] = trim($data[$mapping[$field]]);
                } else {
                    $fields[$field] = ""; // valeur vide si non trouvée
                }
            }
            // Récupérer l'email
            $email = isset($data[$mapping['email']]) ? trim($data[$mapping['email']]) : "";

            // Si les champs realname et firstname sont vides, tenter de reconstituer à partir de fullname
            if ((empty($fields['realname']) || empty($fields['firstname'])) && $mapping['fullname'] !== null) {
                $fullname = isset($data[$mapping['fullname']]) ? trim($data[$mapping['fullname']]) : "";
                if (!empty($fullname)) {
                    $parts = explode(" ", $fullname);
                    if (count($parts) > 1) {
                        if (empty($fields['firstname'])) {
                            $fields['firstname'] = array_shift($parts);
                        }
                        if (empty($fields['realname'])) {
                            $fields['realname'] = implode(" ", $parts);
                        }
                    } else {
                        // Si impossible de séparer, on affecte tout au prénom
                        if (empty($fields['firstname'])) {
                            $fields['firstname'] = $fullname;
                        }
                    }
                }
            }

            // Si l'email est vide, on ignore cette ligne
            if (empty($email)) {
                $countSkipped++;
                continue;
            }

            /*            highlight_string("<?php\n\$data =\n" . var_export($email, true) . ";\n?>");*/
            // Recherche de l'utilisateur via son email dans glpi_useremails
            $query = "SELECT id FROM glpi_users WHERE name = '" . addslashes($email) . "'";
            $result = $DB->query($query);


            if ($DB->numrows($result) > 0) {
                // Utilisateur trouvé par email : mise à jour
                $row = $result->fetch_assoc();
                $userID = $row['id'];
                $user = new User();

                // Préparer le tableau de mise à jour en y intégrant tous les champs récupérés
                $dataUpdate = array_merge(array('id' => $userID), $fields, $dataUpdate);

                if ($user->update($dataUpdate)) {
                    $profile_user = new Profile_User();
                    if (!$profile_user->getFromDBByCrit([
                        "users_id" => $userID,
                        "profiles_id" => $dataUpdate["profiles_id"]
                    ])) {
                        $profile_user->add([
                            "users_id" => $userID,
                            "profiles_id" => $dataUpdate["profiles_id"],
                            "entities_id" => Session::getActiveEntity(),
                            "is_default_profile" => 1,
                            "is_dynamic" => 0,
                            "is_recursive" => 0
                        ]);
                    }
//                    update or add email of the user
                    $query_useremail = "SELECT id as id_mail FROM glpi_useremails WHERE email = '" . addslashes($email) . "'";
                    $result_useremail = $DB->query($query_useremail);

                    if ($DB->numrows($result_useremail) <= 0) {
                        $userEmailTemp = new UserEmail();
                        $userEmailTemp->add([
                            "users_id" => $userID,
                            "email" => addslashes($email)
                        ]);
                    }
                    $countUpdate++;
                }
            } else {
                // Vérifier si un utilisateur existe déjà avec le même nom et prénom
                $query2 = "SELECT id FROM glpi_users WHERE name = '" . addslashes($fields['realname']) . "' AND firstname = '" . addslashes($fields['firstname']) . "'";
                $result2 = $DB->query($query2);
                if ($DB->numrows($result2) > 0) {
                    // Utilisateur trouvé par nom/prénom, on effectue une mise à jour
                    $row2 = $result2->fetch_assoc();
                    $userID = $row2['id'];
                    $user = new User();
                    $dataUpdate = array_merge(array('id' => $userID), $fields, $dataUpdate);
                    if ($user->update($dataUpdate)) {
                        $countUpdate++;
                    }
                    // Vérifier si l'email est déjà associé, sinon l'ajouter
                    $queryEmail = "SELECT id FROM glpi_useremails WHERE email = '" . addslashes($email) . "'";
                    $resultEmail = $DB->query($queryEmail);
                    if ($DB->numrows($resultEmail) == 0) {
                        $userEmail = new UserEmail();
                        $dataAddEmail = array(
                            'users_id' => $userID,
                            'email' => $email,
                            'is_default' => 0
                        );
                        $userEmail->add($dataAddEmail);
                    }
                } else {
                    // Aucun utilisateur trouvé : création d'un nouvel utilisateur
                    $user = new User();
                    // Pour la création, on ajoute également l'entité active
                    $dataAdd = array_merge($fields, array('entities_id' => Session::getActiveEntity()));
                    $newUserID = $user->add($dataAdd);
                    $profile_user = new Profile_User();
                    if (isset($dataAdd["profiles_id"]) && $dataAdd["profiles_id"])
                        $profile_user->add([
                            "users_id" => $userID,
                            "profiles_id" => $dataAdd["profiles_id"],
                            "entities_id" => Session::getActiveEntity(),
                            "is_default_profile" => 1,
                            "is_dynamic" => 0,
                            "is_recursive" => 0
                        ]);
                    if ($newUserID > 0) {
                        $userEmail = new UserEmail();
                        $dataAddEmail = array(
                            'users_id' => $newUserID,
                            'email' => $email,
                            'is_default' => 0
                        );
                        if ($userEmail->add($dataAddEmail)) {
                            $countAdd++;
                        }
                    }
                }
            }
        }
        fclose($handle);
//        die();
        Session::addMessageAfterRedirect("Importation et synchronisation des utilisateurs réussies", true);
        Session::addMessageAfterRedirect(sprintf("%s ajouté(s), %s mis à jour, %s ligne(s) ignorée(s)", $countAdd, $countUpdate, $countSkipped), true);
        Html::back();
    } else {
        Session::addMessageAfterRedirect("Impossible d'ouvrir le fichier CSV", false, ERROR);
        Html::back();
    }
} else {
    Session::addMessageAfterRedirect("Aucun fichier téléchargé ou erreur lors de l'upload", false, ERROR);
    Html::back();
}
