<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

class PluginDlteamsActivityCategory extends CommonDBTM {
   static $rightname = 'plugin_dlteams_activitycategory';
   public $dohistory = true;
   protected $usenotepad = true;

    static function canCreate() {return true;}
    static function canView() {return true;}
    static function canUpdate() {return true;}
    static function canDelete() {return true;}
    static function canPurge() {return true;}
    function canCreateItem() {return true;}
    function canViewItem() {return true;}
    function canUpdateItem() {return true;}
    function canDeleteItem() {return true;}
    function canPurgeItem() {return true;}


   static function getTypeName($nb = 0) {
      return _n("Activity or profession", "Activities, professions", $nb, 'dlteams');
   }

   public static function dropdown($options = [])
   {
       return parent::dropdown($options); // TODO: Change the autogenerated stub
   }


    function prepareInputForAdd($input) {
      $input['users_id_creator'] = Session::getLoginUserID();
      if (isset($_POST["activitycategories_idx"])){
        $input["activitycategories_idx"] = json_encode($_POST["activitycategories_idx"]);
      }
      if(isset($input['number']) && empty($input['number']))
          $input['number'] = null;
      return parent::prepareInputForAdd($input);

   }

    function showForm($id, $options = [])
    {

        global $CFG_GLPI;

        $this->initForm($id, $options);
        $this->showFormHeader($options);

//        parent::showForm($id, $options);

//        echo "<tr class='tab_bg_1'>";
//        echo "<td style='text-align:right'>" .PluginDlteamsActivityCategory::getTypeName() . "</td>";
//        $randDropdown = mt_rand();
//        echo "<td colspan='2'>";
//        PluginDlteamsActivityCategory::dropdown([
//            'name' => 'plugin_dlteams_activitycategories_id',
//            'value' => $this->fields["plugin_dlteams_activitycategories_id"] ?? "", //$responsible,
//            'entity' => $this->fields["entities_id"],
//            'right' => 'all',
//            'width' => "250px",
//            'rand' => $randDropdown
//        ]);
//        echo "</td></tr>";

        /* echo "<tr class='tab_bg_1'>";
        echo "<td width='40%' style='text-align:right'>" . __("Number (order)", 'dlteams') . "</td>";
        echo "<td colspan='2'>";
        $number = Html::cleanInputText($this->fields['number']);
        echo "<input type='number' min='1' max='9999' name='number' required value='" . $number . "'>";
        //echo "<input type='number' style='width:10%' step='0.1' name='number' required value='" . $number . "'>";
        echo "</td></tr>";*/

        echo "<tr class='tab_bg_1'>";
        echo "<td width='40%' style='text-align:right'>" . __("Ordre", 'dlteams') . "</td>";
        echo "<td colspan='2'>";
        $title = Html::cleanInputText($this->fields['name']);
//        echo "<input type='text' style='width:98%' maxlength=250 name='name' value='" . $title . "'>";
        $number = Html::cleanInputText($this->fields['number']);
        echo "<input type='number' min='1' max='9999' name='number' size='8' value='" . $number . "'>";
        echo "</td></tr>";


        echo "<tr class='tab_bg_1'>";
        echo "<td width='40%' style='text-align:right'>" . __("Name", 'dlteams') . "</td>";
        echo "<td colspan='2'>";
        $title = Html::cleanInputText($this->fields['name']);
        echo "<input type='text' style='width:98%' maxlength=250 name='name' value='" . $title . "'>";
        echo "</td></tr>";



        echo "<tr class='tab_bg_1'>";
        echo "<td width='40%' style='text-align:right'>" . __("As child of") . "</td>";
        echo "<td colspan='2'>";
//        $title = Html::cleanInputText($this->fields['name']);

            Dropdown::show(PluginDlteamsActivityCategory::class, [
                'name' => 'plugin_dlteams_activitycategories_id',
                'value' => $this->fields["plugin_dlteams_activitycategories_id"],
                'used'   => (($id > 0) ? getSonsOf($this->getTable(), $id) : []),
                'width'  => '250px'
            ]);
        echo "</td></tr>";


        echo "<tr class='tab_bg_1'>";
        echo "<td width='40%' style='text-align:right'>" . __("Comment", 'dlteams') . "</td>";

        echo "<td colspan='2' >";
        $purpose = Html::cleanInputText($this->fields['comment']);
        echo "<textarea style='width:98%' name='comment' maxlength='1000' rows='5'>" . $purpose . "</textarea>";
        echo "</td></tr>";

        $this->showFormButtons($options);

        return true;
    }

   function prepareInputForUpdate($input) {
      $input['users_id_lastupdater'] = Session::getLoginUserID();
      return parent::prepareInputForUpdate($input);
   }

   function cleanDBonPurge() {
      $rel = new PluginDlteamsRecord_RecordCategory();
      $rel->deleteByCriteria(['plugin_dlteams_activitycategories_id' => $this->fields['id']]);
   }

    public function defineTabs($options = [])
    {
        $ong = [];
        $ong = array();
        //add main tab for current object
        $this->addDefaultFormTab($ong)
            ->addStandardTab('PluginDlteamsActivityCategory', $ong, $options)
            ->addStandardTab('PluginDlteamsRecord_Item', $ong, $options)
            ->addStandardTab(PluginDlteamsLegalBasi_Item::class, $ong, $options)
            ->addStandardTab(PluginDlteamsPolicieForm_Item::class, $ong, $options);
        return $ong;
    }

    function rawSearchOptions() {

      $tab = [];

      $tab[] = [
         'id'                 => 'common',
         'name'               => __("Characteristics")
      ];

//      $tab[] = [
//         'id'                 => '1',
//         'table'              => $this->getTable(),
//         'field'              => 'number',
//         'name'               => __("Num"),
//         'datatype'           => 'number',
//         'massiveaction'      => false,
//      ];

      $tab[] = [
         'id'                 => '2',
         'table'              => $this->getTable(),
         'field'              => 'name',
         'name'               => __("Name"),
         'datatype'           => 'itemlink',
         'massiveaction'      => false,
         'autocomplete'       => true,
      ];

      $tab[] = [
         'id' 		=> '3',
         'table' 			=> $this->getTable(),
         'field' 			=> 'completename',
         'name'  			=> __("Name"),
         'datatype' 		=> 'itemlink',
         'massiveaction'    => false,
         'autocomplete'     => true,
      ];

      $tab[] = [
         'id'                 => '4',
         'table'              => $this->getTable(),
         'field'              => 'id',
         'name'               => __("ID"),
         'massiveaction'      => false,
         'datatype'           => 'number',
      ];

      $tab[] = [
         'id'                 => '5',
         'table'              => $this->getTable(),
         'field'              => 'comment',
         'name'               => __("Comments"),
         'datatype'           => 'text',
         'toview'             => true,
         'massiveaction'      => true,
      ];

      $tab[] = [
         'id'                 => '6',
         'table'              => 'glpi_entities',
         'field'              => 'completename',
         'name'               => __("Entity"),
         'datatype'           => 'dropdown',
         'massiveaction'      => true,
      ];

      $tab[] = [
         'id'                 => '7',
         'table'              => $this->getTable(),
         'field'              => 'is_recursive',
         'name'               => __("Child entities"),
         'datatype'           => 'bool',
         'massiveaction'      => false,
      ];

      $tab[] = [
         'id'                 => '8',
         'table'              => $this->getTable(),
         'field'              => 'number',
         'name'               => __("Num"),
         'datatype'           => 'number',
         'massiveaction'      => false,
      ];

      return $tab;
   }

    public static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {

        switch ($item->getType()) {
            case 'PluginDlteamsActivityCategory':
                switch ($tabnum) {
                    case 1:
                        $item->showChildren();
                        return true;
                }
                break;
        }
        return false;
    }

    /**
     * Print the HTML array children of a TreeDropdown
     *
     * @return void
     */
    public function showChildren()
    {
        global $DB;

        $ID = $this->getID();
        $this->check($ID, READ);
        $fields = array_filter(
            $this->getAdditionalFields(),
            function ($field) {
                return isset($field['list']) && $field['list'];
            }
        );
        $nb = count($fields);
        $entity_assign = $this->isEntityAssign();

        // Minimal form for quick input.
        if (static::canCreate()) {
            $link = $this->getFormURL();

//            ajouter un catalogue existant comme enfant

            $used = [];
            $fk = $this->getForeignKeyField();
            $result = $DB->request(
                [
                    'FROM' => $this->getTable(),
                    'WHERE' => [$fk => $ID],
                    'ORDER' => 'name',
                ]
            );

            foreach ($result as $id => $data) {
                $used[$data['id']] = $data['id'];
            }

            echo "<div class='firstbloc'>";
            $this->initForm($this->fields["id"], []);
            $this->showFormHeader([]);
            echo "<table class='tab_cadre_fixe'>";
            echo "<tr><th colspan='3'>" . __('Intitulé d\'enfant existant') . "</th></tr>";


            echo "<input type='hidden' name='id' value='" . $this->fields["id"] . "'>";
            echo "<tr class='tab_bg_1'><td style='text-align: right; width: 35%; white-space: nowrap'>" . __('Rattacher une activité comme enfant') . "</td><td style='min-width: 10%'>";
//            echo Html::input('name', ['value' => '']);
            PluginDlteamsActivityCategory::dropdown([
                'addicon' => self::canCreate(),
                'name' => 'son_id',
//                'width' => '100%',
                'entity_sons' => true,
                'width' => '250px',
                'used' => $used,
                'value' => null
            ]);

            if (
                $entity_assign
                && ($this->getForeignKeyField() != 'entities_id')
            ) {
                echo "<input type='hidden' name='entities_id' value='" . $_SESSION['glpiactive_entity'] . "'>";
            }

            if ($entity_assign && $this->isRecursive()) {
                echo "<input type='hidden' name='is_recursive' value='1'>";
            }
            echo "<input type='hidden' name='" . $this->getForeignKeyField() . "' value='$ID'></td>";
            echo "<td style='text-align: left'><input type='submit' name='update_as_child' value=\"" . _sx('button', 'Add') . "\" class='btn btn-primary'>";
            echo "</td></tr>\n";
            echo "</table>";
            Html::closeForm();
            echo "</div>\n";
        }


        $rand = mt_rand();
        echo "<div class='spaced'>";

        echo "<table class='tab_cadre_fixehov'>";

        echo "<tr class='noHover'><th colspan='" . ($nb + 3) . "'>" . sprintf(
                __('Sons of %s'),
                $this->getTreeLink()
            );
        echo "</th></tr>";

        echo "</table>";

        echo "<table class='tab_cadre_fixehov'>";
        $header = "<tr>";

//        $header .= "<th width='10'>";
//        $header .= Html::getCheckAllAsCheckbox('mass' . $ma_processor . $rand);
//        $header .= "</th>";

        $header.= "<th>" . __('Name') . "</th>";
        if ($entity_assign) {
            $header .= "<th>" . Entity::getTypeName(1) . "</th>";
        }
        foreach ($fields as $field) {
            $header .= "<th>" . $field['label'] . "</th>";
        }
        $header .= "<th>" . __('Comments') . "</th>";
        $header .= "</tr>\n";
        echo $header;


        $nb = 0;
        foreach ($result as $data) {
            $nb++;
            echo "<tr class='tab_bg_1'>";

//            echo "<td>";
//            Html::showMassiveActionCheckBox($ma_processor, $data["id"]);
//            echo "</td>";

            echo "<td>";


            if (
                (($fk == 'entities_id') && in_array($data['id'], $_SESSION['glpiactiveentities']))
                || !$entity_assign
                || (($fk != 'entities_id') && in_array($data['entities_id'], $_SESSION['glpiactiveentities']))
            ) {
                echo "<a href='" . $this->getFormURL();
                echo '?id=' . $data['id'] . "'>" . $data['completename'] . "</a>";
            } else {
                echo $data['name'];
            }
            echo "</td>";
            if ($entity_assign) {
                echo "<td>" . Dropdown::getDropdownName("glpi_entities", $data["entities_id"]) . "</td>";
            }

            foreach ($fields as $field) {
                echo "<td>";
                switch ($field['type']) {
                    case 'UserDropdown':
                        echo getUserName($data[$field['name']]);
                        break;

                    case 'bool':
                        echo Dropdown::getYesNo($data[$field['name']]);
                        break;

                    case 'dropdownValue':
                        echo Dropdown::getDropdownName(
                            getTableNameForForeignKeyField($field['name']),
                            $data[$field['name']]
                        );
                        break;

                    default:
                        echo $data[$field['name']];
                }
                echo "</td>";
            }
            echo "<td>" . $data['comment'] . "</td>";
            echo "</tr>\n";
        }
//        if ($nb) {
//            echo $header;
//        }
        echo "</table></div>\n";
    }
}
