<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */
use GuzzleHttp\Client as Guzzle_Client;
use GuzzleHttp\Psr7\Message;
use GuzzleHttp\Psr7\Response;
use GuzzleHttp\Psr7\Request;

class PluginDlteamsConfig extends CommonGLPI
{
    static $rightname = 'plugin_dlteams_record';

    /**
     * Data fields of the Item.
     *
     * @var mixed[]
     */
    public $fields = [];

    public static $glpi_current_version = "10.0.18";

//    /**
//     * Add/Update fields input. Filled during add/update process.
//     *
//     * @var mixed[]
//     */
//    public $input = [];
//
//    /**
//     * Updated fields keys. Filled during update process.
//     *
//     * @var mixed[]
//     */
//    public $updates = [];
//
//    /**
//     * Previous values of updated fields. Filled during update process.
//     *
//     * @var mixed[]
//     */
//    public $oldvalues = [];
//
//
//    /**
//     * Flag to determine whether or not changes must be logged into history.
//     *
//     * @var boolean
//     */
//    public $dohistory = false;
//
//    /**
//     * List of fields that must not be taken into account when logging history or computating last
//     * modification date.
//     *
//     * @var string[]
//     */
//    public $history_blacklist = [];
//
//    /**
//     * Flag to determine whether or not automatic messages must be generated on actions.
//     *
//     * @var boolean
//     */
//    public $auto_message_on_action = true;
//
//    /**
//     * Flag to determine whether or not a link to item form can be automatically generated via
//     * self::getLink() method.
//     *
//     * @var boolean
//     */
//    public $no_form_page = false;
//
//    /**
//     * Flag to determine whether or not table name of item can be automatically generated via
//     * self::getTable() method.
//     *
//     * @var boolean
//     */
//    protected static $notable = false;
//
//    /**
//     * List of fields that must not be taken into account for dictionary processing.
//     *
//     * @var string[]
//     */
//    public $additional_fields_for_dictionnary = [];
//
//    /**
//     * List of linked item types on which entities information should be forwarded on update.
//     *
//     * @var string[]
//     */
//    protected static $forward_entity_to = [];
//
//    /**
//     * Foreign key field cache : set dynamically calling getForeignKeyField
//     *
//     * @TODO Remove this variable as it is not used ?
//     */
//    protected $fkfield = "";
//
//    /**
//     * Search option of item. Initialized on first call to self::getOptions() and used as cache.
//     *
//     * @var array
//     *
//     * @TODO Should be removed and replaced by real cache usage.
//     */
//    protected $searchopt = false;
//
//    /**
//     * {@inheritDoc}
//     */
//    public $taborientation = 'vertical';
//
//    /**
//     * {@inheritDoc}
//     */
//    public $get_item_to_display_tab = true;
//
//    /**
//     * List of linked item types from plugins on which entities information should be forwarded on update.
//     *
//     * @var array
//     */
//    protected static $plugins_forward_entity = [];
//
//    /**
//     * Flag to determine whether or not table name of item has a notepad.
//     *
//     * @var boolean
//     */
//    protected $usenotepad = false;
//
//    /**
//     * Flag to determine whether or not queued notifications should be deduplicated.
//     * Deduplication is done when a new notification is raised.
//     * Any existing notification for same object, event and recipient is dropped to be replaced by the new one.
//     *
//     * @var boolean
//     */
//    public $deduplicate_queued_notifications = true;
//
//    /**
//     * Computed/forced values of classes tables.
//     * @var string[]
//     */
//    protected static $tables_of = [];
//
//    /**
//     * Computed values of classes foreign keys.
//     * @var string[]
//     */
//    protected static $foreign_key_fields_of = [];
//
//
//    /**
//     * Fields to remove when querying data with api
//     * @var array
//     */
//    public static $undisclosedFields = [];
//
//    /**
//     * Current right that can be evaluated in "item_can" hook.
//     * Variable is set prior to hook call then unset.
//     * @var int
//     */
//    public $right;

    protected $core_tcpdf_fonts = [
        'courier' => 'Courier',
        'courierB' => 'Courier-Bold',
        'courierI' => 'Courier-Oblique',
        'courierBI' => 'Courier-BoldOblique',
        'dejavusans' => 'DejaVu Sans',
        'helvetica' => 'Helvetica',
        'helveticaB' => 'Helvetica-Bold',
        'helveticaI' => 'Helvetica-Oblique',
        'helveticaBI' => 'Helvetica-BoldOblique',
        'times' => 'Times-Roman',
        'timesB' => 'Times-Bold',
        'timesI' => 'Times-Italic',
        'timesBI' => 'Times-BoldItalic',
        'symbol' => 'Symbol',
        'zapfdingbats' => 'ZapfDingbats'
    ];

    public static function getTypeName($nb = 0)
    {
        return _n("Config", "Config", $nb, 'dlteams');
    }

    static function getConfigDefault()
    {
        $config = [];

        $config['system'] = [
            'keep_is_special_category_strict' => 1,
            'limit_retention_contracttypes' => 1,
            'remove_software_when_paper_only' => 1,
            'allow_select_expired_contracts' => 1,
            'allow_software_from_every_entity' => 0,
            'allow_controllerinfo_from_ancestor' => 1,
        ];
        $config['print'] = [
            'codepage' => 'UTF-8',
            'font_name' => 'dejavusans',
            'font_size' => 8,
            'margin_left' => 10,
            'margin_top' => 30,
            'margin_right' => 10,
            'margin_bottom' => 20,
            'margin_header' => 10,
            'margin_footer' => 10,
            'logo_show' => 1,
            'logo_image' => 'dlteams_logo.png',
        ];
        return $config;
    }

    /**
     * Return the table used to store this object
     *
     * @param string $classname Force class (to avoid late_binding on inheritance)
     *
     * @return string
     **/
    public static function getTable($classname = null)
    {

        return 'glpi_plugin_dlteams_configs';
    }

    /**
     * Get an object using some criteria
     *
     * @param array $crit search criteria
     *
     * @return boolean|array
     * @since 9.2
     *
     */
    public function getFromDBByCrit(array $crit)
    {
        /** @var \DBmysql $DB */
        global $DB;

        $crit = ['SELECT' => 'id',
            'FROM' => $this->getTable(),
            'WHERE' => $crit
        ];

        $iter = $DB->request($crit);
        if (count($iter) == 1) {
            $row = $iter->current();
            return $this->getFromDB($row['id']);
        } else if (count($iter) > 1) {
            trigger_error(
                sprintf(
                    'getFromDBByCrit expects to get one result, %1$s found in query "%2$s".',
                    count($iter),
                    $iter->getSql()
                ),
                E_USER_WARNING
            );
        }
        return false;
    }

    /**
     * Retrieve an item from the database
     *
     * @param integer $ID ID of the item to get
     *
     * @return boolean true if succeed else false
     **/
    public function getFromDB($ID)
    {
        /** @var \DBmysql $DB */
        global $DB;
        // Make new database object and fill variables

        // != 0 because 0 is considered as empty
        if (strlen((string)$ID) == 0) {
            return false;
        }

        $iterator = $DB->request([
            'FROM' => $this->getTable(),
            'WHERE' => [
                $this->getTable() . '.' . $this->getIndexName() => Toolbox::cleanInteger($ID)
            ],
            'LIMIT' => 1
        ]);


        if (count($iterator) == 1) {
            $this->fields = $iterator->current();
//            $this->post_getFromDB();
            return true;
        } else if (count($iterator) > 1) {
            trigger_error(
                sprintf(
                    'getFromDB expects to get one result, %1$s found in query "%2$s".',
                    count($iterator),
                    $iterator->getSql()
                ),
                E_USER_WARNING
            );
        }

        return false;
    }

    /**
     * Get the name of the index field
     *
     * @return string name of the index field
     **/
    public static function getIndexName()
    {
        return "id";
    }


    static function getConfig($key = '', $key2 = '')
    {
        $config = new PluginDlteamsConfig();
        $config->getFromDBByCrit(['entities_id' => 0]);

        if (isset($config->fields['id'])) {
            $config = importArrayFromDB($config->fields['config']);
            if (!empty($key)) {
                if (!empty($key2)) {
                    return $config[$key][$key2];
                } else {
                    return $config[$key];
                }
            } else {
                return $config;
            }
        } else {
            // get default config
            $default = PluginDlteamsConfig::getConfigDefault();

            if (!empty($key)) {
                if (!empty($key2)) {
                    return $default[$key][$key2];
                } else {
                    return $default[$key];
                }
            } else {
                return $default;
            }
        }
    }

    private function prepareJSON($input)
    {
        $array = [];
        foreach (PluginDlteamsConfig::getConfigDefault() as $key => $value) {
            $array[$key] = $input[$key];
            unset($input[$key]);
        }
        $input['config'] = exportArrayToDB($array);
        return $input;
    }

    function prepareInputForAdd($input)
    {
        $input = $this->prepareJSON($input);
        $input['users_id_creator'] = Session::getLoginUserID();
        return parent::prepareInputForAdd($input);
    }

    function prepareInputForUpdate($input)
    {
        $input = $this->prepareJSON($input);
        $input['users_id_lastupdater'] = Session::getLoginUserID();
        return parent::prepareInputForUpdate($input);
    }

    // dossier pour les fichiers export
    function prepareFolderExport()
    {
        $glpiRoot = str_replace('\\', '/', GLPI_ROOT);
        if (!file_exists($glpiRoot . "/files/_plugins/" . "dlteams" . "/")) {
            mkdir($glpiRoot . "/files/_plugins/" . "dlteams" . "/");
            chmod($glpiRoot . "/files/_plugins/" . "dlteams" . "/", 0310);
        }
        return parent::prepareFolderExport();
    }

    public static function canUpdate()
    {
        return true;
    }

    public function defineTabs($options = [])
    {

        $ong = [];
        $this->addStandardTab(__CLASS__, $ong, $options);

        return $ong;
    }


    public function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {

        if ($item->getType() == __CLASS__) {
            $tabs = [
                0 => __('Général'),
                2 => __('Import / Export, transferts'),
                3 => __('Opérations sur le plugin'),
                1 => __('Entité modèle'),
//                4 => __('Erreurs'),
            ];

            $activ_profil = $_SESSION['glpiactiveprofile']["id"];


            if ($activ_profil == 4) {
                $tabs[4] =  __('Erreurs');
            }
            return $tabs;
        }
        return '';
    }

    static function listFiles($accessToken) {
        $url = 'https://www.googleapis.com/drive/v3/files';
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Authorization: Bearer ' . $accessToken]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);
        $files = json_decode($response, true);

        return $files;
    }


    public function showGeneral(){
        global $DB;
        global $CFG_GLPI;

        if (!self::canUpdate()) {
            return;
        }

//        $this->getFromDBByCrit(['entities_id' => 0]);
        $config = self::getConfig();

        echo "<div class='center' width='50%'>";
        echo "<form method='post' action='./config.form.php'>";
        echo "<table class='tab_cadre' cellpadding='5' width='50%'>";
        echo "<tr>";
        echo "<th colspan='2'>" . __("Manage GDPR RoPA configuration", 'dlteams') . "</th>";
        echo "</tr>";

        date_default_timezone_set('Europe/Paris');

        if (date_default_timezone_get()) {
            echo 'date_default_timezone_set: ' . date_default_timezone_get() . '<br />';
        }

        if (ini_get('date.timezone')) {
            echo 'date.timezone: ' . ini_get('date.timezone');
        }

        echo "<tr>";
        echo "<td colspan='2' class='center b'>" . __("PDF creating configuration", 'dlteams') . "</td>";
        echo "</tr>";

        echo "<tr>";
        echo "<td>" . __("Codepage", 'dlteams') . "</td>";
        echo "<td>";

        Dropdown::showFromArray('print[codepage]', ['UTF-8', 'ISO-8859-1', 'ISO-8859-2'], [
            'value' => $config['print']['codepage']
        ]);
        echo "</td>";

        echo "<tr>";
        echo "<td>" . __("Font name", 'dlteams') . "</td>";
        echo "<td>";

        Dropdown::showFromArray('print[font_name]', $this->core_tcpdf_fonts, [
            'value' => $config['print']['font_name']
        ]);
        echo "</td>";

        echo "<tr>";
        echo "<td>" . __("Font size", 'dlteams') . "</td>";
        echo "<td>";

        Dropdown::showNumber('print[font_size]', [
            'value' => $config['print']['font_size'],
            'min' => 8,
            'max' => 16,
            'step' => 1,
            'unit' => 'pt',
        ]);
        echo "</td>";

        echo "<tr>";
        echo "<td>" . __("Margin left", 'dlteams') . "</td>";
        echo "<td>";

        Dropdown::showNumber('print[margin_left]', [
            'value' => $config['print']['margin_left'],
            'min' => 5,
            'max' => 50,
            'unit' => 'mm',
        ]);
        echo "</td>";

        echo "<tr>";
        echo "<td>" . __("Margin top", 'dlteams') . "</td>";
        echo "<td>";

        Dropdown::showNumber('print[margin_top]', [
            'value' => $config['print']['margin_top'],
            'min' => 5,
            'max' => 50,
            'unit' => 'mm',
        ]);
        echo "</td>";

        echo "<tr>";
        echo "<td>" . __("Margin right", 'dlteams') . "</td>";
        echo "<td>";

        Dropdown::showNumber('print[margin_right]', [
            'value' => $config['print']['margin_right'],
            'min' => 5,
            'max' => 50,
            'unit' => 'mm',
        ]);
        echo "</td>";

        echo "<tr>";
        echo "<td>" . __("Margin bottom", 'dlteams') . "</td>";
        echo "<td>";

        Dropdown::showNumber('print[margin_bottom]', [
            'value' => $config['print']['margin_bottom'],
            'min' => 5,
            'max' => 50,
            'unit' => 'mm',
        ]);
        echo "</td>";

        echo "<tr>";
        echo "<td>" . __("Header margin (from top)", 'dlteams') . "</td>";
        echo "<td>";

        Dropdown::showNumber('print[margin_header]', [
            'value' => $config['print']['margin_header'],
            'min' => 10,
            'max' => 30,
            'unit' => 'mm',
        ]);
        echo "</td>";

        echo "<tr>";
        echo "<td>" . __("Footer margin (from bottom)", 'dlteams') . "</td>";
        echo "<td>";

        Dropdown::showNumber('print[margin_footer]', [
            'value' => $config['print']['margin_footer'],
            'min' => 10,
            'max' => 30,
            'unit' => 'mm',
        ]);
        echo "</td>";

        echo "<tr>";
        echo "<td>" . __("Show logo", 'dlteams') . "</td>";
        echo "<td>";

        dropdown::showYesNo('print[logo_show]', $config['print']['logo_show']);
        echo "</td>";
        echo "</tr>";

        echo "<tr>";
        echo "<td>" . __("Logo image filename (located in /plugins/dlteams/images/)", 'dlteams') . "</td>";
        echo "<td>";

        echo "<input type='text' maxlength='254' name='print[logo_image]' value=\"" . $config['print']['logo_image'] . "\">";
        echo "</td>";
        echo "</tr>";

        echo "<tr class='tab_bg_1'>";
        echo "<td colspan='2'>";
        echo "<div class='center'>";

        echo "<input type='hidden' name='entities_id' value=\"" . 0 . "\">";

        $value = 0;
        if (isset($this->fields['id'])) {
            $value = $this->fields['id'];
        }
        echo "<input type='hidden' name='id' value=\"" . $value . "\">";

        if (isset($this->fields['id']) && $this->fields['id']) {
            $action = 'add';
        } else {
            $action = 'update';
        }


        echo "<input type='submit' name='" . $action . "' value=\"" . _sx('button', 'Save') . "\" class='submit'>";
        echo "</div>";
        echo "</td>";
        echo "</tr>";
        echo "</table>";
        Html::closeForm();
        echo "</div>";
        echo "<br><br>";
    }

//    old version
//    public function showImportExport(){
//        echo "<table class='tab_cadre' cellpadding='5' width='50%'>";
//        echo "<tr>";
//        echo "<th colspan='2'><center>" . __("Importation de données", 'dlteams') . "</th>";
//        echo "</tr>";
//
//        echo "<form method='post'  action='./import_m365.php' enctype='multipart/form-data'>";
//        echo "<tr class='tab_bg_1'>";
//        echo "<td>" . __("Sélectionner le fichier .csv issu de l'export Entra Id", 'dlteams') . "</td>";
//        echo "<td>";
//
//        echo "<tr class='tab_bg_1'>";
//        echo "<td>" . __('Choose a file', 'datainjection') . "</td>";
//        echo "<td><input type='file' name='filename'>";
//        echo "<input type='hidden' name='id' value='"."'>";
//        echo "</td></tr>";
//        echo "<td>";
//        // echo "<th colspan='2'>".sprintf(__('%1$s: %2$s'), __('Model'), $model->fields['name'])."</th>";
//        if ($_SERVER["REQUEST_METHOD"] == "POST") {
//            // Vérifier si un fichier a été téléchargé
//            if(isset($_FILES['filename']) && $_FILES['filename']['error'] == UPLOAD_ERR_OK) {
//                // Récupérer le nom du fichier
//                $filename = $_FILES['filename']['name'];
//                // Afficher le nom du fichier
//                echo "Nom du fichier choisi : " . $filename;
//            } else {
//                // Si aucun fichier n'a été téléchargé ou s'il y a une erreur
//                echo "Aucun fichier sélectionné ou une erreur est survenue lors du téléchargement.";
//            }
//        }
//        // var_dump ($filename);die;
//        //echo "<input type='file' id='ctrl' name='files_to_import[]' placeholder='Choisissez un dossier' webkitdirectory directory multiple/>";
//        echo "</td> </tr>";
//
//        echo "<td>" . __("Indiquer l'entité cible", 'dlteams') . "</td>";
//        echo "<td>";
//        Entity::dropdown(['name' => 'entities_id_target', 'width' => '250px']);
//        echo "</td> </tr>";
//
//        echo "<tr class='tab_bg_1'> <td colspan='2'> <div class='center'>";
//        echo "<input type='submit' name='import_m365' value=\"" . __("Importer des utilisateurs", 'dlteams') . "\" class='submit'>";
//        echo "</div></td></tr>";
//        Html::closeForm();
//
//
//        echo "<form method='post' action='../front/fork.php'>";
//        echo "<tr class='tab_bg_1'> ";
//        echo "<td colspan='2'> <div class='center'>";
//        echo "<input type='submit' name='migrate_profiles' value=\"" . __("Importation des profils de l'entité Root", 'dlteams') . "\" class='submit'>";
//        echo "</div> </td> </tr>";
//        Html::closeForm();
//
//        ///////////////////////////////////////////Transfert massif de données entre entités
//        echo "<table class='tab_cadre' cellpadding='5' width='50%'>";
//        echo "<tr>";
//        echo "<th colspan='2'><center>" . __("Transfert massif de données entre entités", 'dlteams') . "</th>";
//        echo "</tr>";
//
//        // duplicate records from an entity to an other
//        echo "<tr class='tab_bg_1'> <td colspan='2'><strong>" . __("Copier l'ensemble des traitements + les éléments liés", 'dlteams') . "</strong></td> </tr>";
//
//        // exporter les traitements
//        echo "<form method='post' action='./export_recordsrgpd.php'>";
//        echo "<tr class='tab_bg_1'>";
//        echo "<td>" . __("Sélectionner l'entité à exporter", 'dlteams') . "</td>";
//        echo "<td>";
//        Entity::dropdown(['name' => 'entities_id_origin', 'width' => '250px']) . "</td>";
////        $entities_id_origin = "origin";
//        echo "</td> </tr>";
//        echo "<td>" . __("Indiquer le dossier cible", 'dlteams') . "</td>";
//        echo "<td>";
//        Link::dropdown(['name' => 'folder_id_target', 'width' => '250px']);
////        $folder_id_target = "target";
//        echo "</td> </tr>";
//        echo "<tr class='tab_bg_1'> <td colspan='2'> <div class='center'>";
//        echo "<input type='submit' name='export_recordsrgpd' value=\"" . __("Exporter Traitements", 'dlteams') . "\" class='submit'>";
//        echo "</div></td></tr>";
//        Html::closeForm();
//
//        // importer les traitements
//        echo "<form method='post'  action='./import_recordsrgpd.php' enctype='multipart/form-data'>";
//        echo "<tr class='tab_bg_1'>";
//        echo "<td>" . __("Sélectionner le dossier source", 'dlteams') . "</td>";
//        echo "<td>";
//        echo "<input type='file' id='ctrl' name='files_to_import[]' placeholder='Choisissez un dossier' webkitdirectory directory multiple/>";
//
//        echo "</td> </tr>";
//        echo "<td>" . __("Indiquer l'entité cible", 'dlteams') . "</td>";
//        echo "<td>";
//        Entity::dropdown(['name' => 'entities_id_target', 'width' => '250px']);
//
//        echo "</td> </tr>";
//        echo "<tr class='tab_bg_1'> <td colspan='2'> <div class='center'>";
////        echo "<input type='submit' name='import_recordsrgpd' value=\"" . __("Importer Traitements", 'dlteams') . "\" class='submit'>";
//        echo "</div></td></tr>";
//        Html::closeForm();
//
//
//        // duplicate a project from an entity to an other
//        echo "<form method='post' action='./import_projectrgpd_model.php'>";
//        echo "<tr class='tab_bg_1'>";
//        echo "<td colspan='2'><strong>" . __("Copier un projet, les tâches et événements liés)", 'dlteams') . "</strong></td>";
//        echo "</tr>";
//        echo "<tr class='tab_bg_1'>";
//        echo "<td>" . __("Sélectionner le projet source ", 'dlteams') . "</td>";
//        echo "<td>";
//        Project::dropdown(['name' => 'projects_id', 'width' => '250px']);
//        echo "</td>";
//        echo "<tr class='tab_bg_1'> <td>" . __("Indiquer l'entité cible", 'dlteams') . "</td>";
//        echo "<td>";
//        Entity::dropdown(['name' => 'entities_id', 'width' => '250px']);
//        echo "</td></tr>";
//        echo "<tr class='tab_bg_1'> <td colspan='2'> <div class='center'>";
//        echo "<input type='submit' name='import_project' value=\"" . __("Copier Projet", 'dlteams') . "\" class='submit'>";
//        echo "</div></td></tr>";
//        Html::closeForm();
//
//
//
//
//
//        // duplicate forms from an entity to an other
//
//
//        echo "<form method='post' action='./import_forms.php'>";
//        echo "<tr class='tab_bg_1'>";
//        echo "<td colspan='2'><strong>" . __("Copier les formulaires", 'dlteams') . "</strong></td>";
//        echo "</tr>";
//        echo "<tr class='tab_bg_1'>";
//        echo "<td>" . __("Indiquer l'entité modèle", 'dlteams') . "</td>";
//        echo "<td>";
//        Entity::dropdown(['name' => 'entities_id_origin', 'width' => '250px']);
//        echo "</td>";
//        echo "</tr>";
//        echo "<td>" . __("Indiquer l'entité cible", 'dlteams') . "</td>";
//        echo "<td>";
//        Entity::dropdown(['name' => 'entities_id_target', 'width' => '250px']);
//        echo "</td>";
//        echo "<tr class='tab_bg_1'>";
//        echo "<td colspan='2'> <div class='center'>";
////        echo "<input type='submit' name='copyto_forms' value=\"" . __("Copier Formulaires", 'dlteams') . "\" class='submit'>";
//        echo "</div></td></tr>";
//        Html::closeForm();
//
//        echo "<form method='post' action='./import_deliverables.php'>";
//        echo "<tr class='tab_bg_1'>";
//        echo "<td colspan='2'><strong>" . __("Copier les livrables", 'dlteams') . "</strong></td>";
//        echo "</tr>";
//        echo "<tr class='tab_bg_1'>";
//        echo "<td>" . __("Indiquer l'entité modèle", 'dlteams') . "</td>";
//        echo "<td>";
//        Entity::dropdown(['name' => 'entities_id_origin', 'width' => '250px']);
//        echo "</td>";
//        echo "</tr>";
//        echo "<td>" . __("Indiquer l'entité cible", 'dlteams') . "</td>";
//        echo "<td>";
//        Entity::dropdown(['name' => 'entities_id_target', 'width' => '250px']);
//        echo "</td>";
//        echo "<tr class='tab_bg_1'>";
//        echo "<td colspan='2'> <div class='center'>";
////        echo "<input type='submit' name='import_deliverables' value=\"" . __("Copier Livrables", 'dlteams') . "\" class='submit'>";
//        echo "</div></td></tr>";
//        Html::closeForm();
//        echo "</table>";
//
////      echo "<form method='post' action='./config.form.php'>";
//        echo "<form method='post' action='#'>";
//
//        echo "<table class='tab_cadre' cellpadding='5' width='50%'>";
//        echo "<tr class='tab_bg_1'>";
//        echo "<td colspan='2'><strong>" . __("Copier les données de l'entité modèle dans l'entité actuelle", 'dlteams') . "</strong></td>";
//        echo "</tr>";
//
//        echo "<tr class='tab_bg_1'>";
//        echo "<td>" . __("Categories of data subjects", 'dlteams') . "</td>";
//        echo "<td>";
//        Html::showCheckbox(['name' => 'install_categories_of_data_subjects', 'title' => __("Categories of data subjects", 'dlteams'), 'checked' => 0]);
//        echo "</td> </tr>";
//
//        echo "<tr class='tab_bg_1'>";
//        echo "<td>" . __("Legal bases", 'dlteams') . "</td>";
//        echo "<td>";
//        Html::showCheckbox(['name' => 'install_legal_bases', 'title' => __("Legal bases", 'dlteams'), 'checked' => 0]);
//        echo "</td> </tr>";
//
//        echo "<tr class='tab_bg_1'>";
//        echo "<td>" . __("Security measures", 'dlteams') . "</td>";
//        echo "<td>";
//        Html::showCheckbox(['name' => 'install_security_measures', 'title' => __("Security measures", 'dlteams'), 'checked' => 0]);
//        echo "</td> </tr>";
//
//        echo "<tr class='tab_bg_1'>";
//        echo "<td>" . __("Contract types", 'dlteams') . "</td>";
//        echo "<td>";
//        Html::showCheckbox(['name' => 'install_contract_types', 'title' => __("Contract types", 'dlteams'), 'checked' => 0]);
//        echo "</td> </tr>";
//
//        echo "<tr class='tab_bg_1'>";
//        echo "<td>" . __("Personal data types", 'dlteams') . "</td>";
//        echo "<td>";
//        Html::showCheckbox(['name' => 'install_personal_data_types', 'title' => __("Personal data types", 'dlteams'), 'checked' => 0]);
//        echo "</td> </tr>";
//
//        echo "<tr class='tab_bg_1'>";
//        echo "<td>" . __("Référentiel (projet Conformité RGPD)", 'dlteams') . "</td>";
//        echo "<td>";
//        Html::showCheckbox(['name' => 'import_project', 'title' => __("Référentiel", 'dlteams'), 'checked' => 0]);
//        echo "</td> </tr>";
//
//        echo "<tr class='tab_bg_1'> ";
//        echo "<td colspan='2'> <div class='center'>";
//        echo "<input type='submit' name='sampledata' value=\"" . __("Importer les données", 'dlteams') . "\" class='submit'>";
//        echo "</div> </td> </tr>";
//
//        echo "</table>";
//        Html::closeForm();
//
//    }


    public function showImportExport() {
        // -------------------------
        // Section : Importation de données
        // -------------------------
//        echo "<table class='tab_cadre' cellpadding='5' width='50%'>";
//        echo "<tr>";
//        echo "<th colspan='2'><center>" . __("Importation de données", 'dlteams') . "</center></th>";
//        echo "</tr>";
//
//        // Formulaire : Importer des utilisateurs
//        echo "<form method='post' action='./import_m365.php' enctype='multipart/form-data'>";
//        echo "<tr class='tab_bg_1'>";
//        echo "<td>" . __("Sélectionner le fichier .csv issu de l'export Entra Id", 'dlteams') . "</td>";
//        echo "<td>";
//        echo "<input type='file' name='filename'>";
//        echo "<input type='hidden' name='id' value=''>";
//        echo "</td>";
//        echo "</tr>";
//
//        echo "<tr class='tab_bg_1'>";
//        echo "<td>" . __('Choose a file', 'datainjection') . "</td>";
//        echo "<td>";
//        echo "<input type='file' name='filename'>";
//        echo "<input type='hidden' name='id' value=''>";
//        echo "</td>";
//        echo "</tr>";
//
//        echo "<tr class='tab_bg_1'>";
//        echo "<td colspan='2'>";
//        if ($_SERVER["REQUEST_METHOD"] == "POST") {
//            if (isset($_FILES['filename']) && $_FILES['filename']['error'] == UPLOAD_ERR_OK) {
//                $filename = $_FILES['filename']['name'];
//                echo "Nom du fichier choisi : " . $filename;
//            } else {
//                echo "Aucun fichier sélectionné ou une erreur est survenue lors du téléchargement.";
//            }
//        }
//        echo "</td>";
//        echo "</tr>";
//
//        echo "<tr class='tab_bg_1'>";
//        echo "<td>" . __("Indiquer l'entité cible", 'dlteams') . "</td>";
//        echo "<td>";
//        Entity::dropdown(['name' => 'entities_id_target', 'width' => '250px']);
//        echo "</td>";
//        echo "</tr>";
//
//        echo "<tr class='tab_bg_1'>";
//        echo "<td colspan='2'><div class='center'>";
//        echo "<input type='submit' name='import_m365' value=\"" . __("Importer des utilisateurs", 'dlteams') . "\" class='submit'>";
//        echo "</div></td>";
//        echo "</tr>";
//        Html::closeForm();

        // Formulaire : Importation des profils de l'entité Root
        echo "<form method='post' action='../front/fork.php'>";
        echo "<tr class='tab_bg_1'>";
        echo "<td colspan='2'><div class='center'>";
        echo "<input type='submit' name='migrate_profiles' value=\"" . __("Importation des profils de l'entité Root", 'dlteams') . "\" class='submit'>";
        echo "</div></td>";
        echo "</tr>";
        Html::closeForm();
        echo "</table>";

        // -------------------------
        // Section : Transfert massif de données entre entités
        // -------------------------
        echo "<table class='tab_cadre' cellpadding='5' width='50%'>";
        echo "<tr>";
        echo "<th colspan='2'><center>" . __("Transfert massif de données entre entités", 'dlteams') . "</center></th>";
        echo "</tr>";

        // Duplication des traitements et éléments liés
        echo "<tr class='tab_bg_1'>";
        echo "<td colspan='2'><strong>" . __("Copier l'ensemble des traitements + les éléments liés", 'dlteams') . "</strong></td>";
        echo "</tr>";

        // Formulaire : Exporter les traitements
        echo "<form method='post' action='./export_recordsrgpd.php'>";
        echo "<tr class='tab_bg_1'>";
        echo "<td>" . __("Sélectionner l'entité à exporter", 'dlteams') . "</td>";
        echo "<td>";
        Entity::dropdown(['name' => 'entities_id_origin', 'width' => '250px']);
        echo "</td>";
        echo "</tr>";
        echo "<tr class='tab_bg_1'>";
        echo "<td>" . __("Indiquer le dossier cible", 'dlteams') . "</td>";
        echo "<td>";
        Link::dropdown(['name' => 'folder_id_target', 'width' => '250px']);
        echo "</td>";
        echo "</tr>";
        echo "<tr class='tab_bg_1'>";
        echo "<td colspan='2'><div class='center'>";
        echo "<input type='submit' name='export_recordsrgpd' value=\"" . __("Exporter Traitements", 'dlteams') . "\" class='submit'>";
        echo "</div></td>";
        echo "</tr>";
        Html::closeForm();

        // Formulaire : Importer les traitements (dossier source)
        echo "<form method='post' action='./import_recordsrgpd.php' enctype='multipart/form-data'>";
        echo "<tr class='tab_bg_1'>";
        echo "<td>" . __("Sélectionner le dossier source", 'dlteams') . "</td>";
        echo "<td>";
        echo "<input type='file' id='ctrl' name='files_to_import[]' placeholder='Choisissez un dossier' webkitdirectory directory multiple/>";
        echo "</td>";
        echo "</tr>";
        echo "<tr class='tab_bg_1'>";
        echo "<td>" . __("Indiquer l'entité cible", 'dlteams') . "</td>";
        echo "<td>";
        Entity::dropdown(['name' => 'entities_id_target', 'width' => '250px']);
        echo "</td>";
        echo "</tr>";
        echo "<tr class='tab_bg_1'>";
        echo "<td colspan='2'><div class='center'>";
        // Le bouton de soumission est commenté dans le code d'origine
        // echo "<input type='submit' name='import_recordsrgpd' value=\"" . __("Importer Traitements", 'dlteams') . "\" class='submit'>";
        echo "</div></td>";
        echo "</tr>";
        Html::closeForm();

        // Formulaire : Dupliquer un projet (avec tâches et événements liés)
        echo "<form method='post' action='./import_projectrgpd_model.php'>";
        echo "<tr class='tab_bg_1'>";
        echo "<td colspan='2'><strong>" . __("Copier un projet, les tâches et événements liés", 'dlteams') . "</strong></td>";
        echo "</tr>";
        echo "<tr class='tab_bg_1'>";
        echo "<td>" . __("Sélectionner le projet source", 'dlteams') . "</td>";
        echo "<td>";
        Project::dropdown(['name' => 'projects_id', 'width' => '250px']);
        echo "</td>";
        echo "</tr>";
        echo "<tr class='tab_bg_1'>";
        echo "<td>" . __("Indiquer l'entité cible", 'dlteams') . "</td>";
        echo "<td>";
        Entity::dropdown(['name' => 'entities_id', 'width' => '250px']);
        echo "</td>";
        echo "</tr>";
        echo "<tr class='tab_bg_1'>";
        echo "<td colspan='2'><div class='center'>";
        echo "<input type='submit' name='import_project' value=\"" . __("Copier Projet", 'dlteams') . "\" class='submit'>";
        echo "</div></td>";
        echo "</tr>";
        Html::closeForm();

        // Formulaire : Dupliquer les formulaires
        echo "<form method='post' action='./import_forms.php'>";
        echo "<tr class='tab_bg_1'>";
        echo "<td colspan='2'><strong>" . __("Copier les formulaires", 'dlteams') . "</strong></td>";
        echo "</tr>";
        echo "<tr class='tab_bg_1'>";
        echo "<td>" . __("Indiquer l'entité modèle", 'dlteams') . "</td>";
        echo "<td>";
        Entity::dropdown(['name' => 'entities_id_origin', 'width' => '250px']);
        echo "</td>";
        echo "</tr>";
        echo "<tr class='tab_bg_1'>";
        echo "<td>" . __("Indiquer l'entité cible", 'dlteams') . "</td>";
        echo "<td>";
        Entity::dropdown(['name' => 'entities_id_target', 'width' => '250px']);
        echo "</td>";
        echo "</tr>";
        echo "<tr class='tab_bg_1'>";
        echo "<td colspan='2'><div class='center'>";
        // Bouton de soumission commenté dans le code d'origine
        // echo "<input type='submit' name='copyto_forms' value=\"" . __("Copier Formulaires", 'dlteams') . "\" class='submit'>";
        echo "</div></td>";
        echo "</tr>";
        Html::closeForm();

        // Formulaire : Dupliquer les livrables
        echo "<form method='post' action='./import_deliverables.php'>";
        echo "<tr class='tab_bg_1'>";
        echo "<td colspan='2'><strong>" . __("Copier les livrables", 'dlteams') . "</strong></td>";
        echo "</tr>";
        echo "<tr class='tab_bg_1'>";
        echo "<td>" . __("Indiquer l'entité modèle", 'dlteams') . "</td>";
        echo "<td>";
        Entity::dropdown(['name' => 'entities_id_origin', 'width' => '250px']);
        echo "</td>";
        echo "</tr>";
        echo "<tr class='tab_bg_1'>";
        echo "<td>" . __("Indiquer l'entité cible", 'dlteams') . "</td>";
        echo "<td>";
        Entity::dropdown(['name' => 'entities_id_target', 'width' => '250px']);
        echo "</td>";
        echo "</tr>";
        echo "<tr class='tab_bg_1'>";
        echo "<td colspan='2'><div class='center'>";
        // Bouton de soumission commenté dans le code d'origine
        // echo "<input type='submit' name='import_deliverables' value=\"" . __("Copier Livrables", 'dlteams') . "\" class='submit'>";
        echo "</div></td>";
        echo "</tr>";
        Html::closeForm();
        echo "</table>";

        // -------------------------
        // Section : Copier les données de l'entité modèle dans l'entité actuelle
        // -------------------------
        echo "<form method='post' action='#'>";
        echo "<table class='tab_cadre' cellpadding='5' width='50%'>";
        echo "<tr class='tab_bg_1'>";
        echo "<td colspan='2'><strong>" . __("Copier les données de l'entité modèle dans l'entité actuelle", 'dlteams') . "</strong></td>";
        echo "</tr>";

        echo "<tr class='tab_bg_1'>";
        echo "<td>" . __("Categories of data subjects", 'dlteams') . "</td>";
        echo "<td>";
        Html::showCheckbox([
            'name'    => 'install_categories_of_data_subjects',
            'title'   => __("Categories of data subjects", 'dlteams'),
            'checked' => 0
        ]);
        echo "</td>";
        echo "</tr>";

        echo "<tr class='tab_bg_1'>";
        echo "<td>" . __("Legal bases", 'dlteams') . "</td>";
        echo "<td>";
        Html::showCheckbox([
            'name'    => 'install_legal_bases',
            'title'   => __("Legal bases", 'dlteams'),
            'checked' => 0
        ]);
        echo "</td>";
        echo "</tr>";

        echo "<tr class='tab_bg_1'>";
        echo "<td>" . __("Security measures", 'dlteams') . "</td>";
        echo "<td>";
        Html::showCheckbox([
            'name'    => 'install_security_measures',
            'title'   => __("Security measures", 'dlteams'),
            'checked' => 0
        ]);
        echo "</td>";
        echo "</tr>";

        echo "<tr class='tab_bg_1'>";
        echo "<td>" . __("Contract types", 'dlteams') . "</td>";
        echo "<td>";
        Html::showCheckbox([
            'name'    => 'install_contract_types',
            'title'   => __("Contract types", 'dlteams'),
            'checked' => 0
        ]);
        echo "</td>";
        echo "</tr>";

        echo "<tr class='tab_bg_1'>";
        echo "<td>" . __("Personal data types", 'dlteams') . "</td>";
        echo "<td>";
        Html::showCheckbox([
            'name'    => 'install_personal_data_types',
            'title'   => __("Personal data types", 'dlteams'),
            'checked' => 0
        ]);
        echo "</td>";
        echo "</tr>";

        echo "<tr class='tab_bg_1'>";
        echo "<td>" . __("Référentiel (projet Conformité RGPD)", 'dlteams') . "</td>";
        echo "<td>";
        Html::showCheckbox([
            'name'    => 'import_project',
            'title'   => __("Référentiel", 'dlteams'),
            'checked' => 0
        ]);
        echo "</td>";
        echo "</tr>";

        echo "<tr class='tab_bg_1'>";
        echo "<td colspan='2'><div class='center'>";
        echo "<input type='submit' name='sampledata' value=\"" . __("Importer les données", 'dlteams') . "\" class='submit'>";
        echo "</div></td>";
        echo "</tr>";
        echo "</table>";
        Html::closeForm();
    }

    public function showEntiteModel(){

        if (plugin_dlteams_root == "/var/www/html/dlteams_app/marketplace/dlteams" or plugin_dlteams_root == "/var/www/html/model_dlteams_app/marketplace/dlteams") {
            $mandatory_sites = 1;
        } else {
            $mandatory_sites = 0;
        }
        global $DB;
        $activ_profil = $_SESSION['glpiactiveprofile']["id"];
        if ($activ_profil == 4) {
            echo "<table class='tab_cadrehov table-striped table-hover' style='width: 50%'>";
            echo "<tr><th colspan='5'><center>" . __("Opérations sur l'entité modèle (model-rgpd)") . "</th></tr>";

            // if no model-rgpd then purpose création
            $currententity_id = intval(Session::getActiveEntity()); // id of current entity
            $result = $DB->query('SELECT * FROM `glpi_entities` WHERE `name` = "model-rgpd"');
            $rgpdmodel_id = 0;
            if ($result && $DB->numrows($result) > 0) {
                $data = $DB->fetchAssoc($result);
                $rgpdmodel_id = $data['id'];
            } // on a l'id de model-rgpd
            echo "<tr class='tab_bg_1'>";
            echo "<td colspan='2'>" . __("Créer l'entité model-rgpd", 'dlteams') . "</td>";
            echo "</tr>";
            if ($rgpdmodel_id == 0) { // si rgpd_model existe
                echo "<tr class='tab_bg_1'>";
                echo "<td colspan='2'>";
                echo "<div style='display: flex; gap: 6px; width: 100%; justify-content: center; align-items: center;' class='center'>";
                echo "<form method='post' action='./config.form.php' ><input type='submit' name='create_modelrgpd' value=\"" . __("Créer", 'dlteams') . "\" class='submit'>";
                Html::closeForm();
                echo "</tr>";
            }
            echo "<tr class='tab_bg_1'> ";
            echo "<td colspan='2' ><height='250px'><strong><center>" . __("Importer les données du plug'in vers l'entité rgpd-model", 'dlteams') . "</strong></td>";
            echo "</tr>";
            // import untitled
            echo "<tr class='tab_bg_1'> <td colspan='2'>" . __("Importer les intitulés conformité RGPD", 'dlteams') . "</td>";
            echo "<td colspan='2'>" . "<div style='display: flex; gap: 6px; width: 100%; justify-content: right; align-items: center;' class='right'>";
            if ($rgpdmodel_id <> 0 && $mandatory_sites == 0) {
                echo "<form method='post' action='./import_rgpduntitled.php'><input type='submit' name='migrate' value=\"" . __("Importer les intitulés", 'dlteams') . "\" class='submit'>";
                Html::closeForm();
            }
            // import de toutes les tables traitements et tables liées
            echo "<tr class='tab_bg_1'>";
            echo "<td colspan='2'>" . __("Importer et mettre à jour toutes les tables RGPD (traitements, bases légales, etc...)", 'dlteams') . "</td>";
            echo "<td colspan='2'>" . "<div style='display: flex; gap: 6px; width: 100%; justify-content: right; align-items: center;' class='center'>";
            if ($rgpdmodel_id <> 0 && $mandatory_sites == 0) {
                echo "<form method='post' action='./import_allrgpd_model.php'><input type='submit' name='migrate' value=\"" . __("RAZ et import des tables", 'dlteams') . "\" class='submit'>";
                Html::closeForm();
            }
            if ($rgpdmodel_id <> 0 && $mandatory_sites == 0) {
                echo "<form method='post' action='./update_allrgpd_model.php'><input type='submit' name='migrate' value=\"" . __("Mise à jour des tables", 'dlteams') . "\" class='submit'>";
                Html::closeForm();
            }
            echo "</tr>";
            // import model-rgpd project
            // if ($rgpdmodel_id <> 0 && plugin_dlteams_root <> "/var/www/model_dlteams_app/marketplace/dlteams") {
            echo "<tr class='tab_bg_1'> <td colspan='2'>" . __("Importer (ou effacer et ré-importer) le projet \"Conformité RGPD\"", 'dlteams') . "</td>";
            echo "<td colspan='2'>" . "<div style='display: flex; gap: 6px; width: 100%; justify-content: right; align-items: center;' class='center'>";
            if ($rgpdmodel_id <> 0 && $mandatory_sites == 0) {
                echo "<form method='post' action='./import_projectrgpd_model.php'><input type='submit' name='migrate' value=\"" . __("Import du référentiel de l'entité modèle", 'dlteams') . "\" class='submit'>";
                Html::closeForm();
            }
            echo "</tr>";
            // import forms
            echo "<tr class='tab_bg_1'> <td colspan='2'>" . __("Importer les formulaires de model-rgpd", 'dlteams') . "</td>";
            echo "<td colspan='2'>" . "<div style='display: flex; gap: 6px; width: 100%; justify-content: right; align-items: center;' class='center'>";
            if ($rgpdmodel_id <> 0 && $mandatory_sites == 0) {
                echo "<form method='post' action='./import_formrgpd_model.php'><input type='submit' name='migrate' value=\"" . __("Import des formulaires de l'entité modèle", 'dlteams') . "\" class='submit'>";
                Html::closeForm();
            }
            echo "</tr>";
            // import knowledge base
            echo "<tr class='tab_bg_1'> <td colspan='2'>" . __("Importer la base de connaissance de l'entité modèle", 'dlteams') . "</td>";
            echo "<td colspan='2'>" . "<div style='display: flex; gap: 6px; width: 100%; justify-content: right; align-items: center;' class='center'>";
            if ($rgpdmodel_id <> 0 && $mandatory_sites == 0) {
                echo "<form method='post' action='./import_knowledgergpd_model.php'><input type='submit' name='migrate' value=\"" . __("Importer la base de connaissance de l'entité modèle", 'dlteams') . "\" class='submit'>";
                Html::closeForm();
            }
            echo "</tr>";

            // Export datas from model-rgpd entity to "/install/datas/" when root = dlteams_app
            echo "<td></td>";
            echo "<tr class='noHover'><th colspan='2' >" . __("Exporter les données de l'entité model-rgpd vers le plug'in", 'dlteams') . "</th></tr>";

            // Export records objects
            echo "<td>" . __("Exporter les données de l'entité rgpd-model ainsi que leurs éléments liés", 'dlteams') . "</td>";
            echo "<td colspan='2'> <div class='left'>";
            if ($mandatory_sites == 1) {
                echo "<form method='post' action='./export_allrgpd_model.php'><input type='submit' name='export_allrgpd_model' value=\"" . __("Exporter tous les objets et éléments liés", 'dlteams') . "\" class='submit'>";
                Html::closeForm();
            }
            echo "</td></tr>";
            // Export untitled
            echo "<tr class='tab_bg_1'>" . "<td>" . __("Exporter intitulés", 'dlteams') . "</td>";
            echo "<td colspan='2'> <div class='left'>";
            if ($mandatory_sites == 1) {
                echo "<form method='post' action='./export_rgpduntitled.php'><input type='submit' name='export_rgpduntitled' value=\"" . __("Exporter les intitulés", 'dlteams') . "\" class='submit'>";
                Html::closeForm();
            }
            echo "</td></tr>";

            // Export Project
            echo "<tr class='tab_bg_1'>";
            echo "<td>" . __("Exporter le projet \"conformité RGPD\" (+ tâches & actions)", 'dlteams') . "</td>";
            echo "<td colspan='2'> <div class='left'>";
            if ($mandatory_sites == 1) {
                echo "<form method='post' action='./export_projectrgpd_model.php'><input type='submit' name='export_project' value=\"" . __("Exporter Projet", 'dlteams') . "\" class='submit'>";
                Html::closeForm();
            }
            echo "</td></tr>";
            // Export Forms
            echo "<tr class='tab_bg_1'>" . "<td>" . __("Exporter les formulaires", 'dlteams') . "</td>";
            echo "<td colspan='2'> <div class='left'>";
            if ($mandatory_sites == 1) {
                echo "<form method='post' action='./export_formrgpd_model.php'><input type='submit' name='export_form' value=\"" . __("Exporter Formulaires", 'dlteams') . "\" class='submit'>";
                Html::closeForm();
            }
            echo "</td></tr>";
            // Export Knowledge base
            echo "<tr class='tab_bg_1'>" . "<td>" . __("Exporter la base de connaissances", 'dlteams') . "</td>";
            echo "<td colspan='2'> <div class='left'>";
            if ($mandatory_sites == 1) {
                echo "<form method='post' action='./export_knowledgergpd_model.php'><input type='submit' name='export_knowledge' value=\"" . __("Exporter Base de connaissance", 'dlteams') . "\" class='submit'>";
                Html::closeForm();
            }
            echo "</td></tr>";

            // Export records objects
            echo "<tr class='tab_bg_1'>";
            echo "<td>" . __("Exporter les livrables de l'entité rgpd-model", 'dlteams') . "</td>";
            echo "<td colspan='2'> <div class='left'>";
            if ($mandatory_sites == 1) {
                echo "<form method='post' action='./export_deliverablergpd_model.php'><input type='submit' name='export_deliverablergpd_model' value=\"" . __("Export des livrables", 'dlteams') . "\" class='submit'>";
                Html::closeForm();
            }
            echo "</td></tr>";

            echo "<td></td>";
        }
    }


    public function showUpdateSection(){

        global $DB;
        if (plugin_dlteams_root == "/var/www/dlteams_app/marketplace/dlteams" or plugin_dlteams_root == "/var/www/model_dlteams_app/marketplace/dlteams") {
            $mandatory_sites = 1;
        } else {
            $mandatory_sites = 0;
        }
        $result = $DB->query('SELECT * FROM `glpi_entities` WHERE `name` = "model-rgpd"');
        $rgpdmodel_id = 0;
        if ($result && $DB->numrows($result) > 0) {
            $data = $DB->fetchAssoc($result);
            $rgpdmodel_id = $data['id'];
        }

        echo "<table class='tab_cadrehov table-striped table-hover' style='width: 50%'>";
        echo  "<tr class='noHover'><th colspan='2' >" . __("Suppression et nettoyage", 'dlteams') . "</th></tr>";
        echo "<tr class='tab_bg_1'>";
        echo "<td colspan='2'>" . __("Supprimer l'entité model-rgpd et toutes ses données", 'dlteams') . "</td>";
        echo "<td colspan='2'> <div style='display: flex; gap: 6px; width: 100%; justify-content: right; align-items: center;' class='center'>";
        // si rgpd_model existe
        if ($rgpdmodel_id <> 0 && $mandatory_sites == 0) {
            echo "<form method='post' action='./config.form.php'><input type='submit' name='delete_modelrgpd' value=\"" . __("Supprimer rgpd-model", 'dlteams') . "\" class='submit'>";
            Html::closeForm();
        }
        echo "</div></td>";
        echo "</tr>";

        echo "<tr class='tab_bg_1'>";
        echo "<td colspan='2'>" . __("Supprimer les _items orphelins", 'dlteams') . "</td>";
        echo "<td colspan='2'> <div class='right'>";
        //if ($mandatory_sites == 1) {
        echo "<form method='post' action='./clean_items.php'><input type='submit' name='clean_items' value=\"" . __("Nettoyage _items", 'dlteams') . "\" class='submit'>";
        Html::closeForm();
        //}
        echo "</div></td></tr>";


        echo "<tr class='tab_bg_1'>";
        echo "<td colspan='2'>" . __("Rejouer les updates sql", 'dlteams') . "</td>";
        echo "<td colspan='2'> <div class='right'>";
        echo "<form method='post' action='./config.form.php'><input type='submit' name='update_database' value=\"" . __("Executer SQL", 'dlteams') . "\" class='submit'>";
        Html::closeForm();
        echo "</div></td></tr>";



        $httpClient = new Guzzle_Client();
        try {
            $request = new \GuzzleHttp\Psr7\Request('GET', 'https://update.dlteams.app/plugin/versions');
            $response = $httpClient->sendAsync($request)->wait();
            $versionsData = json_decode($response->getBody()->getContents(), true);

            if (json_last_error() !== JSON_ERROR_NONE || !isset($versionsData["versions"]) || !is_array($versionsData["versions"])) {
                return; // Ne rien afficher si la réponse est invalide
            }

            $remoteVersions = array_column($versionsData["versions"], 'version');
            if (empty($remoteVersions)) {
                return;
            }

            usort($remoteVersions, 'version_compare');
            $latestVersion = end($remoteVersions);

            $plugin = new Plugin();
            if (!$plugin->getFromDBbyDir("dlteams")) {
                return; // Plugin non trouvé
            }
            $currentVersion = $plugin->fields["version"];

            if (version_compare($currentVersion, $latestVersion, '<')) {
                if (self::canUpdatePlugin()) {
                    self::displayUpdateAvailableRow($latestVersion);
                } else {
                    self::displayPrerequisiteErrorRow();
                }
            } else {
                self::displayUpToDateRow($currentVersion);
            }

        } catch (\GuzzleHttp\Exception\RequestException $e) {
            self::displayConnectionErrorRow();
        }



        echo "</table>";
        echo "<br/><br/><br/>";


        // profil N°4 = super-admin
        $activ_profil = $_SESSION['glpiactiveprofile']["id"];


        if ($activ_profil == 4) {
            echo "<form method='post' action='./fork.php'>";
            // Copier les fichiers des dossiers fork et whitelabel
            echo "<table class='tab_cadre' cellpadding='5' width='50%'>";
            echo "<tr>";
            echo "<th colspan='2'> <center>" . __("Implémenter Fork et WhiteLabel", 'dlteams') . "</th>";
            echo "</tr>";

            // echo "<form method='post' action=\"" . Html::showSimpleForm(static::getFormURL(),'test_ldap_replicate',_sx('button', 'Test'),['champ1', 'champ2']) . "\">";
            // echo "<form method='post' action=\"" . static::getFormURL() . "\">";
            echo "<tr class='tab_bg_1'> ";
            echo "<td colspan='2'> <div class='center'>";
            echo "<input type='submit' name='fork_on' value=\"" . __("Activer fork", 'dlteams') . "\" class='submit'>";
            echo "</div> </td> </tr>";

            echo "<tr class='tab_bg_1'> ";
            echo "<td colspan='2'> <div class='center'>";
            echo "<input type='submit' name='fork_off' value=\"" . __("Désactiver fork", 'dlteams') . "\" class='submit'>";
            echo "</div> </td> </tr>";

            // echo "<form method='post' action='./fork.php'>";
            echo "<tr class='tab_bg_1'> ";
            echo "<td colspan='2'> <div class='center'>";
            echo "<input type='submit' name='whitelabel_on' value=\"" . __("Activer whitelabel", 'dlteams') . "\" class='submit'>";
            echo "</div> </td> </tr>";

            echo "<tr class='tab_bg_1'> ";
            echo "<td colspan='2'> <div class='center'>";
            echo "<input type='submit' name='whitelabel_off' value=\"" . __("Désactiver whitelabel", 'dlteams') . "\" class='submit'>";
            echo "</div> </td> </tr>";


//            echo "</table>";

            echo "</table>";
            Html::closeForm();
        }



        if ($activ_profil == 4) {
            echo "<form method='post' action='./fork.php'>";
            // Copier les fichiers des dossiers fork et whitelabel
            echo "<table class='tab_cadre' cellpadding='5' width='50%'>";
            echo "<tr>";
            echo "<th colspan='2'> <center>" . __("Projets parents et enfants", 'dlteams') . "</th>";
            echo "</tr>";

            echo "<tr class='tab_bg_1'> ";
            echo "<td colspan='2'>" . __("Transformer les Projecttask en sous-projets : mode GLPI -> Dlteams", 'dlteams') . "</td>";
            echo "<td colspan='2'> <div class='right'>";
            // if ils existent des enfants deprojets alors
            echo "<input type='submit' name='parentproject_on' value=\"" . __("Lancer le transfert", 'dlteams') . "\" class='submit'>";
            echo "</div> </td> </tr>";

            echo "<tr class='tab_bg_1'> ";
            echo "<td colspan='2'>" . __("Transformer les sous-projets en Projecttask : Mode Dlteams -> GLPI", 'dlteams') . "</td>";
            echo "<td colspan='2'> <div class='right'>";
            // if il existe des enfants deprojets alors
            echo "<input type='submit' name='parentproject_off' value=\"" . __("Lancer le transfert", 'dlteams') . "\" class='submit'>";
            echo "</div> </td> </tr>";

            echo "</table>";
            Html::closeForm();
        }


    }


    private static function displayUpdateAvailableRow(string $latestVersion): void {
        echo "<tr class='tab_bg_1'>";
        echo "<td colspan='2'>" . __("Une mise a jour du plug'in est disponible", 'dlteams') . "</td>";
        echo "<td colspan='2'><div class='right'>";
        echo "<form method='post' action='/front/updatedlteamsfiles.php'>";
        echo "<input type='submit' name='update_now' value=\"" . sprintf(__("Mettre à jour vers %s"), $latestVersion) . "\" class='submit'>";
        Html::closeForm();
        echo "</div></td></tr>";
    }

    private static function displayPrerequisiteErrorRow(): void {
        $errorMessage = __("Une mise à jour est disponible, mais le système ne dispose pas des prérequis nécessaires. Veuillez 'Activer fork' et si le problème persiste, contactez le support technique", 'dlteams');
        echo "<tr class='tab_bg_1'>";
        echo "<td colspan='4' style='color: orangered; font-weight: bold;'>$errorMessage</td>";
        echo "<td colspan='2'><div class='right'></div></td></tr>";
    }

    private static function displayUpToDateRow(string $currentVersion): void {
        echo "<tr class='tab_bg_1'>";
        echo "<td colspan='2'>" . __("Le plugin est à jour", 'dlteams') . "</td>";
        echo "<td colspan='2'><div class='right'>$currentVersion</div></td></tr>";
        echo "</tr>";
    }

    private static function displayConnectionErrorRow(): void {
        echo "<tr class='tab_bg_1'>";
        echo "<td colspan='2'><i class='fa fa-times-circle' style='color: red;'></i> " . __("Échec de vérification de mise à jour") . "</td>";
        echo "<td colspan='2'><div class='right'></div></td></tr>";
    }


    /**
     * Vérifie si le fichier prérequis pour la mise à jour existe, et tente de le copier si besoin.
     */
    private static function canUpdatePlugin(): bool {
        $sourceFile      = GLPI_ROOT . "/marketplace/dlteams/install/fork/" . GLPI_VERSION . "/fork_dlteams/front/updatedlteamsfiles.php";
        $destinationFile = GLPI_ROOT . "/front/updatedlteamsfiles.php";

        if (file_exists($destinationFile)) {
            return true;
        }

        if (file_exists($sourceFile)) {
            $destinationPath = dirname($destinationFile);
            if (!is_dir($destinationPath)) {
                mkdir($destinationPath, 0755, true);
            }
            // Retourne true si la copie réussit, false sinon.
            return @copy($sourceFile, $destinationFile);
        }

        return false;
    }



    public static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {
//        var_dump($tabnum);

        if ($item->getType() == "PluginDlteamsConfig") {
            switch ($tabnum) {
                case 0:
                    $item->showGeneral();
                    break;

                case 1:
                    $item->showEntiteModel();
                    break;
//
                case 3:
                    $item->showUpdateSection();
                    break;
//
                case 2:
                    $item->showImportExport();
                    break;

                case 4:

                    echo "<table class='tab_cadre' cellpadding='5' width='100%'>";
                    echo "<tr>";
                    echo "<th colspan='2' align='center'>" . "<button class='btn btn-primary' id='btn-logsql'>Erreurs SLQ</button>" . "</th>";
                    echo "</tr>";

                    echo "<tr>";
                    echo "<th colspan='2' align='center'>" . "<button class='btn btn-primary' id='btn-logphp'>Erreurs PHP</button>" . "</th>";
                    echo "</tr>";

                    echo "<tr>";
                    echo "<th colspan='2' align='center'>" . "<button class='btn btn-primary' id='btn-logevent'>Erreurs d'évènements</button>" . "</th>";
                    echo "</tr>";
                    echo "</table>";



                    $filename = GLPI_LOG_DIR . "/sql-errors.log";
                    $file = fopen($filename, "r");
                    $logs = [];
                    $logsql = "";
                    if ($file) {
                        // Lire le fichier ligne par ligne
                        while (($line = fgets($file)) !== false) {
                            // Extraction de la date et du niveau de log
                            if (preg_match('/\[(\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2})\] (\w+)\./', $line, $matches)) {
                                $date = $matches[1];
                                $level = strtolower($matches[2]);
                                $logs[$date][] = ['level' => $level, 'message' => $line];
                            }
                        }
                        fclose($file);

                        // Trier les logs par date en ordre décroissant
                        krsort($logs);

                        // Affichage des logs
                        foreach ($logs as $date => $entries) {
                            $logsql.= "<h2>" . $date . "</h2>";
                            foreach ($entries as $entry) {
                                $logsql.= "<pre class='" . $entry['level'] . "'>" . htmlspecialchars($entry['message']) . "</pre>";
                            }
                        }


                        echo "<script>

                    $(document).ready(function(e){
                            $(document).on('click', '#btn-logsql', function () {
                                var message = ".json_encode($logsql).";
                                glpi_html_dialog({
                                title: 'Erreurs SQL',
                                body: message,
                                buttons: [{
                                    label: __('OK'),
                                    click: function(event) {
                                        ok_callback(event);
                                            }
                                        }]
                                    });
                            });
                            });
                    </script>";
                    }
                    else {
                        echo "Unable to open file SQL error file.";
                    }



                    $filename = GLPI_LOG_DIR . "/php-errors.log";
                    $file = fopen($filename, "r");
                    $logs = [];
                    $logsql = "";
                    if ($file) {
                        // Lire le fichier ligne par ligne
                        while (($line = fgets($file)) !== false) {
                            // Extraction de la date et du niveau de log
                            if (preg_match('/\[(\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2})\] (\w+)\./', $line, $matches)) {
                                $date = $matches[1];
                                $level = strtolower($matches[2]);
                                $logs[$date][] = ['level' => $level, 'message' => $line];
                            }
                        }
                        fclose($file);

                        // Trier les logs par date en ordre décroissant
                        krsort($logs);

                        // Affichage des logs
                        foreach ($logs as $date => $entries) {
                            $logsql.= "<h2>" . $date . "</h2>";
                            foreach ($entries as $entry) {
                                $logsql.= "<pre class='" . $entry['level'] . "'>" . htmlspecialchars($entry['message']) . "</pre>";
                            }
                        }


                        echo "<script>

                    $(document).ready(function(e){
                            $(document).on('click', '#btn-logphp', function () {
                                var message = ".json_encode($logsql).";
                                glpi_html_dialog({
                                title: 'Erreurs PHP',
                                body: message,
                                buttons: [{
                                    label: __('OK'),
                                    click: function(event) {
                                        ok_callback(event);
                                            }
                                        }]
                                    });
                            });
                            });
                    </script>";
                    }
                    else {
                        echo "Unable to open file PHP error file.";
                    }



                    $filename = GLPI_LOG_DIR . "/event.log";
                    $file = fopen($filename, "r");
                    $logs = [];
                    $logsql = "";
                    if ($file) {
                        // Lire le fichier ligne par ligne
                        while (($line = fgets($file)) !== false) {
                            // Extraction de la date et du niveau de log
                            if (preg_match('/\[(\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2})\] (\w+)\./', $line, $matches)) {
                                $date = $matches[1];
                                $level = strtolower($matches[2]);
                                $logs[$date][] = ['level' => $level, 'message' => $line];
                            }
                        }
                        fclose($file);

                        // Trier les logs par date en ordre décroissant
                        krsort($logs);

                        // Affichage des logs
                        foreach ($logs as $date => $entries) {
                            $logsql.= "<h2>" . $date . "</h2>";
                            foreach ($entries as $entry) {
                                $logsql.= "<pre class='" . $entry['level'] . "'>" . htmlspecialchars($entry['message']) . "</pre>";
                            }
                        }


                        echo "<script>

                    $(document).ready(function(e){
                            $(document).on('click', '#btn-logsql', function () {
                                var message = ".json_encode($logsql).";
                                glpi_html_dialog({
                                title: 'Erreurs Evenements',
                                body: message,
                                buttons: [{
                                    label: __('OK'),
                                    click: function(event) {
                                        ok_callback(event);
                                            }
                                        }]
                                    });
                            });
                            });
                    </script>";
                    }
                    else {
                        echo "Unable to open file event error file.";
                    }

                    break;
            }
        }
        return true;
    }

    /**
     * Activation globale : fork + whitelabel
     */
    public static function plugin_activate(): void
    {
        self::activateFork();
        self::activateWhitelabel();
        self::clearCache();
    }

    /**
     * Désactivation globale : fork + whitelabel
     */
    public static function plugin_deactivate(): void
    {
        self::deactivateFork();
        self::deactivateWhitelabel();
        self::clearCache();
    }

    /**
     * Active les fichiers fork (fork_dlteams) et plugins du marketplace si activés.
     */
    public static function activateFork(): void
    {
        $plugin          = new Plugin();
        $version         = GLPI_VERSION;
        $baseDir         = GLPI_ROOT . "/marketplace/dlteams/install/fork/{$version}";

        // 1) Vérification du dossier fork global
        if (! is_dir($baseDir)) {
            Session::addMessageAfterRedirect(
                "Pas de fork disponible pour la version de GLPI actuelle ({$version})",
                false,
                ERROR
            );
            return;
        }

        // 2) Parcours des plugins versionnés du marketplace
        $marketplacePath = "{$baseDir}/fork_dlteams/marketplace";
        if (is_dir($marketplacePath)) {
            foreach (new DirectoryIterator($marketplacePath) as $dir) {
                if (! $dir->isDir() || $dir->isDot()) {
                    continue;
                }

                $entry    = $dir->getFilename();   // ex. "formcreator_2.13.10"
                $fullPath = $dir->getPathname();

                // 3) Séparation du slug et de la version sur le dernier underscore
                $pos     = strrpos($entry, '_');
                $slug    = ($pos === false) ? $entry : substr($entry, 0, $pos);
                $verFork = ($pos === false) ? ''      : substr($entry, $pos + 1);

                // on ignore si pas de version dans le nom
                if ($verFork === '') {
                    continue;
                }

                // 4) Chargement du plugin depuis la BDD
                if (! $plugin->getFromDBbyDir($slug)) {
                    Session::addMessageAfterRedirect(
                        "Plugin « {$slug} » introuvable, fork ignoré.",
                        false,
                        WARNING
                    );
                    continue;
                }

                // 5) Vérifier que le plugin est activé
                if (! $plugin->isActivated($slug)) {
                    Session::addMessageAfterRedirect(
                        "Plugin « {$slug} » non activé, fork ignoré.",
                        false,
                        WARNING
                    );
                    continue;
                }

                // 6) Comparer la version du fork à celle installée
                $installedVer = $plugin->fields['version'] ?? '';
                if ($installedVer !== $verFork) {
                    Session::addMessageAfterRedirect(
                        "Version du fork ({$verFork}) diffère de la version installée ({$installedVer}) pour « {$slug} ».",
                        false,
                        WARNING
                    );
                    continue;
                }

                // 7) Tout est OK → copie du dossier versionné
                $destination = GLPI_ROOT . "/marketplace/{$slug}";
                self::copyDirectory($fullPath, $destination);
            }
        }

        // 8) Copier le reste du fork_dlteams hors marketplace
        $forkRoot = "{$baseDir}/fork_dlteams";
        if (is_dir($forkRoot)) {
            foreach (new DirectoryIterator($forkRoot) as $item) {
                // on ignore . , .. et le dossier marketplace déjà traité
                if ($item->isDot() || $item->getFilename() === 'marketplace') {
                    continue;
                }
                $source      = $item->getPathname();
                $destination = GLPI_ROOT . '/' . $item->getFilename();
                self::copyDirectory($source, $destination);
            }
        }
    }

    /**
     * Restaure les fichiers d'origine du fork (origin_glpi) et plugins activés
     */
    public static function deactivateFork(): void
    {
        $plugin          = new Plugin();
        $version         = GLPI_VERSION;
        $baseDir         = GLPI_ROOT . "/marketplace/dlteams/install/fork/{$version}";

        // 1) Vérification du dossier origin_glpi global
        if (! is_dir($baseDir)) {
            Session::addMessageAfterRedirect(
                "Pas de fork disponible pour la version de GLPI actuelle ({$version})",
                false,
                ERROR
            );
            return;
        }

        // 2) Parcours des plugins versionnés du marketplace à restaurer
        $marketplacePath = "{$baseDir}/origin_glpi/marketplace";
        if (is_dir($marketplacePath)) {
            foreach (new DirectoryIterator($marketplacePath) as $dir) {
                if (! $dir->isDir() || $dir->isDot()) {
                    continue;
                }

                $entry    = $dir->getFilename();   // ex. "formcreator_2.13.10"
                $fullPath = $dir->getPathname();

                // 3) Séparation du slug et de la version sur le dernier underscore
                $pos       = strrpos($entry, '_');
                $slug      = ($pos === false)
                    ? $entry
                    : substr($entry, 0, $pos);
                $verOrigin = ($pos === false)
                    ? ''
                    : substr($entry, $pos + 1);

                // 4) Chargement du plugin depuis la BDD
                if (! $plugin->getFromDBbyDir($slug)) {
                    Session::addMessageAfterRedirect(
                        "Plugin « {$slug} » introuvable en base, restauration ignorée.",
                        false,
                        WARNING
                    );
                    continue;
                }

                // 5) Vérifier que le plugin est activé
                if (! $plugin->isActivated($slug)) {
                    Session::addMessageAfterRedirect(
                        "Plugin « {$slug} » non activé, restauration ignorée.",
                        false,
                        WARNING
                    );
                    continue;
                }

                // 6) Comparer la version d’origine à celle installée
                $installedVer = $plugin->fields['version'] ?? '';
                if ($verOrigin !== '' && $installedVer !== $verOrigin) {
                    Session::addMessageAfterRedirect(
                        "Version d’origine ({$verOrigin}) diffère de la version installée ({$installedVer}) pour « {$slug} ». ",
                        false,
                        WARNING
                    );
                    continue;
                }

                // 7) Tout est OK → copie du dossier versionné d’origine
                $destination = GLPI_ROOT . "/marketplace/{$slug}";
                self::copyDirectory($fullPath, $destination);
            }
        }

        // 8) Copier le reste de origin_glpi hors marketplace
        $originRoot = "{$baseDir}/origin_glpi";
        if (is_dir($originRoot)) {
            foreach (new DirectoryIterator($originRoot) as $item) {
                if ($item->isDot() || $item->getFilename() === 'marketplace') {
                    continue;
                }
                $source      = $item->getPathname();
                $destination = GLPI_ROOT . '/' . $item->getFilename();
                self::copyDirectory($source, $destination);
            }
        }
    }

    /**
     * Active les fichiers whitelabel personnalisés
     */
    public static function activateWhitelabel(): void
    {
        $version = GLPI_VERSION;
        $baseDir = GLPI_ROOT . "/marketplace/dlteams/install/whitelabel/{$version}";

        if (! is_dir($baseDir)) {
            Session::addMessageAfterRedirect(
                "Pas de whitelabel disponible pour la version de GLPI actuelle ({$version})",
                false,
                WARNING
            );
            return;
        }

        $whitelabelPath = "{$baseDir}/dlteams";
        self::copyDirectory($whitelabelPath);
    }

    /**
     * Restaure les fichiers whitelabel d'origine
     */
    public static function deactivateWhitelabel(): void
    {
        $version = GLPI_VERSION;
        $baseDir = GLPI_ROOT . "/marketplace/dlteams/install/whitelabel/{$version}";

        if (! is_dir($baseDir)) {
            Session::addMessageAfterRedirect(
                "Pas de whitelabel disponible pour la version de GLPI actuelle ({$version})",
                false,
                WARNING
            );
            return;
        }

        $originPath = "{$baseDir}/origin_glpi";
        self::copyDirectory($originPath);
    }

    /**
     * Copie récursive d’un répertoire source vers un dossier cible.
     */
    private static function copyDirectory(string $source, string $targetRoot = GLPI_ROOT): void
    {
        if (! is_dir($source)) {
            return;
        }

        $iterator = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($source, FilesystemIterator::SKIP_DOTS)
        );

        foreach ($iterator as $file) {
            if ($file->isFile()) {
                $destination = $targetRoot . str_replace($source, '', $file->getPathname());
                if (! @copy($file->getPathname(), $destination)) {
                    Session::addMessageAfterRedirect(
                        "Erreur lors de la copie de : {$file->getPathname()} vers {$destination}",
                        false,
                        ERROR
                    );
                }
            }
        }
    }

    /**
     * Supprime le cache GLPI
     */
    private static function clearCache(): void
    {
        $command = 'rm -rf ' . GLPI_CACHE_DIR . '/*';
        system($command);
    }

}