<?php
class PluginDlteamsUpdateStats extends CronTask
{
    /**
     * Retourne le nom de la tâche affiché dans l'interface GLPI.
     */
    static function getTaskName(): string
    {
        return __('Update Record Stats', 'dlteams');
    }

    /**
     * Définit le mode d'exécution (via le cron de GLPI).
     */
    static function getTaskMode(): int
    {
        return self::MODE_SCHEDULE;
    }

    /**
     * C'est ici que le travail est fait.
     */
    public function run(CronTask $task): int
    {
        global $DB;

        // 1. Chercher une tâche à traiter
        $query = "SELECT * FROM `glpi_plugin_dlteams_queued_stats_updates`
                  WHERE `done_date` IS NULL AND `is_processing` = 0
                  LIMIT 1"; // On traite une tâche à la fois

        $job_result = $DB->request($query);

        if ($DB->numrows($job_result) == 0) {
            return self::STATUS_NOACTION; // Rien à faire, on s'arrête là.
        }

        $job = $DB->fetchAssoc($job_result);
        $job_id = $job['id'];

        // 2. On "verrouille" la tâche pour que personne d'autre n'y touche
        $DB->update('glpi_plugin_dlteams_queued_stats_updates', ['is_processing' => 1], ['id' => $job_id]);

        // 3. === EXÉCUTION DU TRAVAIL LOURD ===
        $entity_id = $job['entities_id'];
        $records_query = [
            "FROM"  => PluginDlteamsRecord::getTable(),
            "WHERE" => ["entities_id" => $entity_id]
        ];
        $records_iterator = $DB->request($records_query);
        foreach ($records_iterator as $record) {
            PluginDlteamsRecord_Stats::updateRecordStats($record);
        }
        $task->log("Stats updated for entity ID: " . $entity_id);
        // === FIN DU TRAVAIL LOURD ===

        // 4. On marque la tâche comme terminée
        $DB->update(
            'glpi_plugin_dlteams_queued_stats_updates',
            ['is_processing' => 0, 'done_date' => date('Y-m-d H:i:s')],
            ['id' => $job_id]
        );

        return self::STATUS_DONE; // On signale que la tâche est finie.
    }
}