<?php

/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2023 Teclib' and contributors.
 * @copyright 2003-2014 by the INDEPNET Development Team.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */

class PluginDlteamsFormcreatorForm_Item extends CommonDBTM
{
    static public $itemtype_2 = 'PluginFormcreatorForm';
    static public $itemtype_1;
    public static $items_id_1;
    public static $title;
    public static $sub_title;
    public static $table_match_str = [];

    public function __construct()
    {
        static::$itemtype_1 = str_replace("_Item", "", __CLASS__); // $itemtype_1 ---> PluginDlteamsRecord
        static::$items_id_1 = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", __CLASS__))) . "s_id";
        static::$title = __("Formulaires en relation avec cet objet", 'dlteams');
        static::$sub_title = __("Choisir un formulaire à lier à cet élément", 'dlteams');
        static::$table_match_str = [
            [
                'head_text' => __("Name"),
                'column_name' => 'name',
                'show_as_link' => true
            ],
//            [
//                'head_text' => __("Description"),
//                'column_name' => 'content',
//            ],
            [
                'head_text' => __("Comment"),
                'column_name' => 'comment',
            ]
        ];
        self::forceTable(PluginDlteamsRightMeasure_Item::getTable());
        parent::__construct();
    }

    public static function getTable($classname = null)
    {
        return PluginDlteamsRightMeasure_Item::getTable($classname); // TODO: Change the autogenerated stub
    }

    static function canCreate()
    {
        return true;
    }

    static function canView()
    {
        return true;
    }

    static function canUpdate()
    {
        return true;
    }

    static function canDelete()
    {
        return true;
    }

    static function canPurge()
    {
        return true;
    }

    function canCreateItem()
    {
        return true;
    }

    function canViewItem()
    {
        return true;
    }

    function canUpdateItem()
    {
        return true;
    }

    function canDeleteItem()
    {
        return true;
    }

    function canPurgeItem()
    {
        return true;
    }

    static function getTypeName($nb = 0)
    {
        return PluginFormcreatorForm::getTypeName();
    }


    static function getTypeNameForClass($nb = 0)
    {
        return __("Eléments rattachés", 'dlteams');
    }

    public static function getFormURLWithID($id = 0, $full = true)
    {
        $itemtype = PluginDlteamsRecord::class;
        $itemtype_item = new PluginDlteamsRecord_Item();
        $itemtype_item->getFromDB($id);
        $link = $itemtype::getFormURL($full);
        $link .= (strpos($link, '?') ? '&' : '?') . 'id=' . $itemtype_item->fields["records_id"];
        return $link;
    }

    // affichage de l'onglet et de son nom
    public function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {

        switch ($item->getType()) {

            default:
                if (!$withtemplate) {
                    if (Session::haveRight($item::$rightname, READ)) {
                        if ($_SESSION['glpishow_count_on_tabs']) {
                            return static::createTabEntry(static::getTypeName(2), count(static::getRequest($item)));
                        }
                        return static::getTypeName(2);
                    }
                }
                break;
        }

        return '';
    }

    // comptage du nombre de liaison entre les 2 objets dans la table de l'objet courant
    static function countForItem(CommonDBTM $item)
    {
        $dbu = new DbUtils();
        return $dbu->countElementsInTable(static::getTable(), ['items_id' => $item->getID(), 'itemtype' => $item->getType()]);
    }


    public static function getItemsRequest(CommonDBTM $object_item)
    {
        global $DB;
        $link_table = str_replace("_Item", "", __CLASS__);
        $temp = new $link_table();
        //var_dump ($link_table, static::getTable(), $temp->getTable());
        $items = $DB->request([
            'FROM' => self::getTable(),
            'SELECT' => [
                self::getTable() . '.id',
                self::getTable() . '.id as linkid',
                self::getTable() . '.comment',
                self::getTable() . '.itemtype as itemtype',
                self::getTable() . '.items_id as items_id',
            ],
            'WHERE' => [
                static::getTable() . '.' . static::$items_id_1 => $object_item->fields['id']
            ],
            'LEFT JOIN' => [
                $temp->getTable() => [
                    'FKEY' => [
                        static::getTable() => static::$items_id_1,
                        $temp->getTable() => 'id'
                    ]
                ]
            ],
//            'ORDER' => self::getTable() . '.id DESC',
            'ORDER' => [$temp->getTable() . '.name ASC', self::getTable() . '.itemtype ASC'],
        ]);

        return iterator_to_array($items);
    }


    public function defineTabs($options = [])
    {
        $ong = [];
        $this->addDefaultFormTab($ong);
        $this->addImpactTab($ong, $options);
        return $ong;
    }

    public static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {
        switch ($item->getType()) {
//            case static::$itemtype_2:
//                self::showItems($item);
//                break;
            default:
                self::showForItem($item);
                break;
        }
    }


    static function showForItem(CommonDBTM $item, $withtemplate = 0)
    {

        $id = $item->fields['id'];
        $canedit = $item->can($id, UPDATE); // canedit booleen = true
        $rand = mt_rand(1, mt_getrandmax());
        global $DB;

        $iterator = static::getRequest($item);
        $number = count($iterator);
        $items_list = [];
        $used = [];

        //while ($data = $iterator->next()) {
        foreach ($iterator as $id => $data) {
            $items_list[$data['linkid']] = $data;
            $used[$data['id']] = $data['id'];
        }

        if ($canedit) {
            echo "<form name='recorditem_form$rand' id='recorditem_form$rand' method='post'
             action='" . Toolbox::getItemTypeFormURL(PluginDlteamsElementsRGPD::class) . "'>";
            echo "<input type='hidden' name='itemtype1' value='" . $item->getType() . "' />";
            echo "<input type='hidden' name='itemtype' value='" . static::$itemtype_2 . "' />";
            echo "<input type='hidden' name='items_id1' value='" . $item->getID() . "' />";
            echo "<input type='hidden' name='entities_id' value='" . $item->fields['entities_id'] . "' />";
//
            echo "<table class='tab_cadre_fixe'>";

            echo "<tr class='tab_bg_2'><th colspan='3'>" . static::$title .
                "</th>";
            echo "</tr>";

            echo "<tr class='tab_bg_1'>";
            echo "<td class='right' style='text-wrap: nowrap;' width='20%'>";
            echo static::$sub_title;
            echo "</td>";
            echo "<td style='display: flex;' class='left'>";

            PluginFormcreatorForm::dropdown([
                'addicon' => true,
                'name' => 'items_id',
                'used' => $used,
                'value' => "", //$responsible,
//                'right' => 'all',
                'width' => "250px",
//                'url' => $CFG_GLPI['root_doc'] . "/marketplace/dlteams/ajax/getDropdownValue.php"
            ]);


            echo "</td>";
            echo "<td class='left'>";
            echo "</td>";
            echo "</tr>";


//
//
            echo "<tr class='tab_bg_1' style='display: none;' id='field-createlink'>";
            echo "<td class='right' width='20%'>";
            echo __("Comment");
            echo "</td>";
            echo "<td style='display: flex;' class='left'>";
            echo "<div>";
            echo "<textarea type='text' style='width:100%;' maxlength=1000 rows='2' name='comment' class='comment'></textarea>";

            echo "</div>";
            echo "</td>";
            echo "<td class='left'>";
            echo "</td>";
            echo "</tr>";

            echo "<tr>";
            echo "<td>";
            echo "</td>";
            echo "<td colspan='2' class='left'>";
            echo "<button name='link_element' style='display: none;' id='btn-createlink' class='btn btn-primary'>Relier cet élément</button>";
            echo "</td>";
            echo "</tr>";


            echo "</table>";
            Html::closeForm();
        }

        echo "<script>
                $(document).ready(function(e){

                $('select[name=items_id]').on('change', function () {
                    if($(this).val() != '0'){
                        document.getElementById('btn-createlink').style.display = 'block';
                        document.getElementById('field-createlink').style.display = 'table-row';
                        
                        $.ajax({
                                url: '/marketplace/dlteams/ajax/get_object_specific_field.php',
                                type: 'POST',
                                data: {
                                    id: $(this).val(),
                                    object: '" . static::$itemtype_2 . "',
                                    field: 'content'
                                },
                                success: function (data) {
                                    // Handle the returned data here
//                                    let comm_field = $('textarea[name=comment]');
//                                    comm_field.val(data);
//                                    comm_field.val(comm_field.val().replace(/^\s+/, ''));
                                }
                            });                      
                        
                        
                    }
                    else{
                        document.getElementById('btn-createlink').style.display = 'none';
                        document.getElementById('field-createlink').style.display = 'none';
                    }
                       
                    });
                });
        </script>";


        $massiveaction_processor = __CLASS__;


        echo "<div class='spaced'>";
        if ($canedit && $number) {
            Html::openMassiveActionsForm('mass' . $massiveaction_processor . $rand);
            $massive_action_params = [
                'container' => 'mass' . $massiveaction_processor . $rand,
                'num_displayed' => min($_SESSION['glpilist_limit'], $number)
            ];
            Html::showMassiveActions($massive_action_params);
        }
        echo "<table class='tab_cadre_fixehov'>";

        $header_begin = "<tr>";
        $header_top = '';
        $header_bottom = '';
        $header_end = '';


        if ($canedit && $number) {

            $header_begin .= "<th width='10'>";
            $header_top .= Html::getCheckAllAsCheckbox('mass' . $massiveaction_processor . $rand);
//                $header_bottom .= Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand);
            $header_end .= "</th>";
        }


        foreach (static::$table_match_str as $column) {
            $header_end .= "<th>" . $column["head_text"] . "</th>";
        }
        $header_end .= "</tr>";

        echo $header_begin . $header_top . $header_end;


        foreach ($items_list as $data) {
            echo "<tr class='tab_bg_1'>";

            if ($canedit && $number) {
                echo "<td width='10'>";


                Html::showMassiveActionCheckBox($massiveaction_processor, $data['linkid']);
                echo "</td>";

                $id = $data['linkid'];
            }


            foreach (static::$table_match_str as $key => $column) {

                if (isset($data[$column["column_name"]])) {

                        $name = $data[$column["column_name"]];
                }
                if (!isset($data[$column["column_name"]]))
                    $name = "--";

                if ($key === 0) {

                    // Construire l'URL
                    $url = static::$itemtype_2::getFormURLWithID($data["items_id"]);

                    // Assigner le nom avec le lien formaté
                    $name = sprintf("<a target='_blank' href='%s'>%s</a>", $url, $name);
                }

                echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
                echo ">" . $name . "</td>";
            }

            echo "</tr>";
        }

        echo "</table>";

        Html::closeForm();

        echo "
                <script>
                    $(document).ready(function(e) {
                        var window.eventBinded = false;
                
                        $(document).on('change', 'select[name=id_field]', function () {
                            console.log('shhhh');
                            
                            if (!alertShown) {
                                $.ajax({
                                        url: '/marketplace/dlteams/ajax/get_object_specific_field.php',
                                        type: 'POST',
                                        data: {
                                            id: " . $id . ",
                                            object: '" . static::$itemtype_2 . "_Item" . "',
                                            field: 'comment'
                                        },
                                        success: function (data) {
                                            // Handle the returned data here
                                            console.log(data);
                                            $('textarea[name=comment]').val(data);
                                        }
                            });
                                eventBinded = true;
                            }
                        });
                    });
                </script>
                ";

        echo "</div>";




        echo "<br/>";
        echo "<br/>";echo "<br/>";
        echo "<br/>";
        echo "<table class='tab_cadre_fixe'>";

        echo "<tr class='tab_bg_2'><th colspan='3'>" . "Réponses aux formulaires".
            "</th>";
        echo "</tr>";

        echo "</table>";

        foreach ($items_list as $data){
            $form = new PluginFormcreatorForm();
            $form->getFromDB($data["items_id"]);

            echo "<tr class='tab_bg_2'><th colspan='3'><b>" .
                $form->fields["name"].
                "</b></th>";
            echo "</tr>";

            echo "</table>";
            PluginFormcreatorFormAnswer::showForForm($form);
            echo "<br/>";
            echo "<br/>";
        }

    }

    function rawSearchOptions()
    {
        $tab[] = [
            'id' => '44',
            'table' => static::getTable(),
            'field' => 'comment',
            'datatype' => 'text',
            'name' => __("Commentaire"),
            'forcegroupby' => true,
            'massiveaction' => true,
        ];

        return $tab;
    }

    public function getForbiddenStandardMassiveAction()
    {
        $forbidden = parent::getForbiddenStandardMassiveAction();
        $forbidden[] = 'clone';
        $forbidden[] = 'MassiveAction:add_transfer_list';
        $forbidden[] = 'MassiveAction:amend_comment';
        $forbidden[] = 'Document_Item:remove';
        $forbidden[] = 'Document_Item:add';
        return $forbidden;
    }

    public static function getRequest(CommonDBTM $item)
    {

        global $DB;
//        if (in_array($item::getType(), $itemtype1_list_in_records) || in_array($item::getType(), $exceptions_itemtype_in_records)) {
//            $table_item_name = getTableForItemType($item::getType() . "_Item");
//            $table_name = $item::getTable(); // si $item = DataCatalog, $table_name contiendra data_catalogs
//            $columnid_name = strtolower(str_replace("PluginDlteams", "", $item::getType())) . "s_id"; // $columnid_name contiendra users_id si $item = User
//        } else {
            $table_item_name = getTableForItemType(static::$itemtype_2 . "_Item");
            $table_name = static::$itemtype_2::getTable(); // si $item = DataCatalog, $table_name contiendra data_catalogs
            $columnid_name = "rightmeasures_id";
//        }

//        var_dump($columnid_name);
//        die();

        $query = [
            'SELECT' => [
                'glpi_plugin_dlteams_rightmeasures_items' . '.id AS linkid',
                'glpi_plugin_dlteams_rightmeasures_items' . '.itemtype AS itemtype',
                'glpi_plugin_dlteams_rightmeasures_items' . '.items_id AS items_id',
                'glpi_plugin_dlteams_rightmeasures_items' . '.'.$columnid_name.' AS columnid_name',
                'glpi_plugin_dlteams_rightmeasures_items' . '.*',
                'glpi_plugin_formcreator_forms' . '.id AS id',
                'glpi_plugin_formcreator_forms' . '.name AS name',
                'glpi_plugin_formcreator_forms' . '.content AS content',
            ],
            'FROM' => 'glpi_plugin_dlteams_rightmeasures_items',
            'LEFT JOIN' => [
                'glpi_plugin_formcreator_forms' => [
                    'ON' => [
                        'glpi_plugin_dlteams_rightmeasures_items' => 'items_id',
                        'glpi_plugin_formcreator_forms' => 'id'
                    ]
                ]
            ],
        ];



//        var_dump(static::$itemtype_1);
//        die();

        $query["WHERE"] = [
            'glpi_plugin_dlteams_rightmeasures_items' . '.itemtype' => ['LIKE', 'PluginFormcreatorForm'],
            'glpi_plugin_dlteams_rightmeasures_items' . '.' . $columnid_name => $item->fields['id'],
        ];


        $iterator = $DB->request($query);
        $temp = [];

        foreach ($iterator as $id => $data) {
            if ($data["itemtype"]) {
                $item_object = null;
                $item_str = $data["itemtype"];
                $item_object = new $item_str();
                $item_object->getFromDB($data["items_id"]);
                if (isset($item_object->fields["entities_id"])) {
                    array_push($temp, $data);
                }
            }
        }
        return $temp;
    }

    static function showConsent1(PluginDlteamsRecord $record, $data = [])
    {
        if ($data['consent_type1'] == 0) {
        } else if ($data['consent_type1'] == 1) {
            //echo __("Groupe <i class='fas fa-dolly'></i>&nbsp;", 'dlteams');
            Group::dropdown([
                'addicon' => Group::canCreate(),
                'name' => "groups_id",
                'display_emptychoice' => false,
                'width' => "200px"
            ]);
            echo "<textarea type='text' rows='1' name='comment' placeholder='Commentaire'  style='margin-bottom:-15px;margin-left:190px;width:45%'></textarea>";
            echo "<input type='submit' name='add1' value=\"" . _sx('button', 'Add') . "\" class='submit' style='float:right;margin-right:7.5%'>";

        } else if ($data['consent_type1'] == 2) {
            //echo __("Utilisateur <i class='fas fa-dolly'></i>&nbsp;", 'dlteams');

            /*User::dropdown([
            'addicon'  => User::canCreate(),
            'name' => "users_id",
            'display_emptychoice' => false,
            'width' => "200px"

         ]); */
            $randDropdown = mt_rand();
            User::dropdown(['value' => $record->fields["users_id"],
                'entity' => $record->fields["entities_id"],
                'right' => 'all',
                'width' => '200px',
                'rand' => $randDropdown]);
            echo "<textarea type='text' maxlength=600 rows='1' name='comment' placeholder='Commentaire' style='margin-bottom:-15px;margin-left:140px;width:45%'></textarea>";
            echo "<input type='submit' name='add1' value=\"" . _sx('button', 'Add') . "\" class='submit' style='float:right;margin-right:7.5%'>";


        } else if ($data['consent_type1'] == 3) {
            // Display explicit consentecho "<td><br>" . "</td><td>";

            //echo __("Tiers Categories <i class='fas fa-dolly'></i>&nbsp;", 'dlteams');

//            echo "<span style='margin-right:10px;'>";
//            //echo __("Tiers ", 'dlteams');
//            //echo "<br/><br/>";
//
//            PluginDlteamsRgpdAdequacy::dropdown([
//                'addicon' => PluginDlteamsRgpdAdequacy::canCreate(),
//                'name' => "rgpdadequacies_id",
//                'display_emptychoice' => false,
//                'width' => '150px'
//            ]);
//            echo "</span>";


            PluginDlteamsThirdPartyCategory::dropdown([
                'addicon' => PluginDlteamsThirdPartyCategory::canCreate(),
                'name' => "plugin_dlteams_thirdpartycategories_id1",
                'width' => "200px"
            ]);
            echo "<textarea type='text' maxlength=600 rows='1' name='comment' placeholder='Commentaire' style='margin-bottom:-15px;margin-left:110px;width:35%'></textarea>";
            echo "<input type='submit' name='add1' value=\"" . _sx('button', 'Add') . "\" class='submit' style='float:right;margin-right:7.5%'>";

        } else if ($data['consent_type1'] == 4) {
            // Display explicit consentecho "<td><br>" . "</td><td>";

            //echo __("Tiers <i class='fas fa-dolly'></i>&nbsp;", 'dlteams');
//            echo "<span style='margin-right:10px;'>";
//            //echo __("Tiers ", 'dlteams');
//            //echo "<br/><br/>";
//
//            PluginDlteamsRgpdAdequacy::dropdown([
//                'addicon' => PluginDlteamsRgpdAdequacy::canCreate(),
//                'name' => "rgpdadequacies_id",
//                'display_emptychoice' => false,
//                'width' => '150px'
//            ]);
//            echo "</span>";

            Supplier::dropdown([
                'addicon' => Supplier::canCreate(),
                'name' => "suppliers_id1",
                'display_emptychoice' => false,
                'width' => "200px"
            ]);
            echo "<textarea type='text' maxlength=600 rows='1' name='comment' placeholder='Commentaire' style='margin-bottom:-15px;margin-left:110px;width:35%'></textarea>";

            echo "<input type='submit' name='add1' value=\"" . _sx('button', 'Add') . "\" class='submit' style='float:right;margin-right:7.5%'>";
        }

    }
}

