<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

class PluginDlteamsPolicieForm_CollectionFeatures extends CommonDBTM
{

    static public $itemtype_2 = PluginDlteamsTransmissionMethod::class;
    static public $itemtype_1;
    public static $items_id_1;
    public static $title;
    public static $sub_title;

    static function canCreate()
    {
        return true;
    }

    static function canView()
    {
        return true;
    }

    static function canUpdate()
    {
        return true;
    }

    static function canDelete()
    {
        return true;
    }

    static function canPurge()
    {
        return true;
    }

    public static function showTransmissionMethods(CommonGLPI $item){
        $rand = mt_rand();

        // Styles globaux
        echo "<style>
        .form-element {
            display: flex;
            flex-direction: column;
            gap: 1em;
        }
        .input-field select {
            width: 100%;
        }
        @media (max-width: 768px) {
            .form-element {
                font-size: 16px;
            }
            .input-field select {
                height: 40px;
            }
        }
    </style>";







//

        $iterator = static::getRequest($item);
        $number = count($iterator);
        $items_list = [];


        $canedit = true;
        if ($canedit) {
            echo "<form name='ticketitem_form$rand' id='ticketitem_form$rand' method='post'
             action='" . Toolbox::getItemTypeFormURL(PluginDlteamsElementsRGPD::class) . "'>";
            echo "<input type='hidden' name='itemtype1' value='" . $item->getType() . "' />";
            echo "<input type='hidden' name='itemtype' value='" . static::$itemtype_2 . "' />";
            echo "<input type='hidden' name='items_id1' value='" . $item->getID() . "' />";
            echo "<input type='hidden' name='entities_id' value='" . $item->fields['entities_id'] . "' />";
//
            echo "<table class='tab_cadre_fixe'>";

            echo "<tr class='tab_bg_2'><th colspan='3'>" . __('Méthode de transmission', 'dlteams') .
                "</i></th>";
            echo "</tr>";

            echo "<tr class='tab_bg_1'>";
            echo "<td class='right' width='20%'>";
            echo __('Quel canal ou méthode de collecte ?', 'dlteams');
            echo "</td>";
            echo "<td style='display: flex;' class='left'>";

            $used = [];
            foreach ($iterator??[] as $id => $data) {
                // while ($data = $iterator->next()) {
                $items_list[$data['linkid']] = $data;

                $used[$data['linkid']] = $data['linkid'];
            }

//            $mesures_applicables_query = [
//                "FROM" => PluginDlteamsProtectiveMeasure::getTable(),
//                "WHERE" => [
//                    "applicables" => [
//                        'LIKE', "%".$item::getType()."%"
//                    ]
//                ]
//            ];

            global $DB;

//            $mesures_applicables_iterator = $DB->request($mesures_applicables_query);


//            $applicables = [];
//            foreach ($mesures_applicables_iterator as $applicable){
//                $applicables[] = $applicable["id"];
//            }


            global $CFG_GLPI;
            $params = [
                'addicon' => false,
                'name' => 'items_id',
                'value' => "", //$responsible,
                //'entity' => $this->fields["entities_id"],
                'right' => 'all',
                'width' => "250px",
                'url' => $CFG_GLPI['root_doc'] . "/marketplace/dlteams/ajax/getDropdownValue.php",
                'used' => $used,
                'rand' => $rand
            ];

//            if(count($applicables) > 0) {
//                $params['condition'] = [
//                    'glpi_plugin_dlteams_protectivemeasures.id' => $applicables
//                ];
//            }
            static::$itemtype_2::dropdown($params);
            echo "&nbsp;";


            $field_id = Html::cleanId("dropdown_" . 'items_' . mt_rand());
            $item_link = getItemForItemtype(static::$itemtype_2);

            echo '<div class="btn btn-outline-secondary"
                           title="' . __s('Add') . '" data-bs-toggle="modal" data-bs-target="#add_' . $field_id . '">'
                . Ajax::createIframeModalWindow('add_' . $field_id, $item_link->getFormURL(), ['display' => false])
                . "<span data-bs-toggle='tooltip'>
              <i class='fa-fw ti ti-plus'></i>
              <span class='sr-only'>" . __s('Add') . "</span>
                </span>"
                . '</div>';


            echo "</td>";
            echo "<td class='left'>";
            echo "</td>";
            echo "</tr>";


//
//
            echo "<tr class='tab_bg_1' style='display: none;' id='field-createlink'>";
            echo "<td class='right' width='20%'>";
            echo __("Comment");
            echo "</td>";
            echo "<td style='display: flex;' class='left'>";
            echo "<textarea type='text' style='width:100%;' maxlength=1000 rows='2' id='comment_tm' name='comment' class='comment'></textarea>";
            echo "</td>";
            echo "<td class='left'>";
            echo "</td>";
            echo "</tr>";

            echo "<tr>";
            echo "<td>";
            echo "</td>";
            echo "<td colspan='2' class='left'>";
            echo "<button name='link_element' style='display: none;' id='btn-createlink' class='btn btn-primary'>Ajouter</button>";
            echo "</td>";
            echo "</tr>";


            echo "</table>";
            Html::closeForm();
        }


        echo "<script>
                $(document).ready(function(e){

                $('#dropdown_items_id".$rand."').on('change', function () {
                    if($(this).val() != '0'){
                        document.getElementById('btn-createlink').style.display = 'block';
                        document.getElementById('field-createlink').style.display = 'table-row';
                        
                        $.ajax({
                                url: '/marketplace/dlteams/ajax/get_object_specific_field.php',
                                type: 'POST',
                                data: {
                                    id: $(this).val(),
                                    object: '" . static::$itemtype_2 . "',
                                    field: 'content'
                                },
                                success: function (data) {
                                    // Handle the returned data here
                                    let comm_field = $('#comment_tm');
                                    comm_field.val(data);
                                    comm_field.val(comm_field.val().replace(/^\s+/, ''));
                                }
                            });                      
                        
                        
                    }
                    else{
                        document.getElementById('btn-createlink').style.display = 'none';
                        document.getElementById('field-createlink').style.display = 'none';
                    }
                       
                    });
                });
        </script>";


        echo "<div class='spaced'>";
        if ($canedit && $number) {
            Html::openMassiveActionsForm('mass' . PluginDlteamsTransmissionMethod_Item::class . $rand);
            $massive_action_params = [
                'container' => 'mass' . PluginDlteamsTransmissionMethod_Item::class . $rand,
                'num_displayed' => min($_SESSION['glpilist_limit'], $number)
            ];
            Html::showMassiveActions($massive_action_params);
        }
        echo "<table class='tab_cadre_fixehov'>";

        $header_begin = "<tr>";
        $header_top = '';
        $header_bottom = '';
        $header_end = '';


        if ($canedit && $number) {

            $header_begin .= "<th width='10'>";
            $header_top .= Html::getCheckAllAsCheckbox('mass' . PluginDlteamsTransmissionMethod_Item::class . $rand);
//                $header_bottom .= Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand);
            $header_end .= "</th>";
        }


//        foreach (static::$table_match_str as $column) {
        $header_end .= "<th>" . __("Name") . "</th>";
        $header_end .= "<th>" . __("Coment") . "</th>";
//        }
        $header_end .= "</tr>";

        echo $header_begin . $header_top . $header_end;
        //var_dump($items_list);
        foreach ($items_list as $data) {

            echo "<tr class='tab_bg_1'>";

            if ($canedit && $number) {
                echo "<td width='10'>";

                $item_str = $item::class . "_Item";
                Html::showMassiveActionCheckBox(PluginDlteamsTransmissionMethod_Item::class, $data['linkid']);
                echo "</td>";

                $id = $data['linkid'];
            }


//            foreach (static::$table_match_str as $key => $column) {

//                if (isset($data["name"]))
//                    $name = $data[$column["column_name"]];
//                if (!isset($data[$column["column_name"]]))
            $name = $data["name"];
//
//                if ($key === 0)
            $name = "<a target='_blank' href=\"" . static::$itemtype_2::getFormURLWithID($data["transmissionmethods_id"]) . "\">" . $name . "</a>";

            echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
            echo ">" . $name . "</td>";

            echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
            echo ">" . $data["comment"] . "</td>";
//            }

            echo "</tr>";
        }

        echo "</table>";

        Html::closeForm();
    }


    public static function showMediaCollect(CommonGLPI $item){
        $rand = mt_rand();

        // Styles globaux
        echo "<style>
        .form-element {
            display: flex;
            flex-direction: column;
            gap: 1em;
        }
        .input-field select {
            width: 100%;
        }
        @media (max-width: 768px) {
            .form-element {
                font-size: 16px;
            }
            .input-field select {
                height: 40px;
            }
        }
    </style>";


        $items_list = [];






//

        $iterator = static::getMediaRequest($item);
        $number = count($iterator);


        $canedit = true;
        $ma_class = PluginDlteamsMediaSupport_Item::class;
        if ($canedit) {
            echo "<form name='ticketitem_form$rand' id='ticketitem_form$rand' method='post'
             action='" . Toolbox::getItemTypeFormURL(PluginDlteamsElementsRGPD::class) . "'>";
            echo "<input type='hidden' name='itemtype1' value='" . $item->getType() . "' />";
            echo "<input type='hidden' name='itemtype' value='" . PluginDlteamsMediaSupport::class . "' />";
            echo "<input type='hidden' name='items_id1' value='" . $item->getID() . "' />";
            echo "<input type='hidden' name='entities_id' value='" . $item->fields['entities_id'] . "' />";
//
            echo "<table class='tab_cadre_fixe'>";

            echo "<tr class='tab_bg_2'><th colspan='3'>" . __('Supports, médias de collecte', 'dlteams') .
                "</i></th>";
            echo "</tr>";

            echo "<tr class='tab_bg_1'>";
            echo "<td class='right' width='20%'>";
            echo __('Supports, médias de collecte', 'dlteams');
            echo "</td>";
            echo "<td style='display: flex;' class='left'>";

            $used = [];
            foreach ($iterator??[] as $id => $data) {
                // while ($data = $iterator->next()) {
                $items_list[$data['linkid']] = $data;

                $used[$data['linkid']] = $data['linkid'];
            }

//            $mesures_applicables_query = [
//                "FROM" => PluginDlteamsProtectiveMeasure::getTable(),
//                "WHERE" => [
//                    "applicables" => [
//                        'LIKE', "%".$item::getType()."%"
//                    ]
//                ]
//            ];

            global $DB;

//            $mesures_applicables_iterator = $DB->request($mesures_applicables_query);


//            $applicables = [];
//            foreach ($mesures_applicables_iterator as $applicable){
//                $applicables[] = $applicable["id"];
//            }


            global $CFG_GLPI;
            $params = [
                'addicon' => false,
                'name' => 'items_id',
                'value' => "", //$responsible,
                //'entity' => $this->fields["entities_id"],
                'right' => 'all',
                'width' => "250px",
                'url' => $CFG_GLPI['root_doc'] . "/marketplace/dlteams/ajax/getDropdownValue.php",
                'used' => $used,
                'rand' => $rand
            ];

//            if(count($applicables) > 0) {
//                $params['condition'] = [
//                    'glpi_plugin_dlteams_protectivemeasures.id' => $applicables
//                ];
//            }
            PluginDlteamsMediaSupport::dropdown($params);
            echo "&nbsp;";


            $field_id = Html::cleanId("dropdown_" . 'items_' . mt_rand());
            $item_link = getItemForItemtype(static::$itemtype_2);

            echo '<div class="btn btn-outline-secondary"
                           title="' . __s('Add') . '" data-bs-toggle="modal" data-bs-target="#add_' . $field_id . '">'
                . Ajax::createIframeModalWindow('add_' . $field_id, $item_link->getFormURL(), ['display' => false])
                . "<span data-bs-toggle='tooltip'>
              <i class='fa-fw ti ti-plus'></i>
              <span class='sr-only'>" . __s('Add') . "</span>
                </span>"
                . '</div>';


            echo "</td>";
            echo "<td class='left'>";
            echo "</td>";
            echo "</tr>";


//
//
            echo "<tr class='tab_bg_1' style='display: none;' id='field-createlink-support'>";
            echo "<td class='right' width='20%'>";
            echo __("Comment");
            echo "</td>";
            echo "<td style='display: flex;' class='left'>";
            echo "<textarea type='text' style='width:100%;' maxlength=1000 rows='2' id='comment_mc' name='comment' class='comment'></textarea>";
            echo "</td>";
            echo "<td class='left'>";
            echo "</td>";
            echo "</tr>";

            echo "<tr>";
            echo "<td>";
            echo "</td>";
            echo "<td colspan='2' class='left'>";
            echo "<button name='link_element' style='display: none;' id='btn-createlink-support' class='btn btn-primary'>Ajouter</button>";
            echo "</td>";
            echo "</tr>";


            echo "</table>";
            Html::closeForm();
        }


        echo "<script>
                $(document).ready(function(e){

                $('#dropdown_items_id".$rand."').on('change', function () {
                    if($(this).val() != '0'){
                        document.getElementById('btn-createlink-support').style.display = 'block';
                        document.getElementById('field-createlink-support').style.display = 'table-row';
                        
                        $.ajax({
                                url: '/marketplace/dlteams/ajax/get_object_specific_field.php',
                                type: 'POST',
                                data: {
                                    id: $(this).val(),
                                    object: '" . PluginDlteamsMediaSupport::class . "',
                                    field: 'content'
                                },
                                success: function (data) {
                                    // Handle the returned data here
                                    let comm_field = $('#comment_mc');
                                    comm_field.val(data);
                                    comm_field.val(comm_field.val().replace(/^\s+/, ''));
                                }
                            });                      
                        
                        
                    }
                    else{
                        document.getElementById('btn-createlink-support').style.display = 'none';
                        document.getElementById('field-createlink-support').style.display = 'none';
                    }
                       
                    });
                });
        </script>";


        echo "<div class='spaced'>";
        if ($canedit && $number) {
            Html::openMassiveActionsForm('mass' . $ma_class . $rand);
            $massive_action_params = [
                'container' => 'mass' . $ma_class . $rand,
                'num_displayed' => min($_SESSION['glpilist_limit'], $number)
            ];
            Html::showMassiveActions($massive_action_params);
        }
        echo "<table class='tab_cadre_fixehov'>";

        $header_begin = "<tr>";
        $header_top = '';
        $header_bottom = '';
        $header_end = '';


        if ($canedit && $number) {

            $header_begin .= "<th width='10'>";
            $header_top .= Html::getCheckAllAsCheckbox('mass' . $ma_class . $rand);
//                $header_bottom .= Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand);
            $header_end .= "</th>";
        }


//        foreach (static::$table_match_str as $column) {
        $header_end .= "<th>" . __("Name") . "</th>";
        $header_end .= "<th>" . __("Coment") . "</th>";
//        }
        $header_end .= "</tr>";

        echo $header_begin . $header_top . $header_end;
        //var_dump($items_list);
        foreach ($items_list as $data) {

            echo "<tr class='tab_bg_1'>";

            if ($canedit && $number) {
                echo "<td width='10'>";

                $item_str = $item::class . "_Item";
                Html::showMassiveActionCheckBox($ma_class, $data['linkid']);
                echo "</td>";

                $id = $data['linkid'];
            }


//            foreach (static::$table_match_str as $key => $column) {

//                if (isset($data["name"]))
//                    $name = $data[$column["column_name"]];
//                if (!isset($data[$column["column_name"]]))
            $name = $data["name"];
//
//                if ($key === 0)
            $name = "<a target='_blank' href=\"" . PluginDlteamsMediaSupport::getFormURLWithID($data["mediasupports_id"]) . "\">" . $name . "</a>";

            echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
            echo ">" . $name . "</td>";

            echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
            echo ">" . $data["comment"] . "</td>";
//            }

            echo "</tr>";
        }

        echo "</table>";

        Html::closeForm();
    }


    public static function showSIIntegration(CommonGLPI $item){
        $rand = mt_rand();

        // Styles globaux
        echo "<style>
        .form-element {
            display: flex;
            flex-direction: column;
            gap: 1em;
        }
        .input-field select {
            width: 100%;
        }
        @media (max-width: 768px) {
            .form-element {
                font-size: 16px;
            }
            .input-field select {
                height: 40px;
            }
        }
    </style>";


        $items_list = [];






//

        $iterator = static::getSIIRequest($item);
        $number = count($iterator);


        $ma_processor = PluginDlteamsSIIntegration_Item::class;
        $canedit = true;
        if ($canedit) {
            echo "<form name='ticketitem_form$rand' id='ticketitem_form$rand' method='post'
             action='" . Toolbox::getItemTypeFormURL(PluginDlteamsElementsRGPD::class) . "'>";
            echo "<input type='hidden' name='itemtype1' value='" . $item->getType() . "' />";
            echo "<input type='hidden' name='itemtype' value='" . PluginDlteamsSIIntegration::class . "' />";
            echo "<input type='hidden' name='items_id1' value='" . $item->getID() . "' />";
            echo "<input type='hidden' name='entities_id' value='" . $item->fields['entities_id'] . "' />";
//
            echo "<table class='tab_cadre_fixe'>";

            echo "<tr class='tab_bg_2'><th colspan='3'>" . __('Intégration au SI', 'dlteams') .
                "</i></th>";
            echo "</tr>";

            echo "<tr class='tab_bg_1'>";
            echo "<td class='right' width='20%'>";
            echo __('Mode d\'enregistrement des données collectées', 'dlteams');
            echo "</td>";
            echo "<td style='display: flex;' class='left'>";

            $used = [];
            foreach ($iterator??[] as $id => $data) {
                // while ($data = $iterator->next()) {
                $items_list[$data['linkid']] = $data;

                $used[$data['linkid']] = $data['linkid'];
            }

//            $mesures_applicables_query = [
//                "FROM" => PluginDlteamsProtectiveMeasure::getTable(),
//                "WHERE" => [
//                    "applicables" => [
//                        'LIKE', "%".$item::getType()."%"
//                    ]
//                ]
//            ];

            global $DB;

//            $mesures_applicables_iterator = $DB->request($mesures_applicables_query);


//            $applicables = [];
//            foreach ($mesures_applicables_iterator as $applicable){
//                $applicables[] = $applicable["id"];
//            }


            global $CFG_GLPI;
            $params = [
                'addicon' => false,
                'name' => 'items_id',
                'value' => "", //$responsible,
                //'entity' => $this->fields["entities_id"],
                'right' => 'all',
                'width' => "250px",
                'url' => $CFG_GLPI['root_doc'] . "/marketplace/dlteams/ajax/getDropdownValue.php",
                'used' => $used,
                'rand' => $rand
            ];

//            if(count($applicables) > 0) {
//                $params['condition'] = [
//                    'glpi_plugin_dlteams_protectivemeasures.id' => $applicables
//                ];
//            }
            PluginDlteamsSIIntegration::dropdown($params);
            echo "&nbsp;";


            $field_id = Html::cleanId("dropdown_" . 'items_' . mt_rand());
            $item_link = getItemForItemtype(PluginDlteamsSIIntegration::class);

            echo '<div class="btn btn-outline-secondary"
                           title="' . __s('Add') . '" data-bs-toggle="modal" data-bs-target="#add_' . $field_id . '">'
                . Ajax::createIframeModalWindow('add_' . $field_id, $item_link->getFormURL(), ['display' => false])
                . "<span data-bs-toggle='tooltip'>
              <i class='fa-fw ti ti-plus'></i>
              <span class='sr-only'>" . __s('Add') . "</span>
                </span>"
                . '</div>';


            echo "</td>";
            echo "<td class='left'>";
            echo "</td>";
            echo "</tr>";


//
//
            echo "<tr class='tab_bg_1' style='display: none;' id='field-createlink-sii'>";
            echo "<td class='right' width='20%'>";
            echo __("Comment");
            echo "</td>";
            echo "<td style='display: flex;' class='left'>";
            echo "<textarea type='text' style='width:100%;' maxlength=1000 rows='2' id='comment_sii' name='comment' class='comment'></textarea>";
            echo "</td>";
            echo "<td class='left'>";
            echo "</td>";
            echo "</tr>";

            echo "<tr>";
            echo "<td>";
            echo "</td>";
            echo "<td colspan='2' class='left'>";
            echo "<button name='link_element' style='display: none;' id='btn-createlink-sii' class='btn btn-primary'>Ajouter</button>";
            echo "</td>";
            echo "</tr>";


            echo "</table>";
            Html::closeForm();
        }


        echo "<script>
                $(document).ready(function(e){

                $('#dropdown_items_id".$rand."').on('change', function () {
                    if($(this).val() != '0'){
                        document.getElementById('btn-createlink-sii').style.display = 'block';
                        document.getElementById('field-createlink-sii').style.display = 'table-row';
                        
                        $.ajax({
                                url: '/marketplace/dlteams/ajax/get_object_specific_field.php',
                                type: 'POST',
                                data: {
                                    id: $(this).val(),
                                    object: '" . PluginDlteamsSIIntegration::class . "',
                                    field: 'content'
                                },
                                success: function (data) {
                                    // Handle the returned data here
                                    let comm_field = $('#comment_sii');
                                    comm_field.val(data);
                                    comm_field.val(comm_field.val().replace(/^\s+/, ''));
                                }
                            });                      
                        
                        
                    }
                    else{
                        document.getElementById('btn-createlink-sii').style.display = 'none';
                        document.getElementById('field-createlink-sii').style.display = 'none';
                    }
                       
                    });
                });
        </script>";


        echo "<div class='spaced'>";
        if ($canedit && $number) {
            Html::openMassiveActionsForm('mass' . $ma_processor . $rand);
            $massive_action_params = [
                'container' => 'mass' . $ma_processor . $rand,
                'num_displayed' => min($_SESSION['glpilist_limit'], $number)
            ];
            Html::showMassiveActions($massive_action_params);
        }
        echo "<table class='tab_cadre_fixehov'>";

        $header_begin = "<tr>";
        $header_top = '';
        $header_bottom = '';
        $header_end = '';


        if ($canedit && $number) {

            $header_begin .= "<th width='10'>";
            $header_top .= Html::getCheckAllAsCheckbox('mass' . $ma_processor . $rand);
//                $header_bottom .= Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand);
            $header_end .= "</th>";
        }


//        foreach (static::$table_match_str as $column) {
        $header_end .= "<th>" . __("Name") . "</th>";
        $header_end .= "<th>" . __("Coment") . "</th>";
//        }
        $header_end .= "</tr>";

        echo $header_begin . $header_top . $header_end;
        //var_dump($items_list);
        foreach ($items_list as $data) {

            echo "<tr class='tab_bg_1'>";

            if ($canedit && $number) {
                echo "<td width='10'>";

                $item_str = $item::class . "_Item";
                Html::showMassiveActionCheckBox($ma_processor, $data['linkid']);
                echo "</td>";

                $id = $data['linkid'];
            }


//            foreach (static::$table_match_str as $key => $column) {

//                if (isset($data["name"]))
//                    $name = $data[$column["column_name"]];
//                if (!isset($data[$column["column_name"]]))
            $name = $data["name"];
//
//                if ($key === 0)
            $name = "<a target='_blank' href=\"" . PluginDlteamsSIIntegration::getFormURLWithID($data["siintegrations_id"]) . "\">" . $name . "</a>";

            echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
            echo ">" . $name . "</td>";

            echo "<td class='left" . (isset($data['is_deleted']) && $data['is_deleted'] ? " tab_bg_2_2'" : "'");
            echo ">" . $data["comment"] . "</td>";
//            }

            echo "</tr>";
        }

        echo "</table>";

        Html::closeForm();
    }

    public static function showForPolicieForm(CommonGLPI $item, mixed $withtemplate) {

        $id = $item->fields["id"];
        $rand = mt_rand();
        static::showTransmissionMethods($item);
        static::showMediaCollect($item);
        static::showSIIntegration($item);
    }



    public static function getRequest(CommonDBTM $item)
    {
        $table_name = static::$itemtype_2::getTable(); // si $item = DataCatalog, $table_name contiendra data_catalogs
        $columnid_name = strtolower(str_replace("PluginDlteams", "", static::$itemtype_2::getType())) . "s_id"; // $columnid_name contiendra users_id si $item = User

//
        global $DB;
        $table_item_name = getTableForItemType(static::$itemtype_2 . "_Item");

        $query = [
            'SELECT' => [
                $table_item_name . '.id AS linkid',
                $table_item_name . '.itemtype AS itemtype',
                $table_item_name . '.items_id AS items_id',
                $table_item_name . '.*',
                $table_name . '.id AS id',
                $table_name . '.name AS name',
                $table_name . '.content AS content',
//                'glpi_plugin_dlteams_protectivetypes.name AS typename',
//                'glpi_plugin_dlteams_protectivecategories.name as namecat',
            ],
            'FROM' => $table_item_name,
            'LEFT JOIN' => [
                $table_name => [
                    'ON' => [
                        $table_item_name => $columnid_name,
                        $table_name => 'id'
                    ]
                ]
            ],
//            'JOIN' => [
//                'glpi_plugin_dlteams_protectivetypes' => [
//                    'FKEY' => [
//                        'glpi_plugin_dlteams_protectivemeasures' => "plugin_dlteams_protectivetypes_id",
//                        'glpi_plugin_dlteams_protectivetypes' => "id"
//                    ]
//                ],
//                'glpi_plugin_dlteams_protectivecategories' => [
//                    'FKEY' => [
//                        'glpi_plugin_dlteams_protectivemeasures' => "plugin_dlteams_protectivecategories_id",
//                        'glpi_plugin_dlteams_protectivecategories' => "id"
//                    ]
//                ],
//            ],
            'WHERE' => [
                $table_item_name . '.itemtype' => ['LIKE', $item::getType()],
                $table_item_name . '.' . 'items_id' => $item->fields['id'],
            ],
            'ORDERBY' => ['name ASC']
        ];


        /*        highlight_string("<?php\n\$data =\n" . var_export($query, true) . ";\n?>");*/
//        die();
        if ($DB->fieldExists($table_item_name, 'comment')) {
            $query['SELECT'][] = $table_item_name . '.comment AS comment';
        }

        if ($DB->fieldExists($table_name, 'content')) {
            $query['SELECT'][] = $table_name . '.content AS content';
        }


        $iterator = $DB->request($query);
        $temp = [];

        foreach ($iterator as $id => $data) {

            if ($data["itemtype"]) {
                $item_object = null;
                $item_str = $data["itemtype"];
                $item_object = new $item_str();
                $item_object->getFromDB($data["items_id"]);


                if (isset($item_object->fields["entities_id"])) {
                    array_push($temp, $data);
                }

            }

        }
        return $temp;
    }


    public static function getMediaRequest(CommonDBTM $item)
    {
        $table_name = PluginDlteamsMediaSupport::getTable(); // si $item = DataCatalog, $table_name contiendra data_catalogs
        $columnid_name = strtolower(str_replace("PluginDlteams", "", PluginDlteamsMediaSupport::class)) . "s_id"; // $columnid_name contiendra users_id si $item = User

//
        global $DB;
        $table_item_name = getTableForItemType(PluginDlteamsMediaSupport::class . "_Item");

        $query = [
            'SELECT' => [
                $table_item_name . '.id AS linkid',
                $table_item_name . '.itemtype AS itemtype',
                $table_item_name . '.items_id AS items_id',
                $table_item_name . '.*',
                $table_name . '.id AS id',
                $table_name . '.name AS name',
                $table_name . '.content AS content',
//                'glpi_plugin_dlteams_protectivetypes.name AS typename',
//                'glpi_plugin_dlteams_protectivecategories.name as namecat',
            ],
            'FROM' => $table_item_name,
            'LEFT JOIN' => [
                $table_name => [
                    'ON' => [
                        $table_item_name => $columnid_name,
                        $table_name => 'id'
                    ]
                ]
            ],
//            'JOIN' => [
//                'glpi_plugin_dlteams_protectivetypes' => [
//                    'FKEY' => [
//                        'glpi_plugin_dlteams_protectivemeasures' => "plugin_dlteams_protectivetypes_id",
//                        'glpi_plugin_dlteams_protectivetypes' => "id"
//                    ]
//                ],
//                'glpi_plugin_dlteams_protectivecategories' => [
//                    'FKEY' => [
//                        'glpi_plugin_dlteams_protectivemeasures' => "plugin_dlteams_protectivecategories_id",
//                        'glpi_plugin_dlteams_protectivecategories' => "id"
//                    ]
//                ],
//            ],
            'WHERE' => [
                $table_item_name . '.itemtype' => ['LIKE', $item::getType()],
                $table_item_name . '.' . 'items_id' => $item->fields['id'],
            ],
            'ORDERBY' => ['name ASC']
        ];


        /*        highlight_string("<?php\n\$data =\n" . var_export($query, true) . ";\n?>");*/
//        die();
        if ($DB->fieldExists($table_item_name, 'comment')) {
            $query['SELECT'][] = $table_item_name . '.comment AS comment';
        }

        if ($DB->fieldExists($table_name, 'content')) {
            $query['SELECT'][] = $table_name . '.content AS content';
        }


        $iterator = $DB->request($query);
        $temp = [];

        foreach ($iterator as $id => $data) {

            if ($data["itemtype"]) {
                $item_object = null;
                $item_str = $data["itemtype"];
                $item_object = new $item_str();
                $item_object->getFromDB($data["items_id"]);


                if (isset($item_object->fields["entities_id"])) {
                    array_push($temp, $data);
                }

            }

        }
        return $temp;
    }



    public static function getSIIRequest(CommonDBTM $item)
    {
        $table_name = PluginDlteamsSIIntegration::getTable(); // si $item = DataCatalog, $table_name contiendra data_catalogs
        $columnid_name = strtolower(str_replace("PluginDlteams", "", PluginDlteamsSIIntegration::class)) . "s_id"; // $columnid_name contiendra users_id si $item = User

//
        global $DB;
        $table_item_name = getTableForItemType(PluginDlteamsSIIntegration::class . "_Item");

        $query = [
            'SELECT' => [
                $table_item_name . '.id AS linkid',
                $table_item_name . '.itemtype AS itemtype',
                $table_item_name . '.items_id AS items_id',
                $table_item_name . '.*',
                $table_name . '.id AS id',
                $table_name . '.name AS name',
                $table_name . '.content AS content',
//                'glpi_plugin_dlteams_protectivetypes.name AS typename',
//                'glpi_plugin_dlteams_protectivecategories.name as namecat',
            ],
            'FROM' => $table_item_name,
            'LEFT JOIN' => [
                $table_name => [
                    'ON' => [
                        $table_item_name => $columnid_name,
                        $table_name => 'id'
                    ]
                ]
            ],
//            'JOIN' => [
//                'glpi_plugin_dlteams_protectivetypes' => [
//                    'FKEY' => [
//                        'glpi_plugin_dlteams_protectivemeasures' => "plugin_dlteams_protectivetypes_id",
//                        'glpi_plugin_dlteams_protectivetypes' => "id"
//                    ]
//                ],
//                'glpi_plugin_dlteams_protectivecategories' => [
//                    'FKEY' => [
//                        'glpi_plugin_dlteams_protectivemeasures' => "plugin_dlteams_protectivecategories_id",
//                        'glpi_plugin_dlteams_protectivecategories' => "id"
//                    ]
//                ],
//            ],
            'WHERE' => [
                $table_item_name . '.itemtype' => ['LIKE', $item::getType()],
                $table_item_name . '.' . 'items_id' => $item->fields['id'],
            ],
            'ORDERBY' => ['name ASC']
        ];


        /*        highlight_string("<?php\n\$data =\n" . var_export($query, true) . ";\n?>");*/
//        die();
        if ($DB->fieldExists($table_item_name, 'comment')) {
            $query['SELECT'][] = $table_item_name . '.comment AS comment';
        }

        if ($DB->fieldExists($table_name, 'content')) {
            $query['SELECT'][] = $table_name . '.content AS content';
        }


        $iterator = $DB->request($query);
        $temp = [];

        foreach ($iterator as $id => $data) {

            if ($data["itemtype"]) {
                $item_object = null;
                $item_str = $data["itemtype"];
                $item_object = new $item_str();
                $item_object->getFromDB($data["items_id"]);


                if (isset($item_object->fields["entities_id"])) {
                    array_push($temp, $data);
                }

            }

        }
        return $temp;
    }



    public function canEdit($ID)
    {
        return true;
    }

    function canCreateItem()
    {
        return true;
    }

    function canViewItem()
    {
        return true;
    }

    function canUpdateItem()
    {
        return true;
    }

    function canDeleteItem()
    {
        return true;
    }

    function canPurgeItem()
    {
        return true;
    }


    static function getTypeName($nb = 0)
    {
        return __("Collection feature", 'dlteams');
    }


    function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {
        if (!$item->canView()) {
            return false;
        }

        switch ($item->getType()) {
            case PluginDlteamsPolicieForm::class :

                $nb = 0;

                if ($_SESSION['glpishow_count_on_tabs']) {
                    $nb = 0;
                }
                return self::createTabEntry(static::getTypeName($nb), "$nb");
        }

        return '';
    }

    static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {

        switch ($item->getType()) {
            case PluginDlteamsPolicieForm::class :
                self::showForPolicieForm($item, $withtemplate);
//                $item->ShowDatacarrierType($item->fields["id"]);
                break;
        }

        return true;
    }


}