<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

class PluginDlteamsPolicieForm_PersonalAndDataCategory extends CommonDBTM implements
    PluginDlteamsExportableInterface
{

    static public $itemtype_1 = 'PluginDlteamsPolicieForm';
    static public $items_id_1 = 'policieforms_id';
    static public $itemtype_2 = 'PluginDlteamsConcernedPerson';
    static public $items_id_2 = 'plugin_dlteams_concernedpersons_id';
    static public $column1_id = '49'; // for dlteams massiveupdate purpose
    static public $column2_id = '42'; // for dlteams massiveupdate purpose
    static public $column3_id = '39'; // for dlteams massiveupdate purpose

    static function canCreate()
    {
        return true;
    }

    static function canView()
    {
        return true;
    }

    static function canUpdate()
    {
        return true;
    }

    static function canDelete()
    {
        return true;
    }

    static function canPurge()
    {
        return true;
    }

    public function canEdit($ID)
    {
        return true;
    }

    function canCreateItem()
    {
        return true;
    }

    function canViewItem()
    {
        return true;
    }

    function canUpdateItem()
    {
        return true;
    }

    function canDeleteItem()
    {
        return true;
    }

    function canPurgeItem()
    {
        return true;
    }


    static function getTypeName($nb = 0)
    {
        return __("People, Datas", 'dlteams');
    }

    public function __construct()
    {
        self::forceTable(PluginDlteamsPolicieForm_Item::getTable());
    }

    function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
    {
        if (!$item->canView()) {
            return false;
        }

        switch ($item->getType()) {
            case PluginDlteamsPolicieForm::class :

                $nb = 0;
//                if ($_SESSION['glpishow_count_on_tabs']) {
//                    $nb = self::countForPolicieForm($item);
//                }
//
//                $nb1 = count($item->ShowDatacarrierTypeGetRequest($item->fields['id']));
//
//                $text = "";
//                if($nb1>0)
//                    $text = "$nb, $nb1";
//                elseif ($nb>0)
//                    $text = "$nb, $nb1";

                if ($_SESSION['glpishow_count_on_tabs']) {
                    $nb = static::countForPolicieform($item);
                }
                return self::createTabEntry(static::getTypeName($nb), "$nb");
        }

        return '';
    }

    static function countForPolicieform($item)
    {
        global $DB;

        // Exécute la requête et récupère l’itérateur
        $iterator = $DB->request(self::getRequest($item));

        // Tableaux associatifs pour stocker les combinaisons uniques
        $uniquePerson = [];
        $uniqueDonnees = [];

        foreach ($iterator as $data) {
            // Combinaisons pour itemtype + items_id
            if (!empty($data['itemtype']) && !empty($data['items_id'])) {
                $key = $data['itemtype'] . '|' . $data['items_id'];
                $uniquePerson[$key] = true;
            }

            // Combinaisons pour itemtype1 + items_id1
            if (!empty($data['itemtype1']) && !empty($data['items_id1'])) {
                $key1 = $data['itemtype1'] . '|' . $data['items_id1'];
                $uniqueDonnees[$key1] = true;
            }
        }

        // Nombre d’éléments distincts
        $person = count($uniquePerson);
        $donnees = count($uniqueDonnees);

        // Si les deux comptes sont supérieurs à zéro, renvoyer "X, Y", sinon chaîne vide
        return ($person > 0 && $donnees > 0)
            ? "$person, $donnees"
            : "";
    }


    static function displayTabContentForItem(CommonGLPI $item, $tabnum = 1, $withtemplate = 0)
    {

        switch ($item->getType()) {
            case PluginDlteamsPolicieForm::class :
                self::showForPolicieForm($item, $withtemplate);
                $item->ShowDatacarrierType($item->fields["id"]);
                break;
        }

        return true;
    }

    /**
     * Normalise la colonne timeline_position pour un enregistrement donné.
     *
     * @param int $recordsId  L’ID du PluginDlteamsRecord parent.
     */
    public static function normalizeTimelinePositions(int $recordsId) {
        global $DB;

        // 1. Charger l’objet parent et construire la requête GLPI
        $record = new PluginDlteamsRecord();
        $record->getFromDB($recordsId);
        $query    = self::getRequest($record);
        $iterator = $DB->request($query);

        // 2. Parcourir et réassigner les positions
        $position = 1;
        $DB->beginTransaction();
        try {
            foreach ($iterator as $row) {
                $linkid = $row['linkid'];
                if ((int)$row['ranking'] !== $position) {
                    $DB->update(
                        'glpi_plugin_dlteams_policieforms_items',
                        ['ranking' => $position],
                        ['id'                => $linkid]
                    );
                }
                $position++;
            }
            $DB->commit();
        } catch (\Exception $e) {
            $DB->rollbackTransaction();
            // Vous pouvez loguer l’erreur ou afficher un message
            Session::addMessageAfterRedirect(
                __('Erreur lors de la normalisation des positions :').' '.$e->getMessage(),
                false,
                ERROR
            );
        }
    }

    public static function showForPolicieForm(PluginDlteamsPolicieForm $policyForm, bool $withTemplate = false): bool
    {
        $id = $policyForm->fields['id'];
        if (!$policyForm->can($id, READ)) {
            return false;
        }

        PluginDlteamsPolicieForm_PersonalAndDataCategory::normalizeTimelinePositions($policyForm->fields["id"]);
        $canEdit = PluginDlteamsPolicieForm::canUpdate();
        $rand = mt_rand(1, mt_getrandmax());

        global $CFG_GLPI, $DB;

        // Fetch items list
        $iterator = $DB->request(self::getRequest($policyForm));


        $itemsList = [];
        foreach ($iterator as $row) {
            $itemsList[$row['linkid']] = $row;
        }

        // Prepare "used" data types based on recent selection
        $recentPersonId = $_SESSION['dlteams_pf_recent_concernedperson'] ?? null;
        $usedDataTypes = [];
        if ($recentPersonId) {
            $filtered = array_filter(
                $itemsList,
                fn($item) => $item['items_id'] == $recentPersonId
            );

            $usedDataTypes = array_column($filtered, 'items_id1');
        }



        // ----- Render input form -----
        echo "<div class='firstbloc'>";
        echo "<form id='policyform_{$rand}' name='policyform_{$rand}' method='post' action='" . Toolbox::getItemTypeFormURL(__CLASS__) . "'>";
        echo Html::hidden('base_id', ['value' => $id]);
        echo Html::hidden('baseitem', ['value' => 'PluginDlteamsPolicieForm']);
        echo Html::hidden('itemtype', ['value' => 'PluginDlteamsConcernedPerson']);
        echo Html::hidden('itemtype1', ['value' => 'PluginDlteamsProcessedData']);

        echo "<table class='tab_cadre_fixe' style='width:100%'>";
        echo "  <tr class='tab_bg_2'><th colspan='5'>"
            . __("Données et catégories de personnes contenues dans ce jeu de données", 'dlteams')
            . "</th></tr>";
        echo "  <tr class='tab_bg_1'>";

        // People category dropdown
        echo "    <td>";
        echo _n("People category", "People categories", 0, 'dlteams') . "<br><br>";
        PluginDlteamsConcernedPerson::dropdown([
            'name' => 'items_id',
            'rand' => $rand,
            'width' => '100%',
            'value' => $recentPersonId,
            'url' => "{$CFG_GLPI['root_doc']}/marketplace/dlteams/ajax/getDropdownValue.php",
        ]);
        echo "<style>
            #page .tab_cadre_fixe .select2-container .select2-selection.select2-selection--single, .qtip .tab_cadre_fixe .select2-container .select2-selection.select2-selection--single, .modal .modal-body .tab_cadre_fixe .select2-container .select2-selection.select2-selection--single {
                max-width: 100%;
            }
        </style>";
        echo "</td>";

        // Data type dropdown
        echo "    <td>";
        echo _n("Data type", "Data types", 0, 'dlteams') . "<br><br>";
        PluginDlteamsProcessedData::dropdown([
            'name' => 'items_id1',
            'used' => $usedDataTypes,
            'width' => '100%',
            'url' => "{$CFG_GLPI['root_doc']}/marketplace/dlteams/ajax/getDropdownValue.php",
        ]);
        echo "</td>";

        // Mandatory flag
        echo "    <td>";
        echo __("Mandatory", 'dlteams') . "<br><br>";
        Dropdown::showYesNo('mandatory', 1);
        echo "</td>";

        // Comment textarea
        echo "    <td>";
        echo "<br><br>";
        Html::textarea([
            'name' => 'comment',
            'enable_fileupload' => false,
            'cols' => 20,
            'rows' => 2,
            'placeholder' => 'Commentaires'
        ]);
        echo "</td>";

        // Submit button
        echo "    <td class='center'>";
        echo "<input type='submit' name='add' value='" . __('Add') . "' class='submit' style='margin-top:35px;'>";
        echo "</td>";

        echo "  </tr>";
        echo "</table>";
        Html::closeForm();
        echo "</div>";

        // ----- Render existing items table -----
        if (count($itemsList) > 0) {
            echo "<div class='spaced'>";

            if ($canEdit) {
                Html::openMassiveActionsForm('mass' . __CLASS__ . $rand);
                Html::showMassiveActions([
                    'container' => 'mass' . __CLASS__ . $rand,
                    'num_displayed' => min($_SESSION['glpilist_limit'], count($itemsList)),
                ]);
            }

            echo "<table class='tab_cadre_fixehov'>";
            echo "<tr>";
            if ($canEdit) {
                echo "<th width='10'>" . Html::getCheckAllAsCheckbox('mass' . __CLASS__ . $rand) . "</th>";
                echo "<th width='5%'></th>";
            }
            echo "<th class='left'>" . _n("People category", "People categories", 0, 'dlteams') . "</th>";
            echo "<th class='left'>" . _n("Data type", "Data types", 0, 'dlteams') . "</th>";
            echo "<th width='10%' class='left'>" . __("Mandatory", 'dlteams') . "</th>";
            echo "<th width='25%' class='left'>" . __("Comment") . "</th>";
            if ($canEdit) {
                echo "<th width='4%'></th>";
            }
            echo "</tr>";

            echo "<tbody class='sortable-rules_pd'>";

            foreach ($itemsList as $data) {

                echo "<tr class='tab_bg_1' data-policieformitems_id='{$data['linkid']}'>";

                if ($canEdit) {
                    echo "<td width='10'>";
                    Html::showMassiveActionCheckBox(__CLASS__, $data['linkid']);
                    echo "</td>";
                    echo "<td width='3%' class='center'>";
                    echo "<i class='fas fa-edit editma_ppd' style='color:#007bff;cursor:pointer' data-id='{$data['linkid']}'></i>";
                    echo "</td>";
                }

                // People category column
                $personName = '----';
                if (!empty($data['itemtype']) && !empty($data['items_id'])) {
                    $obj = new $data['itemtype']();
                    $obj->getFromDB($data['items_id']);
                    $personName = $obj->fields['name'];
                    $personName = "<a target='_blank' href='"
                        . $data['itemtype']::getFormURLWithID($data['items_id'])
                        . "'>{$personName}</a>";
                }
                echo "<td class='left'>{$personName}</td>";

                // Data type column
                $typeName = '----';
                if (!empty($data['itemtype1']) && !empty($data['items_id1'])) {
                    $obj = new $data['itemtype1']();
                    $obj->getFromDB($data['items_id1']);
                    $typeName = $obj->fields['name'];
                    $typeName = "<a target='_blank' href='"
                        . $data['itemtype1']::getFormURLWithID($data['items_id1'])
                        . "'>{$typeName}</a>";
                }
                echo "<td class='left'>{$typeName}</td>";

                echo "<td class='left'>" . ($data['mandatory'] ? __('Yes') : __('No')) . "</td>";
                echo "<td class='left'>" . htmlspecialchars_decode($data['comment'] ?? '') . "</td>";

                if ($canEdit) {
                    echo "<td><i class='fas fa-grip-horizontal grip-rule_pd'></i></td>";
                }

                echo "</tr>";
            }
            echo "</tbody>";
            echo "</table>";

            if ($canEdit) {
                Html::closeForm();
            }

            echo "<script>
            $('.editma_ppd').off('click').click(function(e) {
                
               glpi_ajax_dialog({
                dialogclass: 'modal-xs',
                bs_focus: false,
                url: '/marketplace/dlteams/ajax/edit_items.php',
                params: {
                    action: 'edit_ppd',
                    linkid: $(this).data('id'),
                    itemtype: '" . $policyForm->getType() . "',
                    items_id: '" . $policyForm->fields["id"] . "',
                },
                title: i18n.textdomain('dlteams').__('Action', 'dlteams'),
                close: function () {

                },
                fail: function () {
                    displayAjaxMessageAfterRedirect();
                }
            });
            });
            
            </script>";


            echo "</div>";


            if ($canEdit) {
                $collection_classname = static::getType();
                $js = <<<JAVASCRIPT
         $(function() {
            sortable('.sortable-rules_pd', {
               handle: '.grip-rule_pd',
               placeholder: '<tr><td colspan="7" class="sortable-placeholder">&nbsp;</td></tr>'
            })[0].addEventListener('sortupdate', function(e) {
               var sort_detail          = e.detail;
               console.log('alll');
               console.log(sort_detail);
               var policieformitems_id              = sort_detail.item.dataset.policieformitems_id;
               var collection_classname = "{$collection_classname}";
               var new_index            = sort_detail.destination.index;
               var old_index            = sort_detail.origin.index;
               var ref_id               = sort_detail.destination.itemsBeforeUpdate[new_index].dataset.policieformitems_id;
               var sort_action          = 'after';

               if (old_index > new_index) {
                  sort_action = 'before';
               }

               try{
                $.post(CFG_GLPI['root_doc']+'/marketplace/dlteams/ajax/policieform.php', {
                  'action': 'move_rule',
                  'new_index': new_index,
                  'old_index': old_index,
                  'policieformitems_id': policieformitems_id,
                  'collection_classname': collection_classname,
                  'sort_action': sort_action,
                  'ref_id': ref_id,
               });
               }
               catch(e){
               
               }

               displayAjaxMessageAfterRedirect();
            });
         });
JAVASCRIPT;
                echo Html::scriptBlock($js);

//                $massiveactionparams['ontop'] = false;
//                Html::showMassiveActions($massiveactionparams);
            }
        }

        return true;
    }


    public function getSpecificMassiveActions($checkitem = NULL)
    {
        $actions = parent::getSpecificMassiveActions($checkitem);
        // add a single massive action
        $class = __CLASS__;
        $action_key = "add_data_to_record_dlteams_action";
        $action_label = _n("Ajouter ces données aux traitements liés", "Supprimer", 0, "dlteams");

        $actions[$class . MassiveAction::CLASS_ACTION_SEPARATOR . $action_key] = $action_label;

        return $actions;
    }

    public static function processMassiveActionsForOneItemtype(MassiveAction $ma, CommonDBTM $item, array $ids)
    {
        switch ($ma->getAction()) {
            case 'add_data_to_record_dlteams_action':

                $item = new PluginDlteamsPolicieForm_Item();
                /*                highlight_string("<?php\n\$data =\n" . var_export(array_key_first($ids), true) . ";\n?>");*/
//                die();
                $item->getFromDB(array_key_first($ids));
                $policieforms_id = $item->fields["policieforms_id"];
                $policieform = new PluginDlteamsPolicieForm();
                $policieform->getFromDB($policieforms_id);

                $recordsitems_iterator = PluginDlteamsRecord_Item::getRequest($policieform);
                /*                highlight_string("<?php\n\$data =\n" . var_export(iterator_to_array($recordsitems_iterator), true) . ";\n?>");*/
//                die();
                foreach ($recordsitems_iterator as $record_item) {
                    foreach ($ids as $policieforms_items_id) {
//                        highli/
                        $policieform_item = new PluginDlteamsPolicieForm_Item();
                        $policieform_item->getFromDB($policieforms_items_id);

                        $recordtemp = new PluginDlteamsRecord_Item();
                        if (!$recordtemp->getFromDBByCrit([
                            "records_id" => $record_item["records_id"],
                            "itemtype" => $policieform_item->fields["itemtype"],
                            "itemtype1" => $policieform_item->fields["itemtype1"],
                            "items_id" => $policieform_item->fields["items_id"],
                            "items_id1" => $policieform_item->fields["items_id1"],
                        ])) {
                            $record_itemobject = new PluginDlteamsRecord_Item();
                            $result = $record_itemobject->add([
                                "records_id" => $record_item["records_id"],
                                "itemtype" => $policieform_item->fields["itemtype"],
                                "itemtype1" => $policieform_item->fields["itemtype1"],
                                "items_id" => $policieform_item->fields["items_id"],
                                "items_id1" => $policieform_item->fields["items_id1"],
                                "mandatory" => $policieform_item->fields["mandatory"],
                                "comment" => $policieform_item->fields["comment"],
                            ]);

                            if ($policieform_item->fields["itemtype"] && $policieform_item->fields["itemtype"] == PluginDlteamsConcernedPerson::class) {
                                $cp_i = new PluginDlteamsConcernedPerson_Item();
                                $cp_i->add([
                                    "concernedpersons_id" => $policieform_item->fields["items_id"],
                                    "itemtype" => PluginDlteamsRecord::class,
                                    "items_id" => $record_item["records_id"],
                                    "itemtype1" => $policieform_item->fields["itemtype1"],
                                    "items_id1" => $policieform_item->fields["items_id1"],
                                    "comment" => $policieform_item->fields["comment"],
                                ]);
                            }

                            if ($policieform_item->fields["itemtype1"] && $policieform_item->fields["itemtype1"] == PluginDlteamsProcessedData::class) {
                                $pd_i = new PluginDlteamsProcessedData_Item();
                                $pd_i->add([
                                    "processeddatas_id" => $policieform_item->fields["items_id1"],
                                    "itemtype" => PluginDlteamsRecord::class,
                                    "items_id" => $record_item["records_id"],
                                    "itemtype1" => $policieform_item->fields["itemtype"],
                                    "items_id1" => $policieform_item->fields["items_id"],
                                    "comment" => $policieform_item->fields["comment"],
                                ]);
                            }
                        }

                        if (array_key_first($ma->getRemainings()))
                            $ma->itemDone(array_key_first($ma->getRemainings()), $policieforms_items_id, MassiveAction::ACTION_OK);
                    }
                }

                Session::addMessageAfterRedirect(sprintf(__('Opération éffectuée avec succès', 'dlteams'), $item->getName()));

                return;
        }
    }


    function getForbiddenStandardMassiveAction()
    {

        $forbidden = parent::getForbiddenStandardMassiveAction();
        $forbidden[] = 'MassiveAction:amend_comment';
        $forbidden[] = 'MassiveAction:add_transfer_list';

        return $forbidden;
    }

    function rawSearchOptions()
    {

        $tab = [];

        /*$tab[] = [
           'id' => 'datasubjectscategory',
           'name' => PluginGenericobjectPersonnesconcernee::getTypeName(0)
        ];*/

        $tab[] = [
            'id' => "410",
            'table' => PluginDlteamsConcernedPerson::getTable(),
            'field' => 'items_id',
            'name' => __("Catégorie de personnes"),
            'forcegroupby' => true,
            'massiveaction' => true,
            'datatype' => 'dropdown',
        ];

        $tab[] = [
            'id' => "411",
            'table' => PluginDlteamsProcessedData::getTable(),
            'field' => 'items_id1',
            'name' => __("Catégories de données"),
            'forcegroupby' => true,
            'massiveaction' => true,
            'datatype' => 'dropdown',
        ];

        $tab[] = [
            'id' => "412",
            'table' => 'mandatory',
            'field' => 'mandatory',
            'name' => __("Obligatoire"),
            'forcegroupby' => true,
            'massiveaction' => true,
            'datatype' => 'bool',
        ];


        return $tab;
    }

    public function update(array $input, $history = 1, $options = [])
    {

        $plicieform_item = new PluginDlteamsPolicieForm_Item();
        $plicieform_item->getFromDB($input["id"]);
        $policieform_oldfields = $plicieform_item->fields;

        global $DB;
        if (isset($input["plugin_dlteams_concernedpersons_id"])) {
            $DB->update(
                $plicieform_item->getTable(),
                [
                    "items_id" => $input["plugin_dlteams_concernedpersons_id"]
                ],
                [
                    "id" => $input["id"]
                ]
            );


//            mis a jour de concerned person
            $concernedperson_item = new PluginDlteamsConcernedPerson_Item();
            $concernedperson_item->getFromDBByCrit([
                "concernedpersons_id" => $policieform_oldfields["items_id"],
                "itemtype" => PluginDlteamsPolicieForm::class,
                "items_id" => $policieform_oldfields["policieforms_id"],
                "itemtype1" => $policieform_oldfields["itemtype1"],
                "items_id1" => $policieform_oldfields["items_id1"],
                "comment" => $policieform_oldfields["comment"],
            ]);
            if ($concernedperson_item) {
                $DB->update(
                    $concernedperson_item->getTable(),
                    [
                        "concernedpersons_id" => $input["plugin_dlteams_concernedpersons_id"]
                    ],
                    [
                        "id" => $concernedperson_item->fields["id"]
                    ]
                );

                Session::addMessageAfterRedirect("Relation " . PluginDlteamsConcernedPerson::getTypeName() . " mis a jour avec succès");
            }

//            mise a jour de processed data item
            $processeddata_item = new PluginDlteamsProcessedData_Item();
            $processeddata_item->getFromDBByCrit([
                "processeddatas_id" => $policieform_oldfields["items_id1"],
                "itemtype" => PluginDlteamsPolicieForm::class,
                "items_id" => $policieform_oldfields["policieforms_id"],
                "itemtype1" => $policieform_oldfields["itemtype"],
                "items_id1" => $policieform_oldfields["items_id"],
                "comment" => $policieform_oldfields["comment"],
            ]);
            if ($processeddata_item) {
                $DB->update(
                    $processeddata_item->getTable(),
                    [
                        "items_id1" => $input["plugin_dlteams_concernedpersons_id"]
                    ],
                    [
                        "id" => $processeddata_item->fields["id"]
                    ]
                );

                Session::addMessageAfterRedirect("Relation " . PluginDlteamsProcessedData::getTypeName() . " mis a jour avec succès");
            }
        }

        if (isset($input["plugin_dlteams_processeddatas_id"])) {
            $DB->update(
                $plicieform_item->getTable(),
                [
                    "items_id1" => $input["plugin_dlteams_processeddatas_id"]
                ],
                [
                    "id" => $input["id"]
                ]
            );
            Session::addMessageAfterRedirect("Traitement mis à jour avec succès");


            $processeddata_item = new PluginDlteamsProcessedData_Item();
            $processeddata_item->getFromDBByCrit([
                "processeddatas_id" => $policieform_oldfields["items_id1"],
                "itemtype" => PluginDlteamsPolicieForm::class,
                "items_id" => $policieform_oldfields["policieforms_id"],
                "itemtype1" => $policieform_oldfields["itemtype"],
                "items_id1" => $policieform_oldfields["items_id"],
                "comment" => $policieform_oldfields["comment"],
            ]);
            if ($processeddata_item) {
                $DB->update(
                    $processeddata_item->getTable(),
                    [
                        "processeddatas_id" => $input["plugin_dlteams_processeddatas_id"]
                    ],
                    [
                        "id" => $processeddata_item->fields["id"]
                    ]
                );

                Session::addMessageAfterRedirect("Relation " . PluginDlteamsProcessedData::getTypeName() . " mis a jour avec succès");
            }


            //            mis a jour de concerned person
            $concernedperson_item = new PluginDlteamsConcernedPerson_Item();
            $concernedperson_item->getFromDBByCrit([
                "concernedpersons_id" => $policieform_oldfields["items_id"],
                "itemtype" => PluginDlteamsPolicieForm::class,
                "items_id" => $policieform_oldfields["policieforms_id"],
                "itemtype1" => $policieform_oldfields["itemtype1"],
                "items_id1" => $policieform_oldfields["items_id1"],
                "comment" => $policieform_oldfields["comment"],
            ]);
            if ($concernedperson_item) {
                $DB->update(
                    $concernedperson_item->getTable(),
                    [
                        "items_id1" => $input["plugin_dlteams_processeddatas_id"]
                    ],
                    [
                        "id" => $concernedperson_item->fields["id"]
                    ]
                );

                Session::addMessageAfterRedirect("Relation " . PluginDlteamsConcernedPerson::getTypeName() . " mis a jour avec succès");
            }
        }


        if (isset($input["mandatory"])) {
            $DB->update(
                $plicieform_item->getTable(),
                [
                    "mandatory" => $input["mandatory"]
                ],
                [
                    "id" => $input["id"]
                ]
            );
        }

        Session::addMessageAfterRedirect("Traitement modifié avec succès");
        return true; // TODO: Change the autogenerated stub
    }

//    static function countForPolicieForm($policieform)
//    {
//        global $DB;
//        $items_list = [];
//        $iterator = $DB->request(self::getRequest($policieform));
//        foreach ($iterator as $id => $data) {
//            //while ($data = $iterator->next()) {
////            if (($data['itemtype'] === 'PluginDlteamsConcernedPerson' && $data['itemtype1'] == null)
////                || ($data['itemtype1'] === 'PluginDlteamsProcessedData' && $data['itemtype'] == null )
////                ) {
////                $items_list[$data['linkid']] = $data;
////                $used[$data['linkid']] = $data['linkid'];
////            }
//
//            array_push($items_list, $data);
//        }
////        var_dump(count($items_list));
////        die();
//
//        return count($items_list);
//    }

    static function getRequest($policieform, $all = false)
    {
        return [
            'SELECT' => [
                'glpi_plugin_dlteams_policieforms_items.id AS linkid',
                'glpi_plugin_dlteams_policieforms_items.*',
                'glpi_plugin_dlteams_concernedpersons.name AS gpdpname',
                'glpi_plugin_dlteams_processeddatas.name AS gpddname',
                'glpi_plugin_dlteams_policieforms_items.comment AS comment',
                'glpi_plugin_dlteams_policieforms_items.mandatory AS mandatory',
                'glpi_plugin_dlteams_concernedpersons.ranking as cpnumber',
                'glpi_plugin_dlteams_processeddatas.number as pdnumber',

            ],
            'FROM' => 'glpi_plugin_dlteams_policieforms_items',
            'JOIN' => [
                'glpi_plugin_dlteams_policieforms' => [
                    'FKEY' => [
                        'glpi_plugin_dlteams_policieforms_items' => "policieforms_id",
                        'glpi_plugin_dlteams_policieforms' => "id"
                    ],
                ],
            ],
            'LEFT JOIN' => [
                'glpi_plugin_dlteams_concernedpersons' => [
                    'FKEY' => [
                        'glpi_plugin_dlteams_policieforms_items' => "items_id",
                        'glpi_plugin_dlteams_concernedpersons' => "id",
                    ]
                ],
                'glpi_plugin_dlteams_processeddatas' => [
                    'FKEY' => [
                        'glpi_plugin_dlteams_policieforms_items' => "items_id1",
                        'glpi_plugin_dlteams_processeddatas' => "id",

                    ],
                ],
            ],
            'ORDERBY' => [
                'glpi_plugin_dlteams_policieforms_items.ranking ASC'
            ],
            'WHERE' => [
                'OR' => [
                    [
//                        'glpi_plugin_dlteams_policieforms_items.policieforms_id' => $policieform->fields['id'],
                        'glpi_plugin_dlteams_policieforms_items.itemtype' => 'PluginDlteamsConcernedPerson',
                        'glpi_plugin_dlteams_policieforms_items.itemtype1' => null,
                        'glpi_plugin_dlteams_concernedpersons.is_deleted' => 0,
                    ] + ($all ? [
                        'glpi_plugin_dlteams_policieforms.entities_id' => Session::getActiveEntity()
                    ] : ['glpi_plugin_dlteams_policieforms_items.policieforms_id' => $policieform->fields['id']]),
                    [
//                        'glpi_plugin_dlteams_policieforms_items.policieforms_id' => $policieform->fields['id'],
                        'glpi_plugin_dlteams_policieforms_items.itemtype' => 'PluginDlteamsConcernedPerson',
                        'glpi_plugin_dlteams_policieforms_items.itemtype1' => 'PluginDlteamsProcessedData',
                        'glpi_plugin_dlteams_policieforms_items.items_id1' => 0,
                        'glpi_plugin_dlteams_concernedpersons.is_deleted' => 0,
                    ] + ($all ? ['glpi_plugin_dlteams_policieforms.entities_id' => Session::getActiveEntity()] : ['glpi_plugin_dlteams_policieforms_items.policieforms_id' => $policieform->fields['id']]),
                    [
//                        'glpi_plugin_dlteams_policieforms_items.policieforms_id' => $policieform->fields['id'],
                        'glpi_plugin_dlteams_policieforms_items.itemtype' => null,
                        'glpi_plugin_dlteams_policieforms_items.itemtype1' => 'PluginDlteamsProcessedData',
                        'glpi_plugin_dlteams_processeddatas.is_deleted' => 0,
                    ] + ($all ? ['glpi_plugin_dlteams_policieforms.entities_id' => Session::getActiveEntity()] : ['glpi_plugin_dlteams_policieforms_items.policieforms_id' => $policieform->fields['id']]),
                    [
//                        'glpi_plugin_dlteams_policieforms_items.policieforms_id' => $policieform->fields['id'],
                        'glpi_plugin_dlteams_policieforms_items.itemtype' => 'PluginDlteamsConcernedPerson',
                        'glpi_plugin_dlteams_policieforms_items.items_id' => 0,
                        'glpi_plugin_dlteams_policieforms_items.itemtype1' => 'PluginDlteamsProcessedData',
                        'glpi_plugin_dlteams_processeddatas.is_deleted' => 0,
                    ] + ($all ? ['glpi_plugin_dlteams_policieforms.entities_id' => Session::getActiveEntity()] : ['glpi_plugin_dlteams_policieforms_items.policieforms_id' => $policieform->fields['id']]),
                    [
//                        'glpi_plugin_dlteams_policieforms_items.policieforms_id' => $policieform->fields['id'],
                        'glpi_plugin_dlteams_policieforms_items.itemtype' => 'PluginDlteamsConcernedPerson',
                        'glpi_plugin_dlteams_policieforms_items.itemtype1' => 'PluginDlteamsProcessedData',
                        'glpi_plugin_dlteams_concernedpersons.is_deleted' => 0,
                        'glpi_plugin_dlteams_processeddatas.is_deleted' => 0,
//                    'glpi_plugin_dlteams_records_items.policieforms_id' => $policieform->fields['id'],
                    ] + ($all ? ['glpi_plugin_dlteams_policieforms.entities_id' => Session::getActiveEntity()] : ['glpi_plugin_dlteams_policieforms_items.policieforms_id' => $policieform->fields['id']])
                ],
            ]
        ];
    }


    static function getMaxRankingRequest($policieform)
    {
        global $DB;

        $max = 0;
        $iterator = $DB->request([
            'SELECT' => ['MAX' => 'ranking AS max_ranking'],
            'FROM' => 'glpi_plugin_dlteams_policieforms_items',
            'LEFT JOIN' => [
                'glpi_plugin_dlteams_concernedpersons' => [
                    'FKEY' => [
                        'glpi_plugin_dlteams_policieforms_items' => "items_id",
                        'glpi_plugin_dlteams_concernedpersons' => "id",
                    ]
                ],
                'glpi_plugin_dlteams_processeddatas' => [
                    'FKEY' => [
                        'glpi_plugin_dlteams_policieforms_items' => "items_id1",
                        'glpi_plugin_dlteams_processeddatas' => "id",

                    ],
                ],
            ],
            'WHERE' => [
                'OR' => [
                    [
                        'glpi_plugin_dlteams_policieforms_items.policieforms_id' => $policieform->fields['id'],
                        'glpi_plugin_dlteams_policieforms_items.itemtype' => 'PluginDlteamsConcernedPerson',
                        'glpi_plugin_dlteams_policieforms_items.itemtype1' => null,
                        'glpi_plugin_dlteams_concernedpersons.is_deleted' => 0,
                    ],
                    [
                        'glpi_plugin_dlteams_policieforms_items.policieforms_id' => $policieform->fields['id'],
                        'glpi_plugin_dlteams_policieforms_items.itemtype' => 'PluginDlteamsConcernedPerson',
                        'glpi_plugin_dlteams_policieforms_items.itemtype1' => 'PluginDlteamsProcessedData',
                        'glpi_plugin_dlteams_policieforms_items.items_id1' => 0,
                        'glpi_plugin_dlteams_concernedpersons.is_deleted' => 0,
                    ],
                    [
                        'glpi_plugin_dlteams_policieforms_items.policieforms_id' => $policieform->fields['id'],
                        'glpi_plugin_dlteams_policieforms_items.itemtype' => null,
                        'glpi_plugin_dlteams_policieforms_items.itemtype1' => 'PluginDlteamsProcessedData',
                        'glpi_plugin_dlteams_processeddatas.is_deleted' => 0,
                    ],
                    [
                        'glpi_plugin_dlteams_policieforms_items.policieforms_id' => $policieform->fields['id'],
                        'glpi_plugin_dlteams_policieforms_items.itemtype' => 'PluginDlteamsConcernedPerson',
                        'glpi_plugin_dlteams_policieforms_items.items_id' => 0,
                        'glpi_plugin_dlteams_policieforms_items.itemtype1' => 'PluginDlteamsProcessedData',
                        'glpi_plugin_dlteams_processeddatas.is_deleted' => 0,
                    ],
                    [
                        'glpi_plugin_dlteams_policieforms_items.policieforms_id' => $policieform->fields['id'],
                        'glpi_plugin_dlteams_policieforms_items.itemtype' => 'PluginDlteamsConcernedPerson',
                        'glpi_plugin_dlteams_policieforms_items.itemtype1' => 'PluginDlteamsProcessedData',
                        'glpi_plugin_dlteams_concernedpersons.is_deleted' => 0,
                        'glpi_plugin_dlteams_processeddatas.is_deleted' => 0,
//                    'glpi_plugin_dlteams_records_items.policieforms_id' => $policieform->fields['id'],
                    ]
                ],
            ]
        ]);
        if (count($iterator)) {
            $max = $iterator->current()['max_ranking'];
        }


        return $max;
    }


    protected function toggleMandatory($input)
    {
        $this->fields['mandatory'] = $input['mandatory'];
        return $this->updateInDB(['mandatory']);
    }

    /**
     * Export in an array all the data of the current instanciated PluginDlteamsPolicieForm_PersonalAndDataCategory
     * @param boolean $remove_uuid remove the uuid key
     *
     * @return array the array with all data (with sub tables)
     */
    public function exportToDB($remove_uuid = false, $subItems = [])
    {
        if ($this->isNewItem()) {
            return false;
        }

        $personal_data_catagory = $this->fields;
        return $personal_data_catagory;
    }


    public static function importToDB(PluginDlteamsLinker $linker, $input = [], $policieform_id = 0, $subItems = [])
    {
        $policieformFk = PluginDlteamsPolicieForm::getForeignKeyField();
        $input[$policieformFk] = $policieform_id;

        $item = new self();
        $originalId = $input['id'];
        unset($input['id']);
        $itemId = $item->add($input);
        if ($itemId === false) {
            $typeName = strtolower(self::getTypeName());
            throw new ImportFailureException(sprintf(__('failed to copy the %1$s policieform', 'dlteams'), $input['name']));
        }
        $linker->addObject($originalId, $item);
        return $itemId;
    }

    public function deleteObsoleteItems(CommonDBTM $container, array $exclude)
    {
    }


    public function post_purgeItem()
    {
//        purge relation 1
        if ($this->fields["itemtype"] && $this->fields["items_id"]) {
            $relation_item_str = $this->fields["itemtype"] . "_Item";
            if (!class_exists($relation_item_str))
                $relation_item_str = "PluginDlteams" . $relation_item_str;
            $relation_item = new $relation_item_str();

            $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype"]))) . "s_id";

            $criteria = [
                "itemtype" => "PluginDlteamsPolicieForm",
                "items_id" => $this->fields["policieforms_id"],
                $relation_column_id => $this->fields["items_id"],
                "itemtype1" => $this->fields["itemtype1"],
                "items_id1" => $this->fields["items_id1"],
                "comment" => $this->fields["comment"]
            ];

            if ($relation_item->deleteByCriteria($criteria))
                Session::addMessageAfterRedirect("Relation " . $relation_item::getTypeName() . " supprimé avec succès");
        }


        //        purge relation 2
        if ($this->fields["itemtype1"] && $this->fields["items_id1"]) {

            $relation_item_str = $this->fields["itemtype1"] . "_Item";
            if (!class_exists($relation_item_str))
                $relation_item_str = "PluginDlteams" . $relation_item_str;
            $relation_item = new $relation_item_str();

            $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype1"]))) . "s_id";

            $criteria = [
                "itemtype" => "PluginDlteamsPolicieForm",
                "items_id" => $this->fields["policieforms_id"],
                $relation_column_id => $this->fields["items_id1"],
                "itemtype1" => $this->fields["itemtype"],
                "items_id1" => $this->fields["items_id"],
                "comment" => $this->fields["comment"]
            ];

            if ($relation_item->deleteByCriteria($criteria))
                Session::addMessageAfterRedirect("Relation " . $relation_item::getTypeName() . " supprimé avec succès");
        }
    }
}
