<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

use GlpiPlugin\dlteams\Exception\ImportFailureException;
//class PluginDlteamsStoragePeriod extends CommonDBTM implements
class PluginDlteamsStoragePeriod extends CommonDropdown implements
   PluginDlteamsExportableInterface{
   use PluginDlteamsExportable;
   static $rightname = 'plugin_dlteams_storageperiod';
    public static $menukey = "datagovernancestorageperiod";
    public $dohistory = true;
   protected $usenotepad = true;
   static function getTypeName($nb = 0) {
      return _n("Conservation duration", "Conservation durations", $nb, 'dlteams');
   }

   public static function canDelete()
   {
       return true;
   }

    public static function canPurge()
    {
        return true;
    }


    public static function getMenuContent()
    {

        $menu = [];
        $menu['title'] = static::getTypeName(Session::getPluralNumber());
        $menu['shortcut'] = 'n';
        $menu['page'] = static::getSearchURL();
        $menu['icon'] = self::getIcon();
        $menu['config']['default'] = '/front/dropdown.php';


        $menu['options'] = [];
//        Bouton add
        if (static::canCreate()) {
            $menu['options']["storageperiod"]['links']['add'] = static::getFormURL(false);
        }

//        bouton rechercher
        $menu['options']["storageperiod"]['links']['search'] = static::getSearchURL(false);



//        bouton help
        $image = "<i class='fas fa-question' title='" . 'Aide' . "'></i>";
        $menu['options']["storageperiod"]['links'][$image] = KnowbaseItem::getSearchURL(false) . '?contains="durées de conservation"';

        echo "<script>
                        \$(document).ready(function () {
                            // Attendre que la page soit complètement chargée
                            \$('a[href^=\"/front/knowbaseitem.php?contains=\"]').attr('target', '_blank');
                           
                        });
                    </script>";


        if (count($_SESSION['glpiprofiles']) > 1) {
            $profile = new Profile();
            $name = 'Vue-Modele';
            $options = [
                'SELECT' => [
                    'id'
                ],
                'WHERE' => [
                    'name' => $name,
                ]
            ];

            global $DB;
            $req = $DB->request($profile->getTable(), $options);
            foreach ($req as $id => $row) {
                //if ($row = $req->next()) {
                $profile->getFromDB($row['id']);
                if (array_key_exists($profile->getID(), $_SESSION['glpiprofiles'])) {
                    $swap = $_SESSION['glpiactiveprofile']['id'] == $profile->getID();
                    $text = '<i class="fa fa-layer-group pointer" style="margin-right: 0.4em;"></i>' . __("Swap to model view", "dlteams");
                    $returnKey = array_key_first($_SESSION['glpiprofiles']) == $profile->getID() ? array_keys($_SESSION['glpiprofiles'])[1] : array_key_first($_SESSION['glpiprofiles']);
                    $prodif = $profile->getID();
                    $server_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
                    empty($swap) ? $text = "vue modèle" : $text = "vue modèle";
                    empty($swap) ? $val = $prodif : $val = $returnKey;
                    empty($swap) ? $checked = '' : $checked = 'checked';


                    $text_temp = "<div id='switchmodelcontainer' style='width:100%; display: flex;justify-content: center; margin-bottom: 1px; margin-right: 25px;'>
                                        <label class='form-check form-switch btn-xs  me-0 me-sm-1 px-1 py-1 mb-0 flex-column-reverse flex-sm-row'
                                            title='$text'>
                                         <input type='checkbox' class='form-check-input ms-0 me-1 mt-0' role='button'
                                                autocomplete='off'
                                                $checked
                                                onclick='window.location.href=`$server_url/front/central.php?newprofile=$val`'
                                                />
                                         <span class='form-check-label mb-1 mb-sm-0'>
                                            $text
                                         </span>
                                      </label></div>
                                      
                                      <script>
                                            var child = document.getElementById('switchmodelcontainer');
                                            var parent = child.parentNode;
                                            parent.style.border = 'none';
                                            parent.classList.remove('btn-outline-secondary');
                                        </script>
                            ";


                    $menu['options']["storageperiod"]['links'][$text_temp] = "/front/central.php?newprofile=$val";
                    break;


                }
            }

        }

        return $menu;
    }
    public static function getCurrentId()
    {
        // Get the current URL
        $currentURL = $_SERVER['REQUEST_URI'];

        // Get the query string from the URL
        $queryString = parse_url($currentURL, PHP_URL_QUERY);

        // Initialize an empty array for query parameters
        $queryParams = [];

        // Parse the query string into an array of parameters if it exists
        if ($queryString) {
            parse_str($queryString, $queryParams);
        }

        // Get the value of the "id" parameter
        $id = isset($queryParams['id']) ? $queryParams['id'] : null;

        return $id;
    }


    function showForm($id, $options = [])
   {
      global $CFG_GLPI;
      $this->initForm($id, $options);
      $this->showFormHeader($options);

       echo "<style>";
       echo "
            .form-table-text {
                text-align: right;
                width: 25%;
            }
            
            @media (max-width: 800px) {
                .form-table-text {
                    text-align: left;
                    width: 100%;
                }
            }
        ";

       echo "</style>";
	echo "<table, th, td width='100%'>";
	  echo "<tr>";
//		echo "<td width='15%' style='text-align:right'>". " " . "</td>";
		echo "<td class='form-table-text' >". __("Name", 'dlteams') . "</td>";
		echo "<td>";
		$name = Html::cleanInputText($this->fields['name']);
		echo "<input type='text' style='width:98%' name='name' required value='" . $name. "'>" . "</td>";
		echo "<td width='15%' style='text-align:right'>". " " . "</td>";
	  echo "</tr>" ;

	  echo "<tr>";
//      echo "<td width='15%' style='text-align:right'>". " " . "</td>";
	  echo "<td class='form-table-text'>" . __("Données concernées", 'dlteams') . "</td>";
	  echo "<td>";
      $content = Html::cleanInputText($this->fields['content']);
//      echo "<textarea style='width: 98%;' name='content' rows='3'>" . $content . "</textarea>";
       Html::textarea(['name'            => 'content',
           'value'           => $content,
           'cols'            => 60,
           'rows'            => 3,
           'enable_richtext' => true]);
      echo "</td></tr>";

/*	  echo "<tr>";
	  echo "<td width='15%' style='text-align:right'>". " " . "</td>";
      echo "<td width='0%' div style='text-align:right'>". __("Catégorie de stockage", 'dlteams') . "</div></td>";
	  echo "<td>";
         PluginDlteamsStorageType::dropdown([
            'addicon'  => PluginDlteamsStorageType::canCreate(),
            'name' => 'plugin_dlteams_storagetypes_id',
            'width' => '250px%',
			'value' => $this->fields['plugin_dlteams_storagetypes_id']
         ]);
	  echo "</td></tr>"; */

	  /*echo "<tr>";
      echo "<td class='form-table-text'>". __("URL", 'dlteams')."</td>";
         echo "<td style='display: flex; align-items: center'>";
        $name = Html::cleanInputText($this->fields['url']);
        echo "<input type='text' style='width:98%' name='url' value='" . $name. "'>";
        if($this->fields["url"])
        echo "&nbsp;<a target='_blank' href='" . $this->fields["url"] . "'><i class=\"fas fa-link\"></i></a>";
        echo "</td>";
      echo "</tr>";

      echo "<tr>";
      echo "<td class='form-table-text'>". __("URL2", 'dlteams')."</td>";
         echo "<td style='display: flex; align-items: center'>";
        $name = Html::cleanInputText($this->fields['url2']);
        echo "<input type='text' style='width:98%' name='url2' value='" . $name. "'>";

        if($this->fields["url2"])
			echo "&nbsp;<a target='_blank' href='" . $this->fields["url2"] . "'><i class=\"fas fa-link\"></i></a>";
        echo "</td>";
       echo "</tr>";*/

      echo "<tr>";
//      echo "<td width='15%' style='text-align:right'>". " " . "</td>";
	  echo "<td class='form-table-text'>" . __("Comment", 'dlteams') . "</td>";
      echo "<td>";
	  $comment = Html::cleanInputText($this->fields['comment']);
      echo "<textarea style='width: 98%;' name='comment' rows='3'>" . $comment . "</textarea>";
      echo "</td></tr>";
    echo "</table>";

        $options["withtemplate"] = "";
      $this->showFormButtons($options);


        echo "<script>
            document.querySelector('button[name=purge]').removeAttribute('onclick');

            $(document).off('click').on('click', 'button[name=purge]', function (e) {
                console.log($('input[name=id]').val());
                e.preventDefault();
//                
                glpi_ajax_dialog({
                dialogclass: 'modal-lg',
                bs_focus: false,
                url: '/marketplace/dlteams/ajax/confirm_purge_relations.php',
                params: { itemtype: 'PluginDlteamsStoragePeriod', items_id: $('input[name=id]').val() },
                title: i18n.textdomain('dlteams').__('Confirmation', 'dlteams'),
                close: function () {},
                fail: function () {
                    displayAjaxMessageAfterRedirect();
                }
            });
            });

        </script>";
      return true;
   }


   function prepareInputForAdd($input) {

      $input['users_id_creator'] = Session::getLoginUserID();

      return parent::prepareInputForAdd($input);
   }


//    public static function addWhere($link = "", $nott = "", $itemtype = "", $ID = null, $searchtype = "", $val = "", $meta = 0)
//    {
//
////        var_dump("zzz");
////        die();
//
//            $entity_filter = " AND `glpi_tickets`.`entities_id` = " . Session::getActiveEntity();
//
//        $where = "";
//        if($ID == 12){
//            $where.= " `".TicketTask::getTable()."`.`state` = ".$val.$entity_filter;
//        }
//        return $where;
//    }

   function prepareInputForUpdate($input) {

      $input['users_id_lastupdater'] = Session::getLoginUserID();

      return parent::prepareInputForUpdate($input);
   }

   function cleanDBonPurge() {
      /*$rel = new PluginDlteamsRecord_MotifEnvoi();
      $rel->deleteByCriteria(['plugin_dlteams_concernedpersons_id' => $this->fields['id']]);*/
   }

   function rawSearchOptions() {

      $tab = [];

      $tab[] = [
         'id'                 => 'common',
         'name'               => __("Characteristics")
      ];

      $tab[] = [
         'id'                 => '1',
         'table'              => $this->getTable(),
         'field'              => 'name',
         'name'               => __("Name"),
         'datatype'           => 'itemlink',
         'massiveaction'      => false,
         'autocomplete'       => true,
      ];

      $tab[] = [
         'id'                 => '2',
         'table'              => $this->getTable(),
         'field'              => 'id',
         'name'               => __("ID"),
         'massiveaction'      => false,
         'datatype'           => 'number',
      ];

      $tab[] = [
         'id'                 => '3',
         'table'              => $this->getTable(),
         'field'              => 'comment',
         'name'               => __("Comments"),
         'datatype'           => 'text',
         'toview'             => true,
         'massiveaction'      => true,
      ];

      $tab[] = [
         'id'                 => '4',
         'table'              => 'glpi_entities',
         'field'              => 'completename',
         'name'               => __("Entity"),
         'datatype'           => 'dropdown',
         'massiveaction'      => true,
      ];

      $tab[] = [
         'id'                 => '5',
         'table'              => $this->getTable(),
         'field'              => 'is_recursive',
         'name'               => __("Child entities"),
         'datatype'           => 'bool',
         'massiveaction'      => false,
      ];

	  $tab[] = [
         'id'                 => '6',
         'table'              => $this->getTable(),
         'field'              => 'content',
         'name'               => __("Données concernées"),
         'datatype'           => 'specific',
         'toview'             => true,
         'massiveaction'      => true,
         'htmltext'           => true
      ];

      $tab[] = [
          'id' 			=> '13',
          'table' 		=> $this->getTable(),
          'field' 		=> 'date_mod',
          'name' 		=> __("Last update"),
          'massiveaction' => false,
          'datatype' 	=> 'text',
      ];

       $tab[] = [
           'id'                 => '108',
           'table'              => PluginDlteamsStoragePeriod_Item::getTable(),
           'field'              => 'items_id',
           'name'               => _x('quantity', 'Traitements'),
           'datatype'           => 'specific',
           'comments'           => true,
           'nosort'             => true,
           'nosearch'           => true,
           'additionalfields'   => ['itemtype'],
           'joinparams'         => [
               'linkfield' => 'storageperiods_id',
               'jointype'           => 'child',
               'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsRecord::class."' AND NEWTABLE.`items_id` <> 0 AND NEWTABLE.`items_id` IN (SELECT `id` FROM `glpi_plugin_dlteams_records`)",
           ],
           'forcegroupby'       => true,
           'massiveaction'      => false,

           'showrecords' => true
       ];

       $tab[] = [
           'id'                 => '111',
           'table'              => PluginDlteamsStoragePeriod_Item::getTable(),
           'field'              => 'items_id',
           'name'               => _x('quantity', 'Jeux de données'),
           'datatype'           => 'specific',
           'comments'           => true,
           'nosort'             => true,
           'nosearch'           => true,
           'additionalfields'   => ['itemtype'],
           'joinparams'         => [
               'linkfield' => 'storageperiods_id',
               'jointype'           => 'child',
               'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsPolicieForm::class."' AND NEWTABLE.`items_id` <> 0 AND NEWTABLE.`items_id` IN (SELECT `id` FROM `glpi_plugin_dlteams_records`)",
           ],
           'forcegroupby'       => true,
           'massiveaction'      => false,

           'showPolicies' => true
       ];
//
//       $tab[] = [
//           'id'                 => '111',
//           'table'              => PluginDlteamsProcessedData_Item::getTable(),
//           'field'              => 'id',
//           'name'               => _x('quantity', 'Jeux de données'),
//           'datatype'           => 'count',
//           'comments'           => true,
//           'nosort'             => true,
//           'nosearch'           => true,
//           'joinparams'         => [
//               'linkfield' => 'processeddatas_id',
//               'jointype'           => 'child', // TODO: revoir le pb d'entité
//               'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsPolicieForm::class."'
//                                AND NEWTABLE.`items_id` <> 0
//                                AND NEWTABLE.`items_id` IN (SELECT `id` FROM `".PluginDlteamsPolicieForm::getTable()."`
//
//                                WHERE `entities_id` IN (".implode(',', array_map('intval', $_SESSION["glpiactiveentities"] ))."))",
//           ],
//           'forcegroupby'       => true,
//           'massiveaction'      => false,
//       ];


	  /*$tab[] = [
         'id'                 => '7',
         'table'              => $this->getTable(),
         'field'              => 'url',
         'name'               => __("URL"),
         'datatype'           => 'weblink',
         'toview'             => true,
         'massiveaction'      => true,
      ];


	  $tab[] = [
         'id' => '101',
         'table' => 'users',
         'field' => 'users_id_responsible',
         'name' => __("Responsable du traitement"),
         'forcegroupby' => true,
         'massiveaction' => true,
         'datatype' => 'dropdown',
         'searchtype' => ['equals', 'notequals'],
         'joinparams' => [
            'beforejoin' => [
               'table' => self::getTable(),
               'joinparams' => [
                  'jointype' => 'child'
               ]
            ]
         ]
      ];*/


      return $tab;
   }

    public static function getSpecificValueToDisplay($field, $values, array $options = [])
    {
        /*        highlight_string("<?php\n\$data =\n" . var_export($options, true) . ";\n?>");*/
//        die();
        $id = $options["raw_data"]["id"];
        $storageperiod = new PluginDlteamsStoragePeriod();
        $storageperiod->getFromDB($id);

        if($field == "content"){
            return htmlspecialchars_decode($storageperiod->fields["content"]??"");
        }
        return parent::getSpecificValueToDisplay($field, $values, $options);
    }

   public function defineTabs($options = [])
   {
      $ong = [];
      $ong = array();
      $this->addDefaultFormTab($ong)
      ->addStandardTab('PluginDlteamsRecord_Item', $ong, $options)
	  ->addStandardTab('PluginDlteamsStoragePeriod_Item', $ong, $options)
//	  ->addStandardTab('PluginDlteamsObject_document', $ong, $options)
	  ->addStandardTab('ManualLink', $ong, $options)
      ->addStandardTab(PluginDlteamsTicket_Item::class, $ong, $options)
	  ->addStandardTab('KnowbaseItem_Item', $ong, $options)
      ->addImpactTab($ong, $options)
      ->addStandardTab('Notepad', $ong, $options)
      ->addStandardTab('Log', $ong, $options);
      return $ong;
   }

   function exportToDB($subItems = [])
   {
      if ($this->isNewItem()) {
         return false;
      }
      $export = $this->fields;
      return $export;
   }

    public static function importToDB(PluginDlteamsLinker $linker, $input = [], $containerId = 0, $subItems = [])
   {
      $item = new self();
      $originalId = $input['id'];
      unset($input['id']);
      $itemId = $item->add($input);
      if ($itemId === false) {
         $typeName = strtolower(self::getTypeName());
         throw new ImportFailureException(sprintf(__('failed to copy the %1$s record', 'dlteams'), $input['name']));
      }
      return $itemId;
   }

    public function deleteObsoleteItems(CommonDBTM $container, array $exclude)
   {
   }

   public static function showMassiveActionsSubForm(MassiveAction $ma)
   {
      switch ($ma->getAction()) {
         case 'copyTo':
            Entity::dropdown([
               'name' => 'entities_id',
            ]);
            echo '<br /><br />' . Html::submit(_x('button', 'Post'), ['name' => 'massiveaction']);
            return true;
      }
      return parent::showMassiveActionsSubForm($ma);
   }

   static function processMassiveActionsForOneItemtype(MassiveAction $ma, CommonDBTM $item, array $ids)
   {
      switch ($ma->getAction()) {
         case 'copyTo':
            if ($item->getType() == 'PluginDlteamsStoragePeriod') {
               foreach ($ids as $id) {
                  if ($item->getFromDB($id)) {
                     if ($item->copy1($ma->POST['entities_id'], $id, $item)) {

                        Session::addMessageAfterRedirect(sprintf(__('Record copied: %s', 'dlteams'), $item->getName()));
                        $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);
                     }
                  } else {
                     // Example of ko count
                     $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_KO);
                  }
               }
            }
            return;
      }
      parent::processMassiveActionsForOneItemtype($ma, $item, $ids);
   }

   public function copy1($entity, $id, $item){
	  global $DB;
	  $dbu = new DbUtils();
	  $name=$item->fields['name'];

      $nb=$dbu->countElementsInTable(static::getTable(), ['name' => addslashes($name), 'entities_id' => $entity]);

	  if($nb<=0){
		  $DB->request("INSERT INTO ".static::getTable()." (is_deleted, entities_id, is_recursive, date_mod, date_creation, name, content, comment, url, url2) SELECT is_deleted, '$entity', is_recursive, date_mod, date_creation, name, content, comment, url, url2 FROM ".static::getTable()." WHERE id='$id'");
		  return true;
	  }else{
		  return false;
	  }
   }


}
