<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

$querys = [
//    "ALTER TABLE `glpi_plugin_dlteams_processeddatas` ADD IF NOT EXISTS  `users_read_json` mediumtext DEFAULT NULL",
"ALTER TABLE `glpi_documents` ADD IF NOT EXISTS `is_faq` tinyint(1) NOT NULL DEFAULT '0'",
"ALTER TABLE `glpi_documents` ADD IF NOT EXISTS `view` int(11) NOT NULL DEFAULT '0'",
"CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_documents_users` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `documents_id` int(11) NOT NULL DEFAULT '0',
          `users_id` int(11) NOT NULL DEFAULT '0',
          PRIMARY KEY (`id`),
          KEY `documents_id` (`documents_id`),
          KEY `users_id` (`users_id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",
"CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_documents_groups` (
      `id` int unsigned NOT NULL AUTO_INCREMENT,
      `documents_id` int unsigned NOT NULL DEFAULT '0',
      `groups_id` int unsigned NOT NULL DEFAULT '0',
      `entities_id` int unsigned DEFAULT NULL,
      `is_recursive` tinyint NOT NULL DEFAULT '0',
      `no_entity_restriction` tinyint NOT NULL DEFAULT '0',
      PRIMARY KEY (`id`),
      KEY `documents_id` (`documents_id`),
      KEY `groups_id` (`groups_id`),
      KEY `entities_id` (`entities_id`),
      KEY `is_recursive` (`is_recursive`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;",
"CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_documents_profiles` (
      `id` int unsigned NOT NULL AUTO_INCREMENT,
      `documents_id` int unsigned NOT NULL DEFAULT '0',
      `profiles_id` int unsigned NOT NULL DEFAULT '0',
      `entities_id` int unsigned DEFAULT NULL,
      `is_recursive` tinyint NOT NULL DEFAULT '0',
      `no_entity_restriction` tinyint NOT NULL DEFAULT '0',
      PRIMARY KEY (`id`),
      KEY `documents_id` (`documents_id`),
      KEY `profiles_id` (`profiles_id`),
      KEY `entities_id` (`entities_id`),
      KEY `is_recursive` (`is_recursive`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;",
    "CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_documents_entities` (
      `id` int(11) NOT NULL AUTO_INCREMENT,
      `documents_id` int(11) NOT NULL DEFAULT '0',
      `entities_id` int(11) NOT NULL DEFAULT '0',
      `is_recursive` tinyint(1) NOT NULL DEFAULT '0',
      PRIMARY KEY (`id`),
      KEY `documents_id` (`documents_id`),
      KEY `entities_id` (`entities_id`),
      KEY `is_recursive` (`is_recursive`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci",
"CREATE OR REPLACE VIEW glpi_plugin_dlteams_messages AS
    WITH enfants_recents AS (
        SELECT e.*
        FROM `glpi_itilfollowups` AS e
        WHERE e.parent_comment_id IS NOT NULL
            AND e.`date_creation` = (
                SELECT MAX(`date_creation`)
                FROM `glpi_itilfollowups` e2
                WHERE e2.parent_comment_id = e.parent_comment_id
            )
    ), 
    parents_sans_enfants AS (
        SELECT p.*
        FROM `glpi_itilfollowups` p
        WHERE p.parent_comment_id IS NULL
            AND NOT EXISTS (
                SELECT 1
                FROM `glpi_itilfollowups` e
                WHERE e.parent_comment_id = p.id
            )
    ) 
    SELECT * FROM enfants_recents 
    UNION ALL 
    SELECT * FROM parents_sans_enfants;",
"ALTER TABLE `glpi_itilfollowups` ADD IF NOT EXISTS `type` INT NOT NULL DEFAULT 0 COMMENT 'see contants for types in message.php';",
"ALTER TABLE `glpi_plugin_formcreator_forms` ADD IF NOT EXISTS `multisectionshow` tinyint NOT NULL DEFAULT 0;",
"ALTER TABLE `glpi_itilfollowups` 
        ADD IF NOT EXISTS `itemtype1` varchar(255) DEFAULT NULL,
        ADD IF NOT EXISTS `items_id1` int unsigned NOT NULL DEFAULT 0;",
"CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_entities_items` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `entities_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype` varchar(255) NOT NULL,
  `items_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype1` varchar(255) DEFAULT NULL,
  `items_id1` int unsigned NOT NULL DEFAULT 0,
  `comment` varchar(255) DEFAULT NULL,
  `date_creation` timestamp NULL,
  `date_mod` timestamp NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",
    "ALTER TABLE `glpi_items_tickets`
    ADD IF NOT EXISTS `comment` text DEFAULT NULL;",
    "ALTER TABLE `glpi_profiles`
        ADD IF NOT EXISTS
    `entities_id` int NOT NULL DEFAULT '0' AFTER `name`",
"ALTER TABLE `glpi_profiles`
        ADD IF NOT EXISTS
    `is_recursive` tinyint NOT NULL DEFAULT '0';",
"CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_help` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entities_id` int(11) NOT NULL DEFAULT '0',
  `is_recursive` tinyint(1) NOT NULL DEFAULT '1',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  `open_window` tinyint(1) NOT NULL DEFAULT '1',
  `date_mod` TIMESTAMP DEFAULT NULL,
  `date_creation` TIMESTAMP DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `entities_id` (`entities_id`),
  KEY `date_mod` (`date_mod`),
  KEY `date_creation` (`date_creation`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",
"ALTER TABLE `glpi_documents` ADD IF NOT EXISTS `documentcategories_json` JSON DEFAULT ('{}') AFTER `comment`;",
"UPDATE `glpi_computers_items`
SET itemtype = REPLACE(itemtype, 'Dlregister', 'Dlteams')
WHERE itemtype LIKE '%Dlregister%';",
"ALTER TABLE `glpi_users`
	ADD IF NOT EXISTS `microsoft_guid` text DEFAULT NULL;",
"ALTER TABLE `glpi_users`
    MODIFY COLUMN `microsoft_guid` TEXT DEFAULT NULL;",
"ALTER TABLE`glpi_users`
        ADD IF NOT EXISTS `google_guid` text DEFAULT NULL;",
"ALTER TABLE `glpi_groups`
        ADD IF NOT EXISTS `microsoft_guid` text DEFAULT NULL;",
"ALTER TABLE `glpi_groups`
        ADD IF NOT EXISTS
    `google_guid` text DEFAULT NULL;",
//"ALTER TABLE `glpi_itilfollowups` DROP COLUMN IF EXISTS `conversation`;",
"ALTER TABLE `glpi_itilfollowups`
        ADD IF NOT EXISTS
    `conversationname` text DEFAULT NULL;",
"ALTER TABLE `glpi_plugin_formcreator_forms`
    ADD COLUMN IF NOT EXISTS `text_notification` LONGTEXT NULL AFTER `content`,
    ADD COLUMN IF NOT EXISTS `object_notification` VARCHAR(255) NOT NULL AFTER `text_notification`;",
"CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_forms_items` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `forms_id` int unsigned NOT NULL DEFAULT 0 COMMENT 'id de l''objet à relier',
  `items_id` int unsigned NOT NULL DEFAULT 0 COMMENT 'id de l''objet de la classe reliée',
  `itemtype` varchar(100) DEFAULT NULL COMMENT 'nom de la classe reliée (see .class.php file)',
  `comment` mediumtext DEFAULT NULL,
  `date_creation` timestamp NULL DEFAULT NULL,
  `entities_id` int unsigned NOT NULL DEFAULT 0,
  `is_recursive` tinyint(1) NOT NULL DEFAULT 0,
  `date_mod` timestamp NULL DEFAULT NULL,
   PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",
"ALTER TABLE `glpi_plugin_dlteams_forms_items`
    ADD IF NOT EXISTS `object_notification` VARCHAR(255) NULL AFTER `comment`;",
"ALTER TABLE `glpi_plugin_dlteams_datacarriertypes`
	ADD IF NOT EXISTS `number` INT UNSIGNED NULL AFTER `name`",
    "ALTER TABLE `glpi_plugin_dlteams_policieforms_items`
ADD IF NOT EXISTS `timeline_position` INT NOT NULL DEFAULT 0 AFTER `comment`;
",
//    réindexer les timeline_position en conservant celles ayant deja des valeurs
"
UPDATE glpi_plugin_dlteams_policieforms_items AS t
JOIN (
    SELECT 
        id,
        ROW_NUMBER() OVER (
            PARTITION BY policieforms_id 
            ORDER BY COALESCE(timeline_position, 999999), id
        ) AS new_pos
    FROM glpi_plugin_dlteams_policieforms_items
) AS numbered ON t.id = numbered.id
SET t.timeline_position = numbered.new_pos
WHERE t.timeline_position IS NULL OR t.timeline_position <> numbered.new_pos;

",

    "ALTER TABLE `glpi_plugin_dlteams_records_items`
ADD IF NOT EXISTS `timeline_position` INT NOT NULL DEFAULT 0 AFTER `comment`;
",
    "
    UPDATE glpi_plugin_dlteams_records_items
SET timeline_position = 0
WHERE timeline_position IS NULL;
    ",
//    réindexer les timeline_position en conservant celles ayant deja des valeurs
    "
UPDATE glpi_plugin_dlteams_records_items AS t
JOIN (
    SELECT 
        id,
        ROW_NUMBER() OVER (
            PARTITION BY records_id 
            ORDER BY COALESCE(timeline_position, 999999), id
        ) AS new_pos
    FROM glpi_plugin_dlteams_records_items
) AS numbered ON t.id = numbered.id
SET t.timeline_position = numbered.new_pos
WHERE t.timeline_position IS NULL OR t.timeline_position <> numbered.new_pos;

",

"ALTER TABLE `glpi_plugin_dlteams_deliverables_sections`
ADD IF NOT EXISTS `itemtype` VARCHAR(100) DEFAULT NULL AFTER `name`;",

"ALTER TABLE `glpi_plugin_dlteams_deliverables_sections`
ADD IF NOT EXISTS `items_id` INT UNSIGNED DEFAULT NULL AFTER `itemtype`;",

"UPDATE `glpi_plugin_dlteams_deliverables_sections`
SET `itemtype` = 'PluginDlteamsDeliverable'
WHERE `itemtype` IS NULL;",
    "ALTER TABLE `glpi_documents`
    ADD IF NOT EXISTS `text_notification` LONGTEXT NULL AFTER `comment`,
    ADD IF NOT EXISTS `text_approval` LONGTEXT NULL AFTER `text_notification`;",

"ALTER TABLE `glpi_documents`
    ADD IF NOT EXISTS `object_notification` VARCHAR(255) NULL AFTER `comment`,
    ADD IF NOT EXISTS `object_approval` VARCHAR(255) NULL AFTER `object_notification`;",

"ALTER TABLE `glpi_documents`
    ADD IF NOT EXISTS `is_firstpage` TINYINT NOT NULL DEFAULT '0' AFTER `comment`,
    ADD IF NOT EXISTS `is_comment` TINYINT NOT NULL DEFAULT '0' AFTER `is_firstpage`;",

"ALTER TABLE `glpi_documents`
    ADD IF NOT EXISTS `document_title` VARCHAR(255) NULL AFTER `comment`,
    ADD IF NOT EXISTS `document_name` VARCHAR(255) NULL AFTER `comment`, # added
    ADD IF NOT EXISTS `publication_folder` VARCHAR(255) NULL AFTER `document_title`;",

"ALTER TABLE `glpi_documents`
    ADD IF NOT EXISTS `links_id` INT UNSIGNED NULL AFTER `comment`;",
    "
    ALTER TABLE `glpi_documents`
    ADD IF NOT EXISTS `print_logo` TINYINT NOT NULL DEFAULT '0' AFTER `comment`;
    ",
//    migration deliverable pour plusieurs objets
"
UPDATE `glpi_plugin_dlteams_deliverables_items`
        SET
            `itemtype1` = `itemtype`,
            `items_id1` = `items_id`,
            `itemtype` = 'PluginDlteamsDeliverable',
            `items_id` = `deliverables_id`
        WHERE `itemtype` IN ('User', 'Contact')
",
    "ALTER TABLE `glpi_documents` ADD IF NOT EXISTS `is_html` tinyint(1) NOT NULL DEFAULT '0'",
    "ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `users_id_actor_itemtype` VARCHAR(255) NULL AFTER `users_id_actor`",
    "ALTER TABLE `glpi_plugin_dlteams_thirdpartycategories` ADD IF NOT EXISTS `ranking` INT(11) NULL DEFAULT NULL AFTER `name`",
    "ALTER TABLE `glpi_plugin_dlteams_policieforms_items`
          ADD IF NOT EXISTS `ranking` INT(11) NULL DEFAULT NULL
          AFTER `json`",
    "CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_transmissionmethods_items` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `transmissionmethods_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype` varchar(255) NOT NULL,
  `items_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype1` varchar(255) DEFAULT NULL,
  `items_id1` int unsigned NOT NULL DEFAULT 0,
  `comment` varchar(255) DEFAULT NULL,
  `date_creation` timestamp NULL,
  `date_mod` timestamp NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",

    "CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_mediasupports_items` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `mediasupports_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype` varchar(255) NOT NULL,
  `items_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype1` varchar(255) DEFAULT NULL,
  `items_id1` int unsigned NOT NULL DEFAULT 0,
  `comment` varchar(255) DEFAULT NULL,
  `date_creation` timestamp NULL,
  `date_mod` timestamp NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",
"CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_siintegrations_items` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `siintegrations_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype` varchar(255) NOT NULL,
  `items_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype1` varchar(255) DEFAULT NULL,
  `items_id1` int unsigned NOT NULL DEFAULT 0,
  `comment` varchar(255) DEFAULT NULL,
  `date_creation` timestamp NULL,
  `date_mod` timestamp NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",


    "
UPDATE glpi_plugin_dlteams_policieforms_items AS t
JOIN (
    SELECT 
        id,
        ROW_NUMBER() OVER (
            PARTITION BY policieforms_id 
            ORDER BY COALESCE(ranking, 999999), id
        ) AS new_pos
    FROM glpi_plugin_dlteams_policieforms_items
) AS numbered ON t.id = numbered.id
SET t.ranking = numbered.new_pos
WHERE t.ranking IS NULL OR t.ranking <> numbered.new_pos;
",
    "ALTER TABLE `glpi_plugin_dlteams_concernedpersons`
	ADD IF NOT EXISTS `number` INT UNSIGNED NULL AFTER `name`",
    "ALTER TABLE `glpi_plugin_dlteams_concernedpersons`
	ADD IF NOT EXISTS `newperyear` INT UNSIGNED NULL AFTER `number`",
    "ALTER TABLE `glpi_plugin_dlteams_concernedpersons`
	ADD IF NOT EXISTS `deletedperyear` INT UNSIGNED NULL AFTER `newperyear`",
    "ALTER TABLE `glpi_plugin_dlteams_concernedpersons` ADD IF NOT EXISTS `accounted` tinyint(1) NOT NULL DEFAULT '0'",
    "ALTER TABLE `glpi_plugin_dlteams_concernedpersons`
    ADD IF NOT EXISTS `evenaccounted_id` INT UNSIGNED NULL AFTER `comment`;",
    "ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `impact_examples` varchar(1000) DEFAULT NULL;",
    "ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `url_ppd_tiers` text DEFAULT NULL;",
    "ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `url_ppd_salaries` text DEFAULT NULL;",
    "ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `url_form_exercice_tiers` text DEFAULT NULL;",
    "ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `url_form_exercice_salaries` text DEFAULT NULL;",
    "ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `email_dpo` text DEFAULT NULL;",

    "CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_rightmeasurecategories_items` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `rightmeasurecategories_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype` varchar(255) NOT NULL,
  `items_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype1` varchar(255) DEFAULT NULL,
  `items_id1` int unsigned NOT NULL DEFAULT 0,
  `comment` varchar(255) DEFAULT NULL,
  `date_creation` timestamp NULL,
  `date_mod` timestamp NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",
    "
    CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_processeddatacategories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `comment` mediumtext DEFAULT NULL,
  `entities_id` int unsigned NOT NULL DEFAULT 0,
  `is_recursive` tinyint(1) NOT NULL DEFAULT 1,
  `date_creation` timestamp NULL DEFAULT NULL,
  `users_id_creator` int unsigned DEFAULT NULL,
  `date_mod` timestamp NULL DEFAULT NULL,
  `users_id_lastupdater` int unsigned DEFAULT NULL,
   PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='PluginDlteamsProcessedDataCategory';
    ",
    "CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_processeddatacategories_items` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `processeddatacategories_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype` varchar(255) NOT NULL,
  `items_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype1` varchar(255) DEFAULT NULL,
  `items_id1` int unsigned NOT NULL DEFAULT 0,
  `comment` varchar(255) DEFAULT NULL,
  `date_creation` timestamp NULL,
  `date_mod` timestamp NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",
    "CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_riskassessments_items` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `riskassessments_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype` varchar(255) NOT NULL,
  `items_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype1` varchar(255) DEFAULT NULL,
  `items_id1` int unsigned NOT NULL DEFAULT 0,
  `comment` varchar(255) DEFAULT NULL,
  `date_creation` timestamp NULL,
  `date_mod` timestamp NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",


    "CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_itilfollowups_views` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `itilfollowups_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype` varchar(255) NOT NULL,
  `items_id` int UNSIGNED NOT NULL DEFAULT 0,
  `date_creation` timestamp NULL,
  `date_mod` timestamp NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",
    "ALTER TABLE `glpi_plugin_dlteams_records` DROP IF EXISTS `right_portability`;",
    "ALTER TABLE `glpi_plugin_dlteams_records` DROP IF EXISTS `right_opposition`;",
    "ALTER TABLE `glpi_plugin_dlteams_rightmeasurecategories`
	ADD IF NOT EXISTS `number` INT UNSIGNED NULL AFTER `name`",
    "ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `users_id_tech_itemtype` VARCHAR(255) NULL AFTER `users_id_tech`",
    "
    UPDATE `glpi_plugin_dlteams_records`
SET `users_id_tech_itemtype` = 'User'
WHERE 
  `users_id_tech` IS NOT NULL
  AND `users_id_tech` > 0
  AND (
    `users_id_tech_itemtype` IS NULL
    OR `users_id_tech_itemtype` = ''
  );
    ",
    "-- 1) Ajouter les colonnes temporaires
ALTER TABLE `glpi_plugin_formcreator_forms`
  ADD COLUMN `text_notification_tmp`   LONGTEXT     NULL AFTER `content`,
  ADD COLUMN `object_notification_tmp` VARCHAR(255) NULL AFTER `text_notification_tmp`;",
"-- 2) Copier les données
UPDATE `glpi_plugin_formcreator_forms`
SET
  `text_notification_tmp`   = `text_notification`,
  `object_notification_tmp` = `object_notification`;",
    "-- 3) Supprimer les anciennes colonnes
ALTER TABLE `glpi_plugin_formcreator_forms`
  DROP COLUMN `text_notification`,
  DROP COLUMN `object_notification`;",
    "-- 4) Renommer les colonnes temporaires
ALTER TABLE `glpi_plugin_formcreator_forms`
  CHANGE COLUMN `text_notification_tmp`   `text_notification`   LONGTEXT     NULL AFTER `content`,
  CHANGE COLUMN `object_notification_tmp` `object_notification` VARCHAR(255) NULL AFTER `text_notification`;",
    "
  ALTER TABLE `glpi_documents`
    ADD COLUMN IF NOT EXISTS `link_tmp` MEDIUMTEXT
      CHARACTER SET utf8mb4
      COLLATE utf8mb4_unicode_ci
      NULL
      AFTER `link`;",
    "UPDATE `glpi_documents`
    SET `link_tmp` = `link`;",
    "ALTER TABLE `glpi_documents`
    DROP COLUMN IF EXISTS `link`;",
    "ALTER TABLE `glpi_documents`
    CHANGE COLUMN `link_tmp` `link` MEDIUMTEXT
      CHARACTER SET utf8mb4
      COLLATE utf8mb4_unicode_ci
      NULL;",
"CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_policieformcategories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `comment` mediumtext DEFAULT NULL,
  `entities_id` int unsigned NOT NULL DEFAULT 0,
  `is_recursive` tinyint(1) NOT NULL DEFAULT 1,
  `date_creation` timestamp NULL DEFAULT NULL,
  `users_id_creator` int unsigned DEFAULT NULL,
  `date_mod` timestamp NULL DEFAULT NULL,
  `users_id_lastupdater` int unsigned DEFAULT NULL,
   PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='PluginDlteamsPolicieFormCategory';",
    "CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_policieformcategories_items` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `policieformcategories_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype` varchar(255) NOT NULL,
  `items_id` int UNSIGNED NOT NULL DEFAULT 0,
  `itemtype1` varchar(255) DEFAULT NULL,
  `items_id1` int unsigned NOT NULL DEFAULT 0,
  `comment` varchar(255) DEFAULT NULL,
  `date_creation` timestamp NULL,
  `date_mod` timestamp NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",
//    "ALTER TABLE `glpi_plugin_dlteams_records` DROP IF EXISTS `right_portability`;",
    "ALTER TABLE `glpi_plugin_dlteams_accountkeys`
      ADD COLUMN IF NOT EXISTS  `users_affected` TEXT NULL AFTER `comment`,
      ADD COLUMN IF NOT EXISTS  `profiles_idx` int UNSIGNED NOT NULL DEFAULT 0 AFTER `comment`,
      ADD COLUMN IF NOT EXISTS  `can_changepassword` tinyint(1) NOT NULL DEFAULT '0';",
"CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_processeddatas_processeddatacategories` (
          `id` int unsigned NOT NULL AUTO_INCREMENT,
          `processeddatas_id` int unsigned NOT NULL DEFAULT '0',
          `processeddatacategories_id` int unsigned NOT NULL DEFAULT '0',
          PRIMARY KEY (`id`),
          KEY `processeddatas_id` (`processeddatas_id`),
          KEY `processeddatacategories_id` (`processeddatacategories_id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;",
"CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `itemtype` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `items_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `user_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_mod` timestamp DEFAULT NULL,
  `ip_address` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `date_mod` (`date_mod`),
  KEY `item` (`itemtype`,`items_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;",

"ALTER TABLE `glpi_plugin_dlteams_concernedpersons`
 ADD IF NOT EXISTS `age_and_digital_maturity` TINYINT UNSIGNED DEFAULT NULL AFTER `content`",

"ALTER TABLE `glpi_plugin_dlteams_concernedpersons`
 ADD IF NOT EXISTS `dependency_situation` TINYINT UNSIGNED DEFAULT NULL AFTER `age_and_digital_maturity`",

"ALTER TABLE `glpi_plugin_dlteams_concernedpersons`
 ADD IF NOT EXISTS `record_understanding_ability` TINYINT UNSIGNED DEFAULT NULL AFTER `dependency_situation`",

"ALTER TABLE `glpi_plugin_dlteams_concernedpersons`
 ADD IF NOT EXISTS `socioeconomic_or_legal_situation` TINYINT UNSIGNED DEFAULT NULL AFTER `record_understanding_ability`",

"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_purposes` TINYINT UNSIGNED DEFAULT NULL COMMENT 'finalités indiquées = oui' AFTER `right_correction` ",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_nbrcontroller` INT UNSIGNED DEFAULT NULL COMMENT 'responsable+auditeur+rédacteur, doit être à 3' AFTER `r_purposes` ",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_legalbasis` INT UNSIGNED DEFAULT NULL COMMENT 'nbre de bases légales doit être > 0' AFTER `r_nbrcontroller`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_concernedpersons` INT UNSIGNED DEFAULT NULL COMMENT 'nbre catégories de personnes doit être > 0' AFTER `r_legalbasis`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_processeddatas` INT UNSIGNED DEFAULT NULL COMMENT 'nbre données traitées doit être > 0' AFTER `r_concernedpersons`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_storageperiod` INT UNSIGNED DEFAULT NULL COMMENT 'durée conservation doit être > 0' AFTER `r_processeddatas`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_delete_proc` TEXT DEFAULT NULL COMMENT 'le devenir des données en fin de traitementn est documenté' AFTER `r_storageperiod`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_actors` INT UNSIGNED DEFAULT NULL COMMENT 'nbre acteurs doit être > 0' AFTER `r_delete_proc`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_recipients` INT UNSIGNED DEFAULT NULL COMMENT 'nbre destinataires pas de contrainte' AFTER `r_actors`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_rightmeasures` INT UNSIGNED DEFAULT NULL COMMENT ',nbre de mesures pour les droits doit être > 0' AFTER `r_recipients`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_consentexplicit` ENUM('oui','non','n/a') DEFAULT NULL COMMENT 'si consentement alors consent_explicite doit être conforme' AFTER `r_rightmeasures`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_consentjustif` ENUM('oui','non','n/a') DEFAULT NULL COMMENT 'si pas de consentement alors ' AFTER `r_consentexplicit`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_nbr_concernedpersons` INT UNSIGNED DEFAULT NULL COMMENT 'nombre personnes concernées doit être > 0' AFTER `r_consentjustif`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_maxvulnerability` VARCHAR(100) DEFAULT NULL COMMENT 'vulnérabilité max' AFTER `r_nbr_concernedpersons`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_nbr_sensitivedatas` INT UNSIGNED DEFAULT NULL COMMENT 'nbre données sensibles x nbre concernedpersons'  AFTER `r_maxvulnerability`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_nbr_viewsensitivedatas` INT UNSIGNED DEFAULT NULL COMMENT 'nbre données vue comme sensibles x nbre concernedpersons' AFTER `r_nbr_sensitivedatas`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_profiling` ENUM('yes','no') DEFAULT NULL COMMENT 'yes si profiling = 1, no sinon' AFTER `r_nbr_viewsensitivedatas`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_subcontractoroutue` ENUM('yes','no','n/a') DEFAULT NULL COMMENT 'yes si external_process contient 2:on (ss-traitants hors ue)' AFTER `r_profiling`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_storageoutue` ENUM('yes','no','n/a') DEFAULT NULL COMMENT 'si il existe location de datacatlog <> UE alors consent_explicite doit être conforme' AFTER `r_subcontractoroutue`",    
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_averageimpacts` VARCHAR(255) DEFAULT NULL COMMENT 'moyenne (moyenne (impact concernedperson / impact organism)' AFTER `r_storageoutue`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_treatmentsensitivity` VARCHAR(100) DEFAULT NULL COMMENT 'sensibilité du traitement' AFTER `r_averageimpacts`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_pianeedanddone` VARCHAR(50) DEFAULT NULL COMMENT 'PIA need yes-no / PIA done yes-no' AFTER `r_treatmentsensitivity`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_nbrpolicieform` INT UNSIGNED DEFAULT NULL COMMENT 'nombre de jeux de données' AFTER `r_pianeedanddone`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_pmpolicieform` INT UNSIGNED DEFAULT NULL COMMENT 'nombre de protection pour jeux de données' AFTER `r_nbrpolicieform`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_nbrdatacatalog` INT UNSIGNED DEFAULT NULL COMMENT 'nombre de catalogues' AFTER `r_pmpolicieform`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_pmdatacatalog` INT UNSIGNED DEFAULT NULL COMMENT 'nombre de mesures de protection pour catalogues' AFTER `r_nbrdatacatalog`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_nbrstorage` INT UNSIGNED DEFAULT NULL COMMENT 'nombre de stockages renseignés' AFTER `r_pmdatacatalog`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_nbrestorageloc` INT UNSIGNED DEFAULT NULL COMMENT 'nombre de localisation des stockages' AFTER `r_nbrstorage`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_pmmateriel` INT UNSIGNED DEFAULT NULL COMMENT 'nombre de mesures de protection matériels' AFTER `r_nbrestorageloc`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_pmlocation` INT UNSIGNED DEFAULT NULL COMMENT 'nombre de mesures de protection locaux' AFTER `r_pmmateriel`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_addatacatalog` INT UNSIGNED DEFAULT NULL COMMENT 'nombre de catalogues annuaire' AFTER `r_pmlocation`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_nbraccountandkey` INT UNSIGNED DEFAULT NULL COMMENT 'nombre de comptes ayant accès' AFTER `r_addatacatalog`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_nbrusers` INT UNSIGNED DEFAULT NULL COMMENT 'nombre d''utilisateurs ayant accès' AFTER `r_nbraccountandkey`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_noncompliance` VARCHAR(50) DEFAULT NULL COMMENT 'nombre d''évenement categorie = non-conformités / résolues' AFTER `r_nbrusers`",
"ALTER TABLE `glpi_plugin_dlteams_records` ADD IF NOT EXISTS `r_averageconformity` VARCHAR(50) DEFAULT NULL COMMENT 'note de conformité : 1.non conforme 2.à corriger 3.à améliorer 4.conforme' AFTER `r_noncompliance`",
"ALTER TABLE `glpi_appliances` ADD IF NOT EXISTS `suppliers_id` int(11) UNSIGNED NOT NULL DEFAULT '0'",
    "CREATE TABLE IF NOT EXISTS `glpi_plugin_dlteams_queued_stats_updates` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `entities_id` INT(11) NOT NULL COMMENT 'ID de l''entité à mettre à jour',
    `is_processing` TINYINT(1) NOT NULL DEFAULT 0 COMMENT 'Verrou pour éviter le double traitement',
    `creation_date` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Date de création de la tâche',
    `done_date` TIMESTAMP NULL DEFAULT NULL COMMENT 'Date de fin de la tâche',
    `error_message` TEXT COMMENT 'Message en cas d''erreur',
    PRIMARY KEY (`id`),
    INDEX `status` (`done_date`, `is_processing`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;"

];


$i = 1;
global $DB;
foreach ($querys as $query) {
    // echo $query . "<br>";
    $result = $DB->query($query) or die("Erreur" . $DB->error());
    if ($DB->error) {
        try {
//            throw new Exception("MySQL error $DB->error <br> Query:<br> $query", $msqli->errno);
        } catch (Exception $e) {
            echo "Error No: " . $e->getCode() . " - " . $e->getMessage() . "<br >";
            echo nl2br($e->getTraceAsString());
        }
    }
    $i++;
}

if($DB->fieldExists("glpi_plugin_dlteams_deliverables_sections", "deliverables_id")){
    $DB->query("UPDATE `glpi_plugin_dlteams_deliverables_sections`
                SET `items_id` = `deliverables_id`
                WHERE `itemtype` = 'PluginDlteamsDeliverable';
                ");
}

if($DB->fieldExists("glpi_plugin_dlteams_rightmeasures_items", "comment")){
    $DB->query("ALTER TABLE `glpi_plugin_dlteams_rightmeasures_items` MODIFY `comment` LONGTEXT
                CHARACTER SET utf8mb4
                COLLATE utf8mb4_unicode_ci
                NULL;");
}
if($DB->fieldExists("glpi_plugin_dlteams_rightmeasurecategories_items", "comment")){
    $DB->query("ALTER TABLE `glpi_plugin_dlteams_rightmeasurecategories_items` MODIFY `comment` LONGTEXT
                CHARACTER SET utf8mb4
                COLLATE utf8mb4_unicode_ci
                NULL;");
}



$table = 'glpi_plugin_dlteams_concernedpersons';

// Vérifier que la table et la colonne `number` existent
if ($DB->tableExists($table) && $DB->fieldExists($table, 'number')) {

    // 1) Ajouter `ranking` si elle n’existe pas déjà
    $DB->query("
        ALTER TABLE `$table`
          ADD IF NOT EXISTS `ranking` INT(11) NULL DEFAULT NULL
          AFTER `type_majmodel`
    ");

    // 2) Migrer la valeur de `number` vers `ranking`
    $DB->query("
        UPDATE `$table`
           SET `ranking` = `number`
         WHERE `number` IS NOT NULL
    ");

    // 3) Supprimer `number` une fois la migration faite
//    $DB->query("
//        ALTER TABLE `$table`
//          DROP COLUMN IF EXISTS `number`
//    ");
}

// deletion of unused files

$files_tot_delete_if_exist = [
    GLPI_ROOT . "/marketplace/dlteams/inc/createpdf.class.php",
    GLPI_ROOT . "/marketplace/dlteams/inc/createpdfbase.class.php",
];

foreach ($files_tot_delete_if_exist as $file_path) {
    if (file_exists($file_path))
        if (is_writable($file_path))
            @unlink($file_path);
}
//Html::back();


// update des stats record

$records_query = [
    "FROM" => PluginDlteamsRecord::getTable(),
    "WHERE" => [
        "entities_id" => Session::getActiveEntity()
    ]
];

$records_iterator = $DB->request($records_query);

foreach ($records_iterator as $record){
    PluginDlteamsRecord_Stats::updateRecordStats($record);
}

