<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

use GlpiPlugin\dlteams\Exception\ImportFailureException;

// Selectable elements for broadcast
define('broadcast_elements', [
//    null,
    1 => __("Third party politic", 'dlteams'),
    2 => __("Employees politic", 'dlteams'),
    3 => __("Internal politic", 'dlteams')
]);

class PluginDlteamsRecord extends CommonDropdown implements
    PluginDlteamsExportableInterface
{
    use PluginDlteamsExportable;
    use \Glpi\Features\Clonable;

    static $rightname = 'plugin_dlteams_record';
    public $dohistory = true;
    protected $usenotepad = true;
    public static $menukey = "datagovernancerecord";
    const broadcast_elements = broadcast_elements;


    public const reports = [
        'report/record/recordlist.php' => 'Traitements et leurs finalités',
        'report/record/recordsensitive.php' => 'Traitement comportant des données sensibles',
        'report/record/recordsensitive.php' => 'Traitement selon le nombre personnes concernées',
        'report/record/recordresponsable.php' => 'Responsables de traitements',
        'report/record/recordacteursinterne.php' => 'Acteurs des traitements',
        'report/record/recordsoustraitants.php' => 'Sous-traitants des traitements',
        'report/record/recordprocesseddata.php' => 'Données collectées par catégorie de personne',
        'report/record/recordconcernedpersonprocesseddata.php' => 'Données traitées par catégories de personnes et par traitement',
        'report/record/recordstorageperiod.php' => 'Durée de conservation des informations par activité de traitement',
//        'report/record/recordfinalites.php' => __('traitements et leurs finalités 2', 'dlteams'),
    ];


    public function getCloneRelations(): array
    {
        return [
            Document_Item::class,
            Notepad::class,
            KnowbaseItem_Item::class,
            PluginDlteamsConcernedPerson_Item::class,
            PluginDlteamsProcessedData_Item::class,
            PluginDlteamsLegalBasi_Item::class,
            PluginDlteamsStoragePeriod_Item::class,

        ];
    }

    /**
     * Clone the current item multiple times
     *
     * @param int $n Number of clones
     * @param array $override_input Custom input to override
     * @param boolean $history Do history log ? (true by default)
     *
     * @return int|bool the new ID of the clone (or false if fail)
     * @since 9.5
     *
     */
    public function cloneMultiple(
        int $n,
        array $override_input = [],
        bool $history = true
    ): bool
    {
        $failure = false;

        /*        highlight_string("<?php\n\$data =\n" . var_export($this, true) . ";\n?>");*/
//        die();
        $record = new PluginDlteamsRecord();
        $record->last_clone_index = 0;
        for ($i = 0; $i < $n && !$failure; $i++) {
            $record->copy($this->fields["entities_id"], $this->getID(), $this, true);
        }

//        try {
//            // Init index cache
//            $this->last_clone_index = 0;
//            for ($i = 0; $i < $n && !$failure; $i++) {
//                if ($this->clone($override_input, $history) === false) {
//                    // Increment clone index cache to use less SQL
//                    // queries looking for an available unique clone name
//                    $failure = true;
//                }
//            }
//        } finally {
//            // Make sure cache is cleaned even on exception
//            $this->last_clone_index = null;
//        }
//
//        return !$failure;
        return true;
    }

    /**
     * Clones the current item
     *
     * @param array $override_input custom input to override
     * @param boolean $history do history log ?
     *
     * @return false|integer The new ID of the clone (or false if fail)
     * @since 10.0.0
     *
     */
    public function clone(array $override_input = [], bool $history = true)
    {
        /** @var \DBmysql $DB */
        global $DB;

        if ($DB->isSlave()) {
            return false;
        }
        $new_item = new static();
        $input = Toolbox::addslashes_deep($this->fields);
        foreach ($override_input as $key => $value) {
            $input[$key] = Toolbox::addslashes_deep($value);
        }
        $input = $new_item->cleanCloneInput($input);

        // Do not compute a clone name if a new name is specified (Like creating from template)
        if (!isset($override_input['name'])) {
            if (($copy_name = $this->getUniqueCloneName($input)) !== null) {
                $input[static::getNameField()] = $copy_name;
            }
        }

        $input = $new_item->prepareInputForClone($input);

        $input['clone'] = true;
        $newID = $new_item->add($input, [], $history);

        if ($newID !== false) {
            $new_item->cloneRelations($this, $history);
            $new_item->post_clone($this, $history);
        }

        return $newID;
    }

    /**
     * Clone the item's relations.
     *
     * @param CommonDBTM $source
     * @param bool $history
     *
     * @return void
     *
     * @since 10.0.0
     */
    private function cloneRelations(CommonDBTM $source, bool $history): void
    {
        $clone_relations = $this->getCloneRelations();
        foreach ($clone_relations as $classname) {
            $override_input = [];


            if (!is_a($classname, CommonDBConnexity::class, true)) {
                trigger_error(
                    sprintf(
                        'Unable to clone elements of class %s as it does not extends "CommonDBConnexity"',
                        $classname
                    ),
                    E_USER_WARNING
                );
                continue;
            }

            $override_input[$classname::getItemField($this->getType())] = $this->getID();

            // Force entity / recursivity based on cloned parent, with fallback on session values
            if ($classname::$disableAutoEntityForwarding !== true) {
                $override_input['entities_id'] = $this->isEntityAssign() ? $this->getEntityID() : Session::getActiveEntity();
                $override_input['is_recursive'] = $this->maybeRecursive() ? $this->isRecursive() : Session::getIsActiveEntityRecursive();
            }

            $cloned = []; // Link between old and new ID
            $relation_newitems = [];

            $relation_items = $classname::getItemsAssociatedTo($this->getType(), $source->getID());
            /** @var CommonDBTM $relation_item */
            foreach ($relation_items as $relation_item) {
                if ($source->isTemplate() && isset($relation_item->fields['name'])) {
                    // Force-set name to avoid adding a "(copy)" suffix to the cloned item
                    $override_input['name'] = $relation_item->fields['name'];
                }
                $origin_id = $relation_item->getID();
                $itemtype = $relation_item->getType();
                $cloned[$itemtype][$origin_id] = $relation_item->clone($override_input, $history);
                $relation_item->getFromDB($cloned[$itemtype][$origin_id]);
                $relation_newitems[] = $relation_item;
            }
            // Update relations between cloned items
            foreach ($relation_newitems as $relation_newitem) {
                $itemtype = $relation_newitem->getType();
                $foreignkey = getForeignKeyFieldForItemType($itemtype);
                if ($relation_newitem->isField($foreignkey) && isset($cloned[$itemtype][$relation_newitem->fields[$foreignkey]])) {
                    $relation_newitem->update([
                        'id' => $relation_newitem->getID(),
                        $foreignkey => $cloned[$itemtype][$relation_newitem->fields[$foreignkey]]
                    ]);
                }
            }
        }
    }

    static function getTypeName($nb = 0)
    {
        return _n("Processing Activity", "Processing Activities", $nb, 'dlteams');
    }

//    static function canView(){
//        return true;
//    }

    public function getName($options = [])
    {
        //return sprintf("%s (%s)", $this->fields["name"], $this->fields["number"]); // TODO: Change the autogenerated stub
        return sprintf("%s.%s | %s", $this->fields["number"], $this->fields["parentnumber"], $this->fields["name"]); // TODO: Change the autogenerated stub
    }

    function showForm($id, $options = [])
    {

//        \Glpi\Application\View\TemplateRenderer::getInstance()->display('@dlteams/components/form/recordform.html.twig', [
//            ]
//        );

        global $CFG_GLPI;
        $this->initForm($id, $options);
        $this->showFormHeader($options);


        echo "<style>";
        echo "
            .form-table-text {
                text-align: right;
                width: 40%;
            }
            @media (max-width: 800px) {
                .form-table-text {
                    text-align: left;
                    width: 100%;
                }
            }
        ";

        echo "</style>";
        echo "<tr class='tab_bg_1'>";
        echo "<td class='form-table-text'>" . __("Number (order)", 'dlteams') . "</td>";
        echo "<td colspan='1'>";
        $number = Html::cleanInputText($this->fields['number']);
        echo "<input type='number' min='1' max='9999' name='number' size='8' required value='" . $number . "'>";
        $number = Html::cleanInputText($this->fields['parentnumber']);
        if ($id == 0) $number = 1;
        echo "<input type='number' min='0' max='9999' id='parentnumber' name='parentnumber' size='8' required value='" . $number . "'>";
        echo "</td></tr>";

        echo "<tr class='tab_bg_1'>";
        echo "<td class='form-table-text'>" . __("Title", 'dlteams') .
            "<br><i>" . __("Record objective, must be unique, understandable", 'dlteams') . "</i></td>";
        echo "<td colspan='2'>";
        $title = Html::cleanInputText($this->fields['name']);

        // on affiche un warning (texte en rouge) en dessous de designation du traitement "En publication, seule la désignation sera affichée"
        echo "<input type='text' style='width:98%' maxlength=250 name='name' required value='" . $title . "'>";
        if ($this->fields["parentnumber"] == 0)
            echo "<div id='label_parentnumber' style='color: #b10610;'>En publication, seule la désignation sera affichée</div>";
        echo "</td></tr>";
//
        echo "<tr class='tab_bg_1'>";
        echo "<td class='form-table-text'>" . __("Purpose (GDPR Article 30 1b)", 'dlteams') .
            "<br><i>" . __("Details of objective into sub-purposes (different stages/parts)", 'dlteams') . "</i></td>";

        echo "<td colspan='2' >";
        $purpose = Html::cleanInputText($this->fields['content']);
        echo "<textarea style='width:98%' name='content' maxlength='2000' rows='6'>" . $purpose . "</textarea>";
        echo "</td></tr>";
//
        echo "<tr class='tab_bg_1'>";
        echo "<td class='form-table-text'>" . __("Broadcast", 'dlteams') .
            "<br><i>" . __("In which document it appears", 'dlteams') . "</i></td>";

        echo "<td colspan='2'>";
        // Options for dropdown select
        $options['value'] = $this->fields['states_id'] ?? 0;
        $options['width'] = "250px";

        Dropdown::showFromArray('states_id', self::broadcast_elements, $options);
        echo "</td></tr>";
//
        // Redacteurs
        if ($responsible = $this->fields["users_id_tech"]) ;
        // if empty, take legal representative of the entity
        else {
            global $DB;
            $iterator = $DB->request([
                'SELECT' => 'users_id_representative',
                'FROM' => 'glpi_plugin_dlteams_controllerinfos',
                'WHERE' => ['entities_id' => $this->getEntityID()]
            ]);

            if (count($iterator)) {
                $responsible = $iterator->next() ?? ['users_id_representative'];
            }
        }
//

        $actortype = 'requester'; // ou dynamiquement
        $required = false;
        global $DB;

        $unique_id_tech = "user_opt_" . $actortype . $this->fields["users_id_tech_itemtype"] . $this->fields["users_id_tech"];
        $itemtype_tech = $this->fields["users_id_tech_itemtype"];
        $items_id_tech = $this->fields["users_id_tech"];
        $value_tech = $itemtype_tech . '_' . $items_id_tech;
        $rand = mt_rand(); // si pas déjà défini

        $use_notification = true;
        $default_email = '';
        $alternative_email = '';
        $title = '';
        $text = '';
        $title_tech = '';
        $text_tech = '';

        $records_id = $this->fields["id"];


        $item_tech = null;
        if (class_exists($itemtype_tech ?? "")) {
            $item_tech = new $itemtype_tech();
            $item_tech->getFromDB($items_id_tech);
        }

// Préparation du libellé affiché
        if (in_array($itemtype_tech, [Group::class, Supplier::class, PluginDlteamsThirdPartyCategory::class])) {
            $name = $item_tech->fields['name'] ?? '';
            $title = $text = $name;
        }

        if ($itemtype_tech == User::class) {
            $firstname = $item_tech->fields['firstname'] ?? '';
            $realname = $item_tech->fields['realname'] ?? '';
            $email = $item_tech->fields['email'] ?? '';
            $text_tech = trim("$firstname $realname");
            $title_tech = trim("$firstname $realname - $email");
        }

        echo "<tr class='tab_bg_1'>";
        echo "<td class='form-table-text'>" . __("Process responsible", 'dlteams') . "</td>";
        $randDropdown = mt_rand();
        echo "<td colspan='2'>";
//        User::dropdown([
//            'name' => 'users_id_tech',
//            'value' => $this->fields["users_id_tech"] ?? "", //$responsible,
//            'entity' => $this->fields["entities_id"],
//            'right' => 'all',
//            'width' => "250px",
//            'rand' => $randDropdown
//        ]);

        echo '
<select name="users_id_tech" class="form-select" id="responsible_' . $rand . '" data-actor-type="' . $actortype . '"' . ($required ? ' required' : '') . '>';
        echo '<option value=""></option>';
        if (!empty($items_id_tech) && !empty($itemtype_tech)) {
            echo '<option selected="selected" value="' . $value_tech . '"
        data-itemtype="' . $itemtype_tech . '"
        data-items-id="' . $items_id_tech . '"
        data-use-notification="' . ($use_notification ? 1 : 0) . '"
        data-default-email="' . $default_email . '"
        data-alternative-email="' . $alternative_email . '"
        data-text="' . $text_tech . '"
        data-title="' . $title_tech . '"
        data-glpi-popover-source="content' . $unique_id_tech . '">' . $title . '</option>';
        }

        echo '</select>';
        echo "</td></tr>";
//
        echo "<tr class='tab_bg_1'>";
        echo "<td class='form-table-text'>" . __("Process auditor", 'dlteams') . "</td>";
        $randDropdown = mt_rand();
        echo "<td colspan='2'>";
        User::dropdown([
            'name' => 'users_id_auditor',
            'value' => $this->fields["users_id_auditor"] ?? "",
            'entity' => $this->fields["entities_id"],
            'right' => 'all',
            'width' => "250px",
            'rand' => $randDropdown
        ]);
        echo "</td></tr>";
//
        echo "<tr class='tab_bg_1'>";
        echo "<td class='form-table-text'>" . __("Process actor", 'dlteams') . "</td>";
        echo "<td colspan='2'>";



        $unique_id = "user_opt_" . $actortype . $this->fields["users_id_actor_itemtype"] . $this->fields["users_id_actor"];
        $itemtype = $this->fields["users_id_actor_itemtype"];
        $items_id = $this->fields["users_id_actor"];
        $value = $itemtype . '_' . $items_id;



        $item = null;
        if (class_exists($itemtype ?? "")) {
            $item = new $itemtype();
            $item->getFromDB($items_id);
        }

// Préparation du libellé affiché
        if (in_array($itemtype, [Group::class, Supplier::class, PluginDlteamsThirdPartyCategory::class])) {
            $name = $item->fields['name'] ?? '';
            $title = $text = $name;
        }

        if ($itemtype == User::class) {
            $firstname = $item->fields['firstname'] ?? '';
            $realname = $item->fields['realname'] ?? '';
            $email = $item->fields['email'] ?? '';
            $text = trim("$firstname $realname");
            $title = trim("$firstname $realname - $email");
        }

        echo '
<select name="users_id_actor" class="form-select" id="actor_' . $rand . '" data-actor-type="' . $actortype . '"' . ($required ? ' required' : '') . '>';
        echo '<option value=""></option>';
        if (!empty($items_id) && !empty($itemtype)) {
            echo '<option selected="selected" value="' . $value . '"
        data-itemtype="' . $itemtype . '"
        data-items-id="' . $items_id . '"
        data-use-notification="' . ($use_notification ? 1 : 0) . '"
        data-default-email="' . $default_email . '"
        data-alternative-email="' . $alternative_email . '"
        data-text="' . $text . '"
        data-title="' . $title . '"
        data-glpi-popover-source="content' . $unique_id . '">' . $title . '</option>';
        }

        echo '</select>';

        echo '<script type="text/javascript">
(function () {
   const actor_select = $("#actor_' . $rand . '");
   const responsible_select = $("#responsible_' . $rand . '");
   const actorytype = "' . $actortype . '";
   const users_id_actor = "' . $value . '";
   const users_id_tech = "' . $value_tech . '";

   var genericTemplate_' . $rand . ' = function(option = {}, is_selection = false) {
      var element = $(option.element);
      var itemtype = element.data("itemtype") ?? option.itemtype;
      var items_id = element.data("items-id") ?? option.items_id;
      var text = escapeMarkupText(element.data("text") ?? option.text ?? "");
      var title = escapeMarkupText(element.data("title") ?? option.title ?? "");
      var use_notif = element.data("use-notification") ?? option.use_notification ?? 1;
      var alt_email = element.data("alternative-email") ?? option.alternative_email ?? "";

      var icon = "", fk = "";
      switch (itemtype) {
         case "User":
            if (items_id == 0) {
               text = alt_email;
               icon = "<i class=\'ti fa-fw ti-mail mx-1\' title=\'Direct email\'></i>";
            } else {
               icon = "<i class=\'ti fa-fw ti-user mx-1\' title=\'User\'></i>";
            }
            fk = "users_id_" + actorytype;
            break;
         case "Group":
            icon = "<i class=\'ti fa-fw ti-users mx-1\' title=\'Group\'></i>";
            fk = "groups_id_" + actorytype;
            break;
         case "Supplier":
            icon = "<i class=\'ti fa-fw ti-package mx-1\' title=\'Supplier\'></i>";
            fk = "suppliers_id_assign";
            break;
      }

      var actions = "";
      if (["User", "Supplier", "Email"].includes(itemtype) && is_selection) {
         var fa_class = use_notif ? "fas" : "far";
         actions = `<button class="btn btn-sm btn-ghost-secondary edit-notify-user"
                           data-bs-toggle="tooltip" data-bs-placement="top"
                           title="Email followup" type="button">
               <i class="${fa_class} fa-bell notify-icon"></i>
            </button>`;
      }

      var option_text = `<span class="actor_text">${text}</span>`;
      var option_element = $(`<span class="actor_entry" data-itemtype="${itemtype}" data-items-id="${items_id}" data-actortype="${actorytype}">${icon}${option_text}${actions}</span>`);

      return option_element;
   };

   actor_select.select2({
      tags: true,
      width: "50%",
      tokenSeparators: [",", " "],
      containerCssClass: "actor-field",
      allowClear: true,
      placeholder: "-- Choisir un acteur --",
      templateSelection: function(option) { return genericTemplate_' . $rand . '(option, true); },
      templateResult: function(option) { return genericTemplate_' . $rand . '(option, false); },
      disabled: false,
      createTag: function (params) {
         var term = $.trim(params.term);
         if (term === "") return null;
         if (!/^[\\w-\\.]+@([\\w-]+\\.)+[\\w-]{2,63}$/.test(term)) return null;

         return {
            id: term,
            text: term,
            itemtype: "User",
            items_id: 0,
            use_notification: 1,
            alternative_email: term
         };
      },
      ajax: {
         url: "/marketplace/dlteams/ajax/record_actors.php",
         datatype: "json",
         type: "POST",
         delay: 250,
         data: function (params) {
            return {
               action: "getActors",
               actortype: actorytype,
               users_right: "all",
               entity_restrict: -1,
               records_id: ' . $records_id . ',
               searchText: params.term,
               itemtype: "PluginDlteamsRecord",
               returned_itemtypes: ["User", "Group", "Supplier", "Contact", "PluginDlteamsThirdPartyCategory"],
               page: params.page || 1
            };
         }
      }
   }).on("select2:open", function () {
      $(".popover").popover("hide");
   });

   actor_select.val(users_id_actor).trigger("change");




//   responsible
responsible_select.select2({
      tags: true,
      width: "50%",
      tokenSeparators: [",", " "],
      containerCssClass: "actor-field",
      allowClear: true,
      placeholder: "-- Choisir un responsable --",
      templateSelection: function(option) { return genericTemplate_' . $rand . '(option, true); },
      templateResult: function(option) { return genericTemplate_' . $rand . '(option, false); },
      disabled: false,
      createTag: function (params) {
         var term = $.trim(params.term);
         if (term === "") return null;
         if (!/^[\\w-\\.]+@([\\w-]+\\.)+[\\w-]{2,63}$/.test(term)) return null;

         return {
            id: term,
            text: term,
            itemtype: "User",
            items_id: 0,
            use_notification: 1,
            alternative_email: term
         };
      },
      ajax: {
         url: "/marketplace/dlteams/ajax/record_actors.php",
         datatype: "json",
         type: "POST",
         delay: 250,
         data: function (params) {
            return {
               action: "getResponsible",
               actortype: actorytype,
               users_right: "all",
               entity_restrict: -1,
               records_id: ' . $records_id . ',
               searchText: params.term,
               itemtype: "PluginDlteamsRecord",
               returned_itemtypes: ["User", "Group"],
               page: params.page || 1
            };
         }
      }
   }).on("select2:open", function () {
      $(".popover").popover("hide");
   });

   responsible_select.val(users_id_tech).trigger("change");
})();
</script>';

        echo "</td></tr>";
//
        echo "<tr class='tab_bg_2'>";
        echo "<td class='form-table-text'>" . __("First entry date", 'dlteams') . "</td>";
        echo "<td colspan='2'>";
        // Test if date exists
        if ($this->fields['first_entry_date'] != '')
            $first_entry_date = $this->fields['first_entry_date'];
        // Else pre-add today's date
        else $first_entry_date = date('Y-m-d');
        echo "<div style='width: 30%'>";
        Html::showDateField('first_entry_date', ['value' => $first_entry_date, 'style' => "width: 100%"]);
        echo "</div>";
        echo "</td></tr>";

        echo "<tr class='tab_bg_1'>";
        echo "<td class='form-table-text'><label for='is_grouping'>" . __("Ce traitement est un regroupement", 'dlteams') . "</label></td>";
        echo "<td colspan='2'>";
        Html::showCheckbox(['name' => 'is_grouping', 'title' => 'Ce traitement est un regroupement', 'id' => 'is_grouping', 'checked' => $this->fields['is_grouping']]);
        echo "</td></tr>";

        echo "<tr class='tab_bg_1'>";
        echo "<td class='form-table-text'>" . __("Additional information", 'dlteams') . "</td>";
        echo "<td colspan='2'>";
        $additional_info = Html::cleanInputText($this->fields['additional_info']);
        echo "<textarea style='width: 98%;' name='additional_info' maxlength='1000' rows='3'>" . $additional_info . "</textarea>";
        echo "</td></tr>";


        $this->showFormButtons($options);


        return true;
    }

    /* static function showPIAStatus($data = [])
    {
        if ($data['pia_required']) {
            echo "&nbsp;&nbsp;&nbsp;" . __("Status") . "&nbsp;&nbsp;";
            self::dropdownPiaStatus('pia_status', $data['pia_status']);
        }
    }

    static function showConsentRequired($data = [])
    {

        if ($data['consent_required']) {
            echo "<td>" . __("Consent storage", 'dlteams') . "</td>";
            echo "<td colspan='2'>";
            $consent_storage = Html::setSimpleTextContent($data['consent_storage']);
            echo "<textarea style='width: 98%;' name='consent_storage' maxlength='1000' rows='3'>" . $consent_storage . "</textarea>";
            echo "</td>";
        }
    } */

    // @see CommonDBTM::showMassiveActionsSubForm()
    public static function showMassiveActionsSubForm(MassiveAction $ma)
    {

        switch ($ma->getAction()) {
            case 'copyTo':
//
                //                $values = [];
//                foreach ($_SESSION["glpiactiveentities"] ?? [] as $key => $entities_id) {
//                    $entity = new Entity();
//                    $entity->getFromDB($entities_id);
//                    $values[$key] = $entity->fields["completename"];
//                }
//                Entity::dropdown(['name' => 'entities_id']);
                Entity::dropdown(['name' => 'entities_id']);
                PluginDlteamsPolicieForm::showExportInfo();

                echo '<br /><br />' . Html::submit(_x('button', 'Post'), ['name' => 'massiveaction']);
                return true;
                break;
            case 'publish_dlregister':

//                echo __("Choose dlteams folder", 'dlteams');
//                echo "&nbsp;";

                $links = PluginDlteamsPublish::getPublicationFoldersLinks();

                $links_list = [];
                foreach ($links as $link) {
                    array_push($links_list, $link);
                }

//
                if (!isset($config['report_type'])) {
                    $config['report_type'] = PluginDlteamsPublish::REPORT_SINGLE_RECORD;
                }


                echo "<br/>";
                echo "<div style='display: flex; gap: 1rem; width: 100%; justify-content: center; align-items: center'>";
                echo Html::submit(_x('button', 'Voir / PDF'), ['name' => 'print', 'class' => 'btn btn-primary btn-xs']);
                echo Html::submit(_x('button', 'Editer en HTML'), ['name' => 'edithtml', 'class' => 'btn btn-primary btn-xs']);
//                echo Html::submit(_x('button', 'Copier'), ['name' => 'massiveaction']);
                echo "</div>";
                return true;
                break;

//            case 'copy_policieform_concernedperson_to_record':
//                PluginDlteamsPolicieForm::dropdown([
//                    'name' => 'policieforms_id',
//                ]);
//                echo '<br/><br />' . Html::submit(_x('button', 'Copier'), ['name' => 'massiveaction']);
//                return true;
//                break;

            case 'dlteams_update_numbers':
                echo __("Number (order)");
                echo "&nbsp;";
                echo "<input type='text' placeholder='Ex: 5' name='number' size='8' required>";
//                $number = Html::cleanInputText($this->fields['parentnumber']);
//                if($id == 0) $number = 1;
//                echo "<input type='number' min='0' max='9999' id='parentnumber' name='parentnumber' size='8' required>";
                echo "<br/>";
                echo "<br/>";
                break;
        }
        return parent::showMassiveActionsSubForm($ma);
    }


    /**
     * Select a field using standard system
     *
     * @param integer|string|array $field_id_or_search_options id of the search option field
     *                                                             or field name
     *                                                             or search option array
     * @param string $name name of the select (if empty use linkfield)
     *                                                         (default '')
     * @param mixed $values default value to display
     *                                                         (default '')
     * @param array $options array of possible options:
     * Parameters which could be used in options array :
     *    - comments : boolean / is the comments displayed near the value (default false)
     *    - any others options passed to specific display method
     *
     * @return false|string the string to display
     **@since 0.83
     *
     */
    public function getValueToSelect($field_id_or_search_options, $name = '', $values = '', $options = [])
    {
        /** @var array $CFG_GLPI */
        global $CFG_GLPI;

        $param = [
            'comments' => false,
            'html' => false,
        ];
        foreach ($param as $key => $val) {
            if (!isset($options[$key])) {
                $options[$key] = $val;
            }
        }

        $searchoptions = [];
        if (is_array($field_id_or_search_options)) {
            $searchoptions = $field_id_or_search_options;
        } else {
            $searchopt = $this->searchOptions();

            // Get if id of search option is passed
            if (is_numeric($field_id_or_search_options)) {
                if (isset($searchopt[$field_id_or_search_options])) {
                    $searchoptions = $searchopt[$field_id_or_search_options];
                }
            } else { // Get if field name is passed
                $searchoptions = $this->getSearchOptionByField(
                    'field',
                    $field_id_or_search_options,
                    $this->getTable()
                );
            }
        }

        $value = $values;

        if (count($searchoptions)) {
            $field = $searchoptions['field'];
            // Normalize option
            if (is_array($values)) {
                $value = $values[$field];
            } else {
                $values = [$field => $value];
            }

            if (empty($name)) {
                $name = $searchoptions['linkfield'];
            }
            // If not set : set to specific
            if (!isset($searchoptions['datatype'])) {
                $searchoptions['datatype'] = 'specific';
            }

            $options['display'] = false;

            if (isset($options[$searchoptions['table'] . '.' . $searchoptions['field']])) {
                $options = array_merge(
                    $options,
                    $options[$searchoptions['table'] . '.' . $searchoptions['field']]
                );
            }

            switch ($searchoptions['datatype']) {
                case "count":
                case "number":
                case "integer":
                    $copytooption = ['min', 'max', 'step', 'toadd', 'unit'];
                    foreach ($copytooption as $key) {
                        if (isset($searchoptions[$key]) && !isset($options[$key])) {
                            $options[$key] = $searchoptions[$key];
                        }
                    }
                    $options['value'] = $value;
                    return Dropdown::showNumber($name, $options);

                case "decimal":
                case "mac":
                case "ip":
                case "string":
                case "email":
                case "weblink":
                    return Html::input($name, ['value' => $value]);

                case "text":
                    $is_htmltext = isset($searchoptions['htmltext']) && $searchoptions['htmltext'];
                    if ($is_htmltext) {
                        $value = RichText::getSafeHtml($value, true);
                    }

                    return Html::textarea(
                        [
                            'display' => false,
                            'name' => $name,
                            'value' => $value,
                            'enable_fileupload' => false,
                            'enable_richtext' => $is_htmltext,
                            // For now, this textarea is displayed only in the "update" massive action form, for fields
                            // corresponding to a search option having "htmltext" property.
                            // Uploaded images processing is not able to handle multiple use of same uploaded file, so until this is fixed,
                            // it is preferable to disable image pasting in rich text inside massive actions.
                            'enable_images' => false,
                            'cols' => 45,
                            'rows' => 5,
                        ]
                    );

                case "bool":
                    return Dropdown::showYesNo($name, $value, -1, $options);

                case "color":
                    return Html::showColorField($name, $options);

                case "date":
                case "date_delay":
                    if (isset($options['relative_dates']) && $options['relative_dates']) {
                        if (isset($searchoptions['maybefuture']) && $searchoptions['maybefuture']) {
                            $options['with_future'] = true;
                        }
                        return Html::showGenericDateTimeSearch($name, $value, $options);
                    }
                    $copytooption = ['min', 'max', 'maybeempty', 'showyear'];
                    foreach ($copytooption as $key) {
                        if (isset($searchoptions[$key]) && !isset($options[$key])) {
                            $options[$key] = $searchoptions[$key];
                        }
                    }
                    $options['value'] = $value;
                    return Html::showDateField($name, $options);

                case "datetime":
                    if (isset($options['relative_dates']) && $options['relative_dates']) {
                        if (isset($searchoptions['maybefuture']) && $searchoptions['maybefuture']) {
                            $options['with_future'] = true;
                        }
                        $options['with_time'] = true;
                        return Html::showGenericDateTimeSearch($name, $value, $options);
                    }
                    $copytooption = ['mindate', 'maxdate', 'mintime', 'maxtime',
                        'maybeempty', 'timestep'
                    ];
                    foreach ($copytooption as $key) {
                        if (isset($searchoptions[$key]) && !isset($options[$key])) {
                            $options[$key] = $searchoptions[$key];
                        }
                    }
                    $options['value'] = $value;
                    return Html::showDateTimeField($name, $options);

                case "timestamp":
                    $copytooption = ['addfirstminutes', 'emptylabel', 'inhours', 'max', 'min',
                        'step', 'toadd', 'display_emptychoice'
                    ];
                    foreach ($copytooption as $key) {
                        if (isset($searchoptions[$key]) && !isset($options[$key])) {
                            $options[$key] = $searchoptions[$key];
                        }
                    }
                    $options['value'] = $value;
                    return Dropdown::showTimeStamp($name, $options);

                case "itemlink":
                    if (isset($options['itemlink_as_string']) && $options['itemlink_as_string']) {
                        // Do not use dropdown if wanted to select string value instead of ID
                        break;
                    }
                //use dropdown case per default

                case "dropdown":
                    $copytooption = ['condition', 'displaywith', 'emptylabel',
                        'right', 'toadd'
                    ];
                    $options['name'] = $name;
                    $options['value'] = $value;
                    foreach ($copytooption as $key) {
                        if (isset($searchoptions[$key]) && !isset($options[$key])) {
                            $options[$key] = $searchoptions[$key];
                        }
                    }
                    if (!isset($options['entity'])) {
                        $options['entity'] = $_SESSION['glpiactiveentities'];
                    }
                    $itemtype = getItemTypeForTable($searchoptions['table']);

                    return $itemtype::dropdown($options);

                case "right":
                    return Profile::dropdownRights(
                        Profile::getRightsFor($searchoptions['rightclass']),
                        $name,
                        $value,
                        ['multiple' => false,
                            'display' => false
                        ]
                    );

                case "itemtypename":
                    if (isset($searchoptions['itemtype_list'])) {
                        $options['types'] = $CFG_GLPI[$searchoptions['itemtype_list']];
                    }
                    $copytooption = ['types'];
                    $options['value'] = $value;
                    foreach ($copytooption as $key) {
                        if (isset($searchoptions[$key]) && !isset($options[$key])) {
                            $options[$key] = $searchoptions[$key];
                        }
                    }
                    if (isset($options['types'])) {
                        return Dropdown::showItemTypes(
                            $name,
                            $options['types'],
                            $options
                        );
                    }
                    return false;

                case "language":
                    $copytooption = ['emptylabel', 'display_emptychoice'];
                    foreach ($copytooption as $key) {
                        if (isset($searchoptions[$key]) && !isset($options[$key])) {
                            $options[$key] = $searchoptions[$key];
                        }
                    }
                    $options['value'] = $value;
                    return Dropdown::showLanguages($name, $options);
            }
            // Get specific display if available
            $itemtype = getItemTypeForTable($searchoptions['table']);
            if ($item = getItemForItemtype($itemtype)) {
                $options['searchopt'] = $searchoptions;
                $specific = $item->getSpecificValueToSelect(
                    $searchoptions['field'],
                    $name,
                    $values,
                    $options
                );
                if (strlen($specific)) {
                    return $specific;
                }
            }
        }


        if ($field == "states_id") {
            return Dropdown::showFromArray('states_id', self::broadcast_elements, $options);
        }
        // default case field text
        return Html::input($name, ['value' => $value]);
    }

    public static function importToDB(PluginDlteamsLinker $linker, $input = [], $containerId = 0, $subItems = [])
    {
        global $DB;
        // New record
        $input['_skip_checks'] = true;
        $item = new self();
        // Set Record Fields
        $originalId = $input['id'];
        unset($input['id']);

        // Escape text fields
        foreach ([
                     'name', 'content', 'additional_info', 'consent_explicit',
                     'diffusion', 'conservation_time', 'archive_time', 'right_information',
                     'right_correction', 'profiling_auto', 'specific_security_measures'
                 ] as $key) {
            $input[$key] = $DB->escape($input[$key]);
        }
        $itemId = $item->add($input, [], false);
        if ($itemId === false) {
            $typeName = strtolower(self::getTypeName());
            throw new ImportFailureException(sprintf(__('failed to copy the %1$s record', 'dlteams'), $input['name']));
        }
        // add the record to the linker
        $linker->addObject($originalId, $item);
        return $itemId;
    }

    function getSpecificMassiveActions($checkitem = NULL)
    {
        $actions = parent::getSpecificMassiveActions($checkitem);
        // add a single massive action
        $class = __CLASS__;

        $action_key = "delete_with_related_dlteams_action";
        $action_label = __("Supprimer définitivement avec les éléments liés", "dlteams");
        $actions[$class . MassiveAction::CLASS_ACTION_SEPARATOR . $action_key] = $action_label;

        $action_key = "delete_without_related_dlteams_action";
        $action_label = __("Supprimer mais conserver les éléments liés", "dlteams");
        $actions[$class . MassiveAction::CLASS_ACTION_SEPARATOR . $action_key] = $action_label;

        $action_key = "publish_dlregister";
        $action_label = "<i class='fa-fw far fa-file" . "'></i>". __("Publier", "dlteams");
        $actions[$class . MassiveAction::CLASS_ACTION_SEPARATOR . $action_key] = $action_label;

        $action_key = "dlteams_update_numbers";
        $action_label = __("Modifier numérotation", "dlteams");
        $actions[$class . MassiveAction::CLASS_ACTION_SEPARATOR . $action_key] = $action_label;

        $action_key = "dlteams_reorder_numbers";
        $action_label = __("Numéroter en continu", "dlteams");
        $actions[$class . MassiveAction::CLASS_ACTION_SEPARATOR . $action_key] = $action_label;

//        $action_key = "dlteams_update_number";
//        $action_label = __("Numérotation automatique", "dlteams");
//        $actions[$class . MassiveAction::CLASS_ACTION_SEPARATOR . $action_key] = $action_label;

        $class = __CLASS__;
        $action_key = "copy_policieform_concernedperson_to_record";
        $action_label = "<i class='fa-fw " . PluginDlteamsPolicieForm::getIcon() . "'></i>"._n("Ajouter au traitements les éléments des jeux de données liés", 0, "dlteams");
        $actions[$class . MassiveAction::CLASS_ACTION_SEPARATOR . $action_key] = $action_label;

        return $actions;
    }

    function exportToDB($subItems = [])
    {
        if ($this->isNewItem()) {
            return false;
        }
        $export = $this->fields;

        // Remove unused key
        unset(
            $export['users_id_creator'],
            $export['users_id_lastupdater'],
            $export['users_id_tech'],
            $export['users_id_auditor'],
            $export['users_id_actor'],
            $export['first_entry_date'],
            $export['date_creation'],
            $export['date_mod']
        );
        return $export;
    }

    // Execute massive action for dlteams Plugin
    // @see CommonDBTM::processMassiveActionsForOneItemtype()
    static function processMassiveActionsForOneItemtype(MassiveAction $ma, CommonDBTM $item, array $ids)
    {
        /*        highlight_string("<?php\n\$data =\n" . var_export($item->, true) . ";\n?>");*/
//        die();
        switch ($ma->getAction()) {
            case 'copyTo':
                if ($item->getType() == 'PluginDlteamsRecord') {
                    // @var PluginDlteamsRecord $item
                    foreach ($ids as $id) {
                        if ($item->getFromDB($id)) {
                            if ($item->copyRecord($ma->POST['entities_id'], $id, $item, $ma->POST['exportOption'])) {
                                //Session::addMessageAfterRedirect(sprintf(__('Record copied: %s', 'dlteams'), $item->getName()));
                                $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);
                            }
                        } else {
                            // Example of ko count
                            $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_KO);
                        }
                    }
//                    die();
                }
                return;
                break;
            case 'delete_with_related_dlteams_action':
                global $DB;
                $types = PluginDlteamsItemType::getItemsTypes();
                foreach ($ids as $id) {
                    foreach ($types as $type) {
                        if (class_exists($type)) {
                            $type = new $type();
                            $DB->delete(
                                $type->getTable(),
                                [
                                    'itemtype' => 'PluginDlteamsRecord',
                                    'items_id' => $id
                                ]
                            );
                        }
                    }

                    $record_item = new PluginDlteamsRecord_Item();
                    $DB->delete(
                        $record_item->getTable(),
                        [
                            "records_id" => $id
                        ]
                    );

                    $item->delete(['id' => $id]);
                }
                Session::addMessageAfterRedirect("Opération éffectué avec succés");
                $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);
                return;
                break;


            case 'delete_without_related_dlteams_action':
//                global $DB;
//                $types = PluginDlteamsItemType::getItemsTypes();
                foreach ($ids as $id) {
                    $item->delete(['id' => $id]);
//                    foreach ($types as $type) {
//                    }
                }

                Session::addMessageAfterRedirect("Opération éffectué avec succés");
                $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);
                return;
                break;

            case 'publish_dlregister':

//                if(isset($ma->POST["editpdf"])){
//                    $pdfoutput = new PluginDlteamsPublish();
//                    $pdfoutput->generateReport([], [], $ids);
//                }

                $action = null;
                if (isset($_POST["print"]))
                    $action = "print";
                if (isset($_POST["edithtml"]))
                    $action = "edithtml";

                if (!$action) {
                    Session::addMessageAfterRedirect("Aucune action n'a été définie", 0, ERROR);
                    Html::back();
                }
                $url = PluginDlteamsPublish::getSearchURL();
                $params = array(
                    'action' => $action,
                    'createpdf' => isset($_POST["print"]),
                    'createhtml' => isset($_POST["edithtml"])
                );

                $_SESSION["printable_records"] = $ids;

                // Build the query string
                $queryString = http_build_query($params);

                // Combine URL and query string
                $fullUrl = $url . '?' . $queryString;


                Html::redirect($fullUrl);
                // Output the JavaScript to open a new tab
//            echo "<script type='text/javascript'>
//                    var newWindow = window.open('$fullUrl', '_blank');
//                   if (newWindow) {
//                        newWindow.focus();
//                    } else {
//                        alert('Please allow popups for this website');
//                    }
//                  </script>";
//                Html::back();
                break;

            case 'copy_policieform_concernedperson_to_record':
                foreach ($ids as $id_record) {
                    $id = $id_record;
                    $record = new PluginDlteamsRecord();
                    $record->getFromDB($id_record);
                    $iterator_pf = PluginDlteamsRecord_Element::getPolicyFormRequest($record);

                    foreach ($iterator_pf as $pf_item){
                        $policieforms_id = $pf_item["policieforms_id"];
                        $pf = new PluginDlteamsPolicieForm();
                        $pf->getFromDB($policieforms_id);
                        $pfid = $policieforms_id;

                        global $DB;
                        $pf_query = [
                            "FROM" => PluginDlteamsPolicieForm_Item::getTable(),
                            "OR" => [
                                [
                                    "policieforms_id" => $pfid,
                                    "itemtype" => PluginDlteamsConcernedPerson::class,
                                    "itemtype1" => PluginDlteamsProcessedData::class,
                                    "items_id" => ['<>', 0]
                                ],
                                [
                                    "policieforms_id" => $pfid,
                                    "itemtype" => PluginDlteamsConcernedPerson::class,
                                    "itemtype1" => PluginDlteamsProcessedData::class,
                                    "items_id" => ['<>', null]
                                ],
                                [
                                    "policieforms_id" => $pfid,
                                    "itemtype" => PluginDlteamsConcernedPerson::class,
                                    "items_id" => ['<>', 0],
                                    "itemtype1" => null
                                ],
                                [
                                    "policieforms_id" => $pfid,
                                    "itemtype" => PluginDlteamsConcernedPerson::class,
                                    "items_id" => ['<>', null],
                                    "itemtype1" => null
                                ]
                            ]
                        ];

                        $iteraor = $DB->request($pf_query);
                        foreach ($iteraor as $pf_item) {
                            $record_item = new PluginDlteamsRecord_Item();
                            $criteria_r0 = [
                                "records_id" => $id,
                                "itemtype" => $pf_item["itemtype"],
                                "items_id" => $pf_item["items_id"],
                                "itemtype1" => $pf_item["itemtype1"],
                                "items_id1" => $pf_item["items_id1"],
                                "mandatory" => $pf_item["mandatory"],
                            ];
                            if(!$record_item->getFromDBByCrit($criteria_r0))
                                $record_item->add($criteria_r0);

                            if ($pf_item["itemtype1"]) {
                                $cp_item = new PluginDlteamsConcernedPerson_Item();
                                $criteria = [
                                    "concernedpersons_id" => $pf_item["items_id"],
                                    "itemtype" => PluginDlteamsRecord::class,
                                    "items_id" => $id,
                                    "itemtype1" => $pf_item["itemtype1"],
                                    "items_id1" => $pf_item["items_id1"],
                                ];
                                if (!$cp_item->getFromDBByCrit($criteria))
                                    $cp_item->add($criteria);
                            }

                            if ($pf_item["itemtype1"]) {
                                $pd_item = new PluginDlteamsProcessedData_Item();
                                $criteria = [
                                    "processeddatas_id" => $pf_item["items_id1"],
                                    "itemtype" => PluginDlteamsRecord::class,
                                    "items_id" => $id,
                                    "itemtype1" => $pf_item["itemtype"],
                                    "items_id1" => $pf_item["items_id"],
                                ];
                                if (!$pd_item->getFromDBByCrit($criteria))
                                    $pd_item->add($criteria);
                            }
                        }


//                    ajouter également la licéité contenue dans le jeu de données
                        $pf_query = [
                            "FROM" => PluginDlteamsPolicieForm_Item::getTable(),
                            "WHERE" => [
                                "policieforms_id" => $pfid,
                                "itemtype" => PluginDlteamsLegalbasi::class,
                            ]
                        ];

                        $iteraor = $DB->request($pf_query);
                        foreach ($iteraor as $pf_item) {
                            $record_item = new PluginDlteamsRecord_Item();
                            $criteria_r = [
                                "records_id" => $id,
                                "itemtype" => $pf_item["itemtype"],
                                "items_id" => $pf_item["items_id"],
                                "comment" => $pf_item["comment"],
                            ];

                            if(!$record_item->getFromDBByCrit($criteria_r))
                                $record_item->add($criteria_r);

                            if ($pf_item["itemtype"]) {
                                $lb_item = new PluginDlteamsLegalBasi_Item();
                                $criteria = [
                                    "legalbasis_id" => $pf_item["items_id"],
                                    "itemtype" => PluginDlteamsRecord::class,
                                    "items_id" => $id,
                                    "comment" => $pf_item["comment"],
                                ];
                                if (!$lb_item->getFromDBByCrit($criteria))
                                    $lb_item->add($criteria);
                            }
                        }

//                    ajouter également la rétention contenue dans le jeu de données
                        $pf_query = [
                            "FROM" => PluginDlteamsPolicieForm_Item::getTable(),
                            "WHERE" => [
                                "policieforms_id" => $pfid,
                                "itemtype" => PluginDlteamsStoragePeriod::class,
                            ]
                        ];

                        $iteraor = $DB->request($pf_query);
                        foreach ($iteraor as $pf_item) {
                            $record_item = new PluginDlteamsRecord_Item();
                            $criteria_r2 = [
                                "records_id" => $id,
                                "itemtype" => $pf_item["itemtype"],
                                "items_id" => $pf_item["items_id"],
                                "comment" => $pf_item["comment"],
                                "plugin_dlteams_storageendactions_id" => $pf_item["plugin_dlteams_storageendactions_id"],
                                "plugin_dlteams_storagetypes_id" => $pf_item["plugin_dlteams_storagetypes_id"],
                            ];
                            if(!$record_item->getFromDBByCrit($criteria_r2))
                                $record_item->add($criteria_r2);

                            if ($pf_item["itemtype"]) {
                                $sp_item = new PluginDlteamsStoragePeriod_Item();
                                $criteria = [
                                    "storageperiods_id" => $pf_item["items_id"],
                                    "itemtype" => PluginDlteamsRecord::class,
                                    "items_id" => $id,
                                    "comment" => $pf_item["comment"],
                                    "plugin_dlteams_storageendactions_id" => $pf_item["plugin_dlteams_storageendactions_id"],
                                    "plugin_dlteams_storagetypes_id" => $pf_item["plugin_dlteams_storagetypes_id"],
                                ];
                                if (!$sp_item->getFromDBByCrit($criteria))
                                    $sp_item->add($criteria);
                            }
                        }
                    }



                }

                Session::addMessageAfterRedirect("Opération éffectué avec succés");
                $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);
                break;

            case 'dlteams_update_numbers':

                $number = $ma->POST['number'] ?? '';

                if (!preg_match('/^[0-9]+(?:\.[0-9]+)?$/', $number)) {
                    Session::addMessageAfterRedirect(
                        "Veuillez renseigner une numérotation correcte (ex. 123 ou 40.2)",
                        0,
                        WARNING
                    );
                    Html::back();
                }

                global $DB;
                $input      = (string) $ma->POST['number'];
                $parts      = explode('.', $input, 2);

                $baseNumber = (int) $parts[0];

                $startIndex = isset($parts[1]) ? (int) $parts[1] : 0;

                $decimalWidth = max(strlen($parts[1] ?? ''), 2);

                $table = (new PluginDlteamsRecord())->getTable();

                $orderedIds = array_values($ids);

                $counter = 0;
                foreach ($orderedIds as $id) {
                    // calcul du parentnumber
                    $parent = $startIndex + $counter;

                    // padding sur la partie décimale, ex. 0→"00", 1→"01", 15→"15"
                    $parentPadded = str_pad((string)$parent, $decimalWidth, '0', STR_PAD_LEFT);

                    // nouvelle valeur complète, ex. "2.00", "2.01" ou "6.15"
                    $newComplete = "{$baseNumber}.{$parentPadded}";

                    // mise à jour en base
                    $DB->update(
                        $table,
                        [
                            'number'         => $baseNumber,
                            'parentnumber'   => $parent,
                            'completenumber' => $newComplete,
                        ],
                        ['id' => $id]
                    );

                    $counter++;
                }

//                Session::addMessageAfterRedirect("Opération éffectué avec succés");
                $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);
                break;
            case 'dlteams_reorder_numbers':

                global $DB;
                $orderedIds = array_values($ids);
                $first_record = new PluginDlteamsRecord();
                $first_record->getFromDB($orderedIds[0]);

                $input      = (string) $first_record->fields["completenumber"];
                $parts      = explode('.', $input, 2);




                $baseNumber = (int) $parts[0];

                $startIndex = isset($parts[1]) ? (int) $parts[1] : 0;

                $decimalWidth = max(strlen($parts[1] ?? ''), 2);

                $table = (new PluginDlteamsRecord())->getTable();

                $counter = 0;
                foreach ($orderedIds as $id) {
                    // calcul du parentnumber
                    $parent = $startIndex + $counter;

                    // padding sur la partie décimale, ex. 0→"00", 1→"01", 15→"15"
                    $parentPadded = str_pad((string)$parent, $decimalWidth, '0', STR_PAD_LEFT);

                    // nouvelle valeur complète, ex. "2.00", "2.01" ou "6.15"
                    $newComplete = "{$baseNumber}.{$parentPadded}";

                    // mise à jour en base
                    $DB->update(
                        $table,
                        [
                            'number'         => $baseNumber,
                            'parentnumber'   => $parent,
                            'completenumber' => $newComplete,
                        ],
                        ['id' => $id]
                    );

                    $counter++;
                }

//                Session::addMessageAfterRedirect("Opération éffectué avec succés");
                $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);
                break;
        }
//        parent::processMassiveActionsForOneItemtype($ma, $item, $ids);
    }


    public static function isSensitive(PluginDlteamsRecord $record){
        global $DB;
        $sensitive_iterator = $DB->request(PluginDlteamsRecord_PersonalAndDataCategory::getRequest($record, true));
        return count($sensitive_iterator)>0;
    }

//    public static function getTimelinePosition(){
//        return 0;
//    }


    /**
     * Copy a record to another entity. Execute copy action for massive action.
     * @param integer $entity id of the target entity
     *
     * @return Boolean true if success, false otherwize.
     */

    public static function getForbiddenActionsForMenu()
    {
        return ["Document_Item:remove"];
    }

    public static function getCurrentId()
    {
        // Get the current URL
        $currentURL = $_SERVER['REQUEST_URI'];

        // Get the query string from the URL
        $queryString = parse_url($currentURL, PHP_URL_QUERY);

        // Initialize an empty array for query parameters
        $queryParams = [];

        // Parse the query string into an array of parameters if it exists
        if ($queryString) {
            parse_str($queryString, $queryParams);
        }

        // Get the value of the "id" parameter
        $id = isset($queryParams['id']) ? $queryParams['id'] : null;

        return $id;
    }


    public static function getMenuContent()
    {

        $menu = [];
        $menu['title'] = static::getTypeName(Session::getPluralNumber());
        $menu['shortcut'] = 'n';
        $menu['page'] = static::getSearchURL();
        $menu['icon'] = self::getIcon();
        $menu['config']['default'] = '/front/dropdown.php';


//        Bouton add
        if (static::canCreate()) {
            $menu['options']["record"]['links']['add'] = static::getFormURL(false);
        }

//        bouton rechercher
        $menu['options']["record"]['links']['search'] = static::getSearchURL(false);


//        bouton print pdf
        $image = "<i class='fas fa-eye' title='" . 'Rapport complet' . "'></i>";
        $print_pdf_settings = [
            "record_id" => static::getCurrentId(),
            "report_type" => PluginDlteamsPublish::REPORT_ALL,
            "action" => "print",
            "createpdf" => true,
        ];

        $query_string = http_build_query($print_pdf_settings);
        $eye_url = PluginDlteamsPublish::getSearchURL() . '?' . $query_string;
        $menu['options']["record"]['links'][$image] = $eye_url;

//        bouton help
        $image = "<i class='fas fa-question' title='" . 'Aide' . "'></i>";
        $menu['options']["record"]['links'][$image] = KnowbaseItem::getSearchURL(false) . '?contains="registre des traitements"';

        echo "<script>
                        \$(document).ready(function () {
                            // Attendre que la page soit complètement chargée
                            \$('a[href^=\"/front/knowbaseitem.php?contains=\"]').attr('target', '_blank');
                            \$('a[href^=\"/marketplace/dlteams/front/createpdf.php\"]').attr('target', '_blank');
                        });
                    </script>";


        if (count($_SESSION['glpiprofiles']) > 1) {
            $profile = new Profile();
            $name = 'Vue-Modele';
            $options = [
                'SELECT' => [
                    'id'
                ],
                'WHERE' => [
                    'name' => $name,
                ]
            ];

            global $DB;
            $req = $DB->request($profile->getTable(), $options);
            foreach ($req as $id => $row) {
                //if ($row = $req->next()) {
                $profile->getFromDB($row['id']);
                if (array_key_exists($profile->getID(), $_SESSION['glpiprofiles'])) {
                    $swap = $_SESSION['glpiactiveprofile']['id'] == $profile->getID();
                    $text = '<i class="fa fa-layer-group pointer" style="margin-right: 0.4em;"></i>' . __("Swap to model view", "dlteams");
                    $returnKey = array_key_first($_SESSION['glpiprofiles']) == $profile->getID() ? array_keys($_SESSION['glpiprofiles'])[1] : array_key_first($_SESSION['glpiprofiles']);
                    $prodif = $profile->getID();
                    $server_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
                    empty($swap) ? $text = "vue modèle" : $text = "vue modèle";
                    empty($swap) ? $val = $prodif : $val = $returnKey;
                    empty($swap) ? $checked = '' : $checked = 'checked';


                    $text_temp = "<div id='switchmodelcontainer' style='width:100%; display: flex;justify-content: center; margin-bottom: 1px; margin-right: 25px;'>
                                        <label class='form-check form-switch btn-xs  me-0 me-sm-1 px-1 py-1 mb-0 flex-column-reverse flex-sm-row'
                                            title='$text'>
                                         <input type='checkbox' class='form-check-input ms-0 me-1 mt-0' role='button'
                                                autocomplete='off'
                                                $checked
                                                onclick='window.location.href=`$server_url/front/central.php?newprofile=$val`'
                                                />
                                         <span class='form-check-label mb-1 mb-sm-0'>
                                            $text
                                         </span>
                                      </label></div>
                                      
                                      <script>
                                            var child = document.getElementById('switchmodelcontainer');
                                            var parent = child.parentNode;
                                            parent.style.border = 'none';
                                            parent.classList.remove('btn-outline-secondary');
                                        </script>
                            ";


                    $menu['options']["record"]['links'][$text_temp] = "/front/central.php?newprofile=$val";
                    break;


                }
            }

        }

        return $menu;
    }


    public function defineTabs($options = [])
    {
        $ong = [];
        $this
            ->addDefaultFormTab($ong)
            // Section 1 : Description du traitement
            ->addStandardTab(__CLASS__, $ong, $options)
//            // Section 2 : Personnes concernées par ce traitement et catégories de données
            ->addStandardTab('PluginDlteamsRecord_PersonalAndDataCategory', $ong, $options)
//            // Section 3 : Bases légales & rétention
            ->addStandardTab(PluginDlteamsConservation_Element::class, $ong, $options)

//            // Section 5 : Acteurs, soustaitants, destinataires
            ->addStandardTab('PluginDlteamsRecord_External', $ong, $options)
            // Section 6  : Security and confidentiality
            ->addStandardTab('PluginDlteamsRecord_SecurityMeasure', $ong, $options)
            ->addStandardTab('PluginDlteamsRecord_Element', $ong, $options)

            ->addStandardTab('PluginDlteamsRecord_Rights', $ong, $options)
            ->addStandardTab(PluginDlteamsProtectiveMeasure_Item::class, $ong, $options)
            ->addStandardTab(PluginDlteamsRecord_Catalog::class, $ong, $options)
            ->addStandardTab(PluginDlteamsRecord_Stockage::class, $ong, $options)
//            ->addStandardTab('PluginDlteamsObject_document', $ong, $options)
            ->addStandardTab('PluginDlteamsPublish', $ong, $options)
            ->addStandardTab(PluginDlteamsMessage::class, $ong, $options)
            ->addStandardTab('Notepad', $ong, $options)
            ->addStandardTab(PluginDlteamsTicket_Item::class, $ong, $options)
            ->addStandardTab('PluginDlteamsRecord_Item', $ong, $options)
            ->addStandardTab('Log', $ong, $options);
        return $ong;
    }


//    public function getTabNameForItem(CommonGLPI $item, $withtemplate = 0)
//    {
//
//        if (!$withtemplate) {
//            $nb = 0;
//            switch ($item->getType()) {
//                case __CLASS__:
//                    $ong[1] = $this->getTypeName(1);
//                    if ($item->canUpdateItem()) {
//                        if ($_SESSION['glpishow_count_on_tabs']) {
////                            $nb = $item->countVisibilities();
//                            $nb = 0;
//                        }
//                        $ong[2] = self::createTabEntry(
//                            _n('Target', 'Targets', Session::getPluralNumber()),
//                            $nb
//                        );
//                        $ong[3] = __('Edit');
//                    }
//                    return $ong;
//            }
//        }
//        return '';
//    }

    function cleanDBonPurge()
    {
        $this->deleteChildrenAndRelationsFromDb(
            [
                PluginDlteamsRecord_PersonalAndDataCategory::class,
                PluginDlteamsRecord_Storage::class,
                PluginDlteamsRecord_PersonalDataCategory::class,
            ]
        );

        /*      $retention = new PluginDlteamsRecord_Retention();
              $retention->deleteByCriteria(['plugin_dlteams_records_id' => $this->fields['id']]);*/
    }

    static function getAllPiaStatusArray($withmetaforsearch = false)
    {
        $tab = [
            self::PIA_STATUS_UNDEFINED => __("Undefined", 'dlteams'),
            self::PIA_STATUS_TODO => __("To do"),
            self::PIA_STATUS_QUALIFICATION => __("Qualification"),
            self::PIA_STATUS_APPROVAL => __("Approval"),
            self::PIA_STATUS_PENDING => __("Pending"),
            self::PIA_STATUS_CLOSED => __("Closed")
        ];

        if ($withmetaforsearch) {
            $tab['all'] = __("All");
        }

        return $tab;
    }

    static function getAllStorageMediumArray($withmetaforsearch = false)
    {
        $tab = [
            self::STORAGE_MEDIUM_UNDEFINED => __("Undefined", 'dlteams'),
            self::STORAGE_MEDIUM_PAPER_ONLY => __("Paper only", 'dlteams'),
            self::STORAGE_MEDIUM_MIXED => __("Paper and electronic", 'dlteams'),
            self::STORAGE_MEDIUM_ELECTRONIC => __("Electronic only", 'dlteams'),
        ];

        if ($withmetaforsearch) {
            $tab['all'] = __("All");
        }
        return $tab;
    }

    static function dropdownStorageMedium($name, $value = 0, $display = true)
    {
        return Dropdown::showFromArray($name, self::getAllStorageMediumArray(), [
            'value' => $value, 'display' => $display
        ]);
    }

    static function dropdownPiaStatus($name, $value = 0, $display = true)
    {
        return Dropdown::showFromArray($name, self::getAllPiastatusArray(), [
            'value' => $value, 'display' => $display
        ]);
    }

    static function getSpecificValueToDisplay($field, $values, array $options = [])
    {
        if (!is_array($values)) {
            $values = [$field => $values];
        }

        switch ($field) {
            case 'states_id':
                if (isset(self::broadcast_elements[$values[$field]])) {
                    return self::broadcast_elements[$values[$field]];
                } else {
                    return '&nbsp;';
                }
            case 'pia_status':
                if (!$values[$field]) {
                    return '&nbsp;';
                }
                $pia_status = self::getAllPiastatusArray();

                return $pia_status[$values[$field]];
            case 'storage_medium':
                $storage_medium = self::getAllStorageMediumArray();

                return $storage_medium[$values[$field]];
        }
    }

    static function getSpecificValueToSelect($field, $name = '', $values = '', array $options = [])
    {
        if (!is_array($values)) {
            $values = [$field => $values];
        }
        $options['display'] = false;

        switch ($field) {
            case 'pia_status':
                return self::dropdownPiaStatus($name, $values[$field], false);
            case 'storage_medium':
                return self::dropdownStorageMedium($name, $values[$field], false);
        }
        return parent::getSpecificValueToSelect($field, $name, $values, $options);
    }

    function prepareInputForAdd($input)
    {
        $input['users_id_creator'] = Session::getLoginUserID();
        if (array_key_exists('pia_required', $input) && $input['pia_required'] == 0) {
            $input['pia_status'] = PluginDlteamsRecord::PIA_STATUS_UNDEFINED;
        }

        if (array_key_exists('consent_required', $input) && $input['consent_required'] == 0) {
            $input['consent_storage'] = null;
        }
        return parent::prepareInputForAdd($input);
    }

    function prepareInputForUpdate($input)
    {
        $input['users_id_lastupdater'] = Session::getLoginUserID();
        if (array_key_exists('pia_required', $input) && $input['pia_required'] == 0) {
            $input['pia_status'] = PluginDlteamsRecord::PIA_STATUS_UNDEFINED;
        }
        if (array_key_exists('consent_required', $input) && $input['consent_required'] == 0) {
            $input['consent_storage'] = null;
        }
        return parent::prepareInputForUpdate($input);
    }

    function post_updateItem($history = 1)
    {
        if ((isset($this->fields['storage_medium']) && $this->fields['storage_medium'] == self::STORAGE_MEDIUM_PAPER_ONLY)
            && (PluginDlteamsConfig::getConfig('system', 'remove_software_when_paper_only'))
        ) {
            $del = new PluginDlteamsRecord_Software();
            $del->deleteByCriteria(['plugin_dlteams_records_id' => $this->fields['id']]);
        }


        global $DB;
        $record_item_query = [
            "FROM" => PluginDlteamsRecord_Item::getTable(),
            "WHERE" => [
                "records_id" => $this->fields["id"]
            ]
        ];


        $iterator = $DB->request($record_item_query);

//       foreach related item update the name if the original name changed
        foreach ($iterator as $data) {
            if ($this->fields["name"] != $data["name"]) {
                $record_item = new PluginDlteamsRecord_Item();

                $DB->update($record_item->getTable(), [
                    "name" => addslashes($this->fields["name"]),
                ], ["id" => $data["id"]]);
            }
        }
    }

    public function post_purgeItem()
    {
        $rid = $this->fields["id"];
//        $exception_list = PluginDlteamsUtils::itemtypeExceptionList();
//        if (in_array($this->fields["itemtype"], $exception_list)) {
//            $relation_item_str = "Item_" . $this->fields["itemtype"];
//        } else
//            $relation_item_str = $this->fields["itemtype"] . "_Item";
//
////        purge relations
//        if (!class_exists($relation_item_str))
//            $relation_item_str = "PluginDlteams" . $relation_item_str;
//
//        if ($relation_item_str == Document_Item::class)
//            $relation_item_str = PluginDlteamsDocument_Item::class;
//
//
//        $relation_item = new $relation_item_str();
//
//        $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype"]))) . "s_id";
//        if ($this->fields["itemtype"] == PluginDlteamsThirdPartyCategory::class)
//            $relation_column_id = "thirdpartycategories_id";
//
//        $criteria = [
//            "itemtype" => 'PluginDlteamsRecord',
//            "items_id" => $rid,
////            $relation_column_id => $this->fields["items_id"],
////            "comment" => $this->fields["comment"]
//        ];
//        global $DB;
//        if ($DB->fieldExists($relation_item->getTable(), 'itemtype1') && $this->fields["itemtype1"]) {
//            $criteria["itemtype1"] = $this->fields["itemtype1"];
//            $criteria["items_id1"] = $this->fields["items_id1"];
//        }
//
//        if ($DB->fieldExists($relation_item->getTable(), 'itemtype1')) {
//            $criteria["comment"] = $this->fields["comment"];
//        }
//
//        $relation_item->deleteByCriteria($criteria);
//
//
//        //        purge relation 2
//        if ($this->fields["itemtype1"] && $this->fields["items_id1"]) {
//
//            $relation_item_str = $this->fields["itemtype1"] . "_Item";
//            if (!class_exists($relation_item_str))
//                $relation_item_str = "PluginDlteams" . $relation_item_str;
//            $relation_item = new $relation_item_str();
//
//            $relation_column_id = strtolower(str_replace("PluginDlteams", "", str_replace("_Item", "", $this->fields["itemtype1"]))) . "s_id";
//            if ($this->fields["itemtype1"] == PluginDlteamsRgpdAdequacy::class)
//                $relation_column_id = "rgpdadequacies_id";
//
//            $criteria = [
//                "itemtype" => "PluginDlteamsRecord",
//                "items_id" => $this->fields["records_id"],
//                $relation_column_id => $this->fields["items_id1"],
//                "itemtype1" => $this->fields["itemtype"],
//                "items_id1" => $this->fields["items_id"],
//                "comment" => $this->fields["comment"]
//            ];
//
//            if ($relation_item->deleteByCriteria($criteria))
//                Session::addMessageAfterRedirect("Relation " . $relation_item::getTypeName() . " supprimé avec succès");
//
//        }
        parent::post_purgeItem(); // TODO: Change the autogenerated stub
    }

    function rawSearchOptions()
    {
        $tab = [];
        $tab[] = [
            //'id' => 'common',
            'id' => '100',
            'table' => $this->getTable(),
            'field' => 'id',
            'name' => __("Id", 'dlteams'),
            'massiveaction' => false,
            'datatype' => 'number'
        ];

        $tab[] = [
            'id' => '1',
            'table' => $this->getTable(),
            'field' => 'completenumber',
            'name' => __("Number (order)", 'dlteams'),
//            'datatype' => 'decimal',
            'searchtype' => 'contains',
            'massiveaction' => false,
        ];
//        $tab[] = [
//            'id' => '13',
//            'table' => $this->getTable(),
//            'field' => 'number',
//            'name' => __("Num", 'dlteams'),
//            'massiveaction' => true,
//            'datatype' => 'decimal'
//        ];


        $tab[] = [
            'id' => '2',
            'table' => $this->getTable(),
            'field' => 'name',
            'name' => __("Name"),
            'datatype' => 'itemlink',
            'searchtype' => 'contains',
            'massiveaction' => true
        ];

        $tab[] = [
            'id' => '3',
            'table' => $this->getTable(),
            'field' => 'content',
            'name' => __("Purpose", 'dlteams'),
            'massiveaction' => true,
            'htmltext' => true
        ];

        $tab[] = [
            'id' => '12',
            'table' => $this->getTable(),
            'field' => 'additional_info',
            'name' => __("Additional information", 'dlteams'),
            'massiveaction' => true,
            'htmltext' => true
        ];

        $tab[] = [
            'id' => '13',
            'table' => $this->getTable(),
            'field' => 'completenumber',
            'name' => __("Number (order)", 'dlteams'),
            'massiveaction' => true,
            'datatype' => 'decimal',
//            'htmltext' => true
        ];

        $tab[] = [
            'id' => '4',
            'table' => Link::getTable(),
            'field' => 'name',
            'linkfield' => 'links_id',
            'name' => __("Publication folder", 'dlteams'),
            'massiveaction' => true,
            'datatype' => 'dropdown'
        ];

        $tab[] = [
            'id' => '5',
            'table' => $this->getTable(),
            'field' => 'states_id',
            'name' => __("Broadcast", 'dlteams'),
            'massiveaction' => true,
            'datatype' => 'specific',
        ];

        if ($this->isEntityAssign()) {
            $tab[] = [
                'id' => '6',
                'table' => 'glpi_entities',
                'field' => 'completename',
                'name' => __("Entity"),
                'massiveaction' => true,
                'datatype' => 'dropdown',
            ];
        }
        $tab[] = [
            'id' => '7',
            'table' => $this->getTable(),
            'field' => 'is_recursive',
            'name' => __("Child entities"),
            'massiveaction' => false,
            'datatype' => 'bool'
        ];

//        $tab[] = [
//            'id' => '8',
//            'table' => PluginDlteamsActivityCategory::getTable(),
//            'field' => 'name',
//            'name' => __("Activité", 'dlteams'),
//            'forcegroupby' => true,
//            'massiveaction' => true,
//            'datatype' => 'dropdown',
//            'searchtype' => ['equals', 'notequals'],
//        ];

        $tab[] = [
            'id' => '10',
            'table' => $this->getTable(),
            'field' => 'date_creation',
            'name' => __("Creation date"),
            'massiveaction' => false,
            'datatype' => 'text',
        ];

        $tab[] = [
            'id' => '11',
            'table' => $this->getTable(),
            'field' => 'date_mod',
            'name' => __("Last update"),
            'massiveaction' => false,
            'datatype' => 'text',
        ];

        $tab[] = [
            'id' => '101',
            'table' => 'glpi_users',
            'field' => 'name',
            'linkfield' => 'users_id_tech',
            'name' => __("Responsable du traitement"),
            'forcegroupby' => true,
            'massiveaction' => true,
            'toview' => true,
            'datatype' => 'dropdown',
            'searchtype' => ['equals', 'notequals'],
            'entity' => $this->getEntityID(),
            'right' => 'all',
        ];

        $tab[] = [
            'id' => '102',
            'table' => 'glpi_users',
            'field' => 'name',
            'linkfield' => 'users_id_auditor',
            'name' => __("Auditeur"),
            'forcegroupby' => true,
            'massiveaction' => true,
            'toview' => true,
            'datatype' => 'dropdown',
            'searchtype' => ['equals', 'notequals'],
            'entity' => $this->getEntityID(),
            'right' => 'all',
        ];


        $tab[] = [
            'id' => '103',
            'table' => 'glpi_users',
            'field' => 'name',
            'linkfield' => 'users_id_actor',
            'name' => __("Rédacteur de la fiche"),
            // 'forcegroupby' => true,
            // 'massiveaction' => true,
            'toview' => true,
            'datatype' => 'dropdown',
            'searchtype' => ['equals', 'notequals'],
            'entity' => $this->getEntityID(),
            'right' => 'all',
        ];

        $tab[] = [
            'id'                 => '104',
            'table'              => PluginDlteamsRecord_Item::getTable(),
            'field'              => 'items_id',
            'name'               => _x('quantity','Personnes'),
            'datatype'           => 'specific', //'itemlink',
            'comments'           => true,
            'nosort'             => false,
            'additionalfields'   => ['itemtype'],
            'joinparams'         => [
                'linkfield' => 'records_id',
                'jointype'           => 'child',
                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsConcernedPerson::class."'",
            ],
            'forcegroupby'       => true,
            'massiveaction'      => false,
            'htmltext'           => true,
            'showconcernedPerson' => true
        ];

//        $tab[] = [
//            'id' => '104',
//            'table' => 'glpi_plugin_dlteams_concernedpersons_items',
//            'field' => 'items_id',
//            'name' => _x('    ', 'Personnes'),
//            // 'forcegroupby' => true,
//            // 'usehaving' => true,
//            'datatype' => 'count',
//            // 'massiveaction' => false,
//            'joinparams' => [
//                'jointype' => 'itemtype_item'
//            ]
//        ];
		
       // alternative en liste plutot count
	   /*$tab[] = [
            'id'                 => '104',
            'table'              => PluginDlteamsRecord_Item::getTable(),
            'field'              => 'items_id',
            'name'               => _x('quantity','Personnes'),
            'datatype'           => 'spécific', // 'itemlink'
            'comments'           => true,
            // 'nosort'             => false,
            'additionalfields'   => ['itemtype'],
            'joinparams'         => [
            'linkfield' => 'records_id',
                'jointype'           => 'child',
                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsConcernedPerson::class."'",
            ],
            'forcegroupby'       => true,
            'massiveaction'      => false,			
			'htmltext'           => true,
            //'dlteams_activityname' => true,
        ];*/
//
//        $tab[] = [
//            'id' => '105',
//            'table' => 'glpi_plugin_dlteams_processeddatas_items',
//            'field' => 'id',
//            'name' => _x('quantity', 'Données'),
//            // 'forcegroupby' => true,
//            // 'usehaving' => true,
//            'datatype' => 'count',
//            'massiveaction' => false,
//            'joinparams' => [
//                'jointype' => 'itemtype_item'
//            ]

//        ];

        $tab[] = [
            'id'                 => '105',
            'table'              => PluginDlteamsRecord_Item::getTable(),
            'field'              => 'items_id1',
            'name'               => _x('quantity','Données'),
            'datatype'           => 'specific', //'itemlink',
            'comments'           => true,
            'nosort'             => false,
            'additionalfields'   => ['itemtype1'],
            'joinparams'         => [
                'linkfield' => 'records_id',
                'jointype'           => 'child',
                'condition' => "AND NEWTABLE.`itemtype1` = '".PluginDlteamsProcessedData::class."'",
            ],
            'forcegroupby'       => true,
            'massiveaction'      => false,
            'htmltext'           => true,
            'showprocessedData' => true
            //'dlteams_activityname' => true,
        ];

//        $tab[] = [
//            'id'                 => '105',
//            'table'              => PluginDlteamsRecord_Item::getTable(),
//            'field'              => 'items_id',
//            'name'               => _x('quantity','Données'),
//            'datatype'           => 'specific', //'itemlink',
//            'comments'           => true,
//            'nosort'             => false,
//            'additionalfields'   => ['itemtype'],
//            'joinparams'         => [
//                'linkfield' => 'records_id',
//                'jointype'           => 'child',
//                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsProcessedData::class."'",
//            ],
//            'forcegroupby'       => true,
//            'massiveaction'      => false,
//            'htmltext'           => true,
//            'showprocessedData' => true
//        ];

        $tab[] = [
            'id'                 => '106',
            'table'              => PluginDlteamsRecord_Item::getTable(),
            'field'              => 'items_id',
            'name'               => _x('quantity','Licéité'),
            'datatype'           => 'specific', //'itemlink',
            'comments'           => true,
            'nosort'             => false,
            'additionalfields'   => ['itemtype'],
            'joinparams'         => [
                'linkfield' => 'records_id',
                'jointype'           => 'child',
                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsLegalbasi::class."'",
            ],
            'forcegroupby'       => true,
            'massiveaction'      => false,
            'htmltext'           => true,
            'showLegaBasi' => true
        ];

//        $tab[] = [
//            'id' => '106',
//            'table' => 'glpi_plugin_dlteams_legalbasis_items',
//            'field' => 'id',
//            'name' => _x('quantity', 'Licéité'),
//            // 'forcegroupby' => true,
//            // 'usehaving' => true,
//            'datatype' => 'count',
//            'massiveaction' => false,
//            'joinparams' => [
//                'jointype' => 'itemtype_item'
//            ]
//        ];

        $tab[] = [
            'id'                 => '107',
            'table'              => PluginDlteamsRecord_Item::getTable(),
            'field'              => 'items_id',
            'name'               => _x('quantity','Rétention'),
            'datatype'           => 'specific', //'itemlink',
            'comments'           => true,
            'nosort'             => false,
            'additionalfields'   => ['itemtype'],
            'joinparams'         => [
                'linkfield' => 'records_id',
                'jointype'           => 'child',
                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsStoragePeriod::class."'",
            ],
            'forcegroupby'       => true,
            'massiveaction'      => false,
            'htmltext'           => true,
            'showstoragePeriod' => true
            //'dlteams_activityname' => true,
        ];

//        $tab[] = [
//            'id' => '107',
//            'table' => 'glpi_plugin_dlteams_storageperiods_items',
//            'field' => 'id',
//            'name' => _x('quantity', 'Rétention'),
//            // 'forcegroupby' => true,
//            // 'usehaving' => true,
//            'datatype' => 'count',
//            'massiveaction' => false,
//            'joinparams' => [
//                'jointype' => 'itemtype_item'
//            ]
//        ];



//        $tab[] = [
//            'id' => '110',
//            'table' => 'glpi_plugin_dlteams_policieforms_items',
//            'field' => 'id',
//            'name' => _x('quantity', 'Jeux données'),
//            // 'forcegroupby' => true,
//            // 'usehaving' => true,
//            'datatype' => 'count',
//            'massiveaction' => false,
//            'joinparams' => [
//                'jointype' => 'itemtype_item'
//            ]
//        ];

        $tab[] = [
            'id'                 => '110',
            'table'              => PluginDlteamsRecord_Item::getTable(),
            'field'              => 'items_id',
            'name'               => _x('quantity','Jeux données'),
            'datatype'           => 'specific', //'itemlink',
            'comments'           => true,
            'nosort'             => false,
            'additionalfields'   => ['itemtype'],
            'joinparams'         => [
                'linkfield' => 'records_id',
                'jointype'           => 'child',
                'condition' => "AND NEWTABLE.`itemtype` = '".PluginDlteamsPolicieForm::class."'",
            ],
            'forcegroupby'       => true,
            'massiveaction'      => false,
            'htmltext'           => true,
            'showpolicies' => true
            //'dlteams_activityname' => true,
        ];

        return $tab;
    }

    public function deleteObsoleteItems(CommonDBTM $container, array $exclude)
    {
    }
}
