<?php
/**
-------------------------------------------------------------------------
LICENSE

This file is part of Reports plugin for GLPI.

Reports is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Reports is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with Reports. If not, see <http://www.gnu.org/licenses/>.

@package   reports
@authors    Nelly Mahu-Lasson, Remi Collet
@copyright Copyright (c) 2009-2022 Reports plugin team
@license   AGPL License 3.0 or (at your option) any later version
http://www.gnu.org/licenses/agpl-3.0-standalone.html
@link      https://forge.glpi-project.org/projects/reports
@link      http://www.glpi-project.org/
@since     2009
--------------------------------------------------------------------------
 */

$USEDBREPLICATE        = 1;
$DBCONNECTION_REQUIRED = 0; // not really a big SQL request

include ("../../../../inc/includes.php");

$dbu = new DbUtils();

//if(isset($_POST["publish_dlteams"])){
//
//}
/*highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//die();
//TRANS: The name of the report = Location tree
$report = new PluginReportsAutoReport(__('Rapport des traitements et leurs finalités', 'dlteams'));

$tab = [
    0 => __('Yes'),
    1 => __('No'),
];
$tab2 = [
    0 => __('Yes'),
    1 => __('No'),
];

$filter = new PluginReportsArrayCriteria($report, 'records', __('Avec finalités', 'dlteams'), $tab);
$filter2 = new PluginReportsArrayCriteria($report, 'records', __('Traitement comportant des données sensibles', 'dlteams'), $tab2);

//Display criterias form is needed
$report->displayCriteriasForm();



$cols = [
    new PluginReportsColumn('completenumber', __('Num'), ['sorton' => 'completenumber']),
    new PluginReportsColumn('name', __('Name'), ['sorton' => 'name']),
];

if (!$filter->getParameterValue()) {
    $cols[] = new PluginReportsColumn('content', __('Finalité(s)'), ['sorton' => 'content']);
}
$cols[] = new PluginReportsColumnMap('sensitive', __('Sensible'), ['0' => 'Non', '1' => 'Oui', '' => 'Non précisé'], ['sorton' => 'glpi_plugin_dlteams_records.sensitive']);
$report->setColumns($cols);

// SQL statement
$query = "SELECT `glpi_plugin_dlteams_records`.`name` AS name,
                 `glpi_plugin_dlteams_records`.`content` AS content,
                 `glpi_plugin_dlteams_records`.`sensitive`,
                 `glpi_plugin_dlteams_records`.`completenumber` AS completenumber
          FROM `glpi_plugin_dlteams_records`
          LEFT JOIN `glpi_entities` ON (`glpi_plugin_dlteams_records`.`entities_id` = `glpi_entities`.`id`)" .
    $dbu->getEntitiesRestrictRequest(" WHERE ", "glpi_plugin_dlteams_records") .
    " AND `glpi_plugin_dlteams_records`.`is_deleted` = 0 ".
    $report->getOrderBy('completenumber');

$report->setGroupBy('completenumber');
$report->setSqlRequest($query);
$report->execute();