<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */


define('plugin_dlteams_version', '25.08.27');
define('plugin_dlteams_root', __DIR__);

function plugin_init_dlteams()
{
    global $PLUGIN_HOOKS;
    global $CFG_GLPI;
    $GLOBALS["DLTEAMS_FILES_TO_RENAME"] = [
        "/src/CommonDBTM.php",
        "/src/Plugin.php",
        "/front/commonitiltask.form.php",
        "/src/Search.php",
    ];

    PluginDlteamsItemType::init();


    Plugin::registerClass('ManualLink', ['addtabon' => 'KnowbaseItem']);
    Plugin::registerClass(Document_Item::class, ['addtabon' => DocumentCategory::class]);

    $PLUGIN_HOOKS['assign_to_ticket']['dlteams'] = true;
    $PLUGIN_HOOKS["pre_item_form"]["dlteams"] = "plugin_dlteams_pre_item_form";

    Plugin::registerClass(PluginDlteamsLocation_Item::class, ['addtabon' => [Location::class, 'KnowbaseItem']]);

    Plugin::registerClass(PluginDlteamsActivitycategory_Item::class, ['addtabon' => [KnowbaseItem::class]]);
    Plugin::registerClass(PluginDlteamsPolicieForm_Item::class, ['addtabon' => [Document::class]]);
    Plugin::registerClass(PluginDlteamsProjectTask_Item::class, ['addtabon' => [Problem::class]]);
    Plugin::registerClass(PluginDlteamsCentral::class, ['addtabon' => Central::class]);
    Plugin::registerClass(PluginDlteamsLocation_Item::class, ['addtabon' => Entity::class]);

    Plugin::registerClass(PluginDlteamsDataCatalog::class,
        [
            'linkgroup_types' => true,
            'document_types' => true,
            'ticket_types' => true,
            'helpdesk_visible_types' => true,
            'notificationtemplates_types' => true,
        ]
    );

    Plugin::registerClass(PluginDlteamsRecord::class,
        ['linkgroup_types' => true,
            'linkuser_types' => true,
            'linkgroup_tech_types' => true,
            'linkuser_tech_types' => true,
            'document_types' => true,
            'ticket_types' => true,
            'helpdesk_visible_types' => true,
            'notificationtemplates_types' => true,
        ]
    );

    Plugin::registerClass(PluginDlteamsAccountKey_Item::class,
        [
            'linkgroup_types' => true,
            'linkuser_types' => true,
            'linkgroup_tech_types' => true,
            'linkuser_tech_types' => true,
            'document_types' => true,
            'ticket_types' => true,
            'helpdesk_visible_types' => true,
            'notificationtemplates_types' => true,
        ]
    );

    Plugin::registerClass(PluginDlteamsRecord_Item::class,
        [
            'linkgroup_types' => true,
            'linkuser_types' => true,
            'linkgroup_tech_types' => true,
            'linkuser_tech_types' => true,
            'document_types' => true,
            'ticket_types' => true,
            'helpdesk_visible_types' => true,
            'notificationtemplates_types' => true,
        ]
    );

    Html::requireJs('tinymce');
    $PLUGIN_HOOKS['csrf_compliant']['dlteams'] = true;
    $PLUGIN_HOOKS['use_massive_action']['dlteams'] = 1;


    if (Session::getLoginUserID()) {

        $CFG_GLPI['impact_asset_types']['PluginDlteamsLegalBasi'] = "marketplace/dlteams/legalbasi.png";
//        $CFG_GLPI['location_types'][] = Entity::class;
        $PLUGIN_HOOKS['change_profile']['dlteams'] = ['PluginDlteamsProfile', 'initProfile'];

        if (Session::haveRight('plugin_dlteams_record', UPDATE)
            || Session::haveRight('config', UPDATE)) {
            $PLUGIN_HOOKS['config_page']['dlteams'] = 'front/config.form.php';
        }

        $PLUGIN_HOOKS['post_init']['dlteams'] = 'plugin_post_init_dlteams';
//        $PLUGIN_HOOKS['add_css']['dlteams'][] = 'plugin.css';
//
//        $PLUGIN_HOOKS[\Glpi\Plugin\Hooks::ADD_CSS]['dlteams'][] = 'css/styles.css';

        if (Session::haveRight("plugin_dlteams_controllerinfo", READ)) {
            $PLUGIN_HOOKS['helpdesk_menu_entry']['physicalstorages'] = plugin_dlteams_root . '/front/physicalstorage.form.php';
            $PLUGIN_HOOKS['helpdesk_menu_entry_icon']['physicalstorages'] = PluginDlteamsPhysicalStorage::getIcon();
        }
        if (Session::haveRight("plugin_dlteams_controllerinfo", READ)) {
            $PLUGIN_HOOKS['helpdesk_menu_entry']['vehicles'] = plugin_dlteams_root . '/front/vehicle.form.php';
            $PLUGIN_HOOKS['helpdesk_menu_entry_icon']['vehicles'] = PluginDlteamsVehicle::getIcon();
        }
    }

    $PLUGIN_HOOKS['process_massive_actions_plan']['dlteams'] = ['PluginDlteamsDatabase_Item' => 'processMassiveActionsForOneItemtypetest'];
    $PLUGIN_HOOKS['display_login']['dlteams'] = 'dlteams_display_login';
    $PLUGIN_HOOKS['post_plugin_disable']['dlteams'] = 'dlteams_post_plugin_disable';

    $PLUGIN_HOOKS['item_add']['dlteams'] = ['Supplier' => 'dlteams_additem_called'];


    $PLUGIN_HOOKS['add_javascript']['dlteams'][] = 'js/libraries/jquery-ui.js';
    $PLUGIN_HOOKS['redefine_menus']['dlteams'] = 'plugin_dlteams_redefine_menus';

    $PLUGIN_HOOKS['pre_item_action_massive']['dlteams'] = 'dlteams_pre_item_action_massive';
    $PLUGIN_HOOKS['item_purge']['dlteams'] = [
        'Link' => 'dlteams_purge_called',
    ];

    if (Session::haveRight(PluginDlteamsNetworkPort::$rightname, READ))
        $PLUGIN_HOOKS['menu_toadd']['dlteams']['assets'][] = PluginDlteamsNetworkPort::class;


//    $PLUGIN_HOOKS['menu_toadd']['dlteams']['helpdesk'][] = PluginDlteamsTicketTask::class;
//    $PLUGIN_HOOKS['menu_toadd']['dlteams']['helpdesk'][] = Notepad::class;
    $PLUGIN_HOOKS['menu_toadd']['dlteams']['helpdesk'][] = PluginDlteamsProjectTask::class;
    $PLUGIN_HOOKS['menu_toadd']['dlteams']['helpdesk'][] = PluginDlteamsMessage::class;

//    $PLUGIN_HOOKS['menu_toadd']['dlteams']['management']  = [PluginDlteamsDeliverable::class];
    $mailable = new PluginDlteamsDeliverableNotification();
    $PLUGIN_HOOKS['timeline_answer_actions']['dlteams'][] = [
        'type' => PluginDlteamsMailable::class,
        'class' => 'PluginDlteamsMailable',
        'icon' => PluginDlteamsMailable::getIcon(),
        'label' => _x('button', 'Envoyer un mail'),
        'short_label' => _x('button', 'Envoyer un mail'),
        'template' => '@dlteams/components/itilobject/timeline/mailable.html.twig',
        'item' => $mailable,
        'hide_in_menu' => false
    ];


    $PLUGIN_HOOKS['reports']['dlteams'] = [
        ...PluginDlteamsRecord::reports,
        ...PluginDlteamsDataCatalog::reports,


        'report/asset/assetlocation.php' => __('Liste des matériels par lieu', 'dlteams'),
    ];


    global $CFG_GLPI;
    $CFG_GLPI['appliance_types'][] = 'PluginDlteamsDataCatalog';

    $CFG_GLPI['devices_in_menu'][] = PluginDlteamsPolicieForm::class;

    $CFG_GLPI['appliance_types'][] = Supplier::class;
    $CFG_GLPI["ticket_types"] = array_merge($CFG_GLPI["ticket_types"], PluginDlteamsItemType::getTypes(true));

    $CFG_GLPI['list_limit_max'] = 250;
    $extra_searchelements = [
        Reminder::class,
        KnowbaseItem::class,
        KnowbaseItem_Comment::class,
        KnowbaseItem_KnowbaseItemCategory::class,
        PluginDlteamsMessage::class,
    ];


    $search_elements = array_merge(PluginDlteamsItemType::getTypes(true), $extra_searchelements, $CFG_GLPI["globalsearch_types"]);

    $valuesToRemove = ["PluginDlteamsKnowBaseItem", "ITILFollowup"];

    foreach ($valuesToRemove as $value) {
        $key = array_search($value, $search_elements);
        if ($key !== false) {
            unset($search_elements[$key]);
        }
    }


    $search_elements = array_unique($search_elements);


    $search_elements = array_values($search_elements);

    /*    highlight_string("<?php\n\$data =\n" . var_export($search_elements, true) . ";\n?>");*/


    $CFG_GLPI["globalsearch_types"] = $search_elements;
    $CFG_GLPI['impact_asset_types'][Document::class] = 'marketplace/dlteams/pics/impact/document.png';
    $CFG_GLPI['impact_asset_types'][Entity::class] = 'marketplace/dlteams/pics/impact/document.png';
    $CFG_GLPI['impact_asset_types'][PluginDlteamsDataCatalog::class] = 'marketplace/dlteams/pics/impact/datacatalog.png';
    $CFG_GLPI['impact_asset_types'][PluginDlteamsPolicieForm::class] = 'marketplace/dlteams/pics/impact/policieform.png';
    /*    highlight_string("<?php\n\$data =\n" . var_export($CFG_GLPI["impact_asset_types"], true) . ";\n?>");*/


}


function plugin_dlteams_AssignToTicket($types)
{
    $types[PluginDlteamsAudit::class] = PluginDlteamsAudit::getTypeName(2);
    $types[PluginDlteamsAccountKey::class] = PluginDlteamsAccountKey::getTypeName(2);
    $types[PluginDlteamsConcernedPerson::class] = PluginDlteamsConcernedPerson::getTypeName(2);
    $types[PluginDlteamsDataCatalog::class] = PluginDlteamsDataCatalog::getTypeName(2);
    $types[PluginDlteamsDeliverable::class] = PluginDlteamsDeliverable::getTypeName(2);
    $types[PluginDlteamsLegaBasi::class] = PluginDlteamsLegalBasi::getTypeName(2);
    $types[PluginDlteamsPolicieForm::class] = PluginDlteamsPolicieForm::getTypeName(2);
    $types[PluginDlteamsProcedure::class] = PluginDlteamsProcedure::getTypeName(2);
    $types[PluginDlteamsProtectiveMeasure::class] = PluginDlteamsProtectiveMeasure::getTypeName(2);
    $types[PluginDlteamsRecord::class] = PluginDlteamsRecord::getTypeName(2);
    $types[PluginDlteamsRiskAssessment::class] = PluginDlteamsRiskAssessment::getTypeName(2);
    $types[PluginDlteamsRightMeasure::class] = PluginDlteamsRightMeasure::getTypeName(2);
    $types[PluginDlteamsStoragePeriod::class] = PluginDlteamsStoragePeriod::getTypeName(2);
    $types[PluginDlteamsThirdpartyCategory::class] = PluginDlteamsThirdpartyCategory::getTypeName(2);
    $types[PluginDlteamsTrainingSession::class] = PluginDlteamsTrainingSession::getTypeName(2);
    return $types;
}


function plugin_post_init_dlteams()
{

    Plugin::registerClass(Impact::class, ['addtabon' => [Entity::class]]);
    Plugin::registerClass(PluginDlteamsAppliance_Actor::class, ['addtabon' => [Appliance::class]]);
    Plugin::registerClass(PluginDlteamsLinkfile::class, ['addtabon' => [Link::class]]);
    Plugin::registerClass(Location::class, ['addtabon' => [PluginDlteamsPhysicalStorage::class]]);
    Plugin::registerClass(Notepad::class, ['addtabon' => [User::class]]);
    Plugin::registerClass(PluginDlteamsMessage::class, ['addtabon' => [User::class]]);
    Plugin::registerClass(ManualLink::class, ['addtabon' => ['KnowbaseItem']]);

    Plugin::registerClass('KnowbaseItem_Comment', ['addtabon' => ['Ticket']]);
    Plugin::registerClass(Notepad::class, ['addtabon' => ['Ticket']]);


    Plugin::registerClass(PluginDlteamsAccountKey_Item::class, ['addtabon' => ['User', 'Group', 'Contact', 'Supplier']]);
    Plugin::registerClass(PluginDlteamsAcces_Catalog::class, ['addtabon' => ['Contact', 'Supplier']]);
    Plugin::registerClass('PluginDlteamsControllerInfo', ['addtabon' => ['Entity']]);
    Plugin::registerClass('PluginDlteamsNotification', ['notificationtemplates_types' => true]);
    Plugin::registerClass('PluginDlteamsProfile', ['addtabon' => ['Profile']]);

    Plugin::registerClass(PluginDlteamsObjectRGPD::class, ['addtabon' => ['User']]);
    Plugin::registerClass(PluginDlteamsUserCreatePDF::class, ['addtabon' => ['User']]);
    Plugin::registerClass(PluginDlteamsConfig::class, ['addtabon' => [PluginDlteamsConfig::class]]);
//    Plugin::registerClass(PluginDlteamsDataCatalog_Item::class, ['addtabon' => [Appliance::class]]);

    Plugin::registerClass(PluginDlteamsMessage::class, ['addtabon' => [Problem::class]]);
    Plugin::registerClass(PluginDlteamsMessage::class, ['addtabon' => [Change::class]]);
    if (Config::getConfigurationValue("dlteams", "document_manage_folders"))
        Plugin::registerClass(PluginDlteamsObject1n_document::class, ['addtabon' => [DocumentCategory::class]]);


    Plugin::registerClass(PluginDlteamsMessage::class, ['addtabon' => [Supplier::class]]);


    $_SESSION["glpiactiveprofile"]['plugin_reports_dlteams_asset'] = 1;


    Plugin::registerClass(
        'PluginDlteamsRecord_Item', [
        'addtabon' => ['Supplier',
            'Document',
            'Ticket',
        ]]);
    Plugin::registerClass(
        'PluginDlteamsProtectiveMeasure_Item', [
        'addtabon' => [
            'Computer',
            'Datacenter',
            'NetworkEquipment',
            'Peripheral',
            'Printer',
            'Phone',
            //'PluginAccountsAccount',
            'PluginDlteamstAccount'
        ]]);

    Plugin::registerClass(
        'PluginDlteamsDataCatalog_Item', [
        'addtabon' => [


            'Computer',
            'Datacenter',
            'NetworkEquipment',
            'Peripheral',
            'Printer',
            'PluginDlteamsPhysicalStorage',
            'Phone',
        ]]);


}


function FolderExport()
{
    $glpiRoot = str_replace('\\', '/', GLPI_ROOT);
    if (!file_exists($glpiRoot . "/files/_plugins/" . "dlteams" . "/")) {
        mkdir($glpiRoot . "/files/_plugins/" . "dlteams" . "/");
        chmod($glpiRoot . "/files/_plugins/" . "dlteams" . "/", 0777);
    }
}

function plugin_version_dlteams()
{
    return [
        'name' => "DLTeams",
        'version' => plugin_dlteams_version,
        'author' => "DLPlace developers",
        'license' => "GPLv3+",
        'homepage' => "https://dlplace.fr",
        'minGlpiVersion' => '9.4',
        'requirements' => [
            'glpi' => [
                'min' => '9.4',
                'dev' => false
            ]
        ],
    ];
}

function plugin_dlteams_check_prerequisites()
{

    global $DB;
    if (version_compare(GLPI_VERSION, '10.0', 'lt')
        || version_compare(GLPI_VERSION, '10.1', 'ge') 
		|| version_compare(GLPI_VERSION, '11.0', 'ge')) {
        if (method_exists('Plugin', 'messageIncompatible')) {
            echo Plugin::messageIncompatible('core', '10.0');
        }
        return false;
    } else {
//        $query = "select * from glpi_plugins where directory = 'formcreator' and state = 1";
//        $result_query = $DB->query($query);
//        if ($DB->numRows($result_query) == 1) {
//            return true;
//        } else {
//            echo "the plugin 'FormCreator' must be installed before using 'DLTeams'";
//            return false;
//        }

        return true;
    }
}

function plugin_dlteams_check_config($verbose = false)
{
    if (true) {
        return true;
    }
    if ($verbose) {
        echo __("Installed / not configured");
    }
    return false;
}


function plugin_dlteams_getUuid()
{
    //encode uname -a, ex Linux localhost 2.4.21-0.13mdk #1 Fri Mar 14 15:08:06 EST 2003 i686
    $serverSubSha1 = substr(sha1(php_uname('a')), 0, 8);

    $dirSubSha1 = substr(sha1(__FILE__), 0, 8);
    return uniqid("$serverSubSha1-$dirSubSha1-", true);
}
