<?php

/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include_once('../../../inc/includes.php');

// Vérifier que l'utilisateur est connecté
Session::checkLoginUser();

$id = $_POST["id"];
$message = new PluginDlteamsMessage();
$message->getFromDB($id);

    echo "<form name='form' method='POST' action=\"" . Toolbox::getItemTypeFormURL(PluginDlteamsMessage::class) . "\">";

    echo "<input type='hidden' name='message_id' value='$id'>";
    if($message->fields["parent_comment_id"] || $message->getFromDBByCrit(["parent_comment_id" => $_POST["id"]])) {
        echo '<div class="alert alert-danger" role="alert">
                  Toute la conversation va être déplacée
               </div>';

    }
    echo "<div style='display: flex; flex-direction: row; gap: 0.5rem; align-items: center'>";
    echo "<label>Vers quel élément?</label>";

    if($_POST["itemtype"] != Ticket::class){
        $types = [...PluginDlteamsItemType::getTypes(), PluginDlteamsTicketTask::class];
    }
    else
        $types = [
            Problem::class,
            PluginDlteamsTicketTask::class,
            Document::class,
            Change::class,
            Ticket::class
        ];
            Dropdown::showSelectItemFromItemtypes([
                'itemtypes' => $types,
                'entity_restrict' =>  $message->fields['entities_id'],
                'checkright' => true,
//                'used' => [],
//                'ajax_page' => "/marketplace/dlteams/ajax/dlteamsDropdownAllItem.php"
            ]);

            echo "<button class='btn btn-primary' type='submit' name='move_message'>Déplacer</button>";
    echo "</div>";

    Html::closeForm(true);
