<?php

include_once('../../../inc/includes.php');

$rand = mt_rand();
$actortype = 'requester';
$required = true;
global $DB;

$record = new PluginDlteamsRecord();
if ($record->getFromDB($_POST["records_id"])) {

    $searchText = isset($_POST['searchText']) ? strtolower(trim($_POST['searchText'])) : null;
//    $actors_iterator = $DB->request(PluginDlteamsActeur_Item::getRequest($record));

    if($_POST["action"] == "getResponsible")
        $actors_types = $_POST["returned_itemtypes"];
    else
        $actors_types = [User::class, Group::class, Supplier::class, PluginDlteamsThirdPartyCategory::class];

    foreach ($actors_types as $type){
        foreach ($DB->request(["FROM" => $type::getTable(), "WHERE" => ["entities_id" => Session::getActiveEntity()]]) as $val){
            $actors_iterator[] = [
                "itemtype" => $type,
                "items_id" => $val["id"]
            ];
        }
    }
    $results = [];

    foreach ($actors_iterator as $actor) {
        $item_str = $actor['itemtype'];
        $item = new $item_str();
        $item->getFromDB($actor['items_id']);

        $formatted = [
            'itemtype'          => $actor['itemtype'],
            'items_id'          => $actor['items_id'],
            'default_email'     => $actor['default_email'] ?? '',
            'alternative_email' => $actor['alternative_email'] ?? '',
            'id'                => $actor['itemtype'] . '_' . $actor['items_id'],
        ];

        // Traitement selon le type
        if (in_array($actor['itemtype'], [Group::class, Supplier::class, PluginDlteamsThirdPartyCategory::class])) {
            $name = $item->fields['name'] ?? '';
            $formatted['title'] = $formatted['text'] = $name;
        }

        if ($actor['itemtype'] == User::class) {
            $firstname = $item->fields['firstname'] ?? '';
            $realname = $item->fields['realname'] ?? '';
            $email = $item->fields['email'] ?? '';
            $formatted['text'] = trim("$firstname $realname");
            $formatted['title'] = trim("$firstname $realname - $email");
        }

        // Si searchText est fourni, on filtre ici
        if ($searchText) {
            $search_in = strtolower($formatted['text'] . ' ' . $formatted['title']);
            if (strpos($search_in, $searchText) === false) {
                continue; // Ne correspond pas, on saute
            }
        }

        $results[] = $formatted;
    }

    // Construction de la réponse
    $response = [
        'results' => $results,
        'count'   => count($results),
    ];

    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
