<?php

include_once('../../../inc/includes.php');
header("Content-Type: text/html; charset=UTF-8");
Html::header_nocache();

Session::checkLoginUser();

global $CFG_GLPI;

// Ouverture du formulaire
//echo "<form name='form' method='POST' action=\"" . Toolbox::getItemTypeFormURL("PluginDlteamsDeliverable") . "\">";

// Début de la carte
echo "<div class='card'>";

// Titre de la carte
echo "<div class='card-header'><h3>Demande de contrôle</h3></div>";

// Contenu de la carte
echo "<div class='card-body'>";

echo "<table class='tab_cadre_fixe'>";

$rand = mt_rand();

// Champ dropdown pour sélectionner le type de validateur (Utilisateur ou Groupe)
echo "<tr>";
echo "<td class='form-table-text'>" . __("Approver") . "</td>";
echo "<td>";

$optionsArray = [
    'User'  => User::getTypeName(1),
    'Group' => Group::getTypeName(1),
];

Dropdown::showFromArray('validatortype', $optionsArray, [
    'display_emptychoice' => true,
    'rand'                => $rand,
    'field_class'         => 'col-12',
    'label_class'         => 'col-xxl-4',
    'input_class'         => 'col-xxl-8 flex-wrap',
    'add_field_html'      => "<span id='show_validator_field{$rand}' class='flex-grow-1'>&nbsp;</span>",
]);

echo "</td>";
echo "</tr>";

// Détermination du droit en fonction du type d'élément
$right = 'validate';

// Mise à jour AJAX lors du changement de sélection
Ajax::updateItemOnSelectEvent(
    "dropdown_validatortype{$rand}",
    "show_validator_field{$rand}",
    "{$CFG_GLPI['root_doc']}/ajax/dropdownValidator.php",
    [
        'id'            => 0,
        'entity'        => Session::getActiveEntity(),
        'right'         => $right,
        'validatortype' => '__VALUE__',
        'groups_id'     => 0,
    ]
);

// Champ dropdown pour sélectionner un ticket
echo "<tr>";
echo "<td class='form-table-text'>" . __("Ticket") . "</td>";
echo "<td>";

$ticket_id = $_POST['tickets_id'] ?? 0;

Ticket::dropdown([
    'name'                => 'tickets_id',
    'value'               => $ticket_id,
    'display_emptychoice' => true,
    'rand'                => $rand,
    'width'               => '300px',
]);

echo "<span id='show_ticket_field{$rand}' class='flex-grow-1'>&nbsp;</span>";

echo "</td>";
echo "</tr>";


echo "<tr>";
echo "<td class='form-table-text'>" . __("Commentaires") . "</td>";
echo "<td>";

Html::textarea(['name' => 'content[]',
    'enable_fileupload' => false,
    'enable_richtext' => true,
    'cols' => 100,
    'rows' => 100
]);

echo "<span id='show_ticket_field{$rand}' class='flex-grow-1'>&nbsp;</span>";

echo "</td>";
echo "</tr>";


echo "</table>";

// Fin du contenu de la carte
echo "</div>";

// Bouton de soumission centré en bas
echo "<div class='card-footer text-center'>";
echo "<button type='submit' class='btn btn-primary'>" . __("Soumettre") . "</button>";
echo "</div>";

// Fin de la carte
echo "</div>";

// Fermeture du formulaire
Html::closeForm();

echo "<style>";
echo "
            .form-table-text {
                text-align: right;
                width: 40%;
            }
            @media (max-width: 800px) {
                .form-table-text {
                    text-align: left;
                    width: 100%;
                }
            }
        ";

echo "</style>";
?>
