<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include("../../../inc/includes.php");
/*highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//die();
global $DLTEAMS_FILES_TO_RENAME;

$glpi_versions = [PluginDlteamsConfig::$glpi_current_version];

$message = "Remplacement des fichiers fork et white label GLPI<->DLTEAMS". nl2br("\n");
//$fork_directory_versions = [PluginDlteamsConfig::$glpi_current_version];
if (isset($_POST["fork_on"])) {
    PluginDlteamsConfig::activateFork();
    $message = "Fork activé avec succès.";
}

if (isset($_POST["fork_off"])) {
    PluginDlteamsConfig::deactivateFork();
    $message = "Fork désactivé avec succès.";
}

if (isset($_POST["whitelabel_on"])) {
    PluginDlteamsConfig::activateWhitelabel();
    $message = "Whitelabel activé avec succès.";
}

if (isset($_POST["whitelabel_off"])) {
    PluginDlteamsConfig::deactivateWhitelabel();
    $message = "Whitelabel désactivé avec succès.";
}

if(isset($_POST["migrate_profiles"])){

    if(Session::getActiveEntity() == 0 || $_SESSION['glpiactiveprofile']["id"] == 0){
        Session::addMessageAfterRedirect("Vous ne ppouvez pas éffectuer cette action sur l'entité root ou en structure complète", 0, WARNING);
        Html::back();
    }

    $root_profiles_query = [
        "FROM" => Profile::getTable(),
        "WHERE" => [
            "entities_id" => 0,
        ]
    ];
    global $DB;
    $iterator = $DB->request($root_profiles_query);

    foreach ($iterator as $root_profile){
        unset($root_profile["id"]);
        unset($root_profile["date_creation"]);
        unset($root_profile["date_mod"]);
        $profilename = $root_profile["name"];

        $current_profil_query = [
            "FROM" => Profile::getTable(),
            "WHERE" => [
                "entities_id" => Session::getActiveEntity(),
                "name" => $profilename
            ]
        ];

        $iterator_currentprofile = $DB->request($current_profil_query);
        if(count($iterator_currentprofile) == 0){
            $profile = new Profile();
            $DB->insert($profile->getTable(), [
                ...$root_profile,
                "entities_id" => Session::getActiveEntity()
            ]);

        }

    }
    Session::addMessageAfterRedirect("Opération éffectuée avec succès");
    Html::back();
}
//die();
$config = new Config();
$config->checkGlobal(UPDATE);
$cache_manager = new \Glpi\Cache\CacheManager();
if ($cache_manager->getTranslationsCacheInstance()->clear()) {
    Session::addMessageAfterRedirect(__('Translation cache reset successful'));
}
Session::addMessageAfterRedirect($message);
Html::back();