<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file fait partie de DLTeams Plugin.
 --------------------------------------------------------------------------
*/
include("../../../inc/includes.php");

$itemtype_str = $_POST['itemtype'] ?? '';
if (!class_exists($itemtype_str)) {
    echo "<div class='error'>Type d’objet invalide.</div>";
    exit;
}

global $DB;

// Vérifier les droits sur l’objet cible
$itemtype = new $itemtype_str();
$concerned_itemtype_str = null;
if (isset($itemtype::$rightname)) {
    Session::checkRight($itemtype::$rightname, UPDATE);
}
// Par défaut, on insère dans la table de l’objet principal
$table = $itemtype::getTable();

// Déterminer si l’import concerne “personnes données” de PolicieForm
$items_import = false;
if ($itemtype_str === PluginDlteamsPolicieForm::class
    && ($_POST['action'] ?? '') === 'import_personnesdonnees'
) {
    $table = PluginDlteamsPolicieForm_Item::getTable();
    $items_import = true;
}
if ($itemtype_str === PluginDlteamsPolicieForm::class
    && ($_POST['action'] ?? '') === 'import_legalbasis'
) {
    $table = PluginDlteamsLegalBasi_Item::getTable();
    $concerned_itemtype_str = $itemtype_str;
    $itemtype_str = PluginDlteamsLegalbasi::class;
    $items_import = true;
}
if ($itemtype_str === PluginDlteamsPolicieForm::class
    && ($_POST['action'] ?? '') === 'import_storageperiod'
) {
    $table = PluginDlteamsStoragePeriod_Item::getTable();
    $concerned_itemtype_str = $itemtype_str;
    $itemtype_str = PluginDlteamsStoragePeriod::class;
    $items_import = true;
}

// Vérification de l’upload
if (!isset($_FILES['datfile']) || !is_uploaded_file($_FILES['datfile']['tmp_name'])) {
    echo "<div class='error'>Aucun fichier .dat valide reçu.</div>";
    exit;
}

$currentDate = date("Y-m-d H:i:s");
$fp = fopen($_FILES['datfile']['tmp_name'], 'r');
if (!$fp) {
    echo "<div class='error'>Impossible de lire le fichier uploadé.</div>";
    exit;
}

// Récupération des colonnes valides de la table courante
$validFields = [];
foreach ($DB->request("SHOW COLUMNS FROM `$table`") as $col) {
    $validFields[] = $col['Field'];
}

$lineIndex           = 0;
$columns             = [];
$expectedColumnCount = 0;
$imported            = 0;
$skippedDup          = 0;
$skippedCols         = 0;
$errors              = 0;
$buffer              = '';

// Boucle de lecture du fichier uploadé
while (($line = fgets($fp)) !== false) {
    $rawLine = rtrim($line, "\r\n");
    if ($rawLine === '') {
        // Ligne vide (séparateur entre blocs) : on l’ignore
        continue;
    }

    // ─── Détection du marqueur “# Début de la table : <nom_physique_de_table>” ───
    if ($itemtype_str === PluginDlteamsDeliverable::class) {
        // Exemple : "# Début de la table : glpi_plugin_dlteams_deliverable_sections"
        $trimmed = trim($rawLine);
        if (substr($trimmed, 0, 18) === '# Début de la table') {
            $parts = explode(':', $trimmed, 2);
            if (count($parts) === 2) {
                $physicalTable = trim($parts[1]);
                // Si cette table existe, on bascule la cible d’insertion
                if ($DB->tableExists($physicalTable)) {
                    $table = $physicalTable;
                    // Recharger la liste des colonnes valides pour cette nouvelle table
                    $validFields = [];
                    foreach ($DB->request("SHOW COLUMNS FROM `$table`") as $col) {
                        $validFields[] = $col['Field'];
                    }
                }
            }
            // Réinitialisation de l’état pour le nouveau bloc
            $columns             = [];
            $expectedColumnCount = 0;
            $buffer              = '';
            $lineIndex++;
            continue;
        }
    }
    // ────────────────────────────────────────────────────────────────────────

    // Reconstruction des lignes multi‐lignes
    $buffer .= ($buffer === '' ? '' : "\n") . $rawLine;
    $fields = explode("\t", $buffer);

    if ($lineIndex === 0) {
        // Première ligne : en‐tête de colonnes
        $columns             = $fields;
        $expectedColumnCount = count($columns);
        $lineIndex++;
        $buffer = '';
        continue;
    }

    // Si on n’a pas encore assez de colonnes, on attend d’avoir la suite
    if (count($fields) < $expectedColumnCount) {
        continue;
    }

    // Si le nombre de colonnes ne correspond pas, on ignore cette ligne
    if (count($fields) !== $expectedColumnCount) {
        $skippedCols++;
        $buffer = '';
        $lineIndex++;
        continue;
    }

    // Création du tableau associatif colonne => valeur
    $data = array_combine($columns, $fields);

    // ─── Nettoyage des données avant insertion dans la table cible ───
    unset($data['id']);
    $data['entities_id']   = Session::getActiveEntity();
    $data['date_creation'] = $currentDate;
    $data['date_mod']      = $currentDate;
    // Ne garder que les colonnes existantes dans la table cible
    $data = array_intersect_key($data, array_flip($validFields));
    // Convertir les chaînes vides en NULL
    foreach ($data as $k => $v) {
        $data[$k] = trim($v) === '' ? null : $v;
    }
    // ──────────────────────────────────────────────────────────────────

    // ─── Vérification de doublon ou conditions spécifiques ───
    if ($itemtype_str !== PluginDlteamsDeliverable::class) {
        // Cas “normal” (PolicieForm ou autre) : votre logique existante
        if (!$items_import) {
            if (!empty($data['name'])) {
                $nameQ = $DB->quote($data['name']);
                $entId = (int)$data['entities_id'];
                $sqlChk = "
                    SELECT 1
                      FROM `$table`
                     WHERE `name` = $nameQ
                       AND `entities_id` = $entId
                     LIMIT 1";
                $resChk = $DB->request($sqlChk);
                if ($resChk->numrows()) {
                    $skippedDup++;
                    $buffer = '';
                    $lineIndex++;
                    continue;
                }
            }
        } else {
            // Cas “personnes données”, “licéité” ou “rétention” de PolicieForm
            $column_id_name  = strtolower(str_replace("PluginDlteams", "", $itemtype_str)) . "s_id";
            $column_id_value = $DB->quote($data[$column_id_name]);
            $temp_itemtype   = $DB->quote($data['itemtype']);
            $temp_items_id   = $DB->quote($data['items_id']);
            $sqlChk = "
                SELECT 1
                  FROM `$table`
                 WHERE `$column_id_name` = $column_id_value
                   AND `itemtype` = $temp_itemtype
                   AND `items_id` = $temp_items_id
                 LIMIT 1";
            $resChk = $DB->request($sqlChk);
            if ($resChk->numrows()) {
                $skippedDup++;
                $buffer = '';
                $lineIndex++;
                continue;
            }
        }
    }
    // ──────────────────────────────────────────────────────────────────

    // ─── Insertion dans la table courante ($table) ───
    $fieldsSql = [];
    $valuesSql = [];
    foreach ($data as $col => $val) {
        $fieldsSql[] = "`$col`";
        if (is_null($val)) {
            $valuesSql[] = "NULL";
        } else {
            $valuesSql[] = $DB->quote($val);
        }
    }
    $sqlIns = "INSERT INTO `$table` ("
        . implode(",", $fieldsSql)
        . ") VALUES ("
        . implode(",", $valuesSql)
        . ")";
    try {
        $DB->query($sqlIns);
        $imported++;
    } catch (Throwable $e) {
        $errors++;
    }
    // ──────────────────────────────────────────────────────────────────

    // ─── Bloc “personnes données” / “licéité” / “rétention” de PolicieForm ───
    if ($items_import && ($_POST['action'] ?? '') === 'import_personnesdonnees') {
        // a) ConcernedPerson
        $table1  = PluginDlteamsConcernedPerson_Item::getTable();
        $fields1 = [
            'concernedpersons_id' => $data['items_id'] ?? null,
            'items_id'            => $data['policieforms_id'] ?? null,
            'itemtype'            => PluginDlteamsPolicieForm::class,
            'items_id1'           => $data['items_id1'] ?? null,
            'itemtype1'           => $data['itemtype1'] ?? null,
            'comment'             => $data['comment'] ?? null,
        ];
        // Vérifier s’il existe déjà
        $where1_clauses = [];
        foreach ($fields1 as $col => $val) {
            if ($val === null) {
                $where1_clauses[] = "`$col` IS NULL";
            } else {
                $where1_clauses[] = "`$col` = " . $DB->quote($val);
            }
        }
        $sqlChk1 = "SELECT 1 FROM `$table1` WHERE " . implode(" AND ", $where1_clauses) . " LIMIT 1";
        $resChk1 = $DB->request($sqlChk1);
        if (count($resChk1) == 0) {
            $cols1 = array_map(fn($c) => "`$c`", array_keys($fields1));
            $vals1 = array_map(fn($v) => is_null($v) ? "NULL" : $DB->quote($v), array_values($fields1));
            $sqlIns1 = "INSERT INTO `$table1` ("
                . implode(",", $cols1)
                . ") VALUES ("
                . implode(",", $vals1)
                . ")";
            try {
                $DB->query($sqlIns1);
            } catch (Throwable $e) {
                $errors++;
            }
        }

        // b) ProcessedData
        $table2  = PluginDlteamsProcessedData_Item::getTable();
        $fields2 = [
            'processeddatas_id' => $data['items_id1'] ?? null,
            'items_id'          => $data['policieforms_id'] ?? null,
            'itemtype'          => PluginDlteamsPolicieForm::class,
            'items_id1'         => $data['items_id'] ?? null,
            'itemtype1'         => $data['itemtype'] ?? null,
            'comment'           => $data['comment'] ?? null,
        ];
        $where2_clauses = [];
        foreach ($fields2 as $col => $val) {
            if ($val === null) {
                $where2_clauses[] = "`$col` IS NULL";
            } else {
                $where2_clauses[] = "`$col` = " . $DB->quote($val);
            }
        }
        $sqlChk2 = "SELECT 1 FROM `$table2` WHERE " . implode(" AND ", $where2_clauses) . " LIMIT 1";
        $resChk2 = $DB->request($sqlChk2);
        if (count($resChk2) == 0) {
            $cols2 = array_map(fn($c) => "`$c`", array_keys($fields2));
            $vals2 = array_map(fn($v) => is_null($v) ? "NULL" : $DB->quote($v), array_values($fields2));
            $sqlIns2 = "INSERT INTO `$table2` ("
                . implode(",", $cols2)
                . ") VALUES ("
                . implode(",", $vals2)
                . ")";
            try {
                $DB->query($sqlIns2);
            } catch (Throwable $e) {
                $errors++;
            }
        }
    }
    elseif ($items_import && ($_POST['action'] ?? '') === 'import_legalbasis') {
        $table1  = PluginDlteamsPolicieForm_Item::getTable();
        $fields1 = [
            'policieforms_id' => $data['items_id'] ?? null,
            'items_id'        => $data['legalbasis_id'] ?? null,
            'itemtype'        => PluginDlteamsLegalbasi::class,
            'comment'         => $data['comment'] ?? null,
        ];
        $where1_clauses = [];
        foreach ($fields1 as $col => $val) {
            if ($val === null) {
                $where1_clauses[] = "`$col` IS NULL";
            } else {
                $where1_clauses[] = "`$col` = " . $DB->quote($val);
            }
        }
        $sqlChk1 = "SELECT 1 FROM `$table1` WHERE " . implode(" AND ", $where1_clauses) . " LIMIT 1";
        $resChk1 = $DB->request($sqlChk1);
        if (count($resChk1) == 0) {
            $cols1 = array_map(fn($c) => "`$c`", array_keys($fields1));
            $vals1 = array_map(fn($v) => is_null($v) ? "NULL" : $DB->quote($v), array_values($fields1));
            $sqlIns1 = "INSERT INTO `$table1` ("
                . implode(",", $cols1)
                . ") VALUES ("
                . implode(",", $vals1)
                . ")";
            try {
                $DB->query($sqlIns1);
            } catch (Throwable $e) {
                $errors++;
            }
        }
    }
    elseif ($items_import && ($_POST['action'] ?? '') === 'import_storageperiod') {
        $table1  = PluginDlteamsPolicieForm_Item::getTable();
        $fields1 = [
            'policieforms_id'                     => $data['items_id'] ?? null,
            'items_id'                            => $data['storageperiods_id'] ?? null,
            'itemtype'                            => PluginDlteamsStoragePeriod::class,
            'comment'                             => $data['comment'] ?? null,
            'plugin_dlteams_storageendactions_id' => $data['plugin_dlteams_storageendactions_id'] ?? null,
            'plugin_dlteams_storagetypes_id'      => $data['plugin_dlteams_storagetypes_id'] ?? null,
        ];
        $where1_clauses = [];
        foreach ($fields1 as $col => $val) {
            if ($val === null) {
                $where1_clauses[] = "`$col` IS NULL";
            } else {
                $where1_clauses[] = "`$col` = " . $DB->quote($v);
            }
        }
        $sqlChk1 = "SELECT 1 FROM `$table1` WHERE " . implode(" AND ", $where1_clauses) . " LIMIT 1";
        $resChk1 = $DB->request($sqlChk1);
        if (count($resChk1) == 0) {
            $cols1 = array_map(fn($c) => "`$c`", array_keys($fields1));
            $vals1 = array_map(fn($v) => is_null($v) ? "NULL" : $DB->quote($v), array_values($fields1));
            $sqlIns1 = "INSERT INTO `$table1` ("
                . implode(",", $cols1)
                . ") VALUES ("
                . implode(",", $vals1)
                . ")";
            try {
                $DB->query($sqlIns1);
            } catch (Throwable $e) {
                $errors++;
            }
        }
    }

    // Réinitialisation du buffer
    $buffer   = '';
    $lineIndex++;
}

fclose($fp);

// Résumé
echo "<div class='success'>Import terminé : $imported ligne(s) insérée(s).</div>";
if ($skippedDup) {
    echo "<div class='warning'>$skippedDup ligne(s) ignorée(s) (doublon).</div>";
}
if ($skippedCols) {
    echo "<div class='warning'>$skippedCols ligne(s) ignorée(s) (colonnes incorrectes).</div>";
}
if ($errors) {
    echo "<div class='error'>$errors erreur(s) d'insertion.</div>";
}
exit;
?>
