<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired  DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include("../../../inc/includes.php");

Session::checkLoginUser();
global $DB;
$pf = new PluginDlteamsPolicieForm();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // On récupère l’enregistrement existant
    $pf->getFromDB($_POST['id']);
    $updates = [];

    // Mise à jour de la rubrique "Transmission"
    if (isset($_POST['update_transmission'])) {
        $updates = [
            'transmissionmethod'    => json_encode($_POST['transmission_methods'] ?? []),
            'transmission_comment'  => $_POST['transmission_comment']  ?? ''
        ];
    }
    // Mise à jour de la rubrique "Supports"
    elseif (isset($_POST['update_support'])) {
        $updates = [
            'mediasupport'   => json_encode($_POST['support_methods']    ?? []),
            'support_comment'=> $_POST['support_comment']   ?? ''
        ];
    }
    // Mise à jour de la rubrique "Intégration au SI"
    elseif (isset($_POST['update_integration'])) {
        $updates = [
            'siintegration'       => json_encode($_POST['si_integration'] ?? []),
            'integration_comment' => $_POST['integration_comment'] ?? ''
        ];
    }

    // Exécution de la mise à jour si nécessaire
    if (!empty($updates)) {
        $resp = $DB->update(
            $pf->getTable(),
            $updates,
            ['id' => $pf->fields['id']]
        );
        if ($resp) {
            Session::addMessageAfterRedirect(__('Opération effectuée avec succès', 'dlteams'));
        }
    }

    // Retour à la page précédente
    Html::back();
}
