<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include("../../../inc/includes.php");

$validation = new PluginDlteamsTicketTask_Validation();
/*highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//die();
if(isset($_POST["add_report"])){
    $tickettask = new TicketTask();
    if ($tickettask->getFromDB($_POST["tickettasks_id"])) {
//        have parent
        if ($tickettask->fields["tickettasks_id"]) {
            $tickettask = new TicketTask();
            $tickettask->getFromDB($tickettask->fields["tickettasks_id"]);
        }
    }


    $itilfp = new ITILFollowup();
    global $DB;

    $text_to_add = "<b style='color: #005cbf;'>Compte rendu</b>";


    $tag = addslashes(html_entity_decode($text_to_add));
    if(!$DB->insert($itilfp->getTable(), [
        "itemtype" => PluginDlteamsTicketTask::class,
        "items_id" => $tickettask->fields["id"],
        "content" => addslashes(stripcslashes($_POST["content"])),
        "tag" => $tag,
        "users_id" => Session::getLoginUserID(),
        "date_creation" => $_SESSION['glpi_currenttime'],
        "date_mod" => $_SESSION['glpi_currenttime'],
        "entities_id" => Session::getActiveEntity(),
        "type" => PluginDlteamsMessage::TICKETTASKREPORT,
        "itemtype1" => PluginDlteamsTicketTask::class,
        "items_id1" => $tickettask->fields["id"],
    ])){

        Toolbox::logInFile("dlteams-error", "Echec d'ajout de message de compte rendu");
    }
}
elseif ($validation->update($_POST + [
        'status' => ($_POST['approval_action'] === 'approve') ? CommonITILValidation::ACCEPTED : CommonITILValidation::REFUSED,
        'users_id_validate' => Session::getLoginUserID()
    ]))
{
    Session::addMessageAfterRedirect("Opération éffectuée avec succès");

    $approvedtext = ($_POST['approval_action'] === 'approve') ? "approuvé" : "rejeté";

    $user = new User();
    $user->getFromDB(Session::getLoginUserID());
    $controller = $user->fields["firstname"] . " " . $user->fields["realname"];
    $date = Html::convDateTime($_SESSION["glpi_currenttime"], null, false);

    $color = ($_POST['approval_action'] === 'approve') ? '#28a745' : '#dc3545'; // Vert pour approuvé, rouge pour rejeté
    $text_to_add = "<b style='color: $color;'>Contrôle de tâche $approvedtext par $controller</b>";

    $validation = new PluginDlteamsTicketTask_Validation();
    $validation->getFromDB($_POST["id"]);
    $tickettask = new TicketTask();
    if ($tickettask->getFromDB($validation->fields["tickettasks_id"])) {
//        have parent
        if ($tickettask->fields["tickettasks_id"]) {
            $tickettask = new TicketTask();
            $tickettask->getFromDB($tickettask->fields["tickettasks_id"]);
        }
    }

    $itilfp = new ITILFollowup();
    global $DB;

    $content = html_entity_decode($_POST["comment_validation"]);
    $content = str_replace(array("\r", "\n"), ' ', $content); // Remplace les retours à la ligne par un espace

    if (!$DB->insert($itilfp->getTable(), [
        "itemtype" => PluginDlteamsTicketTask::class,
        "items_id" => $tickettask->fields["id"],
        "content" => $content,
        "tag" => addslashes($text_to_add),
        "users_id" => Session::getLoginUserID(),
        "date_creation" => $_SESSION['glpi_currenttime'],
        "date_mod" => $_SESSION['glpi_currenttime'],
        "entities_id" => Session::getActiveEntity(),
        "type" => PluginDlteamsMessage::TICKETTASKCONTROL,
        "itemtype1" => PluginDlteamsTicketTask::class,
        "items_id1" => $tickettask->fields["id"],
    ])) {
        Toolbox::logInFile("dlteams-error", "Echec d'ajout de message apres controle");
    }

} else
    Session::addMessageAfterRedirect("Une erreur s'est produite", 0, ERROR);
Html::back();