<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */
include("../../../inc/includes.php");


/*highlight_string("<?php\n\$data =\n" . var_export($_POST, true) . ";\n?>");*/
//die();


if (!isset($_POST["itemtype"]) || !isset($_POST["items_id"]) || !$_POST["itemtype"] || !$_POST["items_id"]) {
    Session::addMessageAfterRedirect("Veuillez choisir un destinataire", false, ERROR);
    Html::back();
}

function getEmailsFromTypeAndId($type, $id) {
    $emails = [];
    $obj = new $type();
    if ($obj->getFromDB($id)) {
        if ($type == "Contact" || $type == "Supplier") {
            if (!empty($obj->fields["email"])) {
                $emails[] = $obj->fields["email"];
            }
        } elseif ($type == "Group") {
            $group_users = Group_User::getGroupUsers($obj->fields["id"]);
            foreach ($group_users as $user_id) {
                $mail = UserEmail::getDefaultForUser($user_id);
                if (NotificationMailing::isUserAddressValid($mail)) {
                    $emails[] = $mail;
                }
            }
        } else { // User
            $mail = UserEmail::getDefaultForUser($obj->fields["id"]);
            if (NotificationMailing::isUserAddressValid($mail)) {
                $emails[] = $mail;
            }
        }
    }
    return $emails;
}

// Destinataire principal
$itemtype = $_POST["itemtype"];
$items_id = $_POST["items_id"];

$receiver = new $itemtype();
$receiver->getFromDB($items_id);
$name = " ";
$receiver_mail = [];
if ($receiver) {
    if ($itemtype == "Contact") {
        $receiver_mail = [$receiver->fields["email"]];
        $name = sprintf("%s %s", $receiver->fields["firstname"], $receiver->fields["name"]);
    } elseif ($itemtype == "Supplier") {
        $receiver_mail = [$receiver->fields["email"]];
        $name = $receiver->fields["name"];
    } elseif ($itemtype == "Group") {
        $group_users = Group_User::getGroupUsers($receiver->fields["id"]);
        foreach ($group_users as $user_id) {
            $mail = UserEmail::getDefaultForUser($user_id);
            if (NotificationMailing::isUserAddressValid($mail)) {
                $receiver_mail[] = $mail;
            }
        }
        $name = $receiver->fields["name"];
    } else { // User
        $receiver_mail = [UserEmail::getDefaultForUser($receiver->fields["id"])] ;
        $name = sprintf("%s %s", $receiver->fields["firstname"], $receiver->fields["realname"]);
    }
    // Nettoyage des emails vides
    $receiver_mail = array_filter($receiver_mail);
    if (empty($receiver_mail)) {
        Session::addMessageAfterRedirect("Le destinataire ne possède pas d'adresse email valide.", false, WARNING);
        Html::back();
    }
} else {
    Session::addMessageAfterRedirect("Destinataire non trouvé", false, WARNING);
    Html::back();
}

// CC (Copie à)
$cc_types = isset($_POST['itemtype1']) ? (array)$_POST['itemtype1'] : [];
$cc_ids   = isset($_POST['items_id1']) ? (array)$_POST['items_id1'] : [];
$cc_emails = [];
foreach ($cc_types as $i => $type) {
    if (empty($type) || !isset($cc_ids[$i]) || empty($cc_ids[$i])) {
        continue; // Ignore les entrées invalides
    }
    $id = $cc_ids[$i];
    $cc_emails = array_merge($cc_emails, getEmailsFromTypeAndId($type, $id));
}
$cc_emails = array_unique(array_filter($cc_emails));


// CCI (Pour information)
$bcc_types = isset($_POST['itemtype2']) ? (array)$_POST['itemtype2'] : [];
$bcc_ids   = isset($_POST['items_id2']) ? (array)$_POST['items_id2'] : [];
$bcc_emails = [];
foreach ($bcc_types as $i => $type) {
    if (empty($type) || !isset($bcc_ids[$i]) || empty($bcc_ids[$i])) {
        continue;
    }
    $id = $bcc_ids[$i];
    $bcc_emails = array_merge($bcc_emails, getEmailsFromTypeAndId($type, $id));
}
$bcc_emails = array_unique(array_filter($bcc_emails));

if (isset($_POST["send_notification"])) {
    $fupi = new ITILFollowup();
    global $CFG_GLPI;
    $fromemail = $CFG_GLPI['smtp_username'];
    $objet = $_POST["object_notification"];
    $notification_text = html_entity_decode($_POST["notification_text"]);
    $success = false;
    foreach ($receiver_mail as $mail_addr) {
        $htmlcontent = "<b>De: </b> $fromemail &lt;$fromemail&gt; <br/>";
        $htmlcontent .= "<b>À :</b> $name &lt;$mail_addr&gt; <br/>";
        $htmlcontent .= "<b>Objet :</b> $objet <br/>";
        $htmlcontent .= $notification_text;
        $fupi->add([
            "itemtype" => Ticket::class,
            "items_id" => isset($_POST["items_id1"]) ? $_POST["items_id1"] : $_POST["items_id"],
            "content" => $htmlcontent
        ]);
        $data = [
            "subject" => $objet,
            "content_html" =>  $htmlcontent,
            "to" => $mail_addr,
            "toname" => $mail_addr,
            "cc" => $cc_emails,
            "bcc" => $bcc_emails,
        ];
        $mail = new PluginDlteamsNotificationMail();
        if ($mail->sendNotification($data)) {
            $success = true;
        }
    }
    if ($success) {
        Session::addMessageAfterRedirect("Notification envoyée à tous les destinataires valides.");
    } else {
        Session::addMessageAfterRedirect("Aucune notification envoyée (aucun destinataire valide).", false, ERROR);
    }
}

Html::back();

