<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software.
 It disallow others people than DLPlace developers to distribute, sell,
 or add additional requirements to this software.
 Though, a limited set of safe added requirements can be allowed, but
 for private or internal usage only ;  without even the implied warranty
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

include("../../../inc/includes.php");
use GuzzleHttp\Client as Guzzle_Client;
use GuzzleHttp\Psr7\Message;
use GuzzleHttp\Psr7\Response;
use GuzzleHttp\Psr7\Request;
use wapmorgan\UnifiedArchive\Formats;
use wapmorgan\UnifiedArchive\UnifiedArchive;

$httpClient = new Guzzle_Client();
$request = new Request('GET', 'https://update.dlteams.app/plugin/versions');
$res = $httpClient->sendAsync($request, [])->wait();

$remote_versions = json_decode($res->getBody()->getContents(), true);
$remote_versions = $remote_versions["versions"];
if (is_array($remote_versions)) {
//    var_dump("zzz");
//    die();
    $higher_version = end($remote_versions);

    $plugin_inst = new Plugin();
    $exists = $plugin_inst->getFromDBbyDir("dlteams");
    $currentversion = $plugin_inst->fields["version"];

    if ($currentversion != $higher_version["version"]) {
        $url      = $higher_version["download_url"];
        $filename = basename(parse_url($url, PHP_URL_PATH));
        $dest     = GLPI_TMP_DIR . '/' . $filename;

        $options = [
            'headers'  => [
                'Accept' => '*/*',
            ],
            'sink'     => $dest,
        ];


//        $client = new Guzzle_Client();
//        $response = $client->request('GET', 'https://dlteams.free.beeceptor.com/plugin/versions');





        try {
            $response = $httpClient->request('GET', $url, $options); // ok fichier téléchargé
//            decompresser l'archive vers un nom de version
            // extract the archive
            if (!UnifiedArchive::canOpen($dest)) {
                $type = Formats::detectArchiveFormat($dest);
                Session::addMessageAfterRedirect(
                    sprintf(__('Plugin archive format is not supported by your system : %s.'), $type),
                    false,
                    ERROR
                );
                return false;
            }

            // Some plugins archives may be huge, as they may embed some binaries.
            // Upgrade memory limit to 512M, which should be enough.
            $memory_limit = (int)Toolbox::getMemoryLimit();
            if ($memory_limit > 0 && $memory_limit < (512 * 1024 * 1024)) {
                ini_set('memory_limit', '512M');
            }

            $archive = UnifiedArchive::open($dest);
            $error = $archive === null;
            if (!$error) {
                // clean dir in case of update
                chmod(GLPI_MARKETPLACE_DIR . "/dlteams1", 0777);
                Toolbox::deleteDir(GLPI_MARKETPLACE_DIR . "/dlteams1");

                try {
                    // copy files
                    $dlteams_dir = GLPI_MARKETPLACE_DIR . "/dlteams1";
                    mkdir(GLPI_MARKETPLACE_DIR . "/dlteams1", 0777, true);
                    $archive->extract(GLPI_MARKETPLACE_DIR. "/dlteams1") !== false;
                    chmod(GLPI_MARKETPLACE_DIR . "/dlteams1", 0777);
                    rmdir($dest);
                    Session::addMessageAfterRedirect("Succès");
                    Html::back();
                } catch (\wapmorgan\UnifiedArchive\Exceptions\ArchiveExtractionException $e) {
                    $error = true;
                }
            }

            if ($error) {
                Session::addMessageAfterRedirect(
                    __('Unable to extract plugin archive.'),
                    false,
                    ERROR
                );
                Session::addMessageAfterRedirect("Vous pouvez télécharger manuellement depuis <a href='$url'>$url</a> et extraire vers $dlteams_dir");
                return false;
            }


//            renommer le dossier marketplace/dlteams en marketplace/dlteams-temp




        } catch (\GuzzleHttp\Exception\RequestException $e) {

            Toolbox::logDebug( [
                'title'     => "Plugins API error",
                'exception' => $e->getMessage(),
                'request'   => Message::toString($e->getRequest()),
            ]);

        }
    }
}
//var_dump(ini_set('upload_max_filesize', '20M'));
//var_dump(ini_set('post_max_size', '20M'));
//die();
//$glpiRoot=str_replace('\\', '/', GLPI_ROOT);
//$savePath = GLPI_TMP_DIR ;
//$extractFolder = $savePath . "dlteamslatest/";

//
//$directory_destination = GLPI_MARKETPLACE_DIR . "/dlteams/";
//$memory_limit = (int)Toolbox::getMemoryLimit();
/*highlight_string("<?php\n\$data =\n" . var_export($_FILES, true) . ";\n?>");*/
//die();
//if (isset($_FILES['update_folders'])) {
//    $files_data = [];
//    $temprandom = bin2hex(openssl_random_pseudo_bytes(16));
//    foreach ($_FILES["update_folders"]["tmp_name"] as $key => $file_path) {
//        $file_name = basename($_FILES["update_folders"]["name"][$key]);
//		printf ($filename);
////        $destination = $storageDirectory . $file_name;
//        $destination = GLPI_TMP_DIR . "/" . $temprandom . "/";
////        $table_name = str_replace(".dat", "", $file_name);
//
//        array_push($files_data, [
//            "full_path" => $destination . $file_name,
//            "destination_folder" => $destination,
//            "file_path" => $file_path
////            "table_name" => $table_name
//        ]);
//
//        // Créer les répertoires parents si nécessaire
//        if (!file_exists($destination) && !is_dir($destination)) {
//            mkdir($destination, 0755, true);
//            chmod($destination, 0755);
//        }
//
//        move_uploaded_file($file_path, $destination . $file_name);
//        chmod($destination . $file_name, 0755);
//    }
//
/*    highlight_string("<?php\n\$data =\n" . var_export($files_data, true) . ";\n?>");*/
//    die();
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//    $max_size = Toolbox::return_bytes_from_ini_vars(ini_get("upload_max_filesize"));
//    if ($_FILES['file']['size'] <= $max_size) {
//        Session::addMessageAfterRedirect("La taille du fichier dépasse la taille maximale", 0, ERROR);
//        Html::back();
//    }
//
//    $fileTmpPath = $_FILES['file']['tmp_name'];
//
//
/*    highlight_string("<?php\n\$data =\n" . var_export($_FILES, true) . ";\n?>");*/
//    die();
//    $fileName = $_FILES['file']['name'];
//    $fileSize = $_FILES['file']['size'];
//    $fileType = $_FILES['file']['type'];
//    $fileNameCmps = explode(".", $fileName);
//    $fileExtension = strtolower(end($fileNameCmps));
//    $allowedExtensions = array('zip', 'rar', 'tar', 'gz');
//
//    if (in_array($fileExtension, $allowedExtensions)) {
//        $dest_path = $savePath . $fileName;
//        // Définir les permissions correctes
//        $correctPermissions = 0777;
//
//        if(is_dir($savePath)){
//            echo "Répertoire temporaire trouvé...<br/>";
//        }
//// Créer le répertoire s'il n'existe pas
//        if (!is_dir($extractFolder)) {
//            mkdir($extractFolder, $correctPermissions, true);
//			echo "Répertoire d'extraction créé...<br/>";
//        } else {
//            // Vérifier les permissions actuelles du répertoire
//            $currentPermissions = substr(sprintf('%o', fileperms($extractFolder)), -4);
//
//            // Mettre à jour les permissions si elles ne sont pas correctes
//            if ($currentPermissions != decoct($correctPermissions)) {
//                if(chmod($extractFolder, $correctPermissions))
//                    echo "Ok.. updaté pour les bonnes permissions<br/>";
//                else
//                    echo "Erreur de mise a jour des bonnes permissions <br>";
//            }
//        }
//
//// Déplacer le fichier de l'emplacement temporaire à l'emplacement désiré
//        var_dump($fileTmpPath);
//        var_dump(sprintf("is writable est %s ", is_writable($dest_path)));
//        if (move_uploaded_file($fileTmpPath, $dest_path)) {
//            echo "Le fichier a été téléchargé avec succès dans le dossier " . $savePath;
//        } else {
//            echo "Erreur lors du déplacement du fichier téléchargé.";
//        }
//    } else {
//        echo "Le type de fichier n'est pas autorisé. Seuls les fichiers compressés sont acceptés.";
//    }
//}
//else {
//    echo "Il y a eu une erreur lors du téléchargement du fichier.";
//}
//
////$fileid = $_POST['file_id'];
//// $refreshToken = PluginDlteamsConfig::gdriveKeys()["refresh_token"];
//// $accessToken = PluginDlteamsConfig::refreshAccessToken($refreshToken);
////$download_response = PluginDlteamsConfig::downloadFileFromGoogleDrive($accessToken, $fileid, $savePath);
//
////extract
//$zip = new ZipArchive;
//if ($zip->open($dest_path) === TRUE) {
//    $zip->extractTo($extractFolder);
//    $zip->close();
//    echo  "extrait avec succès";
//} else {
//    echo  "Impossible d'ouvrir le fichier ZIP.";
//}
//
////copy files
//$rii = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($extractFolder));
//$files = array();
//foreach ($rii as $file) {
//    if ($file->isDir()) {
//        continue;
//    }
//$files[] = $file->getPathname();
//$message = "..." . substr($file, -40). nl2br("\n");
//}
//clearstatcache();
//$perms = fileperms($directory_destination);
//
//// On récupère seulement les permissions, masquage des autres bits avec 0777
//chmod(plugin_dlteams_root, 0777); // ouverture des droits d'écriture
//foreach ($files as $path) {
////    var_dump ($file->isDir());
////	var_dump ($path ." --> ".$directory_destination.str_replace($extractFolder, "", $path));
//	$resp = copy($path, $directory_destination.str_replace($extractFolder, "", $path));
//}
//chmod(plugin_dlteams_root, 0755); // fermeture des droits
//
//$message .= "Mise à jour efféctuée avec succès";
//Session::addMessageAfterRedirect($message);
//global $CFG_GLPI;
// Html::redirect($CFG_GLPI['url_base'] . "/front/central.php");
