<?php
/*
 -------------------------------------------------------------------------
 DLTeams plugin for GLPI
 -------------------------------------------------------------------------
 LICENSE : This file is part of DLTeams Plugin.

 DLTeams Plugin is a GNU Free Copylefted software. 
 It disallow others people than DLPlace developers to distribute, sell, 
 or add additional requirements to this software. 
 Though, a limited set of safe added requirements can be allowed, but 
 for private or internal usage only ;  without even the implied warranty 
 of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 You should have received a copy of the GNU General Public License
 along with DLTeams Plugin. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
  @package   dlteams
  @author    DLPlace developers
  @copyright Copyright (c) 2022 DLPlace
  @inspired	 DPO register plugin (Karhel Tmarr) & gdprropa (Yild)
  @license   GPLv3+ http://www.gnu.org/licenses/gpl.txt
  @link      https://github.com/dlplace/dlteams
  @since     2021
 --------------------------------------------------------------------------
 */

class PluginDlteamsDataCarrierType extends CommonDropdown {
   static $rightname = 'plugin_dlteams_datacarriertype';
    public static $menukey = "dataaccessdatacarriertype";
    public $dohistory = true;
   protected $usenotepad = true;

     static function getTypeName($nb = 0) {
      return __("Données d'entreprise", 'dlteams');
   }
     
   function prepareInputForAdd($input) {
      $input['users_id_creator'] = Session::getLoginUserID();
      return parent::prepareInputForAdd($input);
   }

   function prepareInputForUpdate($input) {
      $input['users_id_lastupdater'] = Session::getLoginUserID();
      return parent::prepareInputForUpdate($input);
   }

   function cleanDBonPurge() {
      $rel = new PluginDlteamsRecord_DatabaseType();
      $rel->deleteByCriteria(['plugin_dlteams_datacarriertypes_id' => $this->fields['id']]);
   }

    public static function showMassiveActionsSubForm(MassiveAction $ma)
    {
        switch ($ma->getAction()) {
            case 'copyTo':
                //                $values = [];
//                foreach ($_SESSION["glpiactiveentities"] ?? [] as $key => $entities_id) {
//                    $entity = new Entity();
//                    $entity->getFromDB($entities_id);
//                    $values[$key] = $entity->fields["completename"];
//                }
                Entity::dropdown(['name' => 'entities_id']);
                echo '<br /><br />' . Html::submit(_x('button', 'Post'), ['name' => 'massiveaction']);
                return true;
        }
        return parent::showMassiveActionsSubForm($ma);
    }

   function rawSearchOptions() {

      $tab = [];

      $tab[] = [
         'id'                 => 'common',
         'name'               => __("Characteristics")
      ];

       $tab[] = [
           'id'                 => '1',
           'table'              => $this->getTable(),
           'field'              => 'number',
           'name'               => __("Num"),
           'datatype'           => 'number',
           'min'                => 1,
           'max'                => 10000,
           'massiveaction'      => true,
       ];

      $tab[] = [
         'id'                 => '2',
         'table'              => $this->getTable(),
         'field'              => 'name',
         'name'               => __("Name"),
         'datatype'           => 'itemlink',
         'massiveaction'      => false,
         'autocomplete'       => true,
      ];

      $tab[] = [
         'id'                 => '3',
         'table'              => $this->getTable(),
         'field'              => 'id',
         'name'               => __("ID"),
         'massiveaction'      => false,
         'datatype'           => 'itemlink',
      ];

      $tab[] = [
         'id'                 => '4',
         'table'              => $this->getTable(),
         'field'              => 'comment',
         'name'               => __("Comments"),
         'datatype'           => 'text',
         'toview'             => true,
         'massiveaction'      => true,
      ];

      $tab[] = [
         'id'                 => '5',
         'table'              => 'glpi_entities',
         'field'              => 'completename',
         'name'               => __("Entity"),
         'datatype'           => 'dropdown',
         'massiveaction'      => true,
      ];

      $tab[] = [
         'id'                 => '6',
         'table'              => $this->getTable(),
         'field'              => 'is_recursive',
         'name'               => __("Child entities"),
         'datatype'           => 'bool',
         'massiveaction'      => false,
      ];
	  
	   

      return $tab;
   }
   
   /*public function defineTabs($options = [])
   {

      $ong = [];

      $ong = array();
      //add main tab for current object
      $this->addDefaultFormTab($ong);
      $this->addImpactTab($ong, $options);
      // $this->addStandardTab('Document_Item', $ong, $options);
      $this->addStandardTab('Ticket', $ong, $options);
      $this->addStandardTab('Notepad', $ong, $options);
      $this->addStandardTab('Log', $ong, $options);
      
      return $ong;
   }*/

    function showForm($id, $options = [])
    {
        global $CFG_GLPI;
        $this->initForm($id, $options);
        $this->showFormHeader($options);

        echo "<style>";
        echo "
            .form-table-text {
                text-align: right;
                width: 25%;
            }
            
            
            @media (max-width: 800px) {
                .form-table-text {
                    text-align: left;
                    width: 100%;
                }
            }
        ";

        echo "</style>";


        echo "<table, th, td width='100%'>";


        echo "<tr>";
//		echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td class='form-table-text'>". __("Number (order)", 'dlteams') . "</td>";
        echo "<td colspan='1'>";
        $number = Html::cleanInputText($this->fields['number']);
        echo "<input type='number' min='1' max='9999' name='number' size='8' value='" . $number . "'>";
        echo "</td>";
        echo "<td width='30%' style='text-align:right'>". " " . "</td>";
        echo "</tr>" ;


        echo "<tr>";
//		echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td class='form-table-text' >". __("Name", 'dlteams') . "</td>";
        echo "<td>";
        $name = Html::cleanInputText($this->fields['name']);
        echo "<input type='text' style='width:98%' name='name' required value='" . $name. "'>" . "</td>";
        echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "</tr>" ;


        echo "<tr>";
//      echo "<td width='15%' style='text-align:right'>". " " . "</td>";
        echo "<td class='form-table-text'>" . __("Comments") . "</td>";
        echo "<td>";
        $comment = Html::cleanInputText($this->fields['comment']);
        echo "<textarea style='width: 98%;' name='comment' rows='3'>" . $comment . "</textarea>";
        echo "</td></tr>";
        echo "</table>";

        $options = [];
        $options["withtemplate"] = "";
        $this->showFormButtons($options);

        return true;
    }


    static function processMassiveActionsForOneItemtype(MassiveAction $ma, CommonDBTM $item, array $ids)
    {
        switch ($ma->getAction()) {
            case 'copyTo':
                if ($item->getType() == PluginDlteamsDataCarrierType::getType()) {
                    foreach ($ids as $id) {
                        if ($item->getFromDB($id)) {
                            if ($item->copy1($ma->POST['entities_id'], $id, $item)) {

                                Session::addMessageAfterRedirect(sprintf(__('%s copied: %s', 'dlteams'), $item->getTypeName(), $item->getName()));
                                $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_OK);
                            }
                        } else {
                            // Example of ko count
                            $ma->itemDone($item->getType(), $id, MassiveAction::ACTION_KO);
                        }
                    }
                }
                return;
        }
        parent::processMassiveActionsForOneItemtype($ma, $item, $ids);
    }

    public function copy1($entity, $id, $item){
        global $DB;
        $dbu = new DbUtils();
        $name=$item->fields['name'];

        $nb=$dbu->countElementsInTable(static::getTable(), ['name' => addslashes($name), 'entities_id' => $entity]);

        if($nb<=0){
            $DB->request("INSERT INTO ".static::getTable()." (entities_id, is_recursive, date_mod, date_creation, name, comment) SELECT '$entity', is_recursive, date_mod, date_creation, name, comment FROM ".static::getTable()." WHERE id='$id'");
            return true;
        }else{
            return false;
        }
    }

  
}
